/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import com.l2fprod.common.beans.editor.StringPropertyEditor;
import java.beans.PropertyEditor;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.neptus.plugins.PropertyType;

public class ConsoleScript
implements PropertyType {
    private LinkedHashMap<String, String> variables = new LinkedHashMap();
    private String rawScript;
    private CompiledScript compiledScript;
    private Bindings bindings;

    @Override
    public void fromString(String value) {
        try {
            this.setScript(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return this.rawScript;
    }

    @Override
    public Class<? extends PropertyEditor> getPropertyEditor() {
        return StringPropertyEditor.class;
    }

    public void setScript(String script) throws ScriptException {
        this.rawScript = script;
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        Pattern p = Pattern.compile("\\$\\(([\\<\\>\\.a-zA-Z0-9_ ]*)\\)");
        Matcher m = p.matcher(script);
        vars.clear();
        while (m.find()) {
            String var = m.group();
            String v = var.substring(2, var.length() - 1);
            String v2 = v.replace(".", "_");
            v2 = v2.replace("<", "_");
            v2 = v2.replace(">", "_");
            v2 = v2.replace(" ", "_");
            vars.put(v, v2);
            script = script.substring(0, m.start()) + v2 + script.substring(m.end());
            m = p.matcher(script);
        }
        Pattern p2 = Pattern.compile("\\$\\(\"([^\"]*)\"\\)");
        Matcher m2 = p2.matcher(script);
        while (m2.find()) {
            String var = m2.group();
            String v = var.substring(2, var.length() - 1);
            char[] str = v.toCharArray();
            for (int i = 0; i < str.length; ++i) {
                if (Character.isLetter(str[i])) continue;
                str[i] = 95;
            }
            String v2 = String.copyValueOf(str);
            vars.put(v.replace("\"", ""), v2);
            script = script.substring(0, m2.start()) + v2 + script.substring(m2.end());
            m2 = p2.matcher(script);
        }
        this.variables = vars;
        this.compile(script);
    }

    private void compile(String jsScript) throws ScriptException {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("js");
        this.bindings = engine.createBindings();
        this.compiledScript = ((Compilable)((Object)engine)).compile(jsScript);
    }

    public Object evaluate(ImcSysState state) {
        if (this.compiledScript == null) {
            return null;
        }
        if (state != null) {
            this.bindings.put("state", (Object)state);
            for (String var : this.variables.keySet()) {
                this.bindings.put(this.variables.get(var), state.expr(var));
            }
        }
        return this.evaluate();
    }

    public Object evaluate() {
        try {
            return this.compiledScript.eval(this.bindings);
        }
        catch (Exception e) {
            return e.getCause();
        }
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public void setBindings(Bindings bindings) {
        this.bindings = bindings;
    }

    public static void main(String[] args) throws Exception {
        ConsoleScript script = new ConsoleScript();
        script.setScript("x = $(EstimatedState (ola).x)*2+34;\ny = x * 3;");
    }
}

