/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class DistancePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int VERTICAL_UP = 0;
    public static final int VERTICAL_DOWN = 1;
    public static final int HORIZONTAL_LEFT = 2;
    public static final int HORIZONTAL_RIGHT = 3;
    private int type = 0;
    private double value = 10.0;
    public Graphics2D g2 = null;
    private BufferedImage bi = null;

    public DistancePanel() {
    }

    public DistancePanel(int type, double value) {
        this();
        this.value = value;
        this.type = type;
    }

    @Override
    public void paint(Graphics arg0) {
        super.paint(arg0);
        this.update(arg0);
    }

    @Override
    public void update(Graphics arg0) {
        try {
            Rectangle2D stringBounds;
            this.g2 = (Graphics2D)arg0;
            if (this.g2 == null) {
                return;
            }
            if (this.bi == null || this.bi.getWidth() < this.getWidth() || this.bi.getHeight() < this.getHeight()) {
                this.bi = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
            }
            Graphics2D g = (Graphics2D)this.bi.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setPaintMode();
            g.clearRect(0, 0, this.bi.getWidth(), this.bi.getHeight());
            int percent_arrow_length = this.getWidth() / 9;
            int percent_arrow_height = this.getHeight() / 7;
            if (this.type == 0) {
                g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
                g.drawLine(this.getWidth() / 2 - percent_arrow_length, percent_arrow_height, this.getWidth() / 2, 0);
                g.drawLine(this.getWidth() / 2 + percent_arrow_length, percent_arrow_height, this.getWidth() / 2, 0);
                stringBounds = this.g2.getFontMetrics().getStringBounds(this.value + "m", this.g2);
                g.drawString(this.value + "m", (int)((double)(this.getWidth() / 2) - stringBounds.getCenterX()), (int)((double)(this.getHeight() / 2) - stringBounds.getCenterY()));
            }
            if (this.type == 1) {
                g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
                g.drawLine(this.getWidth() / 2 - percent_arrow_length, this.getHeight() - percent_arrow_height, this.getWidth() / 2, this.getHeight() - 1);
                g.drawLine(this.getWidth() / 2 + percent_arrow_length, this.getHeight() - percent_arrow_height, this.getWidth() / 2, this.getHeight() - 1);
                stringBounds = g.getFontMetrics().getStringBounds(this.value + "m", g);
                g.drawString(this.value + "m", (int)((double)(this.getWidth() / 2) - stringBounds.getCenterX()), (int)((double)(this.getHeight() / 2) - stringBounds.getCenterY()));
            }
            if (this.type == 2) {
                g.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
                g.drawLine(0, this.getHeight() / 2, percent_arrow_length, this.getHeight() / 2 - percent_arrow_height);
                g.drawLine(0, this.getHeight() / 2, percent_arrow_length, this.getHeight() / 2 + percent_arrow_height);
                stringBounds = this.g2.getFontMetrics().getStringBounds(this.value + "m", this.g2);
                g.drawString(this.value + "m", (int)((double)(this.getWidth() / 2) - stringBounds.getCenterX()), (int)((double)(this.getHeight() / 2) - stringBounds.getMinY()));
            }
            if (this.type == 3) {
                g.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
                g.drawLine(this.getWidth() - percent_arrow_length, this.getHeight() / 2 - percent_arrow_height, this.getWidth() - 1, this.getHeight() / 2);
                g.drawLine(this.getWidth() - 1, this.getHeight() / 2, this.getWidth() - percent_arrow_length, this.getHeight() / 2 + percent_arrow_height);
                stringBounds = this.g2.getFontMetrics().getStringBounds(this.value + "m", this.g2);
                g.drawString(this.value + "m", (int)((double)(this.getWidth() / 2) - stringBounds.getCenterX()), (int)((double)(this.getHeight() / 2) - stringBounds.getMinY()));
            }
            this.g2.drawImage((Image)this.bi, 0, 0, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.repaint();
        this.value = value;
    }
}

