/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.gui.StatusLed;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.Enumerated;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.ImageUtils;

@Popup(pos=Popup.POSITION.TOP_LEFT, width=400, height=400, accelerator=69)
@PluginDescription(name="Entities", icon="images/buttons/events.png", documentation="entity-state/entity-state.html")
public class EntityStatePanel
extends ConsolePanel
implements NeptusMessageListener {
    private static final long serialVersionUID = 5150530667334313096L;
    private final Color COLOR_OFF = Color.GRAY;
    private final Color COLOR_GREEN = new Color(0, 200, 125);
    private final Color COLOR_BLUE = Color.BLUE;
    private final Color COLOR_YELLOW = new Color(200, 200, 0);
    private final Color COLOR_ORANGE = new Color(255, 127, 0);
    private final Color COLOR_RED = Color.RED;
    private final Icon ICON_CLEAR = ImageUtils.getScaledIcon("images/buttons/clear.png", 16, 16);
    private LinkedHashMap<String, EntityStateType> dataMap = new LinkedHashMap();
    private Vector<EntityStateType> data = null;
    private EntityStateTableModel etmodel = new EntityStateTableModel();
    private HashMap<Long, Color> eColor = new HashMap();
    private HashMap<Long, Short> eLevel = new HashMap();
    private Timer timer = null;
    private TimerTask ttask = null;
    private JTable table = null;
    private StatusLed status;

    public EntityStatePanel(ConsoleLayout console) {
        super(console);
        this.removeAll();
        this.data = new Vector<EntityStateType>(){

            @Override
            public synchronized boolean add(EntityStateType e) {
                if (EntityStatePanel.this.data.isEmpty()) {
                    super.add(e);
                    return true;
                }
                int index = -1;
                for (int i = 0; i < EntityStatePanel.this.data.size(); ++i) {
                    int val = ((EntityStateType)EntityStatePanel.this.data.get(i)).getEntity().compareTo(e.getEntity());
                    if (val < 0) continue;
                    index = i;
                    break;
                }
                if (index >= EntityStatePanel.this.data.size() || index < 0) {
                    super.add(e);
                } else {
                    super.add(index, e);
                }
                return true;
            }

            @Override
            public synchronized void addElement(EntityStateType obj) {
                super.add(obj);
            }
        };
        this.setup();
        JTable table = this.getTable();
        JScrollPane scrollPane = new JScrollPane(table);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        ToolbarButton clearButton = new ToolbarButton(new AbstractAction("clear", this.ICON_CLEAR){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityStatePanel.this.clearData();
            }
        });
        clearButton.setToolTipText(I18n.text("Clear table"));
        this.status = new StatusLed();
        this.status.made5LevelIndicator();
        this.status.setLevel((short)-1);
        JPanel wPanel = new JPanel();
        wPanel.setLayout(new FlowLayout(0));
        wPanel.add(this.status);
        wPanel.add((Component)((Object)clearButton));
        this.add((Component)wPanel, "North");
    }

    @Override
    public void initSubPanel() {
        this.getTimer().scheduleAtFixedRate(this.getTtask(), 100L, 1000L);
    }

    private void setup() {
        this.eColor.put(0L, this.COLOR_BLUE);
        this.eColor.put(1L, this.COLOR_GREEN);
        this.eColor.put(2L, this.COLOR_YELLOW);
        this.eColor.put(3L, this.COLOR_ORANGE);
        this.eColor.put(4L, this.COLOR_RED);
        this.eColor.put(5L, this.COLOR_RED);
        this.eColor.put(6L, this.COLOR_OFF);
        this.eColor.put(7L, this.COLOR_OFF);
        this.eLevel.put(0L, (short)1);
        this.eLevel.put(1L, (short)0);
        this.eLevel.put(2L, (short)2);
        this.eLevel.put(3L, (short)3);
        this.eLevel.put(4L, (short)4);
        this.eLevel.put(5L, (short)4);
        this.eLevel.put(6L, (short)-2);
        this.eLevel.put(7L, (short)-1);
    }

    private short mapValueToWarningLevel(short value) {
        if (this.eLevel.containsKey(value)) {
            return this.eLevel.get(value);
        }
        return value;
    }

    @Override
    public void cleanSubPanel() {
        if (this.ttask != null) {
            this.ttask.cancel();
            this.ttask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.clearData();
    }

    private Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer("EventsTableSubPanel [" + this.hashCode() + "]");
        }
        return this.timer;
    }

    private TimerTask getTtask() {
        if (this.ttask == null) {
            this.ttask = new TimerTask(){

                @Override
                public void run() {
                    boolean needCalc = true;
                    try {
                        for (int i = 0; i < EntityStatePanel.this.data.toArray(new EntityStateType[0]).length; ++i) {
                            EntityStatePanel.this.etmodel.fireTableCellUpdated(i, 4);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (needCalc) {
                        EntityStatePanel.this.calcTotalState();
                    }
                }
            };
        }
        return this.ttask;
    }

    private JTable getTable() {
        if (this.table == null) {
            this.table = new JTable(this.etmodel);
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
            this.table.setFillsViewportHeight(true);
            this.table.setDefaultRenderer(Enumerated.class, new EnumeratedTableCellRenderer());
            this.table.setDefaultRenderer(Long.class, new HourTableCellRenderer());
            this.table.setDefaultRenderer(JLabel.class, new JLabelTableCellRenderer());
            this.table.setAutoCreateRowSorter(true);
            TableColumn col = ((DefaultTableColumnModel)this.table.getColumnModel()).getColumn(1);
            col.setPreferredWidth(30);
            col = ((DefaultTableColumnModel)this.table.getColumnModel()).getColumn(2);
            col.setPreferredWidth(10);
            col = ((DefaultTableColumnModel)this.table.getColumnModel()).getColumn(4);
            col.setPreferredWidth(20);
        }
        return this.table;
    }

    public String getAlarmMessage() {
        return this.status.getMessage();
    }

    public String getAlarmName() {
        return I18n.text("Entity State Alarm");
    }

    public int sourceState() {
        return -2;
    }

    private synchronized void calcTotalState() {
        short max = -1;
        String evtLabel = "";
        for (EntityStateType en : this.data.toArray(new EntityStateType[0])) {
            Short value;
            if (en.isDontCare()) continue;
            Enumerated evt = en.getState();
            try {
                value = (short)evt.intValue();
                value = this.mapValueToWarningLevel(value);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)(EntityStatePanel.class.getSimpleName() + "calcTotalState: " + e.getMessage()));
                continue;
            }
            if (value == null || value <= max) continue;
            max = value;
            evtLabel = evt.toString();
        }
        this.status.setLevel(max);
        this.status.setMessage(I18n.textf("State '%state'", evtLabel));
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange evt) {
        this.clearData();
    }

    private void clearData() {
        if (this.data.size() != 0) {
            this.etmodel.fireTableRowsDeleted(0, this.data.size() - 1);
        }
        this.data.clear();
        this.dataMap.clear();
        this.etmodel.fireTableStructureChanged();
        this.calcTotalState();
    }

    @Override
    public String[] getObservedMessages() {
        return new String[]{"EntityState"};
    }

    @Override
    public void messageArrived(IMCMessage message) {
        String entityName = EntitiesResolver.resolveName(this.getMainVehicleId(), message.getHeader().getInteger("src_ent"));
        if (entityName != null) {
            Integer index;
            EntityStateType eType = this.dataMap.get(entityName);
            Integer n = index = eType == null ? null : Integer.valueOf(this.data.indexOf(eType));
            if (index != null) {
                eType = this.data.get(index);
                if (message.getLong("state") != eType.getState().longValue()) {
                    // empty if block
                }
                eType.update(entityName, new Enumerated(message.getMessageType().getFieldPossibleValues("state"), message.getLong("state")), message.getString("description"), System.currentTimeMillis());
                this.data.set(index, eType);
                this.etmodel.fireTableRowsUpdated(index, index);
            } else {
                eType = new EntityStateType(entityName, new Enumerated(message.getMessageType().getFieldPossibleValues("state"), message.getLong("state")), this.getDescription(), System.currentTimeMillis());
                if (this.data.add(eType)) {
                    index = this.data.indexOf(eType);
                    this.dataMap.put(entityName, eType);
                    this.etmodel.fireTableRowsInserted(index, index);
                }
            }
            this.calcTotalState();
        }
    }

    class HourTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -619157378506879550L;

        public HourTableCellRenderer() {
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object timems, boolean isSelected, boolean hasFocus, int row, int column) {
            Long enu = System.currentTimeMillis() - (Long)timems;
            this.setText(DateTimeUtil.milliSecondsToFormatedString(enu / 1000L * 1000L));
            return this;
        }
    }

    class JLabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        JLabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JLabel)value;
        }
    }

    class EnumeratedTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -619157378506879550L;

        public EnumeratedTableCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object eventType, boolean isSelected, boolean hasFocus, int row, int column) {
            Enumerated enu = (Enumerated)eventType;
            this.setText(enu.toString());
            Color newColor = (Color)EntityStatePanel.this.eColor.get(enu.getCurrentValue());
            if (newColor == null) {
                newColor = EntityStatePanel.this.COLOR_OFF;
            }
            this.setBackground(newColor);
            this.setForeground(Color.WHITE);
            this.setToolTipText("");
            return this;
        }
    }

    class EntityStateType {
        public static final int ENTITY_COL = 0;
        public static final int STATE_COL = 1;
        public static final int DONT_CARE_FLAG_COL = 2;
        public static final int DESCRIPTION_COL = 3;
        public static final int TIME_COL = 4;
        JLabel entity = new JLabel("");
        Enumerated state = null;
        boolean dontCare = false;
        JLabel description = new JLabel("");
        long timeDelta = 0L;

        public EntityStateType(String entity, Enumerated state, String description, long timeDelta) {
            this.setEntity(entity);
            this.setState(state);
            this.setDescription(description);
            this.setTimeDelta(timeDelta);
        }

        public void update(String entity, Enumerated state, String description, long timeDelta) {
            this.setEntity(entity);
            this.setState(state);
            this.setDescription(description);
            this.setTimeDelta(timeDelta);
        }

        public String getEntity() {
            return this.entity.getText();
        }

        public void setEntity(String entity) {
            this.entity.setText(entity);
            this.entity.setToolTipText(entity);
        }

        public Enumerated getState() {
            return this.state;
        }

        public void setState(Enumerated state) {
            this.state = state;
        }

        public boolean isDontCare() {
            return this.dontCare;
        }

        public void setDontCare(boolean dontCare) {
            this.dontCare = dontCare;
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void setDescription(String description) {
            this.description.setText(description);
            this.description.setToolTipText(description);
        }

        public long getTimeDelta() {
            return this.timeDelta;
        }

        public void setTimeDelta(long timeDelta) {
            this.timeDelta = timeDelta;
        }

        public void setElement(int columnIndex, Object value) {
            switch (columnIndex) {
                case 0: {
                    this.entity = (JLabel)value;
                    break;
                }
                case 1: {
                    this.state = (Enumerated)value;
                    break;
                }
                case 2: {
                    this.dontCare = (Boolean)value;
                    break;
                }
                case 3: {
                    this.description = (JLabel)value;
                    break;
                }
                case 4: {
                    this.timeDelta = (Long)value;
                    break;
                }
            }
        }

        public Object getElement(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.entity;
                }
                case 1: {
                    return this.state;
                }
                case 2: {
                    return this.dontCare;
                }
                case 3: {
                    return this.description;
                }
                case 4: {
                    return this.timeDelta;
                }
            }
            return null;
        }
    }

    class EntityStateTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4368923349985497368L;
        private String[] columnNames = new String[]{I18n.text("Entity"), I18n.text("State"), "x", I18n.text("Description"), "\u2206t"};
        boolean DEBUG = false;

        EntityStateTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return EntityStatePanel.this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (EntityStatePanel.this.data.size() < rowIndex + 1) {
                return null;
            }
            Object obj = ((EntityStateType)EntityStatePanel.this.data.get(rowIndex)).getElement(columnIndex);
            return obj;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            Object cl = this.getValueAt(0, c);
            if (cl == null) {
                return Object.class;
            }
            return cl.getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (this.DEBUG) {
                NeptusLog.pub().info((Object)("<###>Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")"));
            }
            ((EntityStateType)EntityStatePanel.this.data.get(row)).setElement(col, value);
            this.fireTableCellUpdated(row, col);
        }
    }
}

