/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.console.plugins.ClassPropertiesInfo;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.editor.BitmaskPropertyEditor;
import pt.lsts.neptus.gui.editor.ColorMapPropertyEditor;
import pt.lsts.neptus.gui.editor.EnumEditor;
import pt.lsts.neptus.gui.editor.EnumeratedPropertyEditor;
import pt.lsts.neptus.gui.editor.ImcId16Editor;
import pt.lsts.neptus.gui.editor.LocationTypePropertyEditor;
import pt.lsts.neptus.gui.editor.NeptusDoubleEditor;
import pt.lsts.neptus.gui.editor.PlanActionsEditor;
import pt.lsts.neptus.gui.editor.RenderSelectionEditor;
import pt.lsts.neptus.gui.editor.RenderType;
import pt.lsts.neptus.gui.editor.Script;
import pt.lsts.neptus.gui.editor.ScriptSelectionEditor;
import pt.lsts.neptus.gui.editor.VehicleSelectionEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.Bitmask;
import pt.lsts.neptus.messages.Enumerated;
import pt.lsts.neptus.mp.actions.PlanActions;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.PropertyType;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class FunctionalitiesSettings
extends JPanel {
    private static final long serialVersionUID = 6448256757823976181L;
    private PropertyEditorRegistry pEditorRegistry;
    private PropertyRendererRegistry pRenderRegistry;
    private final boolean clientConsole;
    private NeptusProperty.LEVEL permissionLvl;
    private final HashMap<NeptusProperty.LEVEL, DefaultTreeModel> levelTrees;
    private JSplitPane splitPane;
    private JTree tree;

    public FunctionalitiesSettings(boolean clientConsole, Vector<PropertiesProvider> subPanels) {
        super((LayoutManager)new MigLayout());
        this.clientConsole = clientConsole;
        this.levelTrees = new HashMap();
        this.setupFrame();
        this.setupTreeModels(subPanels);
    }

    private void setupTreeModels(Vector<PropertiesProvider> subPanels) {
        this.permissionLvl = NeptusProperty.LEVEL.REGULAR;
        this.levelTrees.put(NeptusProperty.LEVEL.REGULAR, this.createTreeModel(subPanels));
        this.permissionLvl = NeptusProperty.LEVEL.ADVANCED;
        this.levelTrees.put(NeptusProperty.LEVEL.ADVANCED, this.createTreeModel(subPanels));
    }

    private void setupFrame() {
        this.splitPane = new JSplitPane(1);
        this.splitPane.setResizeWeight(0.0);
        JPanel holderPropertiesPanel = new JPanel((LayoutManager)new MigLayout("insets 0"));
        this.splitPane.setRightComponent(holderPropertiesPanel);
        this.tree = this.buildAndSetupTree();
        JScrollPane treePane = new JScrollPane(this.tree);
        this.splitPane.setLeftComponent(treePane);
        this.splitPane.setDividerLocation(200);
        this.add((Component)this.splitPane, "w 100%, h 100%");
    }

    private JTree buildAndSetupTree() {
        JTree tree = new JTree();
        tree.setCellRenderer(new IconRenderer());
        tree.getSelectionModel().setSelectionMode(1);
        tree.expandRow(0);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        final JPanel holderPropertiesPanel = (JPanel)this.splitPane.getRightComponent();
        if (tree.getModel().getChildCount(tree.getModel().getRoot()) == 0) {
            holderPropertiesPanel.add(new JLabel(I18n.text("There are no settings to display")));
        } else {
            tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath path = e.getNewLeadSelectionPath();
                    holderPropertiesPanel.removeAll();
                    if (path != null) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                        ClassPropertiesInfo userObject = (ClassPropertiesInfo)defaultMutableTreeNode.getUserObject();
                        PropertySheetPanel propertiesPanel = userObject.getPropertiesPanel();
                        if (propertiesPanel == null) {
                            propertiesPanel = FunctionalitiesSettings.this.createPropertiesPanelForClass(userObject.getClassInstance());
                            userObject.setPropertiesPanel(propertiesPanel);
                        }
                        holderPropertiesPanel.add((Component)propertiesPanel, "w 100%, h 100%");
                    }
                    FunctionalitiesSettings.this.revalidate();
                }
            });
        }
        return tree;
    }

    public void reset() {
        this.resetPropertiesPanels(NeptusProperty.LEVEL.REGULAR);
        this.resetPropertiesPanels(NeptusProperty.LEVEL.ADVANCED);
        this.permissionLvl = NeptusProperty.LEVEL.REGULAR;
        DefaultTreeModel model = this.levelTrees.get((Object)this.permissionLvl);
        this.tree.setModel(model);
        JPanel holderPanel = (JPanel)this.splitPane.getRightComponent();
        holderPanel.removeAll();
        this.repaint();
    }

    public void saveChanges() {
        TreeModel model = this.tree.getModel();
        Object root = model.getRoot();
        int classCount = model.getChildCount(root);
        for (int c = 0; c < classCount; ++c) {
            ClassPropertiesInfo classInfo = (ClassPropertiesInfo)((DefaultMutableTreeNode)model.getChild(root, c)).getUserObject();
            PropertySheetPanel propertiesPanel = classInfo.getPropertiesPanel();
            if (propertiesPanel == null) continue;
            propertiesPanel.getTable().commitEditing();
            this.setProperties(classInfo);
        }
        GeneralPreferences.saveProperties();
    }

    private void setProperties(ClassPropertiesInfo classInfo) {
        DefaultProperty[] beforeProps = this.convertPropertyType(classInfo.getPropertiesPanel().getProperties());
        PropertiesProvider provider = classInfo.getClassInstance();
        String[] errors = provider.getPropertiesErrors((Property[])beforeProps);
        if (errors != null && errors.length > 0) {
            this.printErrors(errors);
        } else {
            provider.setProperties((Property[])beforeProps);
        }
    }

    private void printErrors(String[] errors) {
        String errorsString = "<html>" + I18n.text("The following errors were found") + ":<br>";
        int i = 1;
        for (String error : errors) {
            errorsString = errorsString + "<br> &nbsp;" + i++ + ") " + error;
        }
        errorsString = errorsString + "</html>";
        GuiUtils.errorMessage(new JFrame(I18n.text("Error")), I18n.text("Invalid properties"), errorsString);
    }

    private DefaultProperty[] convertPropertyType(Property[] properties) {
        DefaultProperty[] defaultProperties = new DefaultProperty[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            Property property = properties[i];
            DefaultProperty newProp = new DefaultProperty();
            newProp.setName(property.getName());
            newProp.setDisplayName(property.getName());
            newProp.setCategory(property.getCategory());
            newProp.setShortDescription(property.getShortDescription());
            newProp.setEditable(property.isEditable());
            newProp.setType(property.getType());
            newProp.setValue(property.getValue());
            defaultProperties[i] = newProp;
        }
        return defaultProperties;
    }

    public void updateForNewPermission() {
        TreePath selPath = ((DefaultTreeSelectionModel)this.tree.getSelectionModel()).getSelectionPath();
        HashMap<String, Property[]> oldProps = this.extractProperties(this.tree.getModel());
        this.switchPermissionLevel();
        this.restoreInsertedProperties(oldProps, selPath);
    }

    private void restoreInsertedProperties(HashMap<String, Property[]> oldProps, TreePath selPath) {
        DefaultMutableTreeNode selectedNode;
        DefaultTreeModel newModel = this.levelTrees.get((Object)this.permissionLvl);
        this.updateUsedPanels(oldProps, newModel);
        JPanel holderPropertiesPanel = (JPanel)this.splitPane.getRightComponent();
        holderPropertiesPanel.removeAll();
        if (selPath != null && (selectedNode = (DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject() instanceof ClassPropertiesInfo) {
            ClassPropertiesInfo selectedClassInfo = (ClassPropertiesInfo)selectedNode.getUserObject();
            String selectedClassInfoName = selectedClassInfo.getName();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)newModel.getRoot();
            int classCount = newModel.getChildCount(root);
            for (int c = 0; c < classCount; ++c) {
                DefaultMutableTreeNode classNode = (DefaultMutableTreeNode)newModel.getChild(root, c);
                ClassPropertiesInfo classInfo = (ClassPropertiesInfo)classNode.getUserObject();
                if (!classInfo.getName().equalsIgnoreCase(selectedClassInfoName)) continue;
                this.tree.setSelectionPath(new TreePath(classNode.getPath()));
                c = classCount;
            }
        }
        holderPropertiesPanel.repaint();
    }

    private void switchPermissionLevel() {
        this.permissionLvl = this.permissionLvl == NeptusProperty.LEVEL.REGULAR ? NeptusProperty.LEVEL.ADVANCED : NeptusProperty.LEVEL.REGULAR;
        this.tree.setModel(this.levelTrees.get((Object)this.permissionLvl));
    }

    private void updateUsedPanels(HashMap<String, Property[]> oldProps, DefaultTreeModel newModel) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)newModel.getRoot();
        int childCount = newModel.getChildCount(root);
        for (int i = 0; i < childCount; ++i) {
            int pStored;
            int pNew;
            int storedPropsLength;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)newModel.getChild(root, i);
            ClassPropertiesInfo funcInfo = (ClassPropertiesInfo)node.getUserObject();
            Property[] storedProps = oldProps.get(funcInfo.getName());
            if (storedProps == null) continue;
            PropertySheetPanel propertyPanel = this.createPropertiesPanelForClass(funcInfo.getClassInstance());
            Property[] newProps = propertyPanel.getProperties();
            int newPropsLength = newProps.length;
            if (newPropsLength < (storedPropsLength = storedProps.length)) {
                pNew = 0;
                for (pStored = 0; pNew < newPropsLength && pStored < storedPropsLength; ++pStored) {
                    if (!storedProps[pStored].getName().equals(newProps[pNew].getName())) continue;
                    newProps[pNew].setValue(storedProps[pStored].getValue());
                    ++pNew;
                }
            } else {
                pStored = 0;
                for (pNew = 0; pNew < newPropsLength && pStored < storedPropsLength; ++pNew) {
                    if (!storedProps[pStored].getName().equals(newProps[pNew].getName())) continue;
                    newProps[pNew].setValue(storedProps[pStored].getValue());
                    ++pStored;
                }
            }
            funcInfo.setPropertiesPanel(propertyPanel);
        }
    }

    private HashMap<String, Property[]> extractProperties(TreeModel model) {
        HashMap<String, Property[]> props = new HashMap<String, Property[]>();
        Object root = model.getRoot();
        int classCount = model.getChildCount(root);
        for (int c = 0; c < classCount; ++c) {
            DefaultMutableTreeNode classNode = (DefaultMutableTreeNode)model.getChild(root, c);
            ClassPropertiesInfo classInfo = (ClassPropertiesInfo)classNode.getUserObject();
            PropertySheetPanel propertiesPanel = classInfo.getPropertiesPanel();
            if (propertiesPanel == null) continue;
            propertiesPanel.getTable().commitEditing();
            Property[] classProperties = propertiesPanel.getProperties();
            props.put(classInfo.getName(), (Property[])classProperties.clone());
        }
        return props;
    }

    private void resetPropertiesPanels(NeptusProperty.LEVEL level) {
        TreeModel model = this.levelTrees.get((Object)level);
        int functionalityCount = model.getChildCount(model.getRoot());
        for (int i = 0; i < functionalityCount; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getChild(model.getRoot(), i);
            ClassPropertiesInfo funcInfo = (ClassPropertiesInfo)node.getUserObject();
            funcInfo.setPropertiesPanel(null);
        }
    }

    private ArrayList<DefaultMutableTreeNode> buildTreeNodes(Vector<PropertiesProvider> subPanels) {
        ArrayList<DefaultMutableTreeNode> unsortedNodes = new ArrayList<DefaultMutableTreeNode>();
        for (PropertiesProvider subPanel : subPanels) {
            this.findPropertiesCreateNodeUpdateNodeList(subPanel, unsortedNodes);
        }
        GeneralPreferences genPref = new GeneralPreferences();
        this.findPropertiesCreateNodeUpdateNodeList(genPref, unsortedNodes);
        return unsortedNodes;
    }

    private void findPropertiesCreateNodeUpdateNodeList(PropertiesProvider subPanel, ArrayList<DefaultMutableTreeNode> unsortedNodes) {
        PropertySheetPanel propertiesPanel = this.createPropertiesPanelForClass(subPanel);
        if (propertiesPanel.getPropertyCount() > 0) {
            unsortedNodes.add(this.createNode(subPanel, propertiesPanel));
        }
    }

    private DefaultMutableTreeNode createNode(PropertiesProvider funcClass, PropertySheetPanel propertiesPanel) {
        String icon;
        String name;
        PluginDescription pluginAnnotation = funcClass.getClass().getAnnotation(PluginDescription.class);
        if (pluginAnnotation == null) {
            name = funcClass.getPropertiesDialogTitle();
            if (name == null || name.isEmpty()) {
                name = funcClass.getClass().getSimpleName();
            }
            icon = "";
        } else {
            name = pluginAnnotation.name();
            if (name == null || name.length() == 0) {
                name = funcClass.getPropertiesDialogTitle();
                if (name == null || name.isEmpty()) {
                    name = funcClass.getClass().getSimpleName();
                }
                char firstLetter = Character.toUpperCase(name.charAt(0));
                name = firstLetter + name.substring(1);
            }
            icon = pluginAnnotation.icon();
        }
        ClassPropertiesInfo classInfo = new ClassPropertiesInfo(funcClass, null, name, propertiesPanel, icon);
        return new DefaultMutableTreeNode(classInfo);
    }

    private ArrayList<DefaultMutableTreeNode> sortNodes(ArrayList<DefaultMutableTreeNode> unsortedNodes) {
        Collections.sort(unsortedNodes, new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
                String s1 = I18n.text(((ClassPropertiesInfo)n1.getUserObject()).getName());
                String s2 = I18n.text(((ClassPropertiesInfo)n2.getUserObject()).getName());
                Collator collator = Collator.getInstance(Locale.US);
                return collator.compare(s1, s2);
            }
        });
        return unsortedNodes;
    }

    private DefaultTreeModel createTreeModel(Vector<PropertiesProvider> subPanels) {
        ArrayList<DefaultMutableTreeNode> nodes = this.buildTreeNodes(subPanels);
        nodes = this.sortNodes(nodes);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        for (DefaultMutableTreeNode defaultMutableTreeNode : nodes) {
            root.add(defaultMutableTreeNode);
        }
        return new DefaultTreeModel(root);
    }

    private <T> PropertySheetPanel createPropertiesPanelForClass(PropertiesProvider funcClass) {
        this.initEditorRegistry();
        this.initRenderRegistry();
        PropertySheetPanel propertiesPanel = new PropertySheetPanel();
        propertiesPanel.setEditorFactory((PropertyEditorFactory)this.pEditorRegistry);
        propertiesPanel.setRendererFactory((PropertyRendererFactory)this.pRenderRegistry);
        propertiesPanel.setMode(1);
        propertiesPanel.setSortingCategories(true);
        propertiesPanel.setDescriptionVisible(true);
        propertiesPanel.setSorting(true);
        propertiesPanel.setToolBarVisible(false);
        NeptusProperty neptusProperty = null;
        for (Field f : funcClass.getClass().getDeclaredFields()) {
            PluginProperty pp;
            neptusProperty = f.getAnnotation(NeptusProperty.class);
            if (neptusProperty == null) continue;
            f.setAccessible(true);
            if (this.clientConsole && neptusProperty.distribution() == NeptusProperty.DistributionEnum.DEVELOPER) continue;
            NeptusProperty.LEVEL userLevel = neptusProperty.userLevel();
            if (this.permissionLvl.getLevel() < userLevel.getLevel()) continue;
            try {
                pp = this.extractPluginProperty(f, funcClass);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)(funcClass.getClass().getSimpleName() + "." + f.getName()), (Throwable)e);
                throw e;
            }
            if (pp == null) continue;
            propertiesPanel.addProperty((Property)pp);
        }
        return propertiesPanel;
    }

    private <T> PluginProperty extractPluginProperty(Field f, T class1) {
        Object defaultPropValue;
        PluginProperty pluginProperty;
        String displayName;
        NeptusProperty neptusProperty = f.getAnnotation(NeptusProperty.class);
        Object fieldValue = null;
        try {
            fieldValue = f.get(class1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String nameRaw = neptusProperty.name();
        if (nameRaw == null || nameRaw.length() == 0) {
            nameRaw = f.getName();
            char firstLetter = Character.toUpperCase(nameRaw.charAt(0));
            displayName = firstLetter + nameRaw.substring(1);
        } else {
            displayName = nameRaw;
        }
        Class<?> type = f.getType();
        PluginProperty pp = new PluginProperty(nameRaw, type, fieldValue);
        pp.setValue(fieldValue);
        if (!neptusProperty.editable()) {
            pp.setEditable(false);
        } else {
            pp.setEditable(true);
        }
        displayName = class1.getClass().equals(GeneralPreferences.class) ? "* " + I18n.text(displayName) : I18n.text(displayName);
        pp.setDisplayName(displayName);
        if (neptusProperty.category() != null) {
            pp.setCategory(I18n.text(neptusProperty.category()));
        }
        Map<String, PluginProperty> hashMap = PluginUtils.getDefaultsValues(class1);
        StringBuilder description = new StringBuilder();
        description.append(I18n.text(neptusProperty.description()));
        String defaultValue = hashMap == null ? I18n.textf("No default found for class %className", class1.getClass().getSimpleName()) : ((pluginProperty = hashMap.get(f.getName())) == null ? I18n.textf("No default found for field %fieldName", f.getName()) : ((defaultPropValue = pluginProperty.getValue()) == null ? I18n.text("Absence of value") : (f.getType().getEnumConstants() != null ? I18n.text(defaultPropValue.toString()) : defaultPropValue.toString())));
        description.append(" (");
        description.append(I18n.text("Default value"));
        description.append(": ");
        description.append(defaultValue);
        description.append(")");
        pp.setShortDescription(description.toString());
        Class<? extends PropertyEditor> editClass = null;
        if (neptusProperty.editorClass() != PropertyEditor.class) {
            editClass = neptusProperty.editorClass();
        }
        if (editClass != null) {
            this.pEditorRegistry.registerEditor((Property)pp, editClass);
        } else {
            if (ReflectionUtil.hasInterface(f.getType(), PropertyType.class)) {
                PropertyType pt = (PropertyType)fieldValue;
                this.pEditorRegistry.registerEditor((Property)pp, pt.getPropertyEditor());
            }
            if (f.getType().getEnumConstants() != null && fieldValue != null) {
                this.pEditorRegistry.registerEditor((Property)pp, (PropertyEditor)((Object)new EnumEditor(fieldValue.getClass())));
            }
        }
        return pp;
    }

    private void initEditorRegistry() {
        this.pEditorRegistry = new PropertyEditorRegistry();
        this.pEditorRegistry.registerDefaults();
        this.pEditorRegistry.registerEditor(LocationType.class, LocationTypePropertyEditor.class);
        this.pEditorRegistry.registerEditor(VehicleType.class, VehicleSelectionEditor.class);
        this.pEditorRegistry.registerEditor(Script.class, ScriptSelectionEditor.class);
        this.pEditorRegistry.registerEditor(RenderType.class, RenderSelectionEditor.class);
        this.pEditorRegistry.registerEditor(Enumerated.class, EnumeratedPropertyEditor.class);
        this.pEditorRegistry.registerEditor(Bitmask.class, BitmaskPropertyEditor.class);
        this.pEditorRegistry.registerEditor(ColorMap.class, ColorMapPropertyEditor.class);
        this.pEditorRegistry.registerEditor(ImcId16.class, ImcId16Editor.class);
        this.pEditorRegistry.registerEditor(PlanActions.class, PlanActionsEditor.class);
        this.pEditorRegistry.registerEditor(Double.class, NeptusDoubleEditor.class);
        this.pEditorRegistry.registerEditor(Float.class, NeptusDoubleEditor.class);
    }

    void initRenderRegistry() {
        this.pRenderRegistry = new PropertyRendererRegistry();
        this.pRenderRegistry.registerDefaults();
        this.pRenderRegistry.registerRenderer(ImcId16.class, (TableCellRenderer)new DefaultCellRenderer(){
            private static final long serialVersionUID = 4138765256774163544L;
            {
                this.setShowOddAndEvenRows(false);
            }

            protected String convertToString(Object value) {
                try {
                    ImcId16 id = (ImcId16)value;
                    return id.toPrettyString();
                }
                catch (Exception e) {
                    return super.convertToString(value);
                }
            }
        });
        this.pRenderRegistry.registerRenderer(LocationType.class, (TableCellRenderer)new DefaultCellRenderer(){
            private static final long serialVersionUID = -1063560117208559935L;
            private String toolTip;
            {
                this.setShowOddAndEvenRows(false);
                this.toolTip = "";
            }

            protected String convertToString(Object value) {
                try {
                    LocationType loc = (LocationType)value;
                    this.toolTip = loc.toString();
                    this.setToolTipText(this.toolTip);
                    return loc.toString();
                }
                catch (Exception e) {
                    return super.convertToString(value);
                }
            }
        });
        this.pRenderRegistry.registerRenderer(Double.class, (TableCellRenderer)new DefaultCellRenderer(){
            private static final long serialVersionUID = 4694991901775088021L;
            protected DecimalFormat format;
            {
                this.setOpaque(false);
                this.format = new DecimalFormat("0.0######");
            }

            protected String convertToString(Object value) {
                return this.format.format(value);
            }
        });
        this.pRenderRegistry.registerRenderer(Enum.class, (TableCellRenderer)new DefaultCellRenderer(){
            {
                this.setOpaque(false);
            }

            protected String convertToString(Object value) {
                return I18n.text(value.toString());
            }
        });
    }

    class IconRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 7206236693078391402L;

        IconRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof ClassPropertiesInfo) {
                this.setIcon(((ClassPropertiesInfo)userObject).getIcon());
                this.setText(I18n.text(((ClassPropertiesInfo)userObject).getName()));
            }
            return this;
        }
    }
}

