/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import com.l2fprod.common.swing.JLinkButton;
import gnu.io.CommPortIdentifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.gps.GPSConnection;
import pt.lsts.neptus.gps.GPSListener;
import pt.lsts.neptus.gps.GPSState;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.painters.SubPanelTitlePainter;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.serial.PortSelector;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.coord.egm96.EGM96Util;

@PluginDescription(icon="images/buttons/gpsbutton.png", name="GPS Panel")
@Deprecated
public class GPSPanel
extends ConsolePanel
implements GPSListener,
IPeriodicUpdates,
IEditorMenuExtension,
SubPanelChangeListener {
    @NeptusProperty(name="Use for My Location setting")
    public boolean useForMyLocationSetting = true;
    @NeptusProperty(name="HDOP max", description="HDOP max for use for My Location")
    public double hdopMax = 4.0;
    @NeptusProperty(name="Use heading")
    public boolean useHeading = true;
    @NeptusProperty(name="Use heading filtering with speed")
    public boolean useHeadingFilterWithSpeed = true;
    @NeptusProperty(name="Ignore heading if speed < X m/s")
    public double useHeadingWithSpeedLessThan = 0.1;
    @NeptusProperty(name="Use altitude (ASL)")
    public boolean useAltitude = false;
    private JLabel statusLabel = new JLabel();
    private JLinkButton connButton = new JLinkButton("connect");
    private SubPanelTitlePainter backPainter;
    private GPSConnection gpsConn = null;
    private GPSState gpsState = null;
    private Vector<IMapPopup> renderersPopups = new Vector();

    public GPSPanel(ConsoleLayout console) {
        super(console);
        this.backPainter = new SubPanelTitlePainter("GPS Device");
        this.setSize(123, 69);
        this.setLayout(new BorderLayout(2, 2));
        JXPanel holder = new JXPanel();
        holder.setLayout((LayoutManager)new BorderLayout(0, 0));
        holder.setBackgroundPainter((Painter)this.backPainter);
        this.setLayout(new BorderLayout());
        this.add((Component)holder);
        holder.add((Component)this.statusLabel, (Object)"Center");
        this.statusLabel.setText("<html><font color='red'>Not Connected</font></blockquote></html>");
        JPanel dummy = new JPanel(new FlowLayout(2, 0, 0));
        dummy.setOpaque(false);
        this.connButton.setFocusPainted(false);
        this.connButton.setMargin(new Insets(0, 0, 0, 0));
        this.connButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        GPSPanel.this.connectToggle();
                    }
                }.start();
            }
        });
        dummy.add((Component)this.connButton);
        holder.add((Component)dummy, (Object)"South");
        this.setPreferredSize(new Dimension(200, 75));
        this.setMinimumSize(new Dimension(200, 75));
    }

    @Override
    public void initSubPanel() {
        this.renderersPopups = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        for (IMapPopup str2d : this.renderersPopups) {
            str2d.addMenuExtension(this);
        }
    }

    @Override
    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        if (panelChange == null) {
            return;
        }
        this.renderersPopups = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), IMapPopup.class)) {
            IMapPopup str2d;
            IMapPopup sub = (IMapPopup)((Object)panelChange.getPanel());
            if (panelChange.added()) {
                this.renderersPopups.add(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addMenuExtension(this);
                }
            }
            if (panelChange.removed()) {
                this.renderersPopups.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removeMenuExtension(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToggle() {
        try {
            this.connButton.setEnabled(false);
            if (this.gpsConn == null) {
                PortSelector ps = PortSelector.showSerialPortSelectionDialog(SwingUtilities.getWindowAncestor(this), true);
                CommPortIdentifier commID = ps.getSelectedPort();
                if (commID == null) {
                    this.connButton.setSelected(false);
                    this.connButton.setEnabled(true);
                    return;
                }
                NeptusLog.pub().info((Object)("<###> " + commID.getName() + "   " + ps.getSerialPortParameters().getBaudrate()));
                this.gpsConn = new GPSConnection(commID.getName(), ps.getSerialPortParameters().getBaudrate());
                this.gpsConn.connect();
                this.gpsConn.addGPSListener(this);
                this.connButton.setText("disconnect");
                this.connButton.setEnabled(true);
            } else {
                this.gpsConn.removeGPSListener(this);
                this.gpsConn.disconnect();
                this.gpsConn = null;
                this.connButton.setText("connect");
                this.connButton.setEnabled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.connButton.setEnabled(true);
        }
    }

    @Override
    public void cleanSubPanel() {
        if (this.gpsConn != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        GPSPanel.this.gpsConn.removeGPSListener(GPSPanel.this);
                        GPSPanel.this.gpsConn.disconnect();
                        GPSPanel.this.gpsConn = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
        }
    }

    @Override
    public void GPSStateChanged(GPSState oldState, GPSState newState) {
        this.gpsState = newState;
        this.statusLabel.setText("<html>" + CoordinateUtil.latitudeAsString(newState.getLatitude()) + " " + CoordinateUtil.longitudeAsString(newState.getLongitude()) + "<br>" + "Heading: " + GuiUtils.getNeptusDecimalFormat(2).format(newState.getHeading()) + "\u00b0 " + "Altitude: " + GuiUtils.getNeptusDecimalFormat(2).format(newState.getAltitude()) + "m <br>HDOP: " + GuiUtils.getNeptusDecimalFormat(1).format(newState.getHdop()) + "" + " Speed: " + GuiUtils.getNeptusDecimalFormat(1).format(newState.getSpeed() * 1000.0 / 3600.0) + "m/s" + "</html>");
    }

    @Override
    public long millisBetweenUpdates() {
        return 200L;
    }

    @Override
    public boolean update() {
        if (!this.useForMyLocationSetting) {
            return true;
        }
        GPSState gps = this.gpsState;
        if (gps == null) {
            return true;
        }
        if (gps.getHdop() > this.hdopMax) {
            return true;
        }
        LocationType loc = new LocationType();
        loc.setLatitudeDegs(gps.getLatitude());
        loc.setLongitudeDegs(gps.getLongitude());
        if (this.useAltitude) {
            double alt = gps.getAltitude();
            double heightBase = EGM96Util.calcHeight(loc.getLatitudeDegs(), loc.getLongitudeDegs());
            loc.setDepth(-1.0 * (alt + heightBase));
        } else {
            loc.setDepth(0.0);
        }
        if (this.useHeading && (!this.useHeadingFilterWithSpeed || gps.getSpeed() > this.useHeadingWithSpeedLessThan)) {
            MyState.setLocationAndAxis(loc, gps.getHeading());
        } else if (!this.useHeadingFilterWithSpeed) {
            MyState.setLocationAndAxis(loc, 0.0);
        }
        return true;
    }

    @Override
    public Collection<JMenuItem> getApplicableItems(LocationType loc, IMapPopup source) {
        Vector<JMenuItem> menus = new Vector<JMenuItem>();
        JMenu myLocMenu = new JMenu("GPS Panel");
        menus.add(myLocMenu);
        AbstractAction copy = new AbstractAction("Copy "){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationType loc = new LocationType();
                loc.setLatitudeDegs(GPSPanel.this.gpsState.getLatitude());
                loc.setLongitudeDegs(GPSPanel.this.gpsState.getLongitude());
                if (GPSPanel.this.useAltitude) {
                    double alt = GPSPanel.this.gpsState.getAltitude();
                    double heightBase = EGM96Util.calcHeight(loc.getLatitudeDegs(), loc.getLongitudeDegs());
                    loc.setDepth(-1.0 * (alt + heightBase));
                } else {
                    loc.setDepth(0.0);
                }
                ClipboardOwner owner = new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                };
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(loc.getClipboardText()), owner);
            }
        };
        JMenuItem jmc = new JMenuItem(copy);
        if (this.gpsState == null) {
            jmc.setEnabled(false);
        } else {
            jmc.setEnabled(true);
        }
        myLocMenu.add(jmc);
        AbstractAction settings = new AbstractAction("Settings"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)GPSPanel.this, GPSPanel.this.getConsole(), true);
            }
        };
        myLocMenu.add(new JMenuItem(settings));
        return menus;
    }

    public static void main(String[] args) {
        GuiUtils.testFrame(new GPSPanel(null), "tesd");
    }
}

