/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.Future;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.SimpleRendererInteraction;
import pt.lsts.neptus.renderer2d.ImageLayer;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Image Layers")
@Popup(accelerator=87, height=300, width=250, name="Image Layers", pos=Popup.POSITION.CENTER)
public class ImageLayers
extends SimpleRendererInteraction {
    private static final long serialVersionUID = 6903794413087312334L;
    @NeptusProperty(editable=false)
    public String layerFiles = "";
    @NeptusProperty(editable=false)
    public String lastDir = ".";
    private Vector<ImageLayer> layers = new Vector();
    private String note = "";
    private Vector<File> files = new Vector();
    private JPanel scroll = new JPanel(new GridLayout(0, 2, 3, 3));

    public ImageLayers(ConsoleLayout cl) {
        super(cl);
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll, "Center");
    }

    private void rebuildControls() {
        this.scroll.removeAll();
        for (final ImageLayer il : this.layers) {
            this.scroll.add(new JLabel(il.getName()));
            final JSlider slider = new JSlider(0, 1000, (int)(il.getTransparency() * 1000.0));
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    il.setTransparency((double)slider.getValue() / 1000.0);
                }
            });
            slider.setMinimumSize(new Dimension(20, 20));
            this.scroll.add(slider);
        }
        this.scroll.doLayout();
        this.scroll.revalidate();
    }

    @Override
    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            popup.add("Add layer from file").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(ImageLayers.this.lastDir);
                    chooser.setFileFilter(GuiUtils.getCustomFileFilter("Neptus image layers", "layer"));
                    int op = chooser.showOpenDialog(ImageLayers.this.getConsole());
                    if (op != 0) {
                        return;
                    }
                    ImageLayers.this.lastDir = chooser.getSelectedFile().getParent();
                    Future il = ImageLayers.this.addLayer(chooser.getSelectedFile());
                    try {
                        il.get();
                    }
                    catch (Exception ex) {
                        GuiUtils.errorMessage(ImageLayers.this.getConsole(), ex);
                    }
                }
            });
            if (!this.layers.isEmpty()) {
                JMenu menu = new JMenu("Remove");
                JMenu menu2 = new JMenu("Opacity");
                for (final ImageLayer l : this.layers) {
                    menu.add(l.getName()).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ImageLayers.this.layers.remove(l);
                            ImageLayers.this.layerFiles = StringUtils.join((Collection)ImageLayers.this.layers, (String)",");
                            ImageLayers.this.rebuildControls();
                        }
                    });
                    menu2.add(l.getName() + "(" + l.getTransparency() + ")").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String s = JOptionPane.showInputDialog(ImageLayers.this.getConsole(), "Enter opacity (1 for opaque, 0 for invisible)", l.getTransparency());
                            if (s == null) {
                                return;
                            }
                            try {
                                double val = Double.parseDouble(s);
                                if (val < 0.0) {
                                    throw new Exception("Value must be greater or equal to 0");
                                }
                                if (val > 1.0) {
                                    throw new Exception("Value must be less or equal to 1");
                                }
                                l.setTransparency(val);
                            }
                            catch (Exception ex) {
                                GuiUtils.errorMessage(ImageLayers.this.getConsole(), ex);
                            }
                        }
                    });
                }
                popup.add(menu);
                popup.add(menu2);
            }
            popup.show(source, event.getX(), event.getY());
        }
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        g.setColor(Color.orange);
        g.drawString(this.note, 50, 20);
        for (ImageLayer il : this.layers) {
            il.paint((Graphics2D)g.create(), renderer);
        }
    }

    private Future<ImageLayer> addLayer(final File f) {
        SwingWorker<ImageLayer, Object> worker = new SwingWorker<ImageLayer, Object>(){

            @Override
            protected ImageLayer doInBackground() throws Exception {
                ImageLayers.this.note = "loading layer in " + f.getAbsolutePath();
                ImageLayer il = ImageLayer.read(f);
                ImageLayers.this.layers.add(il);
                ImageLayers.this.files.add(f);
                ImageLayers.this.note = "";
                ImageLayers.this.layerFiles = StringUtils.join((Collection)ImageLayers.this.files, (String)",");
                ImageLayers.this.rebuildControls();
                return il;
            }
        };
        worker.execute();
        return worker;
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public void initSubPanel() {
        for (String p : this.layerFiles.split(",")) {
            try {
                File f = new File(p);
                ImageLayer il = ImageLayer.read(f);
                this.layers.add(il);
                this.files.add(f);
                this.layerFiles = StringUtils.join(this.files, (String)",");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.rebuildControls();
    }

    @Override
    public void cleanSubPanel() {
    }
}

