/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.JWebCam;
import pt.lsts.neptus.gui.ImagePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer3d.Util3D;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(icon="images/buttons/quicktimebutt.png", name="Video Panel JMF")
public class JVideoPanelConsole
extends ConsolePanel {
    private JWebCam jwc;
    BufferedImage image = new BufferedImage(Util3D.FORMAT_SIZE, Util3D.FORMAT_SIZE, 1);
    Graphics g = this.image.getGraphics();

    public JVideoPanelConsole(ConsoleLayout console) {
        super(console);
        super.setSize(320, 240);
        super.setVisible(true);
        super.repaint();
        Image img = ImageUtils.getImage("images/novideo.png");
        this.g.drawImage(img, 0, 0, Util3D.FORMAT_SIZE, Util3D.FORMAT_SIZE, null);
        ImagePanel J = new ImagePanel(this.image);
        J.setFit_to_panel(true);
        try {
            this.jwc = new JWebCam();
            if (!this.jwc.initialise()) {
                NeptusLog.pub().info((Object)"<###>Web Cam not detected / initialised");
                this.setLayout(new BorderLayout());
                this.add((Component)J, "Center");
            } else {
                this.setLayout(new BorderLayout());
                this.add((Component)this.jwc, "Center");
                this.jwc.setBackground(Color.BLACK);
                this.jwc.setVisible(true);
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)" No video Capture found by JMF video capture", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        if (this.jwc == null) {
            return "Video OFF line (no device connected)";
        }
        if (this.jwc.webCamDeviceInfo == null) {
            return "Video OFF line (no device connected)";
        }
        return this.jwc.webCamDeviceInfo.toString();
    }

    public Image grabFrameImage(int top, int down, int left, int right) {
        if (this.jwc != null && this.jwc.webCamDeviceInfo != null && this.jwc.player != null) {
            Image im = this.jwc.grabFrameImage();
            if (im == null) {
                return null;
            }
            this.g.drawImage(im, 0, 0, Util3D.FORMAT_SIZE, Util3D.FORMAT_SIZE, left, top, im.getWidth(null) - right, im.getHeight(null) - down, null);
            return this.image;
        }
        return this.image;
    }

    @Override
    public void cleanSubPanel() {
        try {
            this.jwc.finalize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initSubPanel() {
    }
}

