/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.media.Buffer;
import javax.media.CannotRealizeException;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import pt.lsts.neptus.NeptusLog;

public class JWebCam
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    protected static final int MIN_WIDTH = 320;
    protected static final int MIN_HEIGHT = 240;
    protected static int shotCounter = 1;
    protected JLabel statusBar = null;
    protected JPanel visualContainer = null;
    protected Component visualComponent = null;
    protected JToolBar toolbar = null;
    protected MyToolBarAction formatButton = null;
    protected MyToolBarAction captureButton = null;
    protected Player player = null;
    protected CaptureDeviceInfo webCamDeviceInfo = null;
    protected MediaLocator ml = null;
    protected Dimension imageSize = null;
    protected FormatControl formatControl = null;
    protected VideoFormat currentFormat = null;
    protected Format[] videoFormats = null;
    protected MyVideoFormat[] myFormatList = null;
    protected MyCaptureDeviceInfo[] myCaptureDevices = null;
    protected boolean initialised = false;

    public JWebCam() {
        this.setSize(320, 260);
        this.addComponentListener(this);
        this.setLayout(new BorderLayout());
        this.visualContainer = new JPanel();
        this.visualContainer.setLayout(new BorderLayout());
        this.add((Component)this.visualContainer, "Center");
        this.statusBar = new JLabel(""){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(10, super.getPreferredSize().height);
            }
        };
        this.statusBar.setBorder(new EtchedBorder());
        this.setBackground(Color.BLACK);
    }

    public boolean initialise() throws Exception {
        Object[] cams = this.autoDetect();
        NeptusLog.pub().info((Object)("<###>cameras detectadas" + cams.length));
        if (cams.length > 0) {
            if (cams.length == 1) {
                NeptusLog.pub().info((Object)"<###>Note : 1 web cam detected");
                return this.initialise(cams[0].capDevInfo);
            }
            NeptusLog.pub().info((Object)("<###>Note : " + cams.length + " web cams detected"));
            Object selected = JOptionPane.showInputDialog(this, "Select Video format", "Capture format selection", 1, null, cams, cams[0]);
            if (selected != null) {
                return this.initialise(((MyCaptureDeviceInfo)selected).capDevInfo);
            }
            return this.initialise(null);
        }
        return this.initialise(null);
    }

    public boolean initialise(CaptureDeviceInfo _deviceInfo) throws Exception {
        this.statusBar.setText("Initialising...");
        this.webCamDeviceInfo = _deviceInfo;
        if (this.webCamDeviceInfo != null) {
            this.statusBar.setText("Connecting to : " + this.webCamDeviceInfo.getName());
            try {
                this.setUpToolBar();
                this.ml = this.webCamDeviceInfo.getLocator();
                if (this.ml != null) {
                    this.player = Manager.createRealizedPlayer((MediaLocator)this.ml);
                    if (this.player != null) {
                        this.player.start();
                        this.formatControl = (FormatControl)this.player.getControl("javax.media.control.FormatControl");
                        this.videoFormats = this.webCamDeviceInfo.getFormats();
                        this.myFormatList = new MyVideoFormat[this.videoFormats.length];
                        for (int i = 0; i < this.videoFormats.length; ++i) {
                            this.myFormatList[i] = new MyVideoFormat((VideoFormat)this.videoFormats[i]);
                        }
                        Format currFormat = this.formatControl.getFormat();
                        this.visualComponent = this.player.getVisualComponent();
                        if (this.visualComponent != null) {
                            this.visualContainer.add(this.visualComponent, "Center");
                            if (currFormat instanceof VideoFormat) {
                                this.currentFormat = (VideoFormat)currFormat;
                                this.imageSize = this.currentFormat.getSize();
                                this.visualContainer.setPreferredSize(this.imageSize);
                                this.setSize(this.imageSize.width, this.imageSize.height);
                            } else {
                                System.err.println("Error : Cannot get current video format");
                            }
                            this.invalidate();
                            return true;
                        }
                        System.err.println("Error : Could not get visual component");
                        return false;
                    }
                    System.err.println("Error : Cannot create player");
                    this.statusBar.setText("Cannot create player");
                    return false;
                }
                System.err.println("Error : No MediaLocator for " + this.webCamDeviceInfo.getName());
                this.statusBar.setText("No Media Locator for : " + this.webCamDeviceInfo.getName());
                return false;
            }
            catch (IOException ioEx) {
                System.err.println("Error connecting to [" + this.webCamDeviceInfo.getName() + "] : " + ioEx.getMessage());
                this.statusBar.setText("Connecting to : " + this.webCamDeviceInfo.getName());
                return false;
            }
            catch (NoPlayerException npex) {
                npex.printStackTrace();
                this.statusBar.setText("Cannot create player");
                return false;
            }
            catch (CannotRealizeException nre) {
                nre.printStackTrace();
                this.statusBar.setText("Cannot realize player");
                return false;
            }
        }
        return false;
    }

    public void setFormat(VideoFormat selectedFormat) {
        if (this.formatControl != null) {
            this.player.stop();
            this.currentFormat = selectedFormat;
            if (this.visualComponent != null) {
                this.visualContainer.remove(this.visualComponent);
            }
            this.imageSize = this.currentFormat.getSize();
            this.visualContainer.setPreferredSize(this.imageSize);
            this.statusBar.setText("Format : " + this.currentFormat);
            NeptusLog.pub().info((Object)("<###>Format : " + this.currentFormat));
            this.formatControl.setFormat((Format)this.currentFormat);
            this.player.start();
            this.visualComponent = this.player.getVisualComponent();
            if (this.visualComponent != null) {
                this.visualContainer.add(this.visualComponent, "Center");
            }
            this.invalidate();
        } else {
            NeptusLog.pub().info((Object)"<###>Visual component not an instance of FormatControl");
            this.statusBar.setText("Visual component cannot change format");
        }
    }

    public VideoFormat getFormat() {
        return this.currentFormat;
    }

    protected void setUpToolBar() {
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.formatButton = new MyToolBarAction("Resolution", "BtnFormat.jpg");
        this.captureButton = new MyToolBarAction("Capture", "BtnCapture.jpg");
        this.toolbar.add(this.formatButton);
        this.toolbar.add(this.captureButton);
    }

    protected void toolbarHandler(MyToolBarAction actionBtn) {
        if (actionBtn == this.formatButton) {
            Object selected = JOptionPane.showInputDialog(this, "Select Video format", "Capture format selection", 1, null, this.myFormatList, this.currentFormat);
            if (selected != null) {
                this.setFormat(((MyVideoFormat)selected).format);
            }
        } else if (actionBtn == this.captureButton) {
            Image photo = this.grabFrameImage();
            if (photo != null) {
                new MySnapshot(photo, new Dimension(this.imageSize));
            } else {
                System.err.println("Error : Could not grab frame");
            }
        }
    }

    public MyCaptureDeviceInfo[] autoDetect() {
        Vector list = CaptureDeviceManager.getDeviceList(null);
        NeptusLog.pub().info((Object)("<###>lista-" + list.size()));
        CaptureDeviceInfo devInfo = null;
        Vector<MyCaptureDeviceInfo> capDevices = new Vector<MyCaptureDeviceInfo>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                devInfo = (CaptureDeviceInfo)list.elementAt(i);
                String name = devInfo.getName();
                NeptusLog.pub().info((Object)("<###> " + name));
                if (!name.startsWith("vfw:")) continue;
                NeptusLog.pub().info((Object)("<###>DeviceManager List : " + name));
                capDevices.addElement(new MyCaptureDeviceInfo(devInfo));
            }
        }
        MyCaptureDeviceInfo[] detected = new MyCaptureDeviceInfo[capDevices.size()];
        for (int i = 0; i < capDevices.size(); ++i) {
            detected[i] = (MyCaptureDeviceInfo)capDevices.elementAt(i);
        }
        return detected;
    }

    public void deviceInfo() {
        if (this.webCamDeviceInfo != null) {
            Format[] formats = this.webCamDeviceInfo.getFormats();
            if (formats == null || formats.length > 0) {
                // empty if block
            }
            for (int i = 0; i < formats.length; ++i) {
                Format aFormat = formats[i];
                if (!(aFormat instanceof VideoFormat)) continue;
            }
        } else {
            NeptusLog.pub().info((Object)"<###>Error : No web cam detected");
        }
    }

    public Buffer grabFrameBuffer() {
        if (this.player != null) {
            FrameGrabbingControl fgc = (FrameGrabbingControl)this.player.getControl("javax.media.control.FrameGrabbingControl");
            if (fgc != null) {
                return fgc.grabFrame();
            }
            System.err.println("Error : FrameGrabbingControl is null");
            return null;
        }
        System.err.println("Error : Player is null");
        return null;
    }

    public Image grabFrameImage() {
        Buffer buffer = this.grabFrameBuffer();
        if (buffer != null) {
            BufferToImage btoi = new BufferToImage((VideoFormat)buffer.getFormat());
            if (btoi != null) {
                Image image = btoi.createImage(buffer);
                if (image != null) {
                    return image;
                }
                System.err.println("Error : BufferToImage cannot convert buffer");
                return null;
            }
        } else {
            NeptusLog.pub().info((Object)"<###>Error : Buffer grabbed is null");
        }
        return null;
    }

    public void playerClose() {
        if (this.player != null) {
            this.player.close();
            this.player.deallocate();
            this.player = null;
        }
    }

    public void windowClosing(WindowEvent e) {
        this.playerClose();
        System.exit(1);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Dimension dim = this.getSize();
        boolean mustResize = false;
        if (dim.width < 320) {
            dim.width = 320;
            mustResize = true;
        }
        if (dim.height < 240) {
            dim.height = 240;
            mustResize = true;
        }
        if (mustResize) {
            this.setSize(dim);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected void finalize() throws Throwable {
        NeptusLog.pub().info((Object)"<###>foi chamado");
        this.playerClose();
        super.finalize();
    }

    public static void main(String[] args) {
        try {
            final JWebCam myWebCam = new JWebCam();
            if (!myWebCam.initialise()) {
                NeptusLog.pub().info((Object)"<###>Web Cam not detected / initialised");
            }
            myWebCam.setVisible(true);
            JFrame frame = new JFrame("Web Cam Capture");
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)myWebCam, "Center");
            frame.setVisible(true);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent arg0) {
                    try {
                        myWebCam.finalize();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class MySnapshot
    extends JFrame
    implements ImageObserver {
        private static final long serialVersionUID = 1L;
        protected Image photo = null;
        protected int shotNumber = shotCounter++;

        public MySnapshot(Image grabbedFrame, Dimension imageSize) {
            this.setTitle("Photo" + this.shotNumber);
            this.photo = grabbedFrame;
            this.setDefaultCloseOperation(2);
            this.photo.getWidth(this);
            this.photo.getHeight(this);
            this.setSize(imageSize.width, imageSize.height);
            final FileDialog saveDialog = new FileDialog((Frame)this, "Save JPEG", 1);
            final MySnapshot thisCopy = this;
            saveDialog.setFile("Photo" + this.shotNumber);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    saveDialog.setVisible(true);
                    String filename = saveDialog.getFile();
                    if (filename != null) {
                        if (MySnapshot.this.saveJPEG(filename)) {
                            JOptionPane.showMessageDialog(thisCopy, "Saved " + filename);
                            MySnapshot.this.setVisible(false);
                            MySnapshot.this.dispose();
                        } else {
                            JOptionPane.showMessageDialog(thisCopy, "Error saving " + filename);
                        }
                    } else {
                        MySnapshot.this.setVisible(false);
                        MySnapshot.this.dispose();
                    }
                }
            });
            this.setVisible(true);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(this.photo, 0, 0, this.getWidth(), this.getHeight(), Color.black, this);
        }

        public boolean saveJPEG(String filename) {
            boolean saved = false;
            BufferedImage bi = new BufferedImage(this.photo.getWidth(null), this.photo.getHeight(null), 1);
            Graphics2D g2 = bi.createGraphics();
            g2.drawImage(this.photo, null, null);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(filename);
                ImageWriter writer = null;
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                if (iter.hasNext()) {
                    writer = iter.next();
                }
                ImageWriteParam iwparam = writer.getDefaultWriteParam();
                iwparam.setCompressionMode(2);
                iwparam.setCompressionQuality(1.0f);
                ImageOutputStream ios = ImageIO.createImageOutputStream(out);
                writer.setOutput(ios);
                writer.write(null, new IIOImage(bi, null, null), iwparam);
                ios.flush();
                writer.dispose();
                ios.close();
                out.close();
                saved = true;
            }
            catch (Exception ex) {
                NeptusLog.pub().info((Object)("<###>Error saving JPEG : " + ex.getMessage()));
            }
            return saved;
        }
    }

    class MyCaptureDeviceInfo {
        public CaptureDeviceInfo capDevInfo;

        public MyCaptureDeviceInfo(CaptureDeviceInfo devInfo) {
            this.capDevInfo = devInfo;
        }

        public String toString() {
            return this.capDevInfo.getName();
        }
    }

    class MyVideoFormat {
        public VideoFormat format;

        public MyVideoFormat(VideoFormat format) {
            this.format = format;
        }

        public String toString() {
            Dimension dim = this.format.getSize();
            return this.format.getEncoding() + " [ " + dim.width + " x " + dim.height + " ]";
        }
    }

    class MyToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public MyToolBarAction(String name, String imagefile) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JWebCam.this.toolbarHandler(this);
        }
    }
}

