/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.LockableSubPanel;
import pt.lsts.neptus.gui.MiniButton;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(icon="images/menus/lock.png", name="Console Lock Button", documentation="lock/lock-button.html")
public class LockConsolePanel
extends ConsolePanel
implements ActionListener {
    private final ImageIcon DEFAULT_ICON = new ImageIcon(ImageUtils.getImage("images/menus/lock.png"));
    private final ImageIcon LOCK_ICON_FILENAME = ImageUtils.getIcon("images/menus/lock.png");
    private ImageIcon icon;
    protected MiniButton lockButton = null;

    public LockConsolePanel(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    private void initialize() {
        this.icon = this.DEFAULT_ICON;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getLockButton(), "Center");
        this.setPreferredSize(new Dimension(40, 40));
        this.setSize(40, 40);
    }

    @Override
    public ImageIcon getImageIcon() {
        return this.icon;
    }

    protected MiniButton getLockButton() {
        if (this.lockButton == null) {
            this.lockButton = new MiniButton();
            this.lockButton.setToggle(true);
            this.lockButton.setPreferredSize(new Dimension(32, 32));
            this.lockButton.setIcon(this.LOCK_ICON_FILENAME);
            this.lockButton.setActionCommand("lock");
            this.lockButton.addActionListener(this);
            this.lockButton.setToolTipText("Lock the lockable components");
        }
        return this.lockButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getConsole() == null) {
            return;
        }
        boolean lock = this.getLockButton().getState();
        for (LockableSubPanel lsp : this.getConsole().getSubPanelsOfInterface(LockableSubPanel.class)) {
            try {
                if (lock) {
                    lsp.lock();
                    continue;
                }
                lsp.unLock();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void initSubPanel() {
    }

    @Override
    public void cleanSubPanel() {
    }
}

