/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LogBookEntry;
import pt.lsts.imc.lsf.LsfMessageLogger;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription(name="Log Book Panel", description="Allows sending entries to the logbook", icon="images/buttons/logbook.png", documentation="logging/logbook.html")
public class LogBookPanel
extends ConsolePanel
implements ActionListener {
    private static final long serialVersionUID = -7765372596110306525L;
    public String name = System.getProperty("user.name");
    protected JTextField textField = new JTextField(10);
    protected JButton button = new JButton("Log");
    protected LogBookEntry logMsg = new LogBookEntry();
    protected Vector<String> msgHistory = new Vector();
    protected int msgHistoryIndex = 0;
    private static DateFormat df1 = new SimpleDateFormat("yyyyMMdd");
    private static DateFormat df2 = new SimpleDateFormat("HH:mm:ss");
    public static String filename = "log/logbook_" + df1.format(new Date()) + ".html";
    private static BufferedWriter lbWriter = null;

    public LogBookPanel(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout());
        this.button.setMargin(new Insets(0, 2, 0, 2));
        this.button.setEnabled(false);
        this.textField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (LogBookPanel.this.textField.getText().length() == 0) {
                    LogBookPanel.this.button.setEnabled(false);
                } else {
                    LogBookPanel.this.button.setEnabled(true);
                }
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LogBookPanel.this.button.doClick();
                } else if (e.getKeyCode() == 38) {
                    if (LogBookPanel.this.msgHistory.size() > 0) {
                        LogBookPanel.this.textField.setText(LogBookPanel.this.msgHistory.get(LogBookPanel.this.msgHistoryIndex));
                    }
                    if (LogBookPanel.this.msgHistoryIndex > 0) {
                        --LogBookPanel.this.msgHistoryIndex;
                    }
                } else if (e.getKeyCode() == 40) {
                    if (LogBookPanel.this.msgHistory.size() > 0) {
                        LogBookPanel.this.textField.setText(LogBookPanel.this.msgHistory.get(LogBookPanel.this.msgHistoryIndex));
                    }
                    if (LogBookPanel.this.msgHistoryIndex < LogBookPanel.this.msgHistory.size() - 1) {
                        ++LogBookPanel.this.msgHistoryIndex;
                    }
                }
            }
        });
        this.textField.setHorizontalAlignment(0);
        this.add((Component)this.textField, "Center");
        this.add((Component)this.button, "East");
        this.button.addActionListener(this);
        this.setSize(200, 31);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.logMsg.setContext(this.name);
        this.logMsg.setHtime(DateTimeUtil.timeStampSeconds());
        this.logMsg.setType(LogBookEntry.TYPE.INFO);
        this.logMsg.setText(this.textField.getText());
        LogBookPanel.logPlain(this.textField.getText() + "\n");
        try {
            LsfMessageLogger.log((IMCMessage)this.logMsg);
            if (this.msgHistory.isEmpty() || !this.msgHistory.lastElement().equals(this.textField.getText())) {
                this.msgHistory.add(this.textField.getText());
            }
            if (!this.msgHistory.isEmpty()) {
                this.msgHistoryIndex = this.msgHistory.size() - 1;
            }
            this.textField.setText("");
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)ex);
        }
    }

    public static void logPlain(String text) {
        try {
            BufferedWriter lb = LogBookPanel.getLogBookWriter();
            if (lb != null) {
                lb.write("<tr><td><b>" + df2.format(new Date()) + "</b></td><td>" + text + "</td></tr>");
                lb.flush();
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    private static BufferedWriter getLogBookWriter() throws Exception {
        if (lbWriter == null) {
            boolean fileExists = new File(filename).exists();
            lbWriter = new BufferedWriter(new FileWriter(new File(filename), true));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        LogBookPanel.logPlain("Neptus shutdown");
                        lbWriter.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            if (!fileExists) {
                lbWriter.write("<html><head><title>Neptus Log Book</title></head><body><table>");
            }
        }
        return lbWriter;
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        GuiUtils.testFrame(new LogBookPanel(null));
    }

    @Override
    public void initSubPanel() {
    }

    @Override
    public void cleanSubPanel() {
    }
}

