/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.systems.external.ExternalSystem;
import pt.lsts.neptus.systems.external.ExternalSystemsHolder;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription(author="Paulo Dias", name="MyLocationDisplay", version="1.3.1", icon="images/myloc.png", description="My location display.", documentation="my-location/my-location.html")
@LayerPriority(priority=182)
public class MyLocationDisplay
extends ConsolePanel
implements IPeriodicUpdates,
Renderer2DPainter,
IEditorMenuExtension,
ConfigurationListener,
SubPanelChangeListener,
MissionChangeListener {
    private final Icon ICON = ImageUtils.getScaledIcon("images/myloc.png", 24, 24);
    private static int secondsToDisplayRanges = 30;
    private final Color orangeNINFO = new Color(230, 121, 56);
    @NeptusProperty(name="Location", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public LocationType location = MyState.getLocation();
    @NeptusProperty(name="My Heading", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double headingDegrees = 0.0;
    @NeptusProperty(name="Use configured My Heading", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean useConfiguredMyHeading = false;
    @NeptusProperty(name="Follow Position Of", editable=false, category="Follow System", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Uses position and heading of other system as mine.")
    private String followPositionOf = "";
    @NeptusProperty(name="Follow Heading Of", editable=false, category="Follow System", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Uses heading of other system as mine.")
    private String followHeadingOf = "";
    @NeptusProperty(name="Follow Heading Of with Angle Offset", editable=false, category="Follow System", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Adds an angle offset to the heading of other system.")
    private short followHeadingOfAngleOffset = 0;
    @NeptusProperty(name="Use System to Derive Heading", editable=false, category="Derive Heading", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Uses the angle between me and another system to derive mine heading.")
    private String useSystemToDeriveHeading = "";
    @NeptusProperty(name="Angle Offset from Front to Derived Heading", editable=false, category="Derive Heading", userLevel=NeptusProperty.LEVEL.ADVANCED, description="This is the angle offset between what you consider front and the line from you to derive heading system. (Clockwise positive angle.)")
    private short angleOffsetFromFrontToDerivedHeading = 0;
    @NeptusProperty(name="Angle Offset from Front to Where the Operator is Looking", editable=false, category="Derive Heading", userLevel=NeptusProperty.LEVEL.ADVANCED, description="This is the angle offset between what you consider front and where the operator is looking. (Clockwise positive angle.)")
    private short angleOffsetFromFrontToWhereTheOperatorIsLooking = 0;
    @NeptusProperty(name="Length", category="Dimension", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double length = 0.0;
    @NeptusProperty(name="Width", category="Dimension", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double width = 0.0;
    @NeptusProperty(name="Show Data Source", editable=true, userLevel=NeptusProperty.LEVEL.ADVANCED, description="Show position and heading sources on the screen.")
    private boolean enableShowDataSource = false;
    private long lastCalcPosTimeMillis = -1L;
    private static GeneralPath arrowShape;
    private Vector<ILayerPainter> renderers = new Vector();
    private Vector<IMapPopup> renderersPopups = new Vector();
    protected GeneralPath myShape = new GeneralPath();

    public MyLocationDisplay(ConsoleLayout console) {
        super(console);
        this.myShape.moveTo(0.0f, 5.0f);
        this.myShape.lineTo(-5.0, 3.5);
        this.myShape.lineTo(-5.0f, -5.0f);
        this.myShape.lineTo(5.0f, -5.0f);
        this.myShape.lineTo(5.0, 3.5);
        this.myShape.lineTo(0.0f, 5.0f);
        this.myShape.closePath();
        this.initialize();
    }

    private void initialize() {
        this.setVisibility(false);
        this.location = MyState.getLocation();
        this.headingDegrees = MyState.getAxisAnglesDegrees()[2];
        this.length = MyState.getLength();
        this.width = MyState.getWidth();
    }

    @Override
    public void initSubPanel() {
        this.renderersPopups = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        for (IMapPopup iMapPopup : this.renderersPopups) {
            iMapPopup.addMenuExtension(this);
        }
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter iLayerPainter : this.renderers) {
            iLayerPainter.addPostRenderPainter(this, I18n.text("My location"));
        }
    }

    @Override
    public long millisBetweenUpdates() {
        return 500L;
    }

    @Override
    public boolean update() {
        ImcSystem sys;
        LocationType newLocation = this.location = MyState.getLocation();
        if (!this.useConfiguredMyHeading) {
            this.headingDegrees = MyState.getHeadingInDegrees();
        }
        double newHeadingDegrees = this.headingDegrees;
        this.lastCalcPosTimeMillis = MyState.getLastLocationUpdateTimeMillis();
        this.length = MyState.getLength();
        this.width = MyState.getWidth();
        boolean updateLocation = false;
        boolean updateHeading = false;
        if (this.followPositionOf != null && this.followPositionOf.length() != 0) {
            sys = ImcSystemsHolder.lookupSystemByName(this.followPositionOf);
            LocationType loc = null;
            long locTime = -1L;
            if (!this.useConfiguredMyHeading) {
                this.headingDegrees = 0.0;
            }
            long headingDegreesTime = -1L;
            if (sys != null) {
                loc = sys.getLocation();
                locTime = sys.getLocationTimeMillis();
                if (!this.useConfiguredMyHeading) {
                    this.headingDegrees = sys.getYawDegrees();
                    headingDegreesTime = sys.getAttitudeTimeMillis();
                }
            } else {
                ExternalSystem ext = ExternalSystemsHolder.lookupSystem(this.followPositionOf);
                if (ext != null) {
                    loc = ext.getLocation();
                    locTime = ext.getLocationTimeMillis();
                    if (!this.useConfiguredMyHeading) {
                        this.headingDegrees = ext.getYawDegrees();
                        headingDegreesTime = ext.getAttitudeTimeMillis();
                    }
                }
            }
            if (loc != null && locTime - this.lastCalcPosTimeMillis > 0L) {
                updateLocation = true;
                newLocation = loc;
            }
            if (headingDegreesTime - this.lastCalcPosTimeMillis > 0L && !this.isFollowingHeadingOfFilled() && !this.isSystemToDeriveHeadingFilled()) {
                updateHeading = true;
                newHeadingDegrees = this.headingDegrees;
            }
        }
        if (!this.useConfiguredMyHeading && this.isFollowingHeadingOfFilled()) {
            sys = ImcSystemsHolder.lookupSystemByName(this.followHeadingOf);
            double headingDegrees = 0.0;
            long headingDegreesTime = -1L;
            if (sys != null) {
                headingDegrees = sys.getYawDegrees();
                headingDegreesTime = sys.getAttitudeTimeMillis();
            } else {
                ExternalSystem ext = ExternalSystemsHolder.lookupSystem(this.followHeadingOf);
                if (ext != null) {
                    headingDegrees = ext.getYawDegrees();
                    headingDegreesTime = ext.getAttitudeTimeMillis();
                }
            }
            if (headingDegreesTime - this.lastCalcPosTimeMillis > 0L) {
                updateHeading = true;
                newHeadingDegrees = headingDegrees + (double)this.followHeadingOfAngleOffset;
            }
        }
        if (!this.useConfiguredMyHeading && this.isSystemToDeriveHeadingFilled()) {
            sys = ImcSystemsHolder.lookupSystemByName(this.useSystemToDeriveHeading);
            LocationType loc = null;
            if (sys != null) {
                loc = sys.getLocation();
            } else {
                ExternalSystem ext = ExternalSystemsHolder.lookupSystem(this.useSystemToDeriveHeading);
                if (ext != null) {
                    loc = ext.getLocation();
                }
            }
            if (loc != null) {
                double[] bearingRange = CoordinateUtil.getNEBearingDegreesAndRange(newLocation, loc);
                bearingRange[0] = bearingRange[0] + (double)(-this.angleOffsetFromFrontToDerivedHeading + this.angleOffsetFromFrontToWhereTheOperatorIsLooking);
                updateHeading = true;
                newHeadingDegrees = bearingRange[0];
            }
        }
        if (this.useConfiguredMyHeading) {
            updateHeading = true;
            newHeadingDegrees = this.headingDegrees;
        }
        if (updateLocation && updateHeading) {
            MyState.setLocationAndAxis(newLocation, AngleCalc.nomalizeAngleDegrees360(newHeadingDegrees));
        } else if (updateLocation) {
            MyState.setLocation(newLocation);
        } else if (updateHeading) {
            MyState.setHeadingInDegrees(AngleCalc.nomalizeAngleDegrees360(newHeadingDegrees));
        }
        return true;
    }

    private boolean isSystemToDeriveHeadingFilled() {
        return this.useSystemToDeriveHeading != null && this.useSystemToDeriveHeading.isEmpty();
    }

    private boolean isFollowingHeadingOfFilled() {
        return this.followHeadingOf != null && this.followHeadingOf.isEmpty();
    }

    @Override
    public void paint(Graphics2D g2, StateRenderer2D renderer) {
        double alfaPercentage = 1.0;
        int dt = 3;
        long deltaTimeMillis = System.currentTimeMillis() - this.lastCalcPosTimeMillis;
        if ((double)deltaTimeMillis > (double)secondsToDisplayRanges * 1000.0) {
            dt = 0;
        } else if ((double)deltaTimeMillis > (double)secondsToDisplayRanges * 1000.0 / 2.0) {
            dt = 1;
        } else if ((double)deltaTimeMillis > (double)secondsToDisplayRanges * 1000.0 / 4.0) {
            dt = 2;
        }
        double rotationAngle = renderer.getRotation();
        Point2D centerPos = renderer.getScreenPosition(new LocationType(this.location));
        Color color = this.orangeNINFO;
        Graphics2D g = (Graphics2D)g2.create();
        g.setStroke(new BasicStroke(2.0f));
        double diameter = Math.max(this.length, this.width);
        if (diameter > 0.0) {
            Graphics2D gt = (Graphics2D)g.create();
            double scaleX = (double)(renderer.getZoom() / 10.0f) * this.width;
            double scaleY = (double)(renderer.getZoom() / 10.0f) * this.length;
            Color colorCircle = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(150.0 * alfaPercentage));
            gt.setColor(colorCircle);
            gt.draw(new Ellipse2D.Double(centerPos.getX() - (diameter *= (double)renderer.getZoom()) / 2.0, centerPos.getY() - diameter / 2.0, diameter, diameter));
            gt.translate(centerPos.getX(), centerPos.getY());
            gt.rotate(Math.PI + Math.toRadians(this.headingDegrees) - renderer.getRotation());
            if (this.isSystemToDeriveHeadingFilled()) {
                gt.rotate(Math.toRadians(-this.angleOffsetFromFrontToWhereTheOperatorIsLooking));
            } else if (this.isFollowingHeadingOfFilled()) {
                gt.rotate(Math.toRadians(-this.followHeadingOfAngleOffset));
            }
            gt.scale(scaleX, scaleY);
            gt.fill(this.myShape);
            gt.dispose();
        }
        if (dt > 0) {
            g.setColor(new Color(0, 0, 0, (int)(255.0 * alfaPercentage)));
            g.draw(new Arc2D.Double(centerPos.getX() - 12.0, centerPos.getY() - 12.0, 24.0, 24.0, -30.0, 60.0, 0));
            g.draw(new Arc2D.Double(centerPos.getX() - 12.0, centerPos.getY() - 12.0, 24.0, 24.0, 150.0, 60.0, 0));
            color = this.orangeNINFO;
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * alfaPercentage)));
            g.draw(new Arc2D.Double(centerPos.getX() - 14.0, centerPos.getY() - 14.0, 28.0, 28.0, -30.0, 60.0, 0));
            g.draw(new Arc2D.Double(centerPos.getX() - 14.0, centerPos.getY() - 14.0, 28.0, 28.0, 150.0, 60.0, 0));
        }
        if (dt > 1) {
            g.setColor(new Color(0, 0, 0, (int)(255.0 * alfaPercentage)));
            g.draw(new Arc2D.Double(centerPos.getX() - 16.0, centerPos.getY() - 16.0, 32.0, 32.0, -30.0, 60.0, 0));
            g.draw(new Arc2D.Double(centerPos.getX() - 16.0, centerPos.getY() - 16.0, 32.0, 32.0, 150.0, 60.0, 0));
            color = this.orangeNINFO;
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * alfaPercentage)));
            g.draw(new Arc2D.Double(centerPos.getX() - 18.0, centerPos.getY() - 18.0, 36.0, 36.0, -30.0, 60.0, 0));
            g.draw(new Arc2D.Double(centerPos.getX() - 18.0, centerPos.getY() - 18.0, 36.0, 36.0, 150.0, 60.0, 0));
        }
        g.translate(centerPos.getX(), centerPos.getY());
        color = this.orangeNINFO;
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * alfaPercentage));
        g.setColor(color);
        g.fill(new Ellipse2D.Double(-9.0, -9.0, 18.0, 18.0));
        color = this.orangeNINFO.brighter();
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * alfaPercentage));
        g.setColor(color);
        g.setStroke(new BasicStroke(2.0f));
        g.draw(new Ellipse2D.Double(-9.0, -9.0, 18.0, 18.0));
        g.setColor(new Color(0, 0, 0, (int)(140.0 * alfaPercentage)));
        g.fill(new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0));
        g.setColor(Color.BLACK);
        double newYaw = Math.toRadians(this.headingDegrees);
        GeneralPath shape = MyLocationDisplay.getArrow();
        g.rotate(-rotationAngle);
        g.rotate(newYaw + Math.PI);
        color = Color.BLACK;
        g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(150.0 * alfaPercentage)));
        g.setStroke(new BasicStroke(2.0f));
        g.fill(shape);
        color = Color.BLACK.darker();
        g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(150.0 * alfaPercentage)));
        g.draw(shape);
        g.setColor(Color.BLACK);
        g.rotate(-(newYaw + Math.PI));
        g.rotate(rotationAngle);
        String meTextToDraw = I18n.text("Me");
        if (this.enableShowDataSource) {
            meTextToDraw = meTextToDraw + (this.followPositionOf != null && this.followPositionOf.length() != 0 ? " " + I18n.text("Pos. external") : "") + (this.isSystemToDeriveHeadingFilled() || this.isFollowingHeadingOfFilled() ? " " + I18n.textc("Heading external", "indication that the heading comes from external source") : "");
        }
        g.drawString(meTextToDraw, 18, 14);
        g.dispose();
    }

    private static GeneralPath getArrow() {
        if (arrowShape == null) {
            arrowShape = new GeneralPath();
            arrowShape.moveTo(-2.0f, 0.0f);
            arrowShape.lineTo(2.0f, 0.0f);
            arrowShape.lineTo(2.0f, 0.0f);
            arrowShape.lineTo(8.0f, 0.0f);
            arrowShape.lineTo(0.0f, 8.0f);
            arrowShape.lineTo(-8.0f, 0.0f);
            arrowShape.lineTo(-2.0f, 0.0f);
            arrowShape.closePath();
        }
        return arrowShape;
    }

    @Override
    public Collection<JMenuItem> getApplicableItems(LocationType loc, IMapPopup source) {
        final LocationType l = new LocationType(loc);
        Vector<JMenuItem> menus = new Vector<JMenuItem>();
        JMenu myLocMenu = new JMenu(I18n.text("My location"));
        myLocMenu.setIcon(this.ICON);
        menus.add(myLocMenu);
        AbstractAction addToMap = new AbstractAction(I18n.text("Add My location to map as marker")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        long tstamp = System.currentTimeMillis();
                        LocationType locContact = new LocationType(MyState.getLocation());
                        if (MyLocationDisplay.this.getConsole() == null) {
                            return;
                        }
                        if (MyLocationDisplay.this.getConsole().getMission() == null) {
                            return;
                        }
                        MissionType mission = MyLocationDisplay.this.getConsole().getMission();
                        LinkedHashMap<String, MapMission> mapList = mission.getMapsList();
                        if (mapList == null) {
                            return;
                        }
                        if (mapList.size() == 0) {
                            return;
                        }
                        MapMission mapMission = mapList.values().iterator().next();
                        MapType mapType = mapMission.getMap();
                        MarkElement contact = new MarkElement();
                        contact.setCenterLocation(locContact);
                        String id = I18n.textc("MyLoc", "String prefix for a marker") + "_" + DateTimeUtil.dateTimeFileNameFormaterMillis.format(new Date(tstamp));
                        contact.setId(id);
                        contact.setParentMap(mapType);
                        contact.setMapGroup(mapType.getMapGroup());
                        mapType.addObject(contact);
                        mission.save(false);
                        mapType.getMapGroup().warnListeners(new MapChangeEvent(2));
                    }
                }.start();
            }
        };
        myLocMenu.add(new JMenuItem(addToMap));
        JMenuItem mid = new JMenuItem("" + this.location.toString());
        mid.setEnabled(false);
        myLocMenu.add(mid);
        JMenuItem mid2 = new JMenuItem(I18n.text("Heading") + ": " + (int)this.headingDegrees + "\u00b0");
        mid2.setEnabled(false);
        myLocMenu.add(mid2);
        AbstractAction copy = new AbstractAction(I18n.text("Copy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipboardOwner owner = new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                };
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(MyState.getLocation().getClipboardText()), owner);
            }
        };
        myLocMenu.add(new JMenuItem(copy));
        AbstractAction paste = new AbstractAction(I18n.text("Paste")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean hasTransferableText;
                ClipboardOwner owner = new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                };
                Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
                if (hasTransferableText) {
                    try {
                        String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                        LocationType lt = new LocationType();
                        lt.fromClipboardText(text);
                        MyState.setLocation(lt);
                    }
                    catch (Exception e1) {
                        NeptusLog.pub().error((Object)e1);
                    }
                }
            }
        };
        myLocMenu.add(new JMenuItem(paste));
        myLocMenu.add(new JSeparator());
        AbstractAction add = new AbstractAction(I18n.text("Set this location as Mine")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyState.setLocation(new LocationType(l));
            }
        };
        myLocMenu.add(new JMenuItem(add));
        String txtUsingSysLoc = this.followPositionOf != null && this.followPositionOf.length() != 0 ? " [" + I18n.text("using") + " " + this.followPositionOf + "]" : "";
        txtUsingSysLoc = txtUsingSysLoc.length() == 0 ? I18n.text("Set to use a system position and heading as mine") : I18n.text("Change the system to use position and heading from") + txtUsingSysLoc;
        AbstractAction useThisLoc = new AbstractAction(txtUsingSysLoc){

            /*
             * WARNING - void declaration
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                void var9_15;
                Vector<String> options = new Vector<String>();
                String noneStr = I18n.text("NONE");
                options.add(noneStr);
                options.add(MyLocationDisplay.this.getConsole().getMainSystem());
                String initialValue = MyLocationDisplay.this.followPositionOf == null || MyLocationDisplay.this.followPositionOf.length() == 0 ? noneStr : MyLocationDisplay.this.followPositionOf;
                Vector<String> sysList = new Vector<String>();
                for (ImcSystem imcSystem : ImcSystemsHolder.lookupAllSystems()) {
                    if (options.contains(imcSystem.getName())) continue;
                    sysList.add(imcSystem.getName());
                }
                for (Comparable<ImcSystem> comparable : ExternalSystemsHolder.lookupAllSystems()) {
                    if (options.contains(((ExternalSystem)comparable).getName())) continue;
                    sysList.add(((ExternalSystem)comparable).getName());
                }
                Collections.sort(sysList);
                options.addAll(sysList);
                Vector extList = new Vector();
                ExternalSystem[] arr$ = ExternalSystemsHolder.lookupAllSystems();
                int len$ = arr$.length;
                boolean bl = false;
                while (var9_15 < len$) {
                    ExternalSystem ext = arr$[var9_15];
                    if (!options.contains(ext.getName())) {
                        sysList.add(ext.getName());
                    }
                    ++var9_15;
                }
                Collections.sort(extList);
                options.addAll(extList);
                if (!options.contains(initialValue)) {
                    options.add(2, initialValue);
                }
                Object[] aopt = options.toArray(new String[options.size()]);
                String ret = (String)JOptionPane.showInputDialog(MyLocationDisplay.this.getConsole(), I18n.text("Set to use a system position and heading as mine"), I18n.text("Choose a system"), 3, MyLocationDisplay.this.ICON, aopt, initialValue);
                if (ret == null) {
                    return;
                }
                if (noneStr.equalsIgnoreCase(ret)) {
                    MyLocationDisplay.this.followPositionOf = "";
                } else {
                    MyLocationDisplay.this.followPositionOf = ret;
                }
            }
        };
        myLocMenu.add(new JMenuItem(useThisLoc));
        String txtUseThisHeading = this.isFollowingHeadingOfFilled() ? " [" + I18n.text("using") + " " + this.followHeadingOf + "]" : "";
        txtUseThisHeading = txtUseThisHeading.length() == 0 ? I18n.text("Set to use a system heading as mine") : I18n.text("Change the system to use heading from") + txtUseThisHeading;
        AbstractAction useThisHeading = new AbstractAction(txtUseThisHeading){

            /*
             * WARNING - void declaration
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                void var9_15;
                Vector<String> options = new Vector<String>();
                String noneStr = I18n.text("NONE");
                options.add(noneStr);
                options.add(MyLocationDisplay.this.getConsole().getMainSystem());
                String initialValue = MyLocationDisplay.this.followHeadingOf == null || MyLocationDisplay.this.followHeadingOf.length() == 0 ? noneStr : MyLocationDisplay.this.followHeadingOf;
                Vector<String> sysList = new Vector<String>();
                for (ImcSystem imcSystem : ImcSystemsHolder.lookupAllSystems()) {
                    if (options.contains(imcSystem.getName())) continue;
                    sysList.add(imcSystem.getName());
                }
                for (Comparable<ImcSystem> comparable : ExternalSystemsHolder.lookupAllSystems()) {
                    if (options.contains(((ExternalSystem)comparable).getName())) continue;
                    sysList.add(((ExternalSystem)comparable).getName());
                }
                Collections.sort(sysList);
                options.addAll(sysList);
                Vector extList = new Vector();
                ExternalSystem[] arr$ = ExternalSystemsHolder.lookupAllSystems();
                int len$ = arr$.length;
                boolean bl = false;
                while (var9_15 < len$) {
                    ExternalSystem ext = arr$[var9_15];
                    if (!options.contains(ext.getName())) {
                        sysList.add(ext.getName());
                    }
                    ++var9_15;
                }
                Collections.sort(extList);
                options.addAll(extList);
                if (!options.contains(initialValue)) {
                    options.add(2, initialValue);
                }
                Object[] aopt = options.toArray(new String[options.size()]);
                String ret = (String)JOptionPane.showInputDialog(MyLocationDisplay.this.getConsole(), I18n.text("Set to use a system heading as mine"), I18n.text("Choose a system"), 3, MyLocationDisplay.this.ICON, aopt, initialValue);
                if (ret == null) {
                    return;
                }
                if (noneStr.equalsIgnoreCase(ret)) {
                    MyLocationDisplay.this.followHeadingOf = "";
                } else {
                    boolean bl2;
                    MyLocationDisplay.this.followHeadingOf = ret;
                    boolean bl3 = false;
                    while (!bl2) {
                        String res = JOptionPane.showInputDialog(MyLocationDisplay.this.getConsole(), I18n.text("Introduce the angle offset from system to use heading from (clockwise positive angle)"), Double.valueOf(AngleCalc.nomalizeAngleDegrees180(MyLocationDisplay.this.followHeadingOfAngleOffset)).shortValue());
                        if (res == null) {
                            return;
                        }
                        try {
                            MyLocationDisplay.this.followHeadingOfAngleOffset = Short.parseShort(res);
                            bl2 = true;
                        }
                        catch (Exception ex) {
                            NeptusLog.pub().debug((Object)ex.getMessage());
                            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), I18n.text("Introduce the angle offset from system to use heading from (clockwise positive angle)"), I18n.text("Value must be a numeric value from [-180, 180]"));
                        }
                    }
                }
            }
        };
        myLocMenu.add(new JMenuItem(useThisHeading));
        String txtUsingSysDeriveHeading = this.isSystemToDeriveHeadingFilled() ? " [" + I18n.text("using") + " " + this.useSystemToDeriveHeading + "]" : "";
        txtUsingSysDeriveHeading = txtUsingSysDeriveHeading.length() == 0 ? I18n.text("Set to use a system to derive heading") : I18n.text("Change the system to derive heading from") + txtUsingSysDeriveHeading;
        AbstractAction useThisForHeading = new AbstractAction(txtUsingSysDeriveHeading){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<String> options = new Vector<String>();
                String noneStr = I18n.text("NONE");
                options.add(noneStr);
                options.add(MyLocationDisplay.this.getConsole().getMainSystem());
                String initialValue = MyLocationDisplay.this.useSystemToDeriveHeading == null || MyLocationDisplay.this.useSystemToDeriveHeading.length() == 0 ? noneStr : MyLocationDisplay.this.useSystemToDeriveHeading;
                Vector<String> sysList = new Vector<String>();
                for (ImcSystem sys : ImcSystemsHolder.lookupAllSystems()) {
                    if (options.contains(sys.getName())) continue;
                    sysList.add(sys.getName());
                }
                Collections.sort(sysList);
                options.addAll(sysList);
                Vector extList = new Vector();
                for (ExternalSystem ext : ExternalSystemsHolder.lookupAllSystems()) {
                    if (options.contains(ext.getName())) continue;
                    sysList.add(ext.getName());
                }
                Collections.sort(extList);
                options.addAll(extList);
                if (!options.contains(initialValue)) {
                    options.add(2, initialValue);
                }
                if (MyLocationDisplay.this.followPositionOf != null && MyLocationDisplay.this.followPositionOf.length() > 0 && options.contains(MyLocationDisplay.this.followPositionOf)) {
                    options.remove(MyLocationDisplay.this.followPositionOf);
                }
                Object[] aopt = options.toArray(new String[options.size()]);
                String ret = (String)JOptionPane.showInputDialog(MyLocationDisplay.this.getConsole(), I18n.text("Set to use a system to derive heading"), I18n.text("Choose a system"), 3, MyLocationDisplay.this.ICON, aopt, initialValue);
                if (ret == null) {
                    return;
                }
                if (noneStr.equalsIgnoreCase(ret)) {
                    MyLocationDisplay.this.useSystemToDeriveHeading = "";
                } else {
                    String res;
                    MyLocationDisplay.this.useSystemToDeriveHeading = ret;
                    boolean validValue = false;
                    while (!validValue) {
                        res = JOptionPane.showInputDialog(MyLocationDisplay.this.getConsole(), I18n.text("Introduce the angle offset from front to derived heading (clockwise positive angle)"), Double.valueOf(AngleCalc.nomalizeAngleDegrees180(MyLocationDisplay.this.angleOffsetFromFrontToDerivedHeading)).shortValue());
                        if (res == null) {
                            return;
                        }
                        try {
                            MyLocationDisplay.this.angleOffsetFromFrontToDerivedHeading = Short.parseShort(res);
                            validValue = true;
                        }
                        catch (Exception ex) {
                            NeptusLog.pub().debug((Object)ex.getMessage());
                            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), I18n.text("Introduce the angle offset from front to derived heading (clockwise positive angle)"), I18n.text("Value must be a numeric value from [-180, 180]"));
                        }
                    }
                    validValue = false;
                    while (!validValue) {
                        res = JOptionPane.showInputDialog(MyLocationDisplay.this.getConsole(), I18n.text("Introduce the angle offset from front to where the operator is looking (clockwise positive angle)"), Double.valueOf(AngleCalc.nomalizeAngleDegrees180(MyLocationDisplay.this.angleOffsetFromFrontToWhereTheOperatorIsLooking)).shortValue());
                        if (res == null) {
                            return;
                        }
                        try {
                            MyLocationDisplay.this.angleOffsetFromFrontToWhereTheOperatorIsLooking = Short.parseShort(res);
                            validValue = true;
                        }
                        catch (Exception ex) {
                            NeptusLog.pub().debug((Object)ex.getMessage());
                            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), I18n.text("Introduce the angle offset from front to where the operator is looking (clockwise positive angle)"), I18n.text("Value must be a numeric value from [-180, 180]"));
                        }
                    }
                }
            }
        };
        myLocMenu.add(new JMenuItem(useThisForHeading));
        myLocMenu.add(new JSeparator());
        AbstractAction settings = new AbstractAction(I18n.text("Settings")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)MyLocationDisplay.this, MyLocationDisplay.this.getConsole(), true);
            }
        };
        myLocMenu.add(new JMenuItem(settings));
        return menus;
    }

    @Override
    public void propertiesChanged() {
        MyState.setHeadingInDegrees(this.headingDegrees);
        MyState.setLength(this.length);
        this.length = MyState.getLength();
        MyState.setWidth(this.width);
        this.width = MyState.getWidth();
    }

    @Override
    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        Object str2d;
        Object sub;
        if (panelChange == null) {
            return;
        }
        this.renderersPopups = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), IMapPopup.class)) {
            sub = (IMapPopup)((Object)panelChange.getPanel());
            if (panelChange.added()) {
                this.renderersPopups.add((IMapPopup)sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addMenuExtension(this);
                }
            }
            if (panelChange.removed()) {
                this.renderersPopups.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removeMenuExtension(this);
                }
            }
        }
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), ILayerPainter.class)) {
            sub = (ILayerPainter)((Object)panelChange.getPanel());
            if (panelChange.added()) {
                this.renderers.add((ILayerPainter)sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addPostRenderPainter(this, "My location");
                }
            }
            if (panelChange.removed()) {
                this.renderers.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removePostRenderPainter(this);
                }
            }
        }
    }

    @Override
    public void cleanSubPanel() {
    }

    @Override
    public void missionReplaced(MissionType mission) {
    }

    @Override
    public void missionUpdated(MissionType mission) {
    }
}

