/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.types.mission.plan.IPlanFileExporter;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription
public class PlanExporter
extends ConsolePanel {
    private static final long serialVersionUID = 5471633324196554012L;
    private String lastExportFolder = ConfigFetch.getConfigFile();

    public PlanExporter(ConsoleLayout console) {
        super(console);
    }

    @Override
    public void cleanSubPanel() {
    }

    @Override
    public void initSubPanel() {
        for (Class<IPlanFileExporter> exporter : PluginsRepository.listExtensions(IPlanFileExporter.class).values()) {
            try {
                final IPlanFileExporter exp = exporter.newInstance();
                this.addMenuItem(I18n.text("Tools") + ">" + I18n.text("Export Plan") + ">" + exp.getExporterName(), null, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (PlanExporter.this.getConsole().getPlan() == null) {
                            GuiUtils.infoMessage(PlanExporter.this.getConsole(), exp.getExporterName(), I18n.text("Nothing to export"));
                            return;
                        }
                        PlanType plan = PlanExporter.this.getConsole().getPlan();
                        JFileChooser chooser = new JFileChooser(PlanExporter.this.lastExportFolder);
                        chooser.setFileView(new NeptusFileView());
                        chooser.setSelectedFile(new File(plan.getDisplayName()));
                        chooser.setFileFilter(GuiUtils.getCustomFileFilter(I18n.textf("%exporterName files", exp.getExporterName()), exp.validExtensions()));
                        chooser.setDialogTitle(I18n.text("Select destination file"));
                        int op = chooser.showSaveDialog(PlanExporter.this.getConsole());
                        if (op != 0) {
                            return;
                        }
                        try {
                            int resp;
                            File dst = chooser.getSelectedFile();
                            String[] exts = exp.validExtensions();
                            if (exts.length > 0 && FileUtil.getFileExtension(dst).isEmpty()) {
                                dst = new File(dst.getAbsolutePath() + "." + exts[0]);
                            }
                            if (dst.exists() && (resp = JOptionPane.showConfirmDialog(PlanExporter.this.getConsole(), I18n.text("Do you want to overwrite the existing file?"), I18n.text("Export plan"), 1)) != 0) {
                                return;
                            }
                            ProgressMonitor pmonitor = new ProgressMonitor(PlanExporter.this.getConsole(), exp.getExporterName(), I18n.text("Exporting"), 0, 100);
                            exp.exportToFile(plan, dst, pmonitor);
                            PlanExporter.this.lastExportFolder = dst.getAbsolutePath();
                            GuiUtils.infoMessage(PlanExporter.this.getConsole(), exp.getExporterName(), pmonitor.isCanceled() ? I18n.text("Export cancelled") : I18n.text("Export done"));
                        }
                        catch (Exception ex) {
                            GuiUtils.errorMessage(PlanExporter.this.getConsole(), ex);
                        }
                    }
                });
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
    }
}

