/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import com.l2fprod.common.swing.StatusBar;
import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.plaf.ButtonUI;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.AbstractConsolePlugin;
import pt.lsts.neptus.console.ConsoleInteraction;
import pt.lsts.neptus.console.ConsoleLayer;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ContainerSubPanel;
import pt.lsts.neptus.console.IConsoleInteraction;
import pt.lsts.neptus.console.IConsoleLayer;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.plugins.Popup;

@Popup(name="Plugin Manager", icon="images/buttons/events.png", pos=Popup.POSITION.CENTER, width=500, height=500, accelerator=80)
public class PluginManager
extends ConsolePanel {
    private static final long serialVersionUID = 1L;
    private JPanel content;
    private JPanel statusPanel;
    private JLabel type = new JLabel();
    private JPanel info;
    private JLabel description = new JLabel();
    private JList<String> activePluginsList;
    private JList<String> availablePluginsList;
    private Map<String, Object> pluginsMap = new LinkedHashMap<String, Object>();
    private Map<String, Class<?>> plugins = new LinkedHashMap();
    private String activeSelected = null;
    private String availableSelected = null;
    private ContainerSubPanel container;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnSettings;

    public PluginManager(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout());
        this.content = new JPanel((LayoutManager)new MigLayout("gap 5px 0, ins 5px"));
        this.add((Component)this.content, "Center");
        StatusBar statusBar = new StatusBar();
        statusBar.setZoneBorder(BorderFactory.createLineBorder(Color.GRAY));
        Component[] componentArray = new Component[1];
        this.statusPanel = new JPanel();
        componentArray[0] = this.statusPanel;
        statusBar.setZones(new String[]{"zone"}, componentArray, new String[]{"*"});
        this.add((Component)statusBar, "South");
        this.createComponents();
        this.createActions();
        this.createListeners();
    }

    private void createComponents() {
        JPanel activePluginsPanel = new JPanel((LayoutManager)new MigLayout("ins 0"));
        JPanel availablePluginsPanel = new JPanel((LayoutManager)new MigLayout("ins 0"));
        this.info = new JPanel((LayoutManager)new MigLayout("gap 5px 0, ins 1px"));
        this.info.setBorder(BorderFactory.createTitledBorder(I18n.text("Info")));
        this.info.add(new JLabel(I18n.text("Type") + ":"));
        this.info.add((Component)this.type, "span, wrap");
        this.info.add((Component)this.description, "span");
        this.content.add((Component)availablePluginsPanel, "h 100%, w 50%");
        this.content.add((Component)activePluginsPanel, "h 100%, w 50%, wrap");
        this.content.add((Component)this.info, "w 100%, h 150px, span");
        JLabel availablePluginsLabel = new JLabel(I18n.text("Available"));
        availablePluginsPanel.add((Component)availablePluginsLabel, "h 7%");
        this.btnAdd = new JButton(I18n.text("Add"));
        this.btnAdd.setUI((ButtonUI)new WindowsButtonUI());
        availablePluginsPanel.add((Component)this.btnAdd, "h 7%, wrap");
        JScrollPane listScroll = new JScrollPane();
        this.availablePluginsList = new JList();
        this.availablePluginsList.setListData((String[])this.getAvailablePlugins());
        listScroll.setViewportView(this.availablePluginsList);
        availablePluginsPanel.add((Component)listScroll, "h 93%, w 100%, span");
        JLabel activePluginsLabel = new JLabel(I18n.text("Active"));
        activePluginsPanel.add((Component)activePluginsLabel, "h 7%");
        this.btnRemove = new JButton(I18n.text("Remove"));
        this.btnRemove.setUI((ButtonUI)new WindowsButtonUI());
        activePluginsPanel.add((Component)this.btnRemove, "h 7%");
        this.btnSettings = new JButton(I18n.text("Settings"));
        this.btnSettings.setUI((ButtonUI)new WindowsButtonUI());
        activePluginsPanel.add((Component)this.btnSettings, "h 7%, wrap");
        JScrollPane activePluginsScrollPane = new JScrollPane();
        this.activePluginsList = new JList();
        activePluginsScrollPane.setViewportView(this.activePluginsList);
        activePluginsPanel.add((Component)activePluginsScrollPane, "h 93%, w 100%, span");
    }

    private void createActions() {
        this.btnAdd.setAction(new AbstractAction(I18n.text("Add")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesProvider sp;
                if (PluginManager.this.availableSelected == null) {
                    return;
                }
                Class clazz = (Class)PluginManager.this.plugins.get(PluginManager.this.availableSelected);
                if (ConsolePanel.class.isAssignableFrom(clazz)) {
                    sp = PluginsRepository.getPanelPlugin(PluginManager.this.availableSelected, PluginManager.this.getConsole());
                    PluginManager.this.container.addSubPanel((ConsolePanel)sp);
                    ((ConsolePanel)sp).init();
                    PluginManager.this.getConsole().informSubPanelListener((ConsolePanel)sp, SubPanelChangeEvent.SubPanelChangeAction.ADDED);
                    PluginManager.this.refreshActivePlugins();
                    NeptusLog.pub().warn((Object)("Added new console panel: " + ((ConsolePanel)sp).getName() + " Class name : " + sp.getClass().getCanonicalName()));
                }
                if (ConsoleLayer.class.isAssignableFrom(clazz)) {
                    sp = PluginsRepository.getConsoleLayer(PluginManager.this.availableSelected);
                    PluginManager.this.getConsole().addMapLayer((IConsoleLayer)sp);
                    PluginManager.this.refreshActivePlugins();
                    NeptusLog.pub().warn((Object)("Added new console layer: " + ((AbstractConsolePlugin)sp).getName() + " Class name : " + sp.getClass().getCanonicalName()));
                }
                if (ConsoleInteraction.class.isAssignableFrom(clazz)) {
                    sp = PluginsRepository.getConsoleInteraction(PluginManager.this.availableSelected);
                    PluginManager.this.getConsole().addInteraction((IConsoleInteraction)((Object)sp));
                    PluginManager.this.refreshActivePlugins();
                    NeptusLog.pub().warn((Object)("Added new console interaction: " + ((AbstractConsolePlugin)sp).getName() + " Class name : " + sp.getClass().getCanonicalName()));
                }
            }
        });
        this.btnRemove.setAction(new AbstractAction(I18n.text("Remove")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesProvider sp;
                if (PluginManager.this.activeSelected == null) {
                    return;
                }
                Class clazz = (Class)PluginManager.this.plugins.get(PluginManager.this.activeSelected);
                if (ConsolePanel.class.isAssignableFrom(clazz)) {
                    sp = (ConsolePanel)PluginManager.this.pluginsMap.get(PluginManager.this.activeSelected);
                    PluginManager.this.container.removeSubPanel(PluginManager.this.activeSelected);
                    PluginManager.this.getConsole().informSubPanelListener((ConsolePanel)sp, SubPanelChangeEvent.SubPanelChangeAction.REMOVED);
                    PluginManager.this.refreshActivePlugins();
                    NeptusLog.pub().warn((Object)("Removed console panel: " + ((ConsolePanel)sp).getName() + " Class name : " + sp.getClass().getCanonicalName()));
                }
                if (ConsoleLayer.class.isAssignableFrom(clazz)) {
                    sp = (ConsoleLayer)PluginManager.this.pluginsMap.get(PluginManager.this.activeSelected);
                    PluginManager.this.getConsole().removeMapLayer((IConsoleLayer)sp);
                    PluginManager.this.refreshActivePlugins();
                    NeptusLog.pub().warn((Object)("Removed layer: " + ((AbstractConsolePlugin)sp).getName() + " Class name : " + sp.getClass().getCanonicalName()));
                }
                if (ConsoleInteraction.class.isAssignableFrom(clazz)) {
                    sp = (ConsoleInteraction)PluginManager.this.pluginsMap.get(PluginManager.this.activeSelected);
                    PluginManager.this.getConsole().removeInteraction((IConsoleInteraction)((Object)sp));
                    PluginManager.this.refreshActivePlugins();
                    NeptusLog.pub().warn((Object)("Removed console interaction: " + ((AbstractConsolePlugin)sp).getName() + " Class name : " + sp.getClass().getCanonicalName()));
                }
            }
        });
        this.btnRemove.getAction().putValue("ShortDescription", I18n.text("Remove selected plugin"));
        this.btnSettings.setAction(new AbstractAction(I18n.text("Settings")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PluginManager.this.activeSelected == null) {
                    return;
                }
                if (PluginManager.this.pluginsMap.get(PluginManager.this.activeSelected) instanceof PropertiesProvider) {
                    PropertiesEditor.editProperties((PropertiesProvider)PluginManager.this.pluginsMap.get(PluginManager.this.activeSelected), true);
                }
            }
        });
        this.btnSettings.getAction().putValue("ShortDescription", I18n.text("Open settings dialog for the selected plugin"));
    }

    private void createListeners() {
        this.activePluginsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = PluginManager.this.activePluginsList.locationToIndex(e.getPoint())) > -1) {
                    PluginManager.this.activeSelected = (String)PluginManager.this.activePluginsList.getSelectedValue();
                    if (PluginManager.this.pluginsMap.get(PluginManager.this.activeSelected) instanceof PropertiesProvider) {
                        PropertiesEditor.editProperties((PropertiesProvider)PluginManager.this.pluginsMap.get(PluginManager.this.activeSelected), true);
                    }
                }
                if (e.getClickCount() == 1 && (index = PluginManager.this.activePluginsList.locationToIndex(e.getPoint())) > -1) {
                    PluginManager.this.activeSelected = (String)PluginManager.this.activePluginsList.getSelectedValue();
                    Class clazz = (Class)PluginManager.this.plugins.get(PluginManager.this.activeSelected);
                    PluginManager.this.type.setText(PluginManager.this.getType(clazz));
                    PluginManager.this.description.setText(PluginUtils.getPluginDescription(clazz));
                }
            }
        });
        this.availablePluginsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 1 && (index = PluginManager.this.availablePluginsList.locationToIndex(e.getPoint())) > -1) {
                    String pluginName = (String)PluginManager.this.availablePluginsList.getSelectedValue();
                    PluginManager.this.availableSelected = pluginName;
                    Class clazz = (Class)PluginManager.this.plugins.get(pluginName);
                    PluginManager.this.type.setText(PluginManager.this.getType(clazz));
                    PluginManager.this.description.setText(PluginUtils.getPluginDescription(clazz));
                }
            }
        });
    }

    private String getType(Class<?> clazz) {
        String type = "N/A";
        if (ConsolePanel.class.isAssignableFrom(clazz)) {
            type = "Panel";
        }
        if (ConsoleLayer.class.isAssignableFrom(clazz)) {
            type = "Layer";
        }
        if (ConsoleInteraction.class.isAssignableFrom(clazz)) {
            type = "Interaction";
        }
        return type;
    }

    private String[] getAvailablePlugins() {
        this.plugins.putAll(PluginsRepository.getPanelPlugins());
        this.plugins.putAll(PluginsRepository.getConsoleInteractions());
        this.plugins.putAll(PluginsRepository.getConsoleLayerPlugins());
        String[] pluginNames = this.plugins.keySet().toArray(new String[0]);
        Arrays.sort(pluginNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Collator collator = Collator.getInstance(Locale.US);
                return collator.compare(PluginUtils.i18nTranslate(o1), PluginUtils.i18nTranslate(o2));
            }
        });
        return pluginNames;
    }

    private void refreshActivePlugins() {
        this.pluginsMap.clear();
        ArrayList<String> names = new ArrayList<String>();
        for (ConsolePanel panel : this.getConsole().getSubPanels()) {
            names.add(panel.getName());
            this.pluginsMap.put(panel.getName(), panel);
            if (!(panel instanceof ContainerSubPanel)) continue;
            this.container = (ContainerSubPanel)panel;
            List<ConsolePanel> panels = ((ContainerSubPanel)panel).getSubPanels();
            Collections.sort(panels, new Comparator<ConsolePanel>(){

                @Override
                public int compare(ConsolePanel o1, ConsolePanel o2) {
                    Collator collator = Collator.getInstance(Locale.US);
                    return collator.compare(PluginUtils.i18nTranslate(o1.getName()), PluginUtils.i18nTranslate(o2.getName()));
                }
            });
            for (ConsolePanel panel2 : panels) {
                names.add(panel2.getName());
                this.pluginsMap.put(panel2.getName(), panel2);
            }
        }
        for (IConsoleLayer layer : this.getConsole().getLayers()) {
            names.add(layer.getName());
            this.pluginsMap.put(layer.getName(), layer);
        }
        for (IConsoleInteraction interaction : this.getConsole().getInteractions()) {
            names.add(interaction.getName());
            this.pluginsMap.put(interaction.getName(), interaction);
        }
        this.activePluginsList.setListData((String[])names.toArray(new String[0]));
    }

    @Override
    public void initSubPanel() {
        this.refreshActivePlugins();
    }

    @Override
    public void cleanSubPanel() {
    }
}

