/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.PropertiesProviders;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginUtils;

public class SidescanConfig
implements PropertiesProvider {
    @NeptusProperty(name="Apply slant range correction (cross path)", category="Visualization parameters")
    public boolean slantRangeCorrection = false;
    @NeptusProperty(name="Apply speed correction (along path)", category="Visualization parameters")
    public boolean speedCorrection = false;
    @NeptusProperty(name="Apply time variable gain", category="Visualization parameters")
    public boolean timeVariableGain = false;
    @NeptusProperty(name="Color map to use", category="Visualization parameters")
    public ColorMap colorMap = ColorMapFactory.createBronzeColormap();
    @NeptusProperty(name="Normalization factor", category="Visualization parameters")
    public double normalization = 0.2;
    @NeptusProperty(name="Time Variable Gain factor", category="Visualization parameters")
    public double tvgGain = 75.0;
    @NeptusProperty(name="Display Vehicle Path", category="Vehicle Path")
    public boolean showPositionHud = true;
    @NeptusProperty(name="Size of Vehicle Path Display", category="Vehicle Path")
    public int hudSize = 200;
    @NeptusProperty(name="Path display color", category="Vehicle Path")
    public Color pathColor = Color.WHITE;

    public SidescanConfig() {
        this.loadProps();
    }

    protected void loadProps() {
        try {
            PluginUtils.loadProperties("conf/sidescan.properties", (Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveProps() {
        try {
            PluginUtils.saveProperties("conf/sidescan.properties", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public DefaultProperty[] getProperties() {
        return PluginUtils.getPluginProperties(this);
    }

    @Override
    public void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this, properties);
    }

    @Override
    public String getPropertiesDialogTitle() {
        return I18n.textf("%plugin parameters", PluginUtils.getPluginName(this.getClass()));
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return PluginUtils.validatePluginProperties((Object)this, properties);
    }
}

