/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PlanControl;
import pt.lsts.imc.Teleoperation;
import pt.lsts.imc.TeleoperationDone;
import pt.lsts.neptus.comm.IMCSendMessageUtils;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.LockableSubPanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.gui.StatusLed;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(author="Paulo Dias", name="Remote Operation Control Panel", icon="images/control-mode/cmode.png", version="1.3.0", description="To enter and leave remote operation.", documentation="plan-control/remoteoperationcontrolmode.html")
public class RemoteOperationControlMode
extends ConsolePanel
implements MainVehicleChangeListener,
IPeriodicUpdates,
LockableSubPanel,
ConfigurationListener,
NeptusMessageListener {
    public final ImageIcon CM_ICON = new ImageIcon(ImageUtils.getImage("images/control-mode/cmode.png"));
    private final ImageIcon CM_CLEAN = new ImageIcon(ImageUtils.getScaledImage("images/led_not.png", 32, 32));
    private final ImageIcon CM_UNKNOWN = new ImageIcon(ImageUtils.getScaledImage("images/control-mode/unknown.png", 32, 32));
    private final ImageIcon CM_NONE = new ImageIcon(ImageUtils.getScaledImage("images/control-mode/wait.png", 32, 32));
    private final ImageIcon CM_MANUAL = new ImageIcon(ImageUtils.getScaledImage("images/control-mode/teleoperation.png", 32, 32));
    private final ImageIcon CM_AUTO = new ImageIcon(ImageUtils.getScaledImage("images/control-mode/autonomous.png", 32, 32));
    private final ImageIcon CM_ALERT = new ImageIcon(ImageUtils.getScaledImage("images/control-mode/alert.png", 32, 32));
    private final ImageIcon CM_CALIB = new ImageIcon(ImageUtils.getScaledImage("images/control-mode/calibration.png", 32, 32));
    private final ImageIcon CM_EXTER = new ImageIcon(ImageUtils.getScaledImage("images/control-mode/external.png", 32, 32));
    private final String CM_NOINFO_TEXT = I18n.text("No Information");
    private final String CM_UNKNOWN_TEXT = I18n.text("Unknown Mode");
    private final String CM_MANUAL_TEXT = I18n.text("Tele-operation Mode");
    private final String CM_ALERT_TEXT = I18n.text("Error Mode");
    private final String CM_SERVICE_TEXT = I18n.text("Service Mode");
    private final String CM_CALIB_TEXT = I18n.text("Calibration Mode");
    private final String CM_MANEUV_TEXT = I18n.text("Maneuver Mode");
    private final String CM_EXTER_TEXT = I18n.text("External Mode");
    private static final String ENTER_REMOTE_TEXT = I18n.text("set remote op.");
    private static final String ENTER_REMOTE_TOOL = I18n.text("request enter remote operation");
    private static final String LEAVE_REMOTE_TEXT = I18n.text("exit remote op.");
    private static final String LEAVE_REMOTE_TOOL = I18n.text("request exit remote operation");
    @NeptusProperty(name="Use PlanControl for Teleoperation or old VehicleCommand")
    public boolean usePlanControlForTeleoperaton = true;
    @NeptusProperty(name="Enable teleoperation button")
    public boolean enableTeleoperationButton = false;
    @NeptusProperty(name="Enable console actions")
    public boolean enableConsoleActions = false;
    @NeptusProperty(name="Font Size")
    public int modeLabelFontSize = 12;
    protected LinkedHashMap<Short, String> cmMessage = new LinkedHashMap();
    protected String controlModeVar = "SetControlMode.state";
    protected String controlModeVar1 = "VehicleState.control_mode";
    protected String opModeVar = "VehicleState.op_mode";
    protected String opModeVar1 = "VehicleState.maneuver_type";
    protected short controlModeValue = 0;
    private long lastMessageReceived = -1L;
    private LinkedHashMap<Short, ImageIcon> oldControlModeIcons = new LinkedHashMap();
    private LinkedHashMap<Short, Color> oldControlModeColors = new LinkedHashMap();
    private LinkedHashMap<Short, String> oldControlModeMessages = new LinkedHashMap();
    private LinkedHashMap<Short, ImageIcon> opModeIcons = new LinkedHashMap();
    private LinkedHashMap<Short, Color> opModeColors = new LinkedHashMap();
    private LinkedHashMap<Short, String> opModeMessages = new LinkedHashMap();
    private boolean opModeOrControlMode = true;
    protected StatusLed state = new StatusLed();
    protected JButton setControlMode = new JButton(I18n.text("remote operation"));
    protected JXLabel modeLabel = new JXLabel("", 0);
    protected ActionListener enterRemoteOperationAction;
    protected ActionListener leaveRemoteOperationAction;

    public RemoteOperationControlMode(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    private void initialize() {
        this.removeAll();
        this.state.made3LevelIndicatorBig();
        this.opModeIcons.put((short)-2, this.CM_CLEAN);
        this.opModeMessages.put((short)-2, this.CM_NOINFO_TEXT);
        this.opModeIcons.put((short)-1, this.CM_UNKNOWN);
        this.opModeMessages.put((short)-1, this.CM_UNKNOWN_TEXT);
        this.opModeIcons.put((short)0, this.CM_NONE);
        this.opModeMessages.put((short)0, this.CM_SERVICE_TEXT);
        this.opModeIcons.put((short)1, this.CM_CALIB);
        this.opModeMessages.put((short)1, this.CM_CALIB_TEXT);
        this.opModeIcons.put((short)2, this.CM_ALERT);
        this.opModeMessages.put((short)2, this.CM_ALERT_TEXT);
        this.opModeIcons.put((short)3, this.CM_AUTO);
        this.opModeMessages.put((short)3, this.CM_MANEUV_TEXT);
        this.opModeIcons.put((short)4, this.CM_EXTER);
        this.opModeMessages.put((short)4, this.CM_EXTER_TEXT);
        this.opModeIcons.put((short)30, this.CM_MANUAL);
        this.opModeMessages.put((short)30, this.CM_MANUAL_TEXT);
        for (Short s : this.opModeIcons.keySet()) {
            this.opModeColors.put(s, Color.BLUE);
        }
        this.state.changeLevels(this.opModeIcons, this.opModeColors);
        this.cmMessage = this.opModeMessages;
        this.setControlMode.addActionListener(this.getRemoteOperationAction());
        this.setControlMode.setText(ENTER_REMOTE_TEXT);
        this.setControlMode.setToolTipText(ENTER_REMOTE_TOOL);
        this.setControlMode.setActionCommand(LEAVE_REMOTE_TEXT);
        this.setControlMode.setVisible(this.enableTeleoperationButton);
        JXPanel holder = new JXPanel();
        holder.setLayout((LayoutManager)new MigLayout("hidemode 3", "", ""));
        holder.add((Component)this.state, (Object)"w 100%, center, wrap");
        this.modeLabel.setFont(new Font("Arial", 1, this.modeLabelFontSize));
        holder.add((Component)this.modeLabel, (Object)"grow, center");
        this.state.setLevel(this.state.getLevel());
        this.setLayout(new BorderLayout());
        holder.add((Component)this.setControlMode);
        this.add((Component)holder);
        this.resetGUI();
        this.setDoubleBuffered(true);
    }

    private void resetGUI() {
        this.setControlMode.setText(ENTER_REMOTE_TEXT);
        this.setControlMode.setToolTipText(ENTER_REMOTE_TOOL);
        this.setControlMode.setActionCommand(LEAVE_REMOTE_TEXT);
        this.setControlModeValue((short)-2);
    }

    @Override
    public void propertiesChanged() {
        this.modeLabel.setFont(new Font("Arial", 1, this.modeLabelFontSize));
        this.setControlMode.setVisible(this.enableTeleoperationButton);
    }

    private void setOpModeOrControlMode(boolean opModeOrControlMode) {
        if (!(opModeOrControlMode ^ this.opModeOrControlMode)) {
            return;
        }
        if (opModeOrControlMode) {
            this.opModeOrControlMode = true;
            this.state.changeLevels(this.opModeIcons, this.opModeColors);
            this.cmMessage = this.opModeMessages;
        } else {
            this.opModeOrControlMode = false;
            this.state.changeLevels(this.oldControlModeIcons, this.oldControlModeColors);
            this.cmMessage = this.oldControlModeMessages;
        }
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange ev) {
        this.resetGUI();
        this.lastMessageReceived = -1L;
    }

    public ActionListener getRemoteOperationAction() {
        if (this.enterRemoteOperationAction == null) {
            this.enterRemoteOperationAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ENTER_REMOTE_TEXT.equals(e.getActionCommand())) {
                        PlanControl msg = PlanControl.create((Object[])new Object[]{"type", "REQUEST", "op", "START", "request_id", IMCSendMessageUtils.getNextRequestId(), "plan_id", "teleoperation-mode", "flags", 0, "arg", new Teleoperation()});
                        RemoteOperationControlMode.this.send((IMCMessage)msg);
                    } else {
                        RemoteOperationControlMode.this.send((IMCMessage)new TeleoperationDone());
                    }
                }
            };
        }
        return this.enterRemoteOperationAction;
    }

    protected short getControlModeValue() {
        return this.controlModeValue;
    }

    protected void setControlModeValue(short controlModeValue) {
        this.controlModeValue = controlModeValue;
        this.state.setLevel(controlModeValue, this.cmMessage.get(controlModeValue));
        this.modeLabel.setText(this.cmMessage.get(controlModeValue));
        short compValue = this.opModeOrControlMode ? (short)30 : 2;
        if (controlModeValue == compValue) {
            this.setControlMode.setText(LEAVE_REMOTE_TEXT);
            this.setControlMode.setToolTipText(LEAVE_REMOTE_TOOL);
            this.setControlMode.setActionCommand(LEAVE_REMOTE_TEXT);
        } else {
            this.setControlMode.setText(ENTER_REMOTE_TEXT);
            this.setControlMode.setToolTipText(ENTER_REMOTE_TOOL);
            this.setControlMode.setActionCommand(ENTER_REMOTE_TEXT);
        }
    }

    @Override
    public String[] getObservedMessages() {
        return new String[]{"VehicleState"};
    }

    @Override
    public void messageArrived(IMCMessage message) {
        this.setOpModeOrControlMode(true);
        this.setControlModeValue((short)message.getInteger("op_mode"));
        this.lastMessageReceived = System.currentTimeMillis();
    }

    @Override
    public long millisBetweenUpdates() {
        return 1000L;
    }

    @Override
    public boolean update() {
        if (this.lastMessageReceived != -1L && System.currentTimeMillis() - this.lastMessageReceived > 5000L) {
            this.setControlModeValue((short)-1);
        }
        return true;
    }

    @Override
    public void lock() {
        this.setControlMode.setEnabled(false);
    }

    @Override
    public void unLock() {
        this.setControlMode.setEnabled(true);
    }

    @Override
    public boolean isLocked() {
        return !this.setControlMode.isEnabled();
    }

    @Override
    public void initSubPanel() {
    }

    @Override
    public void cleanSubPanel() {
    }
}

