/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import javax.swing.JPanel;
import pt.lsts.neptus.util.GuiUtils;

public class ScaleBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    public Graphics2D g2 = null;
    public float maxvalue = 200.0f;
    public float minvalue = 0.0f;
    public float minredlight = -150.0f;
    public float maxredlight = 150.0f;
    public float value = 0.0f;
    public float step = 25.0f;
    public float substep = 5.0f;
    public String label = "Motor";
    public boolean digital = true;
    public boolean hor = false;
    public int precision = 0;
    protected NumberFormat nf = GuiUtils.getNeptusDecimalFormat(this.precision);
    private BufferedImage bi = null;
    Graphics2D g = null;
    public int digprecision = 0;

    public boolean isDigital() {
        return this.digital;
    }

    public void setDigital(boolean digital) {
        this.digital = digital;
    }

    public int getDigprecision() {
        return this.digprecision;
    }

    public void setDigprecision(int digprecision) {
        this.digprecision = digprecision;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.repaint();
    }

    public float getSubstep() {
        return this.substep;
    }

    public void setSubstep(float substep) {
        this.substep = substep;
    }

    public ScaleBar() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(100, 100);
    }

    @Override
    public void paint(Graphics arg0) {
        super.paint(arg0);
        this.update(arg0);
    }

    @Override
    public void update(Graphics arg0) {
        if (this.getWidth() == 0) {
            return;
        }
        try {
            this.g2 = (Graphics2D)arg0;
            if (this.g2 == null) {
                return;
            }
            int width = this.getWidth();
            int height = this.getHeight();
            int bordery = height / 30;
            int borderx = width / 30;
            int axisx = width / 2;
            int axisy = height / 2;
            if (this.bi == null || this.bi.getWidth() < width || this.bi.getHeight() < height) {
                this.bi = (BufferedImage)this.createImage(width, height);
            }
            this.g = (Graphics2D)this.bi.getGraphics();
            this.g.clearRect(0, 0, width, height);
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.g.setPaintMode();
            int radius = axisy - bordery;
            if (radius > axisx - borderx) {
                radius = axisx - borderx;
            }
            if (this.hor) {
                int x;
                int w;
                float d;
                Font font = new Font("Arial", 0, 2 * (int)((float)(axisx - borderx) + this.step) / 40);
                this.g.setFont(font);
                Rectangle2D stringBounds = this.g.getFontMetrics().getStringBounds("" + this.maxvalue, this.g);
                for (d = this.minvalue; d <= this.maxvalue; d += this.step) {
                    if (d < this.minredlight || d > this.maxredlight) {
                        this.g.setColor(Color.red);
                    } else {
                        this.g.setColor(Color.black);
                    }
                    w = width - 2 * borderx;
                    x = (int)(d * (float)w / (this.maxvalue - this.minvalue));
                    x -= (int)(this.minvalue * (float)w / (this.maxvalue - this.minvalue));
                    this.g.drawLine(x += borderx, bordery, x, height - (bordery + (int)stringBounds.getWidth()));
                    this.g.translate(x + (int)stringBounds.getCenterY(), bordery + height - (bordery + (int)stringBounds.getWidth()));
                    this.g.rotate(1.5707963267948966);
                    this.nf = GuiUtils.getNeptusDecimalFormat(this.digprecision);
                    this.g.drawString(this.nf.format(d), 0, 0);
                    this.g.rotate(-1.5707963267948966);
                    this.g.translate(-(x + (int)stringBounds.getCenterY()), -(bordery + height - (bordery + (int)stringBounds.getWidth())));
                }
                for (d = this.minvalue; d <= this.maxvalue; d += this.step / this.substep) {
                    if (d < this.minredlight || d > this.maxredlight) {
                        this.g.setColor(Color.red);
                    } else {
                        this.g.setColor(Color.black);
                    }
                    w = width - 2 * borderx;
                    x = (int)(d * (float)w / (this.maxvalue - this.minvalue));
                    x -= (int)(this.minvalue * (float)w / (this.maxvalue - this.minvalue));
                    this.g.drawLine(x += borderx, bordery, x, height - (bordery * 10 + (int)stringBounds.getWidth()));
                }
                this.g.setColor(Color.green);
                this.g.setXORMode(Color.RED);
                if (this.label != null) {
                    stringBounds = this.g.getFontMetrics().getStringBounds(this.label, this.g);
                    this.g.drawString(this.label, borderx, height - bordery);
                }
                if (this.digital) {
                    this.nf = GuiUtils.getNeptusDecimalFormat(this.digprecision);
                    stringBounds = this.g.getFontMetrics().getStringBounds(this.nf.format(this.value), this.g);
                    this.g.drawString(this.nf.format(this.value), axisx - (int)stringBounds.getCenterX(), bordery + (int)stringBounds.getHeight());
                }
                int w2 = width - 2 * borderx;
                double d2 = this.value;
                int x2 = (int)(d2 * (double)w2 / (double)(this.maxvalue - this.minvalue));
                x2 -= (int)(this.minvalue * (float)w2 / (this.maxvalue - this.minvalue));
                int zero = (int)(0.0 * (double)w2 / (double)(this.maxvalue - this.minvalue));
                zero -= (int)(this.minvalue * (float)w2 / (this.maxvalue - this.minvalue));
                stringBounds = this.g.getFontMetrics().getStringBounds("" + this.maxvalue, this.g);
                if ((zero += borderx) < (x2 += borderx)) {
                    for (int i = zero; i < x2; ++i) {
                        this.g.drawLine(i, bordery + bordery, i, height - (bordery * 10 + (int)stringBounds.getWidth()));
                    }
                } else {
                    for (int i = zero; i > x2; --i) {
                        this.g.drawLine(i, bordery + bordery, i, height - (bordery * 10 + (int)stringBounds.getWidth()));
                    }
                }
            } else {
                int x;
                int w;
                float d;
                Font font = new Font("Arial", 0, 2 * (int)((float)(axisy - bordery) + this.step) / 20);
                this.g.setFont(font);
                Rectangle2D stringBounds = this.g.getFontMetrics().getStringBounds("" + this.maxvalue, this.g);
                for (d = this.minvalue; d <= this.maxvalue; d += this.step) {
                    if (d < this.minredlight || d > this.maxredlight) {
                        this.g.setColor(Color.red);
                    } else {
                        this.g.setColor(Color.black);
                    }
                    w = height - 2 * bordery;
                    x = (int)(d * (float)w / (this.maxvalue - this.minvalue));
                    x -= (int)(this.minvalue * (float)w / (this.maxvalue - this.minvalue));
                    this.g.drawLine(borderx, height - (x += bordery), width - (borderx + (int)stringBounds.getWidth()), height - x);
                    this.g.translate(borderx + width - (borderx + (int)stringBounds.getWidth()), height - (x + (int)stringBounds.getCenterY()));
                    this.nf = GuiUtils.getNeptusDecimalFormat(this.digprecision);
                    this.g.drawString(this.nf.format(d), 0, 0);
                    this.g.translate(-(borderx + width - (borderx + (int)stringBounds.getWidth())), -(height - (x + (int)stringBounds.getCenterY())));
                }
                for (d = this.minvalue; d <= this.maxvalue; d += this.step / this.substep) {
                    if (d < this.minredlight || d > this.maxredlight) {
                        this.g.setColor(Color.red);
                    } else {
                        this.g.setColor(Color.black);
                    }
                    w = height - 2 * bordery;
                    x = (int)(d * (float)w / (this.maxvalue - this.minvalue));
                    x -= (int)(this.minvalue * (float)w / (this.maxvalue - this.minvalue));
                    this.g.drawLine(borderx, height - (x += bordery), width - (borderx * 10 + (int)stringBounds.getWidth()), height - x);
                }
                this.g.setColor(Color.blue);
                if (this.label != null) {
                    stringBounds = this.g.getFontMetrics().getStringBounds(this.label, this.g);
                    this.g.drawString(this.label, borderx, bordery);
                }
                if (this.digital) {
                    this.nf = GuiUtils.getNeptusDecimalFormat(this.digprecision);
                    stringBounds = this.g.getFontMetrics().getStringBounds(this.nf.format(this.value), this.g);
                    this.g.drawString(this.nf.format(this.value), borderx + (int)stringBounds.getWidth(), axisy - (int)stringBounds.getCenterY());
                }
                this.g.setColor(Color.green);
                this.g.setXORMode(Color.RED);
                int w3 = height - 2 * bordery;
                double d3 = this.value;
                int x3 = (int)(d3 * (double)w3 / (double)(this.maxvalue - this.minvalue));
                x3 -= (int)(this.minvalue * (float)w3 / (this.maxvalue - this.minvalue));
                int zero = (int)(0.0 * (double)w3 / (double)(this.maxvalue - this.minvalue));
                zero -= (int)(this.minvalue * (float)w3 / (this.maxvalue - this.minvalue));
                stringBounds = this.g.getFontMetrics().getStringBounds("" + this.maxvalue, this.g);
                if ((zero += bordery) < (x3 += bordery)) {
                    for (int i = zero; i < x3; ++i) {
                        this.g.drawLine(borderx + borderx, height - i, width - (borderx * 10 + (int)stringBounds.getWidth()), height - i);
                    }
                } else {
                    for (int i = zero; i > x3; --i) {
                        this.g.drawLine(borderx + borderx, height - i, width - (borderx * 10 + (int)stringBounds.getWidth()), height - i);
                    }
                }
            }
            this.g2.drawImage((Image)this.bi, 0, 0, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] arg) {
        ScaleBar m = new ScaleBar();
        GuiUtils.testFrame(m, "ScaleBar");
        m.setHorizontal();
        int i = 0;
        while (true) {
            try {
                m.setValue(i);
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            i += 2;
        }
    }

    public float getMaxvalue() {
        return this.maxvalue;
    }

    public void setMaxvalue(float maxvalue) {
        this.maxvalue = maxvalue;
        this.repaint();
    }

    public float getMinvalue() {
        return this.minvalue;
    }

    public void setMinvalue(float minvalue) {
        this.minvalue = minvalue;
        this.repaint();
    }

    public float getStep() {
        return this.step;
    }

    public void setStep(float step) {
        this.step = step;
        this.repaint();
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
        if (value > this.maxvalue) {
            this.value = this.maxvalue;
        }
        if (value < this.minvalue) {
            this.value = this.minvalue;
        }
        this.repaint();
    }

    public float getMaxredlight() {
        return this.maxredlight;
    }

    public void setMaxredlight(float maxredlight) {
        this.maxredlight = maxredlight;
    }

    public float getMinredlight() {
        return this.minredlight;
    }

    public void setMinredlight(float minredlight) {
        this.minredlight = minredlight;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
        this.nf = GuiUtils.getNeptusDecimalFormat(precision);
        this.repaint();
    }

    public int getDigPrecision() {
        return this.digprecision;
    }

    public void setDigPrecision(int precision) {
        this.digprecision = precision;
        this.repaint();
    }

    public void setHorizontal() {
        this.hor = true;
    }

    public void setVertical() {
        this.hor = false;
    }

    public boolean isHor() {
        return this.hor;
    }

    public void setHor(boolean hor) {
        this.hor = hor;
    }
}

