/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ContainerSubPanel;
import pt.lsts.neptus.console.plugins.FunctionalitiesSettings;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@Popup(icon="images/menus/settings.png", name="Console Settings", pos=Popup.POSITION.CENTER, accelerator=114, height=400, width=600)
public class SettingsWindow
extends ConsolePanel {
    private static final long serialVersionUID = 1L;
    private FunctionalitiesSettings settingsPanel;
    private final Vector<PropertiesProvider> subPanels = new Vector();
    private JCheckBox checkLvl;

    public SettingsWindow(ConsoleLayout console) {
        super(console);
        this.removeAll();
        List<PropertiesProvider> consolePlugins = console.getAllPropertiesProviders();
        for (PropertiesProvider propertiesProvider : consolePlugins) {
            if (propertiesProvider == null) continue;
            if (propertiesProvider instanceof ContainerSubPanel) {
                List<ConsolePanel> containerPlugins = ((ContainerSubPanel)propertiesProvider).getSubPanels();
                for (ConsolePanel containerPlugin : containerPlugins) {
                    if (!(containerPlugin instanceof PropertiesProvider)) continue;
                    this.subPanels.add(containerPlugin);
                }
                continue;
            }
            this.subPanels.add(propertiesProvider);
        }
    }

    private void addButtons() {
        this.checkLvl = new JCheckBox(I18n.text("Advanced"));
        this.checkLvl.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SettingsWindow.this.settingsPanel.updateForNewPermission();
            }
        });
        this.checkLvl.setSelected(false);
        this.checkLvl.setFocusable(false);
        JButton save = new JButton(I18n.text("Save"));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsWindow.this.dialog.setVisible(false);
                SettingsWindow.this.settingsPanel.saveChanges();
                SettingsWindow.this.checkLvl.setSelected(false);
                SettingsWindow.this.settingsPanel.reset();
            }
        });
        JButton cancel = new JButton(I18n.text("Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsWindow.this.dialog.setVisible(false);
                SettingsWindow.this.checkLvl.setSelected(false);
                SettingsWindow.this.settingsPanel.reset();
            }
        });
        GuiUtils.reactEnterKeyPress(save);
        GuiUtils.reactEscapeKeyPress(cancel);
        JPanel buttonContainer = new JPanel();
        buttonContainer.setLayout((LayoutManager)new MigLayout("rtl"));
        buttonContainer.add((Component)cancel, "sg buttonOC");
        buttonContainer.add((Component)save, "sg buttonOC");
        buttonContainer.add(this.checkLvl);
        this.add((Component)buttonContainer, "grow");
    }

    @Override
    public void initSubPanel() {
        this.setLayout((LayoutManager)new MigLayout("insets 0"));
        this.removeAll();
        this.settingsPanel = new FunctionalitiesSettings(ConfigFetch.getDistributionType().equals((Object)NeptusProperty.DistributionEnum.CLIENT), this.subPanels);
        this.add((Component)this.settingsPanel, "w 100%!, h 100%, wrap");
        this.addButtons();
        this.settingsPanel.reset();
        this.dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    @Override
    public void cleanSubPanel() {
        this.settingsPanel = null;
    }
}

