/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import com.google.common.eventbus.Subscribe;
import com.rickyclarkson.java.awt.layout.PercentLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.DistancePanel;
import pt.lsts.neptus.console.plugins.RollPitchVehiclePanel;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.util.ConsoleParse;

@Popup(pos=Popup.POSITION.RIGHT, width=500, height=500)
@PluginDescription(name="2D Side View", icon="images/buttons/sensorstatus2dbutt.png")
public class SideState2DPanelConsole
extends ConsolePanel
implements ConfigurationListener,
IPeriodicUpdates {
    private static final long serialVersionUID = -3122371180498520732L;
    @NeptusProperty(name="Up distance variable")
    public String upVar = "";
    @NeptusProperty(name="Down distance variable")
    public String downVar = "BottomDistance.DVL.value";
    @NeptusProperty(name="Back distance variable")
    public String leftVar = "";
    @NeptusProperty(name="Front distance variable")
    public String rightVar = "BottomDistance.EchoSounder.value";
    @NeptusProperty(name="Show up distance")
    public boolean up = true;
    @NeptusProperty(name="Show down distance")
    public boolean down = true;
    @NeptusProperty(name="Show back distance")
    public boolean back = true;
    @NeptusProperty(name="Show front distance")
    public boolean front = true;
    @NeptusProperty(name="Show sea level")
    public boolean sea = true;
    @NeptusProperty(name="Milliseconds between updates")
    public long updateMillis = 100L;
    protected JPanel centerPanel;
    protected DistancePanel upDistancePanel;
    protected DistancePanel downDistancePanel;
    protected RollPitchVehiclePanel renderPanel;
    protected JPanel rightPanel;
    protected JPanel leftPanel;
    protected DistancePanel frontDistancePanel;
    protected DistancePanel backDistancePanel;
    protected JPanel insidePanel = new JPanel();

    @Override
    public long millisBetweenUpdates() {
        return this.updateMillis;
    }

    @Override
    public void initSubPanel() {
        this.renderPanel.setVehicle(this.getMainVehicleId());
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange ev) {
        this.renderPanel.setVehicle(ev.getCurrent());
        this.update();
    }

    @Override
    public boolean update() {
        EstimatedState lastState = this.getState().lastEstimatedState();
        if (lastState == null) {
            return true;
        }
        this.renderPanel.setRoll((float)lastState.getPhi());
        if (!this.sea) {
            this.renderPanel.setPitch((float)lastState.getTheta());
        } else {
            this.renderPanel.setPitchDepth((float)lastState.getTheta(), (float)IMCUtils.getLocation((IMCMessage)lastState).getAllZ());
        }
        if (this.front) {
            this.frontDistancePanel.setValue((Double)this.getState().get(this.rightVar, Double.class));
        }
        if (this.back) {
            this.backDistancePanel.setValue((Double)this.getState().get(this.leftVar, Double.class));
        }
        if (this.up) {
            this.upDistancePanel.setValue((Double)this.getState().get(this.upVar, Double.class));
        }
        if (this.down) {
            this.downDistancePanel.setValue((Double)this.getState().get(this.downVar, Double.class));
        }
        this.repaint();
        return true;
    }

    public SideState2DPanelConsole(ConsoleLayout console) {
        super(console);
        this.removeAll();
        this.setSize(320, 240);
        this.setMinimumSize(new Dimension(100, 100));
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.insidePanel.setLayout((LayoutManager)new PercentLayout());
        this.createLeftPanel();
        this.insidePanel.add((Component)this.leftPanel, new PercentLayout.Constraint(0.0, 0.0, 20.0, 100.0));
        this.createCenterPanel();
        this.insidePanel.add((Component)this.centerPanel, new PercentLayout.Constraint(20.0, 0.0, 60.0, 100.0));
        this.createRightPanel();
        this.insidePanel.add((Component)this.rightPanel, new PercentLayout.Constraint(80.0, 0.0, 20.0, 100.0));
        this.add((Component)this.insidePanel, "Center");
    }

    public void reconfigure() {
        this.insidePanel.removeAll();
        this.insidePanel.setLayout((LayoutManager)new PercentLayout());
        this.reconfigureCentral();
        if (this.front && this.back) {
            this.insidePanel.add((Component)this.leftPanel, new PercentLayout.Constraint(0.0, 0.0, 20.0, 100.0));
            this.insidePanel.add((Component)this.centerPanel, new PercentLayout.Constraint(20.0, 0.0, 60.0, 100.0));
            this.insidePanel.add((Component)this.rightPanel, new PercentLayout.Constraint(80.0, 0.0, 20.0, 100.0));
        }
        if (this.front && !this.back) {
            this.insidePanel.add((Component)this.centerPanel, new PercentLayout.Constraint(0.0, 0.0, 80.0, 100.0));
            this.insidePanel.add((Component)this.rightPanel, new PercentLayout.Constraint(80.0, 0.0, 20.0, 100.0));
        }
        if (!this.front && this.back) {
            this.insidePanel.add((Component)this.leftPanel, new PercentLayout.Constraint(0.0, 0.0, 20.0, 100.0));
            this.insidePanel.add((Component)this.centerPanel, new PercentLayout.Constraint(20.0, 0.0, 80.0, 100.0));
        }
        if (!this.front && !this.back) {
            this.insidePanel.add((Component)this.centerPanel, new PercentLayout.Constraint(0.0, 0.0, 100.0, 100.0));
        }
        this.renderPanel.setSea(this.sea);
        this.forceRepaint();
    }

    public void reconfigureCentral() {
        this.centerPanel.removeAll();
        if (this.up && this.down) {
            this.centerPanel.setLayout(new GridLayout(3, 1));
            this.centerPanel.add(this.upDistancePanel);
            this.centerPanel.add(this.renderPanel);
            this.centerPanel.add(this.downDistancePanel);
        }
        if (!this.up && this.down) {
            this.centerPanel.setLayout(new GridLayout(2, 1));
            this.centerPanel.add(this.renderPanel);
            this.centerPanel.add(this.downDistancePanel);
        }
        if (this.up && !this.down) {
            this.centerPanel.setLayout(new GridLayout(2, 1));
            this.centerPanel.add(this.upDistancePanel);
            this.centerPanel.add(this.renderPanel);
        }
        if (!this.up && !this.down) {
            this.centerPanel.setLayout(new GridLayout(1, 1));
            this.centerPanel.add(this.renderPanel);
        }
    }

    public void forceRepaint() {
        this.doLayout();
        this.repaint();
        this.centerPanel.doLayout();
        this.centerPanel.repaint();
        this.leftPanel.doLayout();
        this.leftPanel.repaint();
        this.rightPanel.doLayout();
        this.rightPanel.repaint();
        this.upDistancePanel.doLayout();
        this.upDistancePanel.repaint();
        this.downDistancePanel.doLayout();
        this.downDistancePanel.repaint();
        this.frontDistancePanel.doLayout();
        this.frontDistancePanel.repaint();
        this.backDistancePanel.doLayout();
        this.backDistancePanel.repaint();
        this.renderPanel.doLayout();
        this.renderPanel.repaint();
    }

    public void createLeftPanel() {
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BorderLayout());
        this.createBackDistancePanel();
        this.leftPanel.add((Component)this.backDistancePanel, "Center");
    }

    public void createCenterPanel() {
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new GridLayout(3, 1));
        this.createUpDistancePanel();
        this.createRenderPanel();
        this.createDownDistancePanel();
        this.centerPanel.add(this.upDistancePanel);
        this.centerPanel.add(this.renderPanel);
        this.centerPanel.add(this.downDistancePanel);
    }

    public void createRightPanel() {
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BorderLayout());
        this.createFrontDistancePanel();
        this.rightPanel.add((Component)this.frontDistancePanel, "Center");
    }

    public void createFrontDistancePanel() {
        this.frontDistancePanel = new DistancePanel();
        this.frontDistancePanel.setType(3);
    }

    public void createBackDistancePanel() {
        this.backDistancePanel = new DistancePanel();
        this.backDistancePanel.setType(2);
    }

    public void createUpDistancePanel() {
        this.upDistancePanel = new DistancePanel();
        this.upDistancePanel.setType(0);
    }

    public void createDownDistancePanel() {
        this.downDistancePanel = new DistancePanel();
        this.downDistancePanel.setType(1);
    }

    public void createRenderPanel() {
        this.renderPanel = new RollPitchVehiclePanel();
    }

    public void setVarUp(String varX) {
        this.upVar = varX;
    }

    public String getVarUp() {
        return this.upVar;
    }

    public void setVarDown(String varX) {
        this.downVar = varX;
    }

    public String getVarDown() {
        return this.downVar;
    }

    public void setVarLeft(String varX) {
        this.leftVar = varX;
    }

    public String getVarLeft() {
        return this.leftVar;
    }

    public void setVarRight(String varX) {
        this.rightVar = varX;
    }

    public String getVarRight() {
        return this.rightVar;
    }

    @Override
    public void propertiesChanged() {
        this.reconfigure();
    }

    public boolean isUp() {
        return this.up;
    }

    public void setUp(boolean up) {
        this.up = up;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down) {
        this.down = down;
    }

    public boolean isLeft() {
        return this.back;
    }

    public void setLeft(boolean left) {
        this.back = left;
    }

    public boolean isRight() {
        return this.front;
    }

    public void setRight(boolean right) {
        this.front = right;
    }

    public boolean isSea() {
        return this.sea;
    }

    public void setSea(boolean sea) {
        this.sea = sea;
    }

    public static void main(String[] args) {
        ConsoleParse.testSubPanel(SideState2DPanelConsole.class);
    }

    @Override
    public void cleanSubPanel() {
    }
}

