/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ImageUtils;

public class SideVehiclePanel
extends JPanel {
    private static final long serialVersionUID = -7234818649430917670L;
    public float pitch = 0.0f;
    public float depth = 0.0f;
    public Graphics2D g2 = null;
    private Image image = null;
    private boolean sea = true;
    public float vsizeX;
    public float vsizeZ;
    private BufferedImage bi = null;
    int lastWidth = 0;

    public SideVehiclePanel() {
        this.initialize();
    }

    public void setVehicle(String id) {
        VehicleType veh = VehiclesHolder.getVehicleById(id);
        if (veh == null) {
            return;
        }
        this.vsizeX = veh.getXSize();
        this.vsizeX = veh.getZSize();
        this.image = ImageUtils.getImage(VehiclesHolder.getVehicleById(id).getSideImageHref());
        this.pitch = 0.0f;
        this.repaint();
    }

    private void initialize() {
        this.setLayout(null);
        this.setDoubleBuffered(true);
    }

    public float getPitch() {
        return this.pitch;
    }

    @Override
    public void paint(Graphics arg0) {
        super.paint(arg0);
        this.update(arg0);
    }

    public void setDepth(float z) {
        this.depth = z;
        this.repaint();
    }

    public void setPitch(float y) {
        this.pitch = y;
        this.repaint();
    }

    public void setValues(float pitcha, float deptha) {
        this.depth = deptha;
        this.pitch = pitcha;
        this.repaint();
    }

    @Override
    public void update(Graphics arg0) {
        if (this.image == null) {
            return;
        }
        this.g2 = (Graphics2D)arg0;
        if (this.g2 == null) {
            return;
        }
        if (this.bi == null || this.bi.getWidth() < this.getWidth() || this.bi.getHeight() < this.getHeight()) {
            this.bi = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        }
        Graphics2D g = (Graphics2D)this.bi.getGraphics();
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.translate(this.getWidth() / 2, this.getHeight() / 2);
        g.rotate(-this.pitch);
        double factorthis = (double)this.getWidth() / (double)this.getHeight();
        double factorim = (double)this.image.getWidth(null) / (double)this.image.getHeight(null);
        double scale = 1.0;
        scale = factorthis < factorim ? (double)this.getWidth() / (double)this.image.getWidth(null) : (double)this.getHeight() / (double)this.image.getHeight(this);
        float metersByPixel = 0.0f;
        if (this.getWidth() != 0) {
            metersByPixel = (float)((double)((float)this.getWidth() / this.vsizeX) * scale);
        }
        g.setColor(Color.BLUE);
        int watterPos = (int)((float)(this.getHeight() / 2) - this.depth * metersByPixel);
        g.scale(scale, scale);
        g.drawImage(this.image, -this.image.getWidth(this) / 2, -this.image.getHeight(this) / 2, this);
        g.scale(1.0 / scale, 1.0 / scale);
        g.rotate(this.pitch);
        g.translate(-this.getWidth() / 2, -this.getHeight() / 2);
        if (this.sea) {
            g.setColor(new Color(Color.BLUE.getRed(), Color.BLUE.getGreen(), Color.BLUE.getBlue(), 125));
            g.fillRect(0, watterPos, this.getWidth() - 1, this.getHeight() - watterPos - 1);
        }
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{2.0f, 5.0f, 2.0f, 5.0f}, 0.0f));
        g.draw(new Line2D.Double(0.0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2));
        this.g2.drawImage((Image)this.bi, 0, 0, this);
    }

    public void drawImage(Graphics2D g, Image img, int imgx, int imgy, int x, int y, int w, int h) {
        Graphics2D ng = (Graphics2D)g.create();
        ng.clipRect(x, y, w, h);
        ng.drawImage(img, imgx, imgy, this);
    }

    public boolean isSea() {
        return this.sea;
    }

    public void setSea(boolean sea) {
        this.sea = sea;
    }

    public static void main(String[] arg) {
    }
}

