/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import com.google.common.eventbus.Subscribe;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import pt.lsts.imc.EntityParameters;
import pt.lsts.imc.FuelLevel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.MonitorIMCComms;
import pt.lsts.neptus.comm.manager.imc.SystemImcMsgCommInfo;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ConsoleSystem;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.ISystemsSelection;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.gui.system.AttentionSymbol;
import pt.lsts.neptus.gui.system.AuthoritySymbol;
import pt.lsts.neptus.gui.system.ConnectionSymbol;
import pt.lsts.neptus.gui.system.EmergencyTaskSymbol;
import pt.lsts.neptus.gui.system.FuelLevelSymbol;
import pt.lsts.neptus.gui.system.LocationSymbol;
import pt.lsts.neptus.gui.system.MilStd2525LikeSymbolsDefinitions;
import pt.lsts.neptus.gui.system.SystemDisplay;
import pt.lsts.neptus.gui.system.SystemDisplayComparator;
import pt.lsts.neptus.gui.system.SystemPainterHelper;
import pt.lsts.neptus.gui.system.SystemTypeSymbol;
import pt.lsts.neptus.gui.system.TaskSymbol;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.renderer2d.CustomInteractionSupport;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.renderer2d.SystemPainterProvider;
import pt.lsts.neptus.systems.external.ExternalSystem;
import pt.lsts.neptus.systems.external.ExternalSystemsHolder;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ColorUtils;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.StringUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@Popup(pos=Popup.POSITION.RIGHT, width=300, height=600, accelerator=83)
@PluginDescription(author="Paulo Dias", version="1.7.1", name="Systems List", icon="images/imc.png", documentation="systems-list/systems-list.html")
@LayerPriority(priority=180)
public class SystemsList
extends ConsolePanel
implements MainVehicleChangeListener,
IPeriodicUpdates,
Renderer2DPainter,
SystemPainterProvider,
IEditorMenuExtension,
ConfigurationListener,
SubPanelChangeListener,
ISystemsSelection {
    private static boolean printPaintDebug = false;
    private final int ICON_SIZE = 20;
    private final Icon ICON_EDIT = ImageUtils.getScaledIcon("images/buttons/edit2.png", 20, 20);
    private final Icon ICON_CLEAR = ImageUtils.getScaledIcon("images/systems/selection-clear.png", 20, 20);
    private final Icon ICON_REDO = ImageUtils.getScaledIcon("images/systems/selection-redo.png", 20, 20);
    private final Icon ICON_FILTER = ImageUtils.getScaledIcon("images/buttons/filter.png", 20, 20);
    private final Icon ICON_VIEW_INFO = ImageUtils.getScaledIcon("images/systems/view-info.png", 20, 20);
    private final Icon ICON_VIEW_EXTRA = ImageUtils.getScaledIcon("images/systems/view-extra.png", 20, 20);
    private final Icon ICON_VIEW_SYMBOL = ImageUtils.getScaledIcon("images/systems/view-symbol.png", 20, 20);
    private final Icon ICON_VIEW_EXPAND = ImageUtils.getScaledIcon("images/systems/expand.png", 20, 20);
    private final Icon ICON_VIEW_RETREAT = ImageUtils.getScaledIcon("images/systems/retreat.png", 20, 20);
    private final Pattern RPM_PATTERN_SEARCH = Pattern.compile("^\\{[^=]+=([\\d\\.,]+)\\}$");
    @NeptusProperty(name="Systems Icons Size", description="Configures the state symbols size for the system box", category="List", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public int iconsSize = 15;
    @NeptusProperty(name="System Indicator Icons Size", description="Configures the state symbols size for the OSD (on screen display) balloon", category="Renderer", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public int indicatorsSize = 15;
    @NeptusProperty(name="Main System Icon Size Increment", description="Configures the increment in size for the system box for the operational console main system", category="List", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public int mainSizeIncrement = 5;
    @NeptusProperty(name="Show System Symbol Or Text", description="Configures if for the system type symbol will use the picture symbol or the text version", category="Layout")
    public boolean showSystemSymbolOrText = false;
    @NeptusProperty(name="System Class Filter", description="This is the filter. This filter will show in the list only the system that match the filter", category="Filter", userLevel=NeptusProperty.LEVEL.REGULAR)
    public VehicleType.SystemTypeEnum systemsFilter = VehicleType.SystemTypeEnum.VEHICLE;
    @NeptusProperty(name="System Vehicle Class Subtype Filter", description="In case the previous filter is VEHICLE, can filter by subtype", category="Filter", userLevel=NeptusProperty.LEVEL.REGULAR)
    public VehicleType.VehicleTypeEnum vehicleTypeFilter = VehicleType.VehicleTypeEnum.ALL;
    @NeptusProperty(name="Systems Ordering", description="This configures if the systems should be shown UNSORTED or SORTED", category="Filter", userLevel=NeptusProperty.LEVEL.REGULAR)
    public SortOrderEnum systemsOrdering = SortOrderEnum.SORTED;
    @NeptusProperty(name="Show System With Authority Equal Or Above", description="This configures if the systems should be shown dependent on the Authority State", category="Filter", userLevel=NeptusProperty.LEVEL.REGULAR)
    public ImcSystem.IMCAuthorityState showSystemWithAuthorityEqualOrAbove = ImcSystem.IMCAuthorityState.OFF;
    @NeptusProperty(name="Systems Ordering Option", description="This configures the ordering type", category="Filter", userLevel=NeptusProperty.LEVEL.REGULAR)
    public SystemDisplayComparator.OrderOptionEnum orderingOption = SystemDisplayComparator.OrderOptionEnum.ID_AUTHORITY_MAIN;
    @NeptusProperty(name="Enable Selection", description="Configures if system selection is active or not", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public boolean enableSelection = true;
    @NeptusProperty(name="Show Systems Icons On Renderer", description="If true, if this component is showing systems icons, it will disable them on the renderer panel.", editable=false)
    public boolean showSystemsIconsOnRenderer = true;
    @NeptusProperty(name="Renderer Icons Size", description="Configures the system symbols size for the renderer", category="Layout", userLevel=NeptusProperty.LEVEL.REGULAR)
    public int rendererIconsSize = 25;
    @NeptusProperty(name="Show Systems Icons That Are Filtered Out", description="If true, if this component will show systems icons on renderer that were filtered out. Option to show system icons has to be enabled", category="Systems in Renderer", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean showSystemsIconsThatAreFilteredOut = true;
    @NeptusProperty(name="Show External Systems Icons", description="If true, if this component will show external systems icons on renderer. Option to show system icons has to be enabled", category="Systems in Renderer", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean showExternalSystemsIcons = true;
    @NeptusProperty(name="Minimum Speed To Be Stopped", description="Configures the maximum speed (m/s) for the system to be considered stoped (affects the drawing of the course/speed vector on the renderer)", category="Renderer", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double minimumSpeedToBeStopped = 0.1;
    @NeptusProperty(name="Draw System Label", description="Configures if this component will draw the system label on the renderer", category="Renderer", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean drawSystemLabel = true;
    @NeptusProperty(name="Use Mil Std 2525 Like Symbols", description="This configures if the location symbols to draw on the renderer will use the MIL-STD-2525 standard", category="MilStd-2525", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean useMilStd2525LikeSymbols = false;
    @NeptusProperty(name="Mil Std 2525 Symbols Filled Or Not", description="This configures if the symbol is to be filled or not", category="MilStd-2525", userLevel=NeptusProperty.LEVEL.REGULAR)
    public MilStd2525SymbolsFilledEnum milStd2525FilledOrNot = MilStd2525SymbolsFilledEnum.FILLED;
    @NeptusProperty(name="Minutes To Hide Systems Without Known Location", description="Minutes after which systems disapear from render if inactive (0 to disable)", category="Systems in Renderer", userLevel=NeptusProperty.LEVEL.REGULAR)
    public int minutesToHideSystemsWithoutKnownLocation = 5;
    @NeptusProperty(name="Draw Circle Arround System Icon In Render Dependent Of System Type", description="This configures if the circle arround the symbol in render is to be drawn dependent of system type", category="Renderer", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean drawCircleInRenderDependentOfSystemType = true;
    private final SystemDisplayComparator comparator = new SystemDisplayComparator();
    private final LinkedHashMap<ImcSystem, SystemDisplay> systems = new LinkedHashMap();
    private Vector<IMapPopup> renderersPopups;
    private Vector<ILayerPainter> renderers;
    private Vector<CustomInteractionSupport> renderersInteractions;
    private JPanel holder;
    private JScrollPane scrollPane;
    private JPanel toolbar;
    private ToolbarButton editConf;
    private ToolbarButton clearSelection;
    private ToolbarButton redoSelection;
    private ToolbarButton expandAll;
    private ToolbarButton retractAll;
    private ToolbarSwitch viewInfoOSDSwitch;
    private ToolbarSwitch filterSwitch;
    private ToolbarSwitch viewExtendedOSDSwitch;
    private ToolbarSwitch viewIconsSwitch;
    private AbstractAction editConfAction;
    private AbstractAction clearSelectionAction;
    private AbstractAction redoSelectionAction;
    private AbstractAction viewInfoOSDAction;
    private AbstractAction filterSwitchAction;
    private AbstractAction viewExtendedOSDAction;
    private AbstractAction viewIconsAction;
    private boolean updateMainVehicle = true;
    private boolean updateOrdering = true;
    private final Vector<SystemDisplay> prevSelection = new Vector();
    private InteractionAdapter stateRendererInteraction = null;
    private SystemTypeSymbol sts = new SystemTypeSymbol();
    private ConnectionSymbol cns = new ConnectionSymbol();
    private LocationSymbol locs = new LocationSymbol();
    private AuthoritySymbol ats = new AuthoritySymbol(){
        {
            this.fullOrNoneOnly = true;
        }
    };
    private TaskSymbol tks = new TaskSymbol();
    private AttentionSymbol as = new AttentionSymbol();
    private FuelLevelSymbol fl = new FuelLevelSymbol();
    private EmergencyTaskSymbol es = new EmergencyTaskSymbol();

    public SystemsList(ConsoleLayout console) {
        super(console);
        this.sts.setBlinkOnChange(false);
        this.cns.setBlinkOnChange(false);
        this.locs.setBlinkOnChange(false);
        this.ats.setBlinkOnChange(false);
        this.tks.setBlinkOnChange(false);
        this.as.setBlinkOnChange(false);
        this.fl.setBlinkOnChange(false);
        this.es.setBlinkOnChange(false);
        this.initialize();
    }

    private void initialize() {
        this.removeAll();
        this.setSize(220, 250);
        this.initializeActions();
        this.setLayout(new BorderLayout());
        this.holder = new JPanel(true);
        this.holder.setLayout(new BoxLayout(this.holder, 1));
        this.editConf = new ToolbarButton(this.editConfAction);
        if (this.getConsole() != null) {
            this.editConf.setVisible(false);
        }
        this.clearSelection = new ToolbarButton(this.clearSelectionAction);
        this.redoSelection = new ToolbarButton(this.redoSelectionAction);
        this.viewInfoOSDSwitch = new ToolbarSwitch(this.viewInfoOSDAction);
        this.viewInfoOSDSwitch.setSelected(false);
        this.viewExtendedOSDSwitch = new ToolbarSwitch(this.viewExtendedOSDAction);
        this.viewExtendedOSDSwitch.setSelected(false);
        this.viewIconsSwitch = new ToolbarSwitch(this.viewIconsAction);
        this.viewIconsSwitch.setSelected(this.showSystemsIconsOnRenderer);
        this.filterSwitch = new ToolbarSwitch(this.filterSwitchAction);
        this.filterSwitch.setSelected(true);
        this.expandAll = new ToolbarButton(new AbstractAction(I18n.text("Expand extra info."), this.ICON_VIEW_EXPAND){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SystemDisplay sd : SystemsList.this.systems.values().toArray(new SystemDisplay[0])) {
                    sd.setShowExtraInfoVisible(true);
                }
            }
        });
        this.retractAll = new ToolbarButton(new AbstractAction(I18n.text("Retract extra info."), this.ICON_VIEW_RETREAT){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SystemDisplay sd : SystemsList.this.systems.values().toArray(new SystemDisplay[0])) {
                    sd.setShowExtraInfoVisible(false);
                }
            }
        });
        this.toolbar = new JPanel();
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 2));
        this.toolbar.add((Component)((Object)this.editConf));
        this.toolbar.add((Component)((Object)this.clearSelection));
        this.toolbar.add((Component)((Object)this.redoSelection));
        this.toolbar.add(this.viewInfoOSDSwitch);
        this.toolbar.add(this.viewExtendedOSDSwitch);
        this.toolbar.add(this.viewIconsSwitch);
        this.toolbar.add(this.filterSwitch);
        this.toolbar.add((Component)((Object)this.expandAll));
        this.toolbar.add((Component)((Object)this.retractAll));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.scrollPane.setViewportView(this.holder);
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.scrollPane, "Center");
        this.holder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block14: {
                    SystemDisplay sd = null;
                    try {
                        try {
                            sd = (SystemDisplay)e.getSource();
                        }
                        catch (ClassCastException ex) {
                            return;
                        }
                        if (1 != e.getButton() || !e.isControlDown() && e.getClickCount() != 2) break block14;
                        String veh = sd.getId();
                        if (!e.isAltDown() && !e.isAltGraphDown()) {
                            if (SystemsList.this.getConsole() != null) {
                                SystemsList.this.getConsole().setMainSystem(veh);
                                if (veh.equalsIgnoreCase(SystemsList.this.getConsole().getMainSystem())) {
                                    ImcSystem sys = ImcSystemsHolder.lookupSystemByName(veh);
                                    if (sys == null) {
                                        sd.setWithAuthority(ImcSystem.IMCAuthorityState.SYSTEM_FULL);
                                    } else {
                                        sys.setAuthorityState(ImcSystem.IMCAuthorityState.SYSTEM_FULL);
                                    }
                                }
                            }
                            break block14;
                        }
                        if (sd.isMainVehicle()) break block14;
                        try {
                            ImcSystem sys = ImcSystemsHolder.lookupSystemByName(veh);
                            if (sys == null || sys.getVehicle() == null) {
                                sd.setWithAuthority(sd.isWithAuthority() ? ImcSystem.IMCAuthorityState.NONE : ImcSystem.IMCAuthorityState.SYSTEM_FULL);
                                break block14;
                            }
                            ImcSystem.IMCAuthorityState authToChange = ImcSystem.IMCAuthorityState.NONE;
                            if (!sys.isWithAuthority()) {
                                authToChange = ImcSystem.IMCAuthorityState.SYSTEM_FULL;
                            }
                            sys.setAuthorityState(authToChange);
                            ConsoleSystem vtl = SystemsList.this.getConsole().getSystem(veh);
                            if (vtl == null) {
                                SystemsList.this.getConsole().addSystem(veh);
                                sys.setAuthorityState(authToChange);
                                break block14;
                            }
                            vtl.toggleIMC();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.repaint();
    }

    private void initializeActions() {
        this.editConfAction = new AbstractAction(I18n.text("Edit Systems List Configurations"), this.ICON_EDIT){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)SystemsList.this, SwingUtilities.getWindowAncestor(SystemsList.this), true);
            }
        };
        this.clearSelectionAction = new AbstractAction(I18n.text("Clear Selection"), this.ICON_CLEAR){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemsList.this.clearSelectedSystems();
            }
        };
        this.redoSelectionAction = new AbstractAction(I18n.text("Redo Selection"), this.ICON_REDO){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemsList.this.redoSelectedSystems();
            }
        };
        this.viewInfoOSDAction = new AbstractAction(I18n.text("Show systems info OSD in render"), this.ICON_VIEW_INFO){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    SystemsList.this.viewExtendedOSDSwitch.setSelected(false);
                }
            }
        };
        this.viewExtendedOSDAction = new AbstractAction(I18n.text("Show systems extended OSD in render"), this.ICON_VIEW_EXTRA){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    SystemsList.this.viewInfoOSDSwitch.setSelected(false);
                }
            }
        };
        this.viewIconsAction = new AbstractAction(I18n.text("View systems icons in render"), this.ICON_VIEW_SYMBOL){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemsList.this.showSystemsIconsOnRenderer = SystemsList.this.viewIconsSwitch.isSelected();
            }
        };
        this.filterSwitchAction = new AbstractAction(I18n.text("Enable filter"), this.ICON_FILTER){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemsList.this.updateMainVehicle = true;
                SystemsList.this.updateOrdering = true;
            }
        };
    }

    @Override
    public void initSubPanel() {
        this.renderersPopups = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        for (IMapPopup iMapPopup : this.renderersPopups) {
            iMapPopup.addMenuExtension(this);
        }
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter iLayerPainter : this.renderers) {
            iLayerPainter.addPostRenderPainter(this, "Systems List");
        }
        this.renderersInteractions = this.getConsole().getSubPanelsOfInterface(CustomInteractionSupport.class);
        this.updateMainVehicle = true;
        this.updateSystemsList();
        if (this.getConsole() != null) {
            String mainVeh = this.getConsole().getMainSystem();
            this.changeMainVehicle(mainVeh);
        }
    }

    @Override
    public void cleanSubPanel() {
        if (this.renderersPopups != null) {
            for (IMapPopup iMapPopup : this.renderersPopups) {
                iMapPopup.removeMenuExtension(this);
            }
        }
        if (this.renderers != null) {
            for (ILayerPainter iLayerPainter : this.renderers) {
                iLayerPainter.removePostRenderPainter(this);
            }
        }
        if (this.renderersInteractions != null) {
            for (CustomInteractionSupport customInteractionSupport : this.renderersInteractions) {
                customInteractionSupport.removeInteraction(this.getInteractionInterface());
            }
        }
        this.prevSelection.clear();
        if (this.sts != null) {
            this.sts.dispose();
        }
        this.sts = null;
        if (this.cns != null) {
            this.cns.dispose();
        }
        this.cns = null;
        if (this.locs != null) {
            this.locs.dispose();
        }
        this.locs = null;
        if (this.ats != null) {
            this.ats.dispose();
        }
        this.ats = null;
        if (this.tks != null) {
            this.tks.dispose();
        }
        this.tks = null;
        if (this.as != null) {
            this.as.dispose();
        }
        this.as = null;
        if (this.fl != null) {
            this.fl.dispose();
        }
        this.fl = null;
        if (this.es != null) {
            this.es.dispose();
        }
        this.es = null;
        for (SystemDisplay systemDisplay : this.systems.values()) {
            systemDisplay.dispose();
        }
        this.holder.removeAll();
        this.systems.clear();
        this.holder = null;
        this.scrollPane = null;
        this.toolbar = null;
        this.editConf = null;
        this.clearSelection = null;
        this.redoSelection = null;
        this.expandAll = null;
        this.retractAll = null;
        this.viewInfoOSDSwitch = null;
        this.filterSwitch = null;
        this.viewExtendedOSDSwitch = null;
        this.viewIconsSwitch = null;
    }

    public int getIconsSize() {
        return this.iconsSize;
    }

    public void setIconsSize(int iconsSize) {
        this.iconsSize = iconsSize;
        this.propertiesChanged();
    }

    public int getIndicatorsSize() {
        return this.indicatorsSize;
    }

    public void setIndicatorsSize(int indicatorsSize) {
        this.indicatorsSize = indicatorsSize;
        this.propertiesChanged();
    }

    public boolean isEnableSelection() {
        return this.enableSelection;
    }

    public void setEnableSelection(boolean enableSelection) {
        this.enableSelection = enableSelection;
        this.propertiesChanged();
    }

    public boolean isViewEnable() {
        return this.viewInfoOSDSwitch.isEnabled();
    }

    public void setViewEnable(boolean enable) {
        this.viewInfoOSDSwitch.setEnabled(enable);
        this.viewExtendedOSDSwitch.setEnabled(enable);
        this.viewIconsSwitch.setEnabled(enable);
        if (!enable) {
            this.viewInfoOSDSwitch.setSelected(enable);
            this.viewExtendedOSDSwitch.setSelected(enable);
            this.viewIconsSwitch.setSelected(enable);
        }
    }

    @Override
    public boolean isSystemPainterEnabled() {
        return this.showSystemsIconsOnRenderer;
    }

    @Override
    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        Object str2d;
        Object sub;
        if (panelChange == null) {
            return;
        }
        this.renderersPopups = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), IMapPopup.class)) {
            sub = (IMapPopup)((Object)panelChange.getPanel());
            if (panelChange.added()) {
                this.renderersPopups.add((IMapPopup)sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addMenuExtension(this);
                }
            }
            if (panelChange.removed()) {
                this.renderersPopups.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removeMenuExtension(this);
                }
            }
        }
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), ILayerPainter.class)) {
            sub = (ILayerPainter)((Object)panelChange.getPanel());
            if (panelChange.added()) {
                this.renderers.add((ILayerPainter)sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addPostRenderPainter(this, "System List");
                }
            }
            if (panelChange.removed()) {
                this.renderers.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removePostRenderPainter(this);
                }
            }
        }
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), CustomInteractionSupport.class)) {
            sub = (CustomInteractionSupport)((Object)panelChange.getPanel());
            if (panelChange.added()) {
                this.renderersInteractions.add((CustomInteractionSupport)sub);
                str2d = sub;
                if (str2d != null) {
                    // empty if block
                }
            }
            if (panelChange.removed()) {
                this.renderersInteractions.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removeInteraction(this.getInteractionInterface());
                }
            }
        }
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange ev) {
        this.update();
        this.changeMainVehicle(ev.getCurrent());
    }

    private void changeMainVehicle(String id) {
        ImcSystem system = ImcSystemsHolder.lookupSystemByName(id);
        if (system == null) {
            return;
        }
        if (this.systems.containsKey(system)) {
            for (ImcSystem sys : this.systems.keySet().toArray(new ImcSystem[0])) {
                SystemDisplay display = this.systems.get(sys);
                if (display == null) continue;
                if (sys.compareTo(system) == 0) {
                    if (!display.isMainVehicle()) {
                        display.setIconSize(this.iconsSize + this.mainSizeIncrement);
                        display.setIndicatorsSize(this.indicatorsSize + this.mainSizeIncrement);
                        display.setIncrementFontSize(this.mainSizeIncrement);
                    }
                    display.setMainVehicle(true);
                    continue;
                }
                if (display.isMainVehicle()) {
                    display.setIconSize(this.iconsSize);
                    display.setIndicatorsSize(this.indicatorsSize);
                    display.setIncrementFontSize(0);
                }
                display.setMainVehicle(false);
            }
        }
    }

    @Override
    public long millisBetweenUpdates() {
        return 500L;
    }

    @Override
    public boolean update() {
        if (this.filterSwitch == null) {
            NeptusLog.pub().info((Object)("<###> " + SystemsList.class.getSimpleName() + " : update of SystemsList called after cleanup call!!!!!"));
            return true;
        }
        this.updateSystemsList();
        boolean enable = true;
        if (this.renderers == null || this.renderers.size() == 0) {
            enable = false;
        }
        this.viewInfoOSDSwitch.setEnabled(enable);
        this.viewExtendedOSDSwitch.setEnabled(enable);
        this.viewIconsSwitch.setEnabled(enable);
        this.repaint();
        return true;
    }

    private synchronized void updateSystemsList() {
        SystemDisplay[] vals;
        ImcSystem[] filteredSystems;
        if (this.filterSwitch == null) {
            NeptusLog.pub().info((Object)("<###> " + SystemsList.class.getSimpleName() + " : updateSystemsList called after cleanup call!!!!!"));
            return;
        }
        for (ImcSystem sys : filteredSystems = ImcSystemsHolder.lookupSystemByType(this.filterSwitch.isSelected() ? this.systemsFilter : VehicleType.SystemTypeEnum.ALL)) {
            String txtInfo;
            boolean isToAdd = false;
            SystemDisplay sd = this.systems.get(sys);
            if (sd == null) {
                sd = this.createSystemElement(sys);
                isToAdd = true;
            }
            sd.setActive(sys.isActive());
            try {
                SystemImcMsgCommInfo commS = (SystemImcMsgCommInfo)ImcMsgManager.getManager().getCommInfoById(sys.getId());
                long deltaMillis = System.currentTimeMillis() - (long)commS.getArrivalTimeMillisLastMsg();
                if (deltaMillis >= 1200000L) {
                    sd.setActiveToolTip(null);
                } else if (deltaMillis > 10000L) {
                    sd.setActiveToolTip(I18n.textf("%deltaTime with no messages", DateTimeUtil.milliSecondsToFormatedString(deltaMillis)));
                } else {
                    sd.setActiveToolTip(null);
                }
                if (deltaMillis > 10000L) {
                    sd.setConnectionStrength(ConnectionSymbol.ConnectionStrengthEnum.LOW);
                } else if (deltaMillis > 7000L) {
                    sd.setConnectionStrength(ConnectionSymbol.ConnectionStrengthEnum.MEDIAN);
                } else if (deltaMillis > 4000L) {
                    sd.setConnectionStrength(ConnectionSymbol.ConnectionStrengthEnum.HIGH);
                } else {
                    sd.setConnectionStrength(ConnectionSymbol.ConnectionStrengthEnum.FULL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                sd.setActiveToolTip(null);
            }
            if (sys.isOnAnnounceState() && System.currentTimeMillis() - sys.getLastAnnounceStateReceived() < 12000L) {
                sd.setAnnounceReceived(true);
            } else {
                sd.setAnnounceReceived(false);
            }
            sd.setTaskAlocated(sys.getActivePlan() != null);
            sd.setTaskAlocatedToolTip(sys.getActivePlan() != null ? sys.getActivePlan().getId() : null);
            if (sys.getType() == VehicleType.SystemTypeEnum.VEHICLE) {
                sd.setSystemType(sys.getTypeVehicle().name());
            } else {
                sd.setSystemType(sys.getType().name());
            }
            sd.setEmergencyTaskAlocated(sys.getEmergencyPlanId() != null && !"".equalsIgnoreCase(sys.getEmergencyPlanId()));
            sd.setEmergencyTaskAlocatedToolTip(sys.getEmergencyPlanId() != null && !"".equalsIgnoreCase(sys.getEmergencyPlanId()) ? sys.getEmergencyPlanId() : null);
            if (sys.getEmergencyPlanId() != null && !"".equalsIgnoreCase(sys.getEmergencyPlanId())) {
                try {
                    EmergencyTaskSymbol.EmergencyStatus es = EmergencyTaskSymbol.EmergencyStatus.valueOf(sys.getEmergencyStatusStr());
                    sd.setEmergencyStatus(es);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    sd.setEmergencyStatus(EmergencyTaskSymbol.EmergencyStatus.NOT_CONFIGURED);
                }
            } else {
                sd.setEmergencyStatus(EmergencyTaskSymbol.EmergencyStatus.NOT_CONFIGURED);
            }
            sd.setAttentionAlert(sys.isOnErrorState());
            sd.setAttentionToolTip(I18n.textf("last update age: %deltaTime", DateTimeUtil.milliSecondsToFormatedString(System.currentTimeMillis() - sys.getLastErrorStateReceived())));
            if (sys.isOnErrorState() && sys.getOnErrorStateStr() != null && !"".equalsIgnoreCase(sys.getOnErrorStateStr())) {
                sd.setAttentionToolTip("<html>" + I18n.textf("Entities in error: %errorMessage", sys.getOnErrorStateStr()) + "<br>" + sd.getAttentionToolTip());
            }
            if (sys.containsData("Fuel Level")) {
                sd.setFuelLevel(true);
                FuelLevel fuelLevelMsg = (FuelLevel)sys.retrieveData("Fuel Level");
                long time = sys.retrieveDataTimeMillis("Fuel Level");
                sd.setFuelLevelPercentage(fuelLevelMsg.getValue());
                sd.setFuelLevelToolTip(I18n.textf("Fuel Level: %fuelValue% with %confidanceValue% confidance", (long)MathMiscUtils.round(fuelLevelMsg.getValue(), 0), (long)MathMiscUtils.round(fuelLevelMsg.getConfidence(), 0)));
                if (System.currentTimeMillis() - time > 120000L) {
                    sd.setFuelLevel(false);
                }
            } else {
                sd.setFuelLevel(false);
                if (!sys.containsData("Fuel Level")) {
                    sd.setFuelLevelPercentage(-1.0);
                }
            }
            sd.setIdAlert(sys.isOnIdErrorState());
            sd.setIdAttentionToolTip(I18n.textf("last update age: %deltaTime", DateTimeUtil.milliSecondsToFormatedString(System.currentTimeMillis() - sys.getLastIdErrorStateReceived())));
            VehicleType vehT = sys.getVehicle();
            if (vehT != null) {
                sd.setDisplayColor(vehT.getIconColor());
            }
            try {
                VehicleType veh;
                if (sd.getSystemImage() == null && (veh = sys.getVehicle()) != null) {
                    String fxPath = veh.getSideImageHref();
                    if (veh.getPresentationImageHref() != null && !"".equals(veh.getPresentationImageHref())) {
                        fxPath = veh.getPresentationImageHref();
                    }
                    sd.setSystemImage(ImageUtils.getImage(fxPath));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                NeptusLog.pub().debug((Object)("System " + sys.getName() + " image was not loaded!"));
            }
            if (sd.isMainVehicle()) {
                sys.setAuthorityState(ImcSystem.IMCAuthorityState.SYSTEM_FULL);
            }
            try {
                ImcSystem.IMCAuthorityState oldValue = sd.getWithAuthority();
                sd.setWithAuthority(sys.getAuthorityState());
                sd.setWithAuthorityToolTip(I18n.text("authority") + ": " + sys.getAuthorityState().toString().toLowerCase().replace("_", " "));
                if (sd.getWithAuthority() != oldValue) {
                    this.updateOrdering = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (SystemPainterHelper.isLocationKnown(sys)) {
                sd.setLocationKnown(true);
                sd.setLocationKnownToolTip(I18n.text("Location known"));
            } else {
                sd.setLocationKnown(false);
                sd.setLocationKnownToolTip(I18n.text("Unknown location for more than 10s"));
            }
            Object epObj = sys.retrieveData("EntityParameters");
            if (epObj != null && epObj instanceof EntityParameters) {
                sd.updateSystemParameters((EntityParameters)epObj);
            }
            if ((txtInfo = this.getSection4Data(sys, true, true)).length() != 0) {
                sd.setInfoLabel("<html>" + txtInfo);
            } else {
                sd.setInfoLabel(I18n.text("No extra info"));
            }
            if (!isToAdd || this.isForRemoval(sd)) continue;
            this.systems.put(sys, sd);
            if (this.systemsOrdering != SortOrderEnum.UNSORTED) {
                int index = -1;
                for (int i = 0; i < this.holder.getComponentCount(); ++i) {
                    int val = this.comparator.compare(sd, (SystemDisplay)((Object)this.holder.getComponent(i)));
                    if (val >= 0) continue;
                    index = i;
                    break;
                }
                this.holder.add((Component)((Object)sd), index);
                continue;
            }
            this.holder.add((Component)((Object)sd));
        }
        for (SystemDisplay sd : vals = this.systems.values().toArray(new SystemDisplay[this.systems.size()])) {
            if (!this.isForRemoval(sd) || sd.isMainVehicle()) continue;
            this.holder.remove((Component)((Object)sd));
            for (ImcSystem sys : this.systems.keySet().toArray(new ImcSystem[0])) {
                if (!sd.equals(this.systems.get(sys))) continue;
                this.systems.remove(sys);
                break;
            }
            sd.dispose();
        }
        if (this.updateMainVehicle && this.getConsole() != null && this.getConsole().getMainSystem() != null) {
            this.updateMainVehicle = false;
            this.updateOrdering = true;
        }
        if (this.updateOrdering) {
            try {
                if (this.systemsOrdering != SortOrderEnum.UNSORTED) {
                    for (int i = 0; i < this.holder.getComponentCount(); ++i) {
                        for (int j = i; j > 0 && this.comparator.compare((SystemDisplay)((Object)this.holder.getComponent(j - 1)), (SystemDisplay)((Object)this.holder.getComponent(j))) > 0; --j) {
                            Component cp = this.holder.getComponent(j);
                            this.holder.remove(cp);
                            this.holder.add(cp, j - 1);
                        }
                    }
                    return;
                }
                this.updateOrdering = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isForRemoval(SystemDisplay sd) {
        if (this.filterSwitch != null && !this.filterSwitch.isSelected()) {
            return false;
        }
        boolean ret = false;
        if (this.systemsFilter != VehicleType.SystemTypeEnum.ALL && this.systemsFilter != ImcSystem.translateSystemTypeFromMessage(sd.getSystemType())) {
            ret = true;
        }
        if (!ret && VehicleType.SystemTypeEnum.VEHICLE == ImcSystem.translateSystemTypeFromMessage(sd.getSystemType()) && this.vehicleTypeFilter != VehicleType.VehicleTypeEnum.ALL && this.vehicleTypeFilter != ImcSystem.translateVehicleTypeFromMessage(sd.getSystemType())) {
            ret = true;
        }
        if (!ret && sd.getWithAuthority().ordinal() < this.showSystemWithAuthorityEqualOrAbove.ordinal()) {
            ret = true;
        }
        return ret;
    }

    private final SystemDisplay createSystemElement(ImcSystem sys) {
        SystemDisplay sd = new SystemDisplay(sys.getName());
        sd.setIconSize(this.iconsSize);
        sd.setIndicatorsSize(this.indicatorsSize);
        sd.setEnableSelection(this.enableSelection);
        sd.setActive(sys.isActive());
        sd.setShowSystemSymbolOrText(this.showSystemSymbolOrText);
        if (sys.getActivePlan() != null) {
            sd.setTaskAlocated(true);
        }
        return sd;
    }

    private String getSection3Data(ImcSystem sys) {
        LocationType loc = sys.getLocation();
        String txtInfo = "";
        String lineSep = "\n";
        if (loc != null && !loc.isLocationEqual(LocationType.ABSOLUTE_ZERO)) {
            loc = loc.convertToAbsoluteLatLonDepth();
            txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep + " " : "");
            txtInfo = txtInfo + I18n.text("Height") + ": " + MathMiscUtils.round(loc.getHeight(), 1) + " m";
        }
        return txtInfo;
    }

    private String getSection4Data(ImcSystem sys, boolean htmlFragmentOrSimpleText, boolean extendedOrReduced) {
        return this.getSection4Data(sys, htmlFragmentOrSimpleText, extendedOrReduced, true);
    }

    private String getSection4Data(ImcSystem sys, boolean htmlFragmentOrSimpleText, boolean extendedOrReduced, boolean showHeight) {
        LocationType loc;
        PlanType plan;
        long maxAgeTimeMillis = 60000L;
        String lineSep = htmlFragmentOrSimpleText ? "<br>" : "\n";
        String txtInfo = "";
        if (sys.isSimulated()) {
            txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep : "");
            txtInfo = txtInfo + I18n.text("SIMULATION");
        }
        if (sys.containsData("Web Updated") && System.currentTimeMillis() - sys.retrieveDataTimeMillis("Web Updated") < 60000L) {
            txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep : "");
            txtInfo = txtInfo + I18n.text("WEB POS RECEIVED");
        }
        if ((plan = sys.getActivePlan()) != null) {
            txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep : "");
            txtInfo = txtInfo + I18n.text("Plan") + ": " + StringUtils.wrapEveryNChars(plan.getId(), (short)30, 30, true);
        }
        if (extendedOrReduced && sys.isOnErrorState()) {
            txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep : "");
            txtInfo = txtInfo + I18n.text("Errors") + ": " + StringUtils.wrapEveryNChars(sys.getOnErrorStateStr(), (short)30, 30, true);
        }
        if ((loc = sys.getLocation()) != null && !loc.isLocationEqual(LocationType.ABSOLUTE_ZERO)) {
            loc = loc.convertToAbsoluteLatLonDepth();
            txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep + "" : "");
            txtInfo = txtInfo + I18n.text("Lat") + ": " + CoordinateUtil.latitudeAsPrettyString(MathMiscUtils.round(loc.getLatitudeDegs(), 6), false) + " " + I18n.text("Lon") + ": " + CoordinateUtil.longitudeAsPrettyString(MathMiscUtils.round(loc.getLongitudeDegs(), 6), false) + (showHeight ? lineSep + I18n.text("Height") + ": " + MathMiscUtils.round(loc.getHeight(), 1) + " m" : "");
        }
        if (sys.containsData("Course") || sys.containsData("Heading")) {
            boolean hasCourse = sys.containsData("Course", maxAgeTimeMillis);
            boolean hasHeading = sys.containsData("Heading", maxAgeTimeMillis);
            txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep : "");
            if (hasCourse) {
                txtInfo = txtInfo + I18n.text("Course") + ": " + CoordinateUtil.heading3DigitsFormat.format(sys.retrieveData("Course")) + '\u00b0';
            }
            if (hasHeading) {
                txtInfo = txtInfo + (hasCourse ? " | " : "");
                txtInfo = txtInfo + I18n.text("Heading") + ": " + CoordinateUtil.heading3DigitsFormat.format(sys.retrieveData("Heading")) + '\u00b0';
            }
        }
        if (sys.containsData("Ground Speed", maxAgeTimeMillis)) {
            txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep : "") + I18n.text("Ground Speed") + ": " + MathMiscUtils.round((Double)sys.retrieveData("Ground Speed"), 1) + " m/s";
        }
        if (sys.containsData("Vertical Speed", maxAgeTimeMillis)) {
            txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep : "") + I18n.text("Vertical Speed") + ": " + MathMiscUtils.round((Double)sys.retrieveData("Vertical Speed"), 1) + " m/s";
        }
        if (sys.containsData("RPM", maxAgeTimeMillis)) {
            String rpms = "" + sys.retrieveData("RPM");
            Matcher m = this.RPM_PATTERN_SEARCH.matcher(rpms);
            if (m.find()) {
                rpms = m.group(1);
            }
            rpms = rpms.replace(",", lineSep + (htmlFragmentOrSimpleText ? "&nbsp;&nbsp;&nbsp;&nbsp;" : "    "));
            txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep : "") + I18n.text("RPM") + ": " + rpms;
        }
        if (extendedOrReduced) {
            if (sys.getId() != ImcId16.NULL_ID && sys.getId() != ImcId16.ANNOUNCE && sys.getId() != ImcId16.BROADCAST_ID) {
                txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep : "") + I18n.text("IMC ID") + ": " + sys.getId().toPrettyString();
            }
            if (sys.getHostAddress() != null && !"".equals(sys.getHostAddress())) {
                txtInfo = txtInfo + (txtInfo.length() != 0 ? lineSep : "") + I18n.text("IP") + ": " + sys.getHostAddress();
                if (sys.isUDPOn() && sys.getRemoteUDPPort() != 0) {
                    txtInfo = txtInfo + "@udp:" + sys.getRemoteUDPPort();
                }
                if (sys.isTCPOn() && sys.getRemoteTCPPort() != 0) {
                    txtInfo = txtInfo + "@tcp:" + sys.getRemoteTCPPort();
                }
            }
        }
        return txtInfo;
    }

    private StateRendererInteraction getInteractionInterface() {
        if (this.stateRendererInteraction == null) {
            this.stateRendererInteraction = new InteractionAdapter(this.getConsole()){

                @Override
                public Image getIconImage() {
                    try {
                        return ImageUtils.getIcon(PluginUtils.getPluginIcon(SystemsList.this.getClass())).getImage();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return super.getIconImage();
                    }
                }

                @Override
                public boolean isExclusive() {
                    return false;
                }

                @Override
                public void mouseMoved(MouseEvent event, StateRenderer2D source) {
                    super.mouseMoved(event, source);
                    NeptusLog.pub().info((Object)("<###>mouse: " + event.getX() + ":" + event.getY() + " -> " + source));
                }
            };
        }
        return this.stateRendererInteraction;
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (!(this.viewInfoOSDSwitch.isSelected() || this.viewExtendedOSDSwitch.isSelected() || this.viewIconsSwitch.isSelected())) {
            return;
        }
        Component[] comps = this.holder.getComponents();
        Vector<SystemDisplay> systemsList = new Vector<SystemDisplay>();
        for (Component c : comps) {
            try {
                systemsList.add((SystemDisplay)((Object)c));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.viewInfoOSDSwitch.isSelected() || this.viewExtendedOSDSwitch.isSelected()) {
            ImcSystem sys;
            boolean showExtendedOSD = false;
            if (this.viewExtendedOSDSwitch.isSelected()) {
                showExtendedOSD = true;
            }
            int fontSize = 12;
            int boxBorderSize = 2;
            int colorTransparency = 100;
            int iconColorTransparency = 220;
            int iconSize = 20;
            int contentLineSpacer = 1;
            Font fontTxt = new Font("Arial", 0, fontSize);
            if (printPaintDebug) {
                NeptusLog.pub().info((Object)"<###> ><<><><><><>< ");
            }
            LinkedHashMap<SystemDisplay, RenderPainterSystemData> painterData = new LinkedHashMap<SystemDisplay, RenderPainterSystemData>();
            for (SystemDisplay sd : systemsList) {
                Graphics2D g2 = (Graphics2D)g.create();
                sys = ImcSystemsHolder.lookupSystemByName(sd.getId());
                if (sys == null) continue;
                this.collectSystemDataAndPositionToDrawInfoBalloon(renderer, g2, sys, sd, showExtendedOSD, painterData, fontTxt, iconSize, contentLineSpacer, boxBorderSize);
                g2.dispose();
            }
            Collections.reverse(systemsList);
            for (SystemDisplay sd : systemsList) {
                RenderPainterSystemData rpd;
                Graphics2D g2 = (Graphics2D)g.create();
                sys = ImcSystemsHolder.lookupSystemByName(sd.getId());
                if (sys == null || (rpd = (RenderPainterSystemData)painterData.get(sd)) == null) continue;
                this.drawInfoBalloonForSystem(g2, sys, sd, rpd, fontTxt, colorTransparency, iconColorTransparency, contentLineSpacer, iconSize);
                g2.dispose();
            }
        }
        if (this.viewIconsSwitch.isSelected()) {
            if (this.showExternalSystemsIcons) {
                ExternalSystem[] externalSystems = ExternalSystemsHolder.lookupAllSystems();
                this.drawInRenderExternalSystemList(renderer, (Graphics2D)g.create(), Arrays.asList(externalSystems));
            }
            if (this.showSystemsIconsThatAreFilteredOut) {
                ImcSystem[] allSystems = ImcSystemsHolder.lookupAllSystems();
                Vector<ImcSystem> imcSystemsNotOnList = new Vector<ImcSystem>();
                for (ImcSystem sys : allSystems) {
                    if (this.systems.containsKey(sys)) continue;
                    imcSystemsNotOnList.add(sys);
                }
                this.drawInRenderImc3SystemList(renderer, (Graphics2D)g.create(), imcSystemsNotOnList);
            }
            this.drawInRenderSystemDisplayList(renderer, (Graphics2D)g.create(), systemsList);
        }
    }

    private void collectSystemDataAndPositionToDrawInfoBalloon(StateRenderer2D renderer, Graphics2D g, ImcSystem sys, SystemDisplay sd, boolean showExtendedOSD, LinkedHashMap<SystemDisplay, RenderPainterSystemData> painterData, Font fontTxt, int iconSize, int contentLineSpacer, int boxBorderSize) {
        Rectangle2D boundsT;
        int i;
        if (printPaintDebug) {
            NeptusLog.pub().info((Object)("<###> > " + sys.getName()));
        }
        Graphics2D g2 = (Graphics2D)g.create();
        RenderPainterSystemData rpd = new RenderPainterSystemData();
        rpd.pt = renderer.getScreenPosition(sys.getLocation());
        g2.setFont(fontTxt);
        rpd.sysName = sys.getName();
        rpd.boundsSysName = g2.getFontMetrics().getStringBounds(rpd.sysName, g2);
        rpd.section3Data = this.getSection3Data(sys).split("\n");
        rpd.boundsSection3DataLines = new Integer[rpd.section3Data.length][2];
        for (i = 0; i < rpd.section3Data.length; ++i) {
            boundsT = g2.getFontMetrics().getStringBounds(rpd.section3Data[i], g2);
            rpd.boundsSection3DataLines[i][0] = (int)boundsT.getWidth();
            rpd.boundsSection3DataLines[i][1] = (int)boundsT.getHeight();
        }
        rpd.section3ContentLines = 2 + (rpd.section3Data.length > 0 ? rpd.section3Data.length : 0);
        rpd.showSection3 = rpd.section3Data.length > 0;
        rpd.section4Data = this.getSection4Data(sys, false, false, false).split("\n");
        rpd.boundsSection4DataLines = new Integer[rpd.section4Data.length][2];
        for (i = 0; i < rpd.section4Data.length; ++i) {
            boundsT = g2.getFontMetrics().getStringBounds(rpd.section4Data[i], g2);
            rpd.boundsSection4DataLines[i][0] = (int)boundsT.getWidth();
            rpd.boundsSection4DataLines[i][1] = (int)boundsT.getHeight();
        }
        rpd.section4ContentLines = 2 + (rpd.section4Data.length > 0 ? rpd.section4Data.length : 0);
        rpd.showSection4 = showExtendedOSD && rpd.section4Data.length > 0;
        rpd.numberOfIcons = 7;
        rpd.section1Width = (int)rpd.boundsSysName.getWidth();
        rpd.section1Height = (int)rpd.boundsSysName.getHeight();
        rpd.section2Width = iconSize * rpd.numberOfIcons;
        rpd.section2Height = iconSize;
        rpd.section3Width = 0;
        rpd.section3Height = 0;
        if (rpd.showSection3) {
            for (i = 0; i < rpd.section3Data.length; ++i) {
                rpd.section3Width = Math.max(rpd.section3Width, rpd.boundsSection3DataLines[i][0]);
                rpd.section3Height += rpd.boundsSection3DataLines[i][1].intValue();
            }
            if (rpd.section3Data.length > 1) {
                rpd.section3Height += (rpd.section3Data.length - 1) * contentLineSpacer;
            }
        }
        rpd.section4Width = 0;
        rpd.section4Height = 0;
        if (rpd.showSection4) {
            for (i = 0; i < rpd.section4Data.length; ++i) {
                rpd.section4Width = Math.max(rpd.section4Width, rpd.boundsSection4DataLines[i][0]);
                rpd.section4Height += rpd.boundsSection4DataLines[i][1].intValue();
            }
            if (rpd.section4Data.length > 1) {
                rpd.section4Height += (rpd.section4Data.length - 1) * contentLineSpacer;
            }
        }
        rpd.boxContentW = Math.max(rpd.section1Width, Math.max(rpd.section2Width, Math.max(rpd.section3Width, rpd.section4Width)));
        rpd.boxContentH = rpd.section1Height + rpd.section2Height + (rpd.showSection3 ? rpd.section3Height + contentLineSpacer * Math.max(rpd.section3ContentLines - 1, 0) : 0) + (rpd.showSection4 ? rpd.section4Height + contentLineSpacer * Math.max(rpd.section4ContentLines - 1, 0) : 0);
        rpd.boxW = (double)(boxBorderSize * 2) + rpd.boxContentW;
        rpd.boxH = (double)(boxBorderSize * 2) + rpd.boxContentH;
        rpd.offsetX = 20;
        rpd.offsetY = -20;
        Vector<RenderPainterSystemData> closeBad = new Vector<RenderPainterSystemData>();
        double maxDist = Math.sqrt((double)(rpd.offsetX * rpd.offsetX) + rpd.boxW * rpd.boxW + ((double)(rpd.offsetX * rpd.offsetX) + rpd.boxH * rpd.boxH));
        Rectangle2D.Double boundingBox = new Rectangle2D.Double(rpd.pt.getX() - maxDist, rpd.pt.getY() - maxDist, maxDist * 2.0, maxDist * 2.0);
        for (RenderPainterSystemData pd : painterData.values()) {
            Rectangle2D.Double bBox = new Rectangle2D.Double(pd.pt.getX() + pd.boxXOffset, pd.pt.getY() + pd.boxYOffset, pd.boxW, pd.boxH);
            if (!boundingBox.intersects(bBox)) continue;
            closeBad.add(pd);
        }
        if (printPaintDebug) {
            NeptusLog.pub().info((Object)("<###>>> " + closeBad.size()));
        }
        while (true) {
            rpd.boxContentXOffset = (double)rpd.offsetX + (Math.signum(rpd.offsetX) < 0.0f ? -rpd.boxContentW : 0.0);
            rpd.boxContentYOffset = (double)rpd.offsetY + (Math.signum(rpd.offsetY) < 0.0f ? -rpd.boxContentH : 0.0);
            rpd.boxXOffset = rpd.boxContentXOffset - (double)boxBorderSize;
            rpd.boxYOffset = rpd.boxContentYOffset - (double)boxBorderSize;
            Rectangle2D.Double placeBBox = new Rectangle2D.Double(rpd.pt.getX() + rpd.boxXOffset, rpd.pt.getY() + rpd.boxYOffset, rpd.boxW, rpd.boxH);
            if (printPaintDebug) {
                NeptusLog.pub().info((Object)("<###>>>>   " + placeBBox));
            }
            boolean freeSpaceFound = true;
            for (RenderPainterSystemData pd : closeBad) {
                Rectangle2D.Double bBox = new Rectangle2D.Double(pd.pt.getX() + pd.boxXOffset, pd.pt.getY() + pd.boxYOffset, pd.boxW, pd.boxH);
                if (placeBBox.intersects(bBox)) {
                    freeSpaceFound = false;
                    if (!printPaintDebug) break;
                    NeptusLog.pub().info((Object)("<###>>>>    " + pd.sysName + " > NOT FREE  " + bBox));
                    break;
                }
                if (!printPaintDebug) continue;
                NeptusLog.pub().info((Object)("<###>>>>    " + pd.sysName + " > FREE  " + bBox));
            }
            if (freeSpaceFound) break;
            freeSpaceFound = true;
            if (rpd.offsetX == 20 && rpd.offsetY == -20) {
                rpd.offsetX = 20;
                rpd.offsetY = 20;
                continue;
            }
            if (rpd.offsetX == 20 && rpd.offsetY == 20) {
                rpd.offsetX = -20;
                rpd.offsetY = 20;
                continue;
            }
            if (rpd.offsetX != -20 || rpd.offsetY != 20) break;
            rpd.offsetX = -20;
            rpd.offsetY = -20;
        }
        rpd.boxContentXOffset = (double)rpd.offsetX + (Math.signum(rpd.offsetX) < 0.0f ? -rpd.boxContentW : 0.0);
        rpd.boxContentYOffset = (double)rpd.offsetY + (Math.signum(rpd.offsetY) < 0.0f ? -rpd.boxContentH : 0.0);
        rpd.boxXOffset = rpd.boxContentXOffset - (double)boxBorderSize;
        rpd.boxYOffset = rpd.boxContentYOffset - (double)boxBorderSize;
        rpd.boxShape = new RoundRectangle2D.Double(rpd.boxXOffset, rpd.boxYOffset, rpd.boxW, rpd.boxH, 5.0, 5.0);
        rpd.pointerShape = new Polygon(new int[]{0, rpd.offsetX, rpd.offsetX + (int)Math.signum(rpd.offsetX) * 20}, new int[]{0, rpd.offsetY + -((int)Math.signum(rpd.offsetY)) * boxBorderSize, rpd.offsetY + -((int)Math.signum(rpd.offsetY)) * boxBorderSize}, 3);
        painterData.put(sd, rpd);
        g2.dispose();
    }

    private void drawInfoBalloonForSystem(Graphics2D g, ImcSystem sys, SystemDisplay sd, RenderPainterSystemData rpd, Font fontTxt, int colorTransparency, int iconColorTransparency, int contentLineSpacer, int iconSize) {
        int i;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(rpd.pt.getX(), rpd.pt.getY());
        g2.setFont(fontTxt);
        g2.setColor(ColorUtils.setTransparencyToColor(Color.BLACK, colorTransparency));
        g2.fill(rpd.pointerShape);
        g2.fill(rpd.boxShape);
        if (sd.isMainVehicle()) {
            g2.setStroke(new BasicStroke(4.0f));
            g2.setColor(ColorUtils.setTransparencyToColor(Color.GREEN, colorTransparency));
            g2.draw(rpd.boxShape);
            g2.setStroke(new BasicStroke(1.0f));
        }
        g2.setColor(ColorUtils.setTransparencyToColor(Color.BLACK, colorTransparency));
        g2.fillOval(-5, -5, 10, 10);
        Color activeColor = Color.GREEN;
        Color errorColor = Color.ORANGE;
        if (!sd.isWithAuthority() || sys.getType() != VehicleType.SystemTypeEnum.VEHICLE) {
            activeColor = errorColor = Color.WHITE;
        }
        g2.translate(rpd.boxContentXOffset, rpd.boxContentYOffset);
        g2.setColor(ColorUtils.setTransparencyToColor(activeColor, iconColorTransparency));
        g2.drawString(rpd.sysName, 0, (int)rpd.boundsSysName.getHeight());
        g2.translate(0, contentLineSpacer + rpd.section1Height);
        Graphics2D gtemp = (Graphics2D)g2.create();
        this.sts.setSystemType(sd.getSystemType());
        this.sts.setShowSymbolOrText(this.showSystemSymbolOrText);
        this.sts.setColor(ColorUtils.setTransparencyToColor(activeColor, iconColorTransparency));
        this.sts.paint(g2, this.sts, iconSize, iconSize);
        g2.translate(iconSize, 0);
        this.cns.setActive(sd.isActive());
        this.cns.setStrength(sd.getConnectionStrength());
        this.cns.setActiveAnnounce(sd.isAnnounceReceived());
        this.cns.setColor(ColorUtils.setTransparencyToColor(sd.isActive() ? activeColor : errorColor, iconColorTransparency));
        this.cns.paint(g2, this.cns, iconSize, iconSize);
        g2.translate(iconSize, 0);
        this.locs.setActive(sd.isLocationKnown());
        this.locs.setColor(ColorUtils.setTransparencyToColor(sd.isLocationKnown() ? activeColor : errorColor, iconColorTransparency));
        this.locs.paint(g2, this.locs, iconSize, iconSize);
        g2.translate(iconSize, 0);
        this.ats.setActive(sd.isWithAuthority());
        this.ats.setAuthorityType(sd.getWithAuthority());
        this.ats.setColor(ColorUtils.setTransparencyToColor(sd.isWithAuthority() ? activeColor : errorColor, iconColorTransparency));
        this.ats.paint(g2, this.ats, iconSize, iconSize);
        g2.translate(iconSize, 0);
        this.tks.setActive(sd.isTaskAlocated());
        this.tks.setColor(ColorUtils.setTransparencyToColor(sd.isTaskAlocated() ? activeColor : errorColor, iconColorTransparency));
        this.tks.paint(g2, this.tks, iconSize, iconSize);
        g2.translate(iconSize, 0);
        this.as.setActive(sd.isAttentionAlert());
        this.as.setColor(ColorUtils.setTransparencyToColor(!sd.isAttentionAlert() ? activeColor : errorColor, iconColorTransparency));
        this.as.paint(g2, this.as, iconSize, iconSize);
        g2.translate(iconSize, 0);
        this.fl.setActive(sd.isFuelLevel());
        this.fl.setPercentage(sd.getFuelLevelPercentage());
        this.fl.setColor(ColorUtils.setTransparencyToColor(sd.getFuelLevelPercentage() >= 0.1 ? activeColor : errorColor, iconColorTransparency));
        this.fl.paint(g2, this.fl, iconSize, iconSize);
        g2.translate(iconSize, 0);
        this.es.setActive(sd.isEmergencyTaskAlocated());
        this.es.setColor(ColorUtils.setTransparencyToColor(sd.isEmergencyTaskAlocated() ? activeColor : errorColor, iconColorTransparency));
        this.es.paint(g2, this.es, iconSize, iconSize);
        g2.dispose();
        g2 = gtemp;
        if (rpd.showSection3) {
            g2.translate(0, contentLineSpacer + rpd.section2Height);
            for (i = 0; i < rpd.section3Data.length; ++i) {
                if (i != 0) {
                    g2.translate(0, contentLineSpacer + rpd.boundsSection3DataLines[i - 1][1]);
                }
                g2.drawString(rpd.section3Data[i], 0, (int)rpd.boundsSection3DataLines[i][1]);
            }
        }
        if (rpd.showSection4) {
            g2.translate(0, contentLineSpacer + rpd.section3Height);
            for (i = 0; i < rpd.section4Data.length; ++i) {
                if (i != 0) {
                    g2.translate(0, contentLineSpacer + rpd.boundsSection4DataLines[i - 1][1]);
                }
                g2.drawString(rpd.section4Data[i], 0, (int)rpd.boundsSection4DataLines[i][1]);
            }
        }
        g2.dispose();
    }

    private void drawInRenderSystemDisplayList(StateRenderer2D renderer, Graphics2D g, List<SystemDisplay> systemsList) {
        for (SystemDisplay sd : systemsList) {
            Graphics2D g2 = (Graphics2D)g.create();
            ImcSystem sys = ImcSystemsHolder.lookupSystemByName(sd.getId());
            if (sys == null) continue;
            Point2D pt = renderer.getScreenPosition(sys.getLocation());
            g2.translate(pt.getX(), pt.getY());
            Color color = Color.WHITE;
            if (sys.getVehicle() != null && sys.getVehicle().getIconColor() != null) {
                color = sys.getVehicle().getIconColor();
            }
            if (sd.isMainVehicle()) {
                color = new Color(0, 255, 64);
            }
            this.drawImc3System(renderer, g2, sys, color, !this.viewInfoOSDSwitch.isSelected() && !this.viewExtendedOSDSwitch.isSelected());
            g2.dispose();
        }
    }

    private void drawInRenderImc3SystemList(StateRenderer2D renderer, Graphics2D g, List<ImcSystem> systemsList) {
        for (ImcSystem sys : systemsList) {
            Graphics2D g2 = (Graphics2D)g.create();
            Point2D pt = renderer.getScreenPosition(sys.getLocation());
            g2.translate(pt.getX(), pt.getY());
            Color color = new Color(210, 176, 106);
            if (SystemPainterHelper.getLocationAge(sys.getLocation(), sys.getLocationTimeMillis()) < 60000L * (long)this.minutesToHideSystemsWithoutKnownLocation || sys.isActive()) {
                this.drawImc3System(renderer, g2, sys, color, true);
            }
            g2.dispose();
        }
    }

    private void drawInRenderExternalSystemList(StateRenderer2D renderer, Graphics2D g, List<ExternalSystem> systemsList) {
        for (ExternalSystem sys : systemsList) {
            Graphics2D g2 = (Graphics2D)g.create();
            Point2D pt = renderer.getScreenPosition(sys.getLocation());
            g2.translate(pt.getX(), pt.getY());
            Color color = new Color(255, 0, 255);
            if (System.currentTimeMillis() - sys.getLocationTimeMillis() < 60000L * (long)this.minutesToHideSystemsWithoutKnownLocation) {
                this.drawExternalSystem(renderer, g2, sys, color);
            }
            g2.dispose();
        }
    }

    private void drawImc3System(StateRenderer2D renderer, Graphics2D g, ImcSystem sys, Color color, boolean drawLabel) {
        Graphics2D g2 = (Graphics2D)g.create();
        double iconWidth = this.rendererIconsSize;
        boolean isLocationKnownUpToDate = SystemPainterHelper.isLocationKnown(sys);
        if (!this.useMilStd2525LikeSymbols) {
            SystemPainterHelper.drawErrorStateForSystem(renderer, g2, sys, iconWidth, isLocationKnownUpToDate);
        }
        if (this.useMilStd2525LikeSymbols) {
            SystemPainterHelper.drawMilStd2525LikeSymbolForSystem(g2, sys, isLocationKnownUpToDate, false, this.milStd2525FilledOrNot == MilStd2525SymbolsFilledEnum.FILLED);
        } else {
            SystemPainterHelper.drawSystemIcon(renderer, g2, sys, color, iconWidth, isLocationKnownUpToDate);
        }
        if (!this.useMilStd2525LikeSymbols && this.drawCircleInRenderDependentOfSystemType) {
            SystemPainterHelper.CircleTypeBySystemType circleType = SystemPainterHelper.CircleTypeBySystemType.DEFAULT;
            block0 : switch (sys.getType()) {
                case CCU: {
                    circleType = SystemPainterHelper.CircleTypeBySystemType.SURFACE_UNIT;
                    break;
                }
                case MOBILESENSOR: 
                case STATICSENSOR: {
                    circleType = SystemPainterHelper.CircleTypeBySystemType.DEFAULT;
                    break;
                }
                case VEHICLE: {
                    switch (sys.getTypeVehicle()) {
                        case UAV: {
                            circleType = SystemPainterHelper.CircleTypeBySystemType.AIR;
                            break block0;
                        }
                        case UUV: {
                            circleType = SystemPainterHelper.CircleTypeBySystemType.SUBSURFACE;
                            break block0;
                        }
                        case USV: 
                        case UGV: {
                            circleType = SystemPainterHelper.CircleTypeBySystemType.SURFACE;
                            break block0;
                        }
                    }
                    circleType = SystemPainterHelper.CircleTypeBySystemType.DEFAULT;
                    break;
                }
                default: {
                    circleType = SystemPainterHelper.CircleTypeBySystemType.DEFAULT;
                }
            }
            SystemPainterHelper.drawCircleForSystem(g2, color, iconWidth, circleType, isLocationKnownUpToDate);
        }
        if (drawLabel && this.drawSystemLabel) {
            SystemPainterHelper.drawSystemNameLabel(g2, sys.getName(), color, iconWidth, isLocationKnownUpToDate);
        }
        SystemPainterHelper.drawCourseSpeedVectorForSystem(renderer, g2, sys, iconWidth, isLocationKnownUpToDate, this.minimumSpeedToBeStopped);
        g2.dispose();
    }

    private void drawExternalSystem(StateRenderer2D renderer, Graphics2D g, ExternalSystem sys, Color color) {
        Graphics2D g2 = (Graphics2D)g.create();
        double iconWidth = this.rendererIconsSize;
        boolean isLocationKnownUpToDate = SystemPainterHelper.isLocationKnown(sys.getLocation(), sys.getLocationTimeMillis());
        if (this.useMilStd2525LikeSymbols) {
            MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum type = MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum.SURFACE;
            MilStd2525LikeSymbolsDefinitions.SymbolShapeEnum shapeType = MilStd2525LikeSymbolsDefinitions.SymbolShapeEnum.UNFRAMED;
            MilStd2525LikeSymbolsDefinitions.SymbolOperationalConditionEnum operationalCondition = MilStd2525LikeSymbolsDefinitions.SymbolOperationalConditionEnum.NONE;
            MilStd2525LikeSymbolsDefinitions.SymbolIconEnum drawIcon = MilStd2525LikeSymbolsDefinitions.SymbolIconEnum.UNKNOWN;
            SystemPainterHelper.drawMilStd2525LikeSymbolForSystem(g2, type, shapeType, operationalCondition, drawIcon, isLocationKnownUpToDate, false, this.milStd2525FilledOrNot == MilStd2525SymbolsFilledEnum.FILLED);
        } else {
            SystemPainterHelper.drawSystemIcon(renderer, g2, sys.getYawDegrees(), color, iconWidth, isLocationKnownUpToDate);
        }
        if (this.drawSystemLabel) {
            SystemPainterHelper.drawSystemNameLabel(g2, sys.getName(), color, iconWidth, isLocationKnownUpToDate);
        }
        g2.dispose();
    }

    @Override
    public Collection<JMenuItem> getApplicableItems(LocationType loc, IMapPopup source) {
        Vector<JMenuItem> menus = new Vector<JMenuItem>();
        JMenu mainMenu = new JMenu(I18n.text("Systems in renderer"));
        JCheckBoxMenuItem viewInfoBallonCheckMenu = new JCheckBoxMenuItem(new AbstractAction((String)this.viewInfoOSDAction.getValue("Name"), this.ICON_VIEW_INFO){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemsList.this.viewInfoOSDSwitch.doClick(50);
            }
        });
        viewInfoBallonCheckMenu.setSelected(this.viewInfoOSDSwitch.isSelected());
        JCheckBoxMenuItem viewExtendedBallonCheckMenu = new JCheckBoxMenuItem(new AbstractAction((String)this.viewExtendedOSDAction.getValue("Name"), this.ICON_VIEW_EXTRA){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemsList.this.viewExtendedOSDSwitch.doClick(50);
            }
        });
        viewExtendedBallonCheckMenu.setSelected(this.viewExtendedOSDSwitch.isSelected());
        mainMenu.add(viewInfoBallonCheckMenu);
        mainMenu.add(viewExtendedBallonCheckMenu);
        menus.add(mainMenu);
        return menus;
    }

    @Override
    public void propertiesChanged() {
        if (this.mainSizeIncrement < 0 || this.mainSizeIncrement > Math.min(this.iconsSize, this.indicatorsSize) / 2) {
            this.mainSizeIncrement = 0;
        }
        for (SystemDisplay sys : this.systems.values().toArray(new SystemDisplay[0])) {
            sys.setIconSize(this.iconsSize);
            sys.setIndicatorsSize(this.indicatorsSize);
            sys.setShowSystemSymbolOrText(this.showSystemSymbolOrText);
            sys.setEnableSelection(this.enableSelection);
            if (!sys.isMainVehicle()) continue;
            this.changeMainVehicle(sys.getId());
        }
        if (this.rendererIconsSize < 20) {
            this.rendererIconsSize = 20;
        } else if (this.rendererIconsSize > 50) {
            this.rendererIconsSize = 50;
        }
        this.viewIconsSwitch.setSelected(this.showSystemsIconsOnRenderer);
        this.clearSelection.setEnabled(this.enableSelection);
        this.redoSelection.setEnabled(this.enableSelection);
        this.comparator.setOrderOption(this.orderingOption);
        this.updateMainVehicle = true;
        this.updateOrdering = true;
    }

    @Override
    public Collection<String> getSelectedSystems(boolean clearSelection) {
        Vector<String> sel = new Vector<String>();
        for (SystemDisplay disp : this.systems.values().toArray(new SystemDisplay[0])) {
            if (!disp.isSelected()) continue;
            sel.add(disp.getId());
        }
        if (clearSelection) {
            this.clearSelectedSystems();
        }
        return sel;
    }

    @Override
    public Collection<String> getAvailableSelectedSystems() {
        Vector<String> sel = new Vector<String>();
        for (SystemDisplay disp : this.systems.values().toArray(new SystemDisplay[0])) {
            sel.add(disp.getId());
        }
        return sel;
    }

    @Override
    public Collection<String> getSelectedVehicles(boolean clearSelection) {
        Vector<String> sel = new Vector<String>();
        for (SystemDisplay disp : this.systems.values().toArray(new SystemDisplay[0])) {
            VehicleType v;
            if (!disp.isSelected() || (v = VehiclesHolder.getVehicleById(disp.getId())) == null) continue;
            sel.add(disp.getId());
        }
        if (clearSelection) {
            this.clearSelectedSystems();
        }
        return sel;
    }

    @Override
    public Collection<String> getAvailableVehicles() {
        Vector<String> sel = new Vector<String>();
        for (SystemDisplay disp : this.systems.values().toArray(new SystemDisplay[0])) {
            VehicleType v = VehiclesHolder.getVehicleById(disp.getId());
            if (v == null) continue;
            sel.add(disp.getId());
        }
        return sel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelectedSystems() {
        Vector<SystemDisplay> vector = this.prevSelection;
        synchronized (vector) {
            Vector<SystemDisplay> tmp = new Vector<SystemDisplay>();
            for (SystemDisplay disp : this.systems.values().toArray(new SystemDisplay[0])) {
                if (!disp.isSelected()) continue;
                disp.setSelected(false);
                tmp.add(disp);
            }
            if (tmp.size() > 0) {
                this.prevSelection.clear();
                this.prevSelection.addAll(tmp);
                Object var2_2 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redoSelectedSystems() {
        Vector<SystemDisplay> vector = this.prevSelection;
        synchronized (vector) {
            if (this.prevSelection.size() > 0) {
                for (SystemDisplay disp : this.prevSelection) {
                    if (disp.isSelected()) continue;
                    disp.setSelected(true);
                }
            }
        }
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        boolean test1Enable = false;
        boolean test2Enable = true;
        boolean test3Enable = false;
        if (test1Enable) {
            ConsoleParse.consoleLayoutLoader("conf/consoles/seacon-light.ncon");
        }
        if (test2Enable) {
            JFrame frame = GuiUtils.testFrame(new MonitorIMCComms(ImcMsgManager.getManager()), "Monitor IMC Comms");
            frame.setIconImage(MonitorIMCComms.ICON_ON.getImage());
            frame.setSize(396, 466);
            SystemDisplay sys1 = new SystemDisplay("lauv-xtreme-2");
            SystemDisplay sys2 = new SystemDisplay("lauv-seacon-1");
            SystemDisplay sys3 = new SystemDisplay("lauv-seacon-2");
            final SystemsList sList = new SystemsList(null);
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        sList.update();
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }.start();
            sys2.setActive(true);
            Image image = new ImageIcon("vehicles-files\\lauv\\conf\\images\\lauv-seacon0-presentation.png").getImage();
            sys1.setSystemImage(image);
            image = new ImageIcon("vehicles-files\\lauv\\conf\\images\\lauv-seacon0-presentation.png").getImage();
            sys2.setSystemImage(image);
            ConsoleParse.dummyConsole(sList);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            VehiclesHolder.loadVehicles();
            ImcMsgManager.getManager().start();
            ImcMsgManager.getManager().initVehicleCommInfo("lauv-xtreme-2", "");
            ImcMsgManager.getManager().initVehicleCommInfo("lauv-seacon-3", "");
            ImcMsgManager.getManager().initVehicleCommInfo("lauv-seacon-1", "");
            ImcMsgManager.getManager().initVehicleCommInfo("lauv-seacon-2", "");
            sList.systemsFilter = VehicleType.SystemTypeEnum.ALL;
        }
        if (test3Enable) {
            final StateRenderer2D sr = new StateRenderer2D();
            final ImcSystem sys = new ImcSystem(new ImcId16(24L));
            JLabel lb = new JLabel(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    int w = this.getWidth();
                    int h = this.getHeight();
                    g2.translate(w / 2, h / 2);
                    int iconWidth = 130;
                    sys.setOnErrorState(true);
                    SystemPainterHelper.drawErrorStateForSystem(sr, g2, sys, iconWidth, true);
                    sys.setAttitudeDegrees(60.0);
                    SystemPainterHelper.drawSystemIcon(sr, g2, sys, Color.GREEN, (double)iconWidth, true);
                    SystemPainterHelper.drawCircleForSystem(g2, Color.GREEN, iconWidth, SystemPainterHelper.CircleTypeBySystemType.AIR, true);
                }
            };
            GuiUtils.testFrame(lb, "test", 300, 300);
        }
    }

    private class RenderPainterSystemData {
        Point2D pt;
        String sysName;
        Rectangle2D boundsSysName;
        boolean showSection3;
        String[] section3Data;
        Integer[][] boundsSection3DataLines;
        int section3ContentLines;
        boolean showSection4;
        String[] section4Data;
        Integer[][] boundsSection4DataLines;
        int section4ContentLines;
        int offsetX = 20;
        int offsetY = -20;
        int numberOfIcons = 8;
        int section1Width;
        int section1Height;
        int section2Width;
        int section2Height;
        int section3Width;
        int section3Height;
        int section4Width;
        int section4Height;
        double boxContentW;
        double boxContentH;
        double boxW;
        double boxH;
        double boxContentXOffset;
        double boxContentYOffset;
        double boxXOffset;
        double boxYOffset;
        RoundRectangle2D boxShape;
        Polygon pointerShape;

        private RenderPainterSystemData() {
        }
    }

    public static enum MilStd2525SymbolsFilledEnum {
        FILLED,
        NOT_FILLED;

    }

    public static enum SortOrderEnum {
        UNSORTED,
        SORTED;

    }
}

