/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import com.google.common.eventbus.Subscribe;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import pt.lsts.imc.VehicleState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ConsoleSystem;
import pt.lsts.neptus.console.events.ConsoleEventVehicleStateChanged;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;

@PluginDescription(name="Vehicle State Monitor")
public class VehicleStateMonitor
extends ConsolePanel
implements IPeriodicUpdates {
    private static final long serialVersionUID = 1L;
    protected ConcurrentMap<String, VehicleState> systemStates = new ConcurrentHashMap<String, VehicleState>();

    public VehicleStateMonitor(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
    }

    @Override
    public long millisBetweenUpdates() {
        return 1500L;
    }

    @Override
    public boolean update() {
        for (String system : this.systemStates.keySet()) {
            try {
                if (ImcSystemsHolder.getSystemWithName(system).isActive()) continue;
                this.systemStates.remove(system);
                this.post(new ConsoleEventVehicleStateChanged(system, I18n.text("No communication received for more than 10 seconds"), ConsoleEventVehicleStateChanged.STATE.DISCONNECTED));
                this.getConsole().getSystem(system).setVehicleState(ConsoleEventVehicleStateChanged.STATE.DISCONNECTED);
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)(VehicleStateMonitor.class.getSimpleName() + " for " + system + " gave an error: " + e.getMessage()));
            }
        }
        return true;
    }

    @Subscribe
    public void consume(VehicleState msg) {
        try {
            VehicleState oldState;
            String src = msg.getSourceName();
            ConsoleSystem consoleSystem = this.getConsole().getSystem(src);
            if (src == null || consoleSystem == null) {
                return;
            }
            ConsoleEventVehicleStateChanged.STATE systemState = ConsoleEventVehicleStateChanged.STATE.valueOf(msg.getOpMode().toString());
            String text = "";
            if (!msg.getLastError().isEmpty() && systemState != ConsoleEventVehicleStateChanged.STATE.SERVICE) {
                text = text + "Last error: " + msg.getLastError() + "<br>";
            }
            if (!msg.getErrorEnts().isEmpty()) {
                text = text + "Entities in error: " + msg.getErrorEnts();
            }
            if ((oldState = (VehicleState)this.systemStates.get(src)) == null) {
                this.post(new ConsoleEventVehicleStateChanged(src, text, systemState));
                consoleSystem.setVehicleState(systemState);
                this.systemStates.put(src, msg);
            } else {
                VehicleState.OP_MODE last = oldState.getOpMode();
                VehicleState.OP_MODE current = msg.getOpMode();
                int lastType = oldState.getManeuverType();
                int currentType = msg.getManeuverType();
                if (last != current || lastType != currentType) {
                    this.systemStates.put(src, msg);
                    if (msg.getManeuverType() == 452) {
                        this.post(new ConsoleEventVehicleStateChanged(src, text, ConsoleEventVehicleStateChanged.STATE.TELEOPERATION));
                        consoleSystem.setVehicleState(ConsoleEventVehicleStateChanged.STATE.TELEOPERATION);
                    } else {
                        this.post(new ConsoleEventVehicleStateChanged(src, text, systemState));
                        consoleSystem.setVehicleState(systemState);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initSubPanel() {
    }

    @Override
    public void cleanSubPanel() {
    }
}

