/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.containers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ContainerSubPanel;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="Console Layout: Collapsible", description="Collapsible subpanels", icon="pt/lsts/neptus/plugins/containers/layout.png")
public class CollapsibleContainer
extends ContainerSubPanel {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(editable=false)
    public String state = "";
    protected LinkedHashMap<ConsolePanel, JXCollapsiblePane> colPanes = new LinkedHashMap();
    protected LinkedHashMap<ConsolePanel, JPanel> auxPanels = new LinkedHashMap();

    public CollapsibleContainer(ConsoleLayout console) {
        super(console);
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray.darker()));
    }

    @Override
    public void addSubPanel(ConsolePanel panel) {
        int pos = this.panels.size();
        this.panels.add(panel);
        String[] states = this.state.split(",");
        if (states.length > pos && states[pos].equals("0")) {
            this.addCollapsiblePanel(panel, panel.getName(), true);
        } else {
            this.addCollapsiblePanel(panel, panel.getName(), false);
        }
        this.doLayout();
        this.invalidate();
        this.revalidate();
    }

    @Override
    public void removeSubPanel(ConsolePanel sp) {
        this.panels.remove(sp);
        this.remove((Component)this.colPanes.get(sp));
        this.remove(this.auxPanels.get(sp));
        this.colPanes.remove(sp);
        this.auxPanels.remove(sp);
        this.doLayout();
        this.invalidate();
        this.revalidate();
    }

    private JXCollapsiblePane addCollapsiblePanel(ConsolePanel cmp, String label, boolean collapsed) {
        final JXCollapsiblePane colPane = new JXCollapsiblePane();
        colPane.setLayout((LayoutManager)new BorderLayout());
        colPane.add((Component)cmp, (Object)"Center");
        final JLabel minimizeLbl = new JLabel(ImageUtils.getScaledIcon("pt/lsts/neptus/plugins/containers/minus.png", 12, 12));
        minimizeLbl.setPreferredSize(new Dimension(12, 12));
        minimizeLbl.setMaximumSize(new Dimension(12, 12));
        minimizeLbl.setMinimumSize(new Dimension(12, 12));
        minimizeLbl.setCursor(new Cursor(12));
        minimizeLbl.setToolTipText("minimize");
        JLabel auxLbl = new JLabel(label);
        JXPanel auxPanel = new JXPanel((LayoutManager)new BorderLayout());
        auxPanel.add((Component)auxLbl, (Object)"Center");
        auxPanel.add((Component)minimizeLbl, (Object)"East");
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getSource() == minimizeLbl || e.getClickCount() == 2) {
                    if (minimizeLbl.getToolTipText().equals("minimize")) {
                        colPane.getActionMap().get("toggle").actionPerformed(new ActionEvent(minimizeLbl, 1999, "toggle"));
                        minimizeLbl.setToolTipText("maximize");
                        minimizeLbl.setIcon(ImageUtils.getScaledIcon("pt/lsts/neptus/plugins/containers/plus.png", 12, 12));
                    } else {
                        colPane.getActionMap().get("toggle").actionPerformed(new ActionEvent(minimizeLbl, 1999, "toggle"));
                        minimizeLbl.setToolTipText("minimize");
                        minimizeLbl.setIcon(ImageUtils.getScaledIcon("pt/lsts/neptus/plugins/containers/minus.png", 12, 12));
                    }
                    CollapsibleContainer.this.state = CollapsibleContainer.this.computeState();
                }
            }
        };
        minimizeLbl.addMouseListener(adapter);
        auxLbl.addMouseListener(adapter);
        auxPanel.setBorder(LineBorder.createBlackLineBorder());
        auxPanel.setPreferredSize(new Dimension(100, 14));
        auxPanel.setMinimumSize(new Dimension(100, 14));
        auxPanel.setMaximumSize(new Dimension(1000, 14));
        auxPanel.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{new MattePainter((Paint)new GradientPaint(0.0f, 0.0f, Color.gray.brighter(), 0.0f, 15.0f, Color.gray)), new GlossPainter()}));
        this.add((Component)auxPanel);
        colPane.setBorder((Border)BorderFactory.createMatteBorder(0, 1, 1, 1, Color.black));
        colPane.setPreferredSize(new Dimension(this.getWidth(), (int)cmp.getPreferredSize().getHeight()));
        if (collapsed) {
            colPane.setCollapsed(true);
            minimizeLbl.setToolTipText("maximize");
            minimizeLbl.setIcon(ImageUtils.getScaledIcon("pt/lsts/neptus/plugins/containers/plus.png", 12, 12));
        }
        this.add((Component)colPane);
        this.auxPanels.put(cmp, (JPanel)auxPanel);
        this.colPanes.put(cmp, colPane);
        return colPane;
    }

    protected String computeState() {
        String state = "";
        for (JXCollapsiblePane pane : this.colPanes.values()) {
            if (pane.isCollapsed()) {
                state = state + "0,";
                continue;
            }
            state = state + "1,";
        }
        return state + "0";
    }

    public static void main(String[] args) {
    }
}

