/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.containers;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ContainerSubPanel;
import pt.lsts.neptus.console.MainPanel;
import pt.lsts.neptus.console.plugins.containers.LayoutProfileProvider;
import pt.lsts.neptus.console.plugins.containers.propeditor.HorizontalGroupPropertyEditor;
import pt.lsts.neptus.console.plugins.containers.propeditor.LinkSizeHorizontalPropertyEditor;
import pt.lsts.neptus.console.plugins.containers.propeditor.LinkSizeVerticalPropertyEditor;
import pt.lsts.neptus.console.plugins.containers.propeditor.ProfilesPropertyEditor;
import pt.lsts.neptus.console.plugins.containers.propeditor.VerticalGroupPropertyEditor;
import pt.lsts.neptus.gui.MenuScroller;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.XMLUtil;

@PluginDescription(author="Paulo Dias", version="1.3.1", name="Console Layout: Group", description="Container using GroupLayout (see 'http://download.oracle.com/javase/tutorial/uiswing/layout/group.html' and 'http://download.oracle.com/javase/tutorial/uiswing/layout/groupExample.html')", icon="pt/lsts/neptus/plugins/containers/layout.png")
public class GroupLayoutContainer
extends ContainerSubPanel
implements ConfigurationListener,
LayoutProfileProvider {
    public static final String GROUP_LAYOUT_SCHEMA = "console-group-layout.xsd";
    protected static final String NONE_PROFILE_STRING = "-- None --";
    @NeptusProperty(name="Auto Create Container Gaps", description="To automatic create gaps arround the container", distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public boolean autoCreateContainerGaps = false;
    @NeptusProperty(name="Auto Create Gaps", description="To automatic create gaps arround the components", distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public boolean autoCreateGaps = false;
    @NeptusProperty(name="Honors Visibility", distribution=NeptusProperty.DistributionEnum.DEVELOPER, description="Set this so if  component is hidden is if it's not there at all. For most uses leave it at true.")
    public boolean honorsVisibility = true;
    @NeptusProperty(name="Horizontal Group", description="You can use the index number or the name as listed.", editorClass=HorizontalGroupPropertyEditor.class, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public String horizontalGroup = "";
    @NeptusProperty(name="Vertical Group", description="You can use the index number or the name as listed.", editorClass=VerticalGroupPropertyEditor.class, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public String verticalGroup = "";
    @NeptusProperty(name="Link Size Horizontal", description="You can use the index number or the name as listed.", editorClass=LinkSizeHorizontalPropertyEditor.class, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public String linkSizeHorizontal = "";
    @NeptusProperty(name="Link Size Vertical", description="You can use the index number or the name as listed.", editorClass=LinkSizeVerticalPropertyEditor.class, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public String linkSizeVertical = "";
    @NeptusProperty(name="Profiles", description="To set groups of visible components. You can use the index number or the name as listed.", editorClass=ProfilesPropertyEditor.class, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public String profiles = "";
    @NeptusProperty(name="Show Only Declared Profiles to User", description="This if true will show only declared profiles to users to choose (will hide the \"-- None --\" option).", distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public boolean showOnlyProfilesToUser = false;
    private boolean inEditMode = false;
    private GroupLayout layout = null;
    protected LinkedHashMap<String, String> profilesList = new LinkedHashMap();
    protected LinkedHashMap<String, LayoutHolder> profilesLayouts = new LinkedHashMap();
    protected String defaultProfile = "";
    protected String activeProfile = "";
    private MouseListener mouseListener = null;
    private JMenu menuForProfileChangeInConsole = null;
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    public static Schema schema = null;

    public GroupLayoutContainer(ConsoleLayout console) {
        super(console);
        this.docBuilderFactory.setIgnoringComments(true);
        this.docBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.docBuilderFactory.setNamespaceAware(false);
        if (schema == null) {
            SchemaFactory sm = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                File sFx = StreamUtil.copyStreamToTempFile(GroupLayoutContainer.class.getResourceAsStream(GROUP_LAYOUT_SCHEMA));
                schema = sm.newSchema(sFx);
            }
            catch (Exception e) {
                NeptusLog.pub().warn((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
            }
        }
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.layout = new GroupLayout(this);
        this.setLayout(this.layout);
        this.layout.setAutoCreateGaps(true);
        this.layout.setAutoCreateContainerGaps(true);
        this.mouseListener = this.getLayoutMouseListener();
        this.addMouseListener(this.getLayoutMouseListener());
        this.loadProfiles();
    }

    @Override
    public void doLayout() {
        try {
            super.doLayout();
        }
        catch (IllegalStateException e) {
            new Thread(){

                @Override
                public void run() {
                    GuiUtils.errorMessage(SwingUtilities.windowForComponent(GroupLayoutContainer.this), e);
                    e.printStackTrace();
                }
            }.start();
        }
    }

    @Override
    public void init() {
        super.init();
        this.addProfilesJMenuToConsole();
    }

    @Override
    public void clean() {
        super.clean();
        this.removeProfilesJMenuFromConsole();
    }

    @Override
    public void propertiesChanged() {
        this.loadProfiles();
        if (this.subPanelList().length > 0) {
            this.applyLayout();
        }
    }

    @Override
    public void XML_ChildsRead(org.dom4j.Element el) {
        super.XML_ChildsRead(el);
        this.applyLayout();
    }

    @Override
    public void addSubPanel(ConsolePanel panel) {
        super.addSubPanel(panel);
        panel.addMouseListener(this.getLayoutMouseListener());
    }

    @Override
    public void removeSubPanel(ConsolePanel sp) {
        super.removeSubPanel(sp);
        sp.removeMouseListener(this.getLayoutMouseListener());
    }

    private void addProfilesJMenuToConsole() {
        if (this.menuForProfileChangeInConsole != null && this.getParent() instanceof MainPanel && this.profilesList.keySet().size() == 0) {
            this.removeProfilesJMenuFromConsole();
        } else if (this.menuForProfileChangeInConsole == null && this.getParent() instanceof MainPanel && this.profilesList.keySet().size() > 0) {
            this.menuForProfileChangeInConsole = this.getConsole().getOrCreateJMenu(new String[]{I18n.text("Profiles")});
            this.menuForProfileChangeInConsole.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    GroupLayoutContainer.this.menuForProfileChangeInConsole.removeAll();
                    for (final String name : GroupLayoutContainer.this.profilesList.keySet()) {
                        String defaultStr = "";
                        if (name.equalsIgnoreCase(GroupLayoutContainer.this.defaultProfile)) {
                            defaultStr = " (default)";
                        }
                        JCheckBoxMenuItem vMItem = new JCheckBoxMenuItem(new AbstractAction(name + defaultStr){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GroupLayoutContainer.this.setActiveProfile(name);
                            }
                        });
                        if (name.equalsIgnoreCase(GroupLayoutContainer.this.activeProfile)) {
                            vMItem.setSelected(true);
                        }
                        GroupLayoutContainer.this.menuForProfileChangeInConsole.add(vMItem);
                    }
                    if (!GroupLayoutContainer.this.showOnlyProfilesToUser) {
                        JCheckBoxMenuItem vMNone = new JCheckBoxMenuItem(new AbstractAction(GroupLayoutContainer.NONE_PROFILE_STRING){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GroupLayoutContainer.this.setActiveProfile(GroupLayoutContainer.this.getName());
                            }
                        });
                        GroupLayoutContainer.this.menuForProfileChangeInConsole.add(vMNone);
                        if ("".equalsIgnoreCase(GroupLayoutContainer.this.activeProfile)) {
                            vMNone.setSelected(true);
                        }
                    }
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
        }
    }

    private void removeProfilesJMenuFromConsole() {
        if (this.menuForProfileChangeInConsole != null) {
            try {
                this.menuForProfileChangeInConsole.getParent().remove(this.menuForProfileChangeInConsole);
                this.menuForProfileChangeInConsole = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String[] validateLayoutXML(InputStream is) {
        final Vector<String> validationMsgs = new Vector<String>();
        Validator validator = schema.newValidator();
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                validationMsgs.add("WARNING: " + exception.getMessage());
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                validationMsgs.add("ERROR: " + exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                validationMsgs.add("FATAL: " + exception.getMessage());
            }
        });
        try {
            validator.validate(new StreamSource(is));
        }
        catch (Exception e) {
            validationMsgs.add("SOURCE: " + e.getMessage());
        }
        return validationMsgs.toArray(new String[validationMsgs.size()]);
    }

    private void changeDefaultProfileInXml() {
        String profToChange = this.profiles.trim();
        boolean toChangeOrRemove = true;
        if ("".equalsIgnoreCase(this.defaultProfile)) {
            toChangeOrRemove = false;
        }
        if (profToChange.startsWith("<Profile")) {
            if (toChangeOrRemove) {
                this.profiles = "<Default profile=\"" + this.defaultProfile + "\" />\n" + profToChange;
            }
        } else {
            Pattern pat = Pattern.compile("^<Default\\s+profile=\\s*(\"((.|\\s)+?)\"|'((.|\\s)+?)')\\s*/>");
            Matcher m = pat.matcher(profToChange);
            m.find();
            if (m.groupCount() > 0) {
                String aspas;
                String string = aspas = m.group(2) != null ? "\"" : "'";
                this.profiles = toChangeOrRemove ? m.replaceFirst("<Default profile=" + aspas + this.defaultProfile + aspas + " />") : m.replaceFirst("");
            } else {
                NeptusLog.pub().info((Object)("<###>Not able to change default profile from " + (m.group(2) != null ? m.group(2) : m.group(4)) + " with " + this.defaultProfile));
            }
        }
    }

    private void loadProfiles() {
        try {
            DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Profiles>" + this.profiles.trim() + "</Profiles>").getBytes());
            String[] vmsgs = this.validateLayoutXML(bais);
            if (vmsgs.length != 0) {
                String strMsg = "Invalid XML!\n";
                for (String str : vmsgs) {
                    strMsg = strMsg + "\n" + str;
                }
                NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + "Profiles: " + strMsg));
                return;
            }
            bais.reset();
            Document docProfiles = builder.parse(bais);
            Element root = docProfiles.getDocumentElement();
            this.profilesList.clear();
            this.activeProfile = "";
            this.defaultProfile = "";
            for (Node bn = root.getFirstChild(); bn != null; bn = bn.getNextSibling()) {
                Node cn;
                if ("Default".equalsIgnoreCase(bn.getNodeName())) {
                    try {
                        String dName = bn.getAttributes().getNamedItem("profile").getTextContent();
                        if ("".equals(dName)) continue;
                        this.defaultProfile = dName;
                    }
                    catch (Exception e) {
                        NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
                    }
                    continue;
                }
                String pName = null;
                try {
                    pName = bn.getAttributes().getNamedItem("name").getTextContent();
                }
                catch (Exception e) {
                    NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
                }
                if (pName == null) continue;
                boolean exclude = false;
                try {
                    exclude = Boolean.parseBoolean(bn.getAttributes().getNamedItem("exclude").getTextContent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String pStringList = !exclude ? "+" : "-";
                LayoutHolder layouHolder = null;
                if (cn != null) {
                    for (cn = bn.getFirstChild(); cn != null; cn = cn.getNextSibling()) {
                        if ("Component".equalsIgnoreCase(cn.getNodeName())) {
                            String cId = null;
                            try {
                                cId = cn.getAttributes().getNamedItem("id").getTextContent();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
                            }
                            if (cId == null) continue;
                            pStringList = pStringList + "," + cId;
                            continue;
                        }
                        if (!"Layout".equalsIgnoreCase(cn.getNodeName())) continue;
                        layouHolder = new LayoutHolder();
                        Node ln = cn.getFirstChild();
                        if (ln == null) continue;
                        while (ln != null) {
                            String xmlStr = XMLUtil.nodeChildsToString(ln);
                            if ("HorizontalGroup".equalsIgnoreCase(ln.getNodeName())) {
                                layouHolder.horizontalGroup = xmlStr;
                            } else if ("VerticalGroup".equalsIgnoreCase(ln.getNodeName())) {
                                layouHolder.verticalGroup = xmlStr;
                            } else if ("LinkSizeHorizontal".equalsIgnoreCase(ln.getNodeName())) {
                                layouHolder.linkSizeHorizontal = xmlStr;
                            } else if ("LinkSizeVertical".equalsIgnoreCase(ln.getNodeName())) {
                                layouHolder.linkSizeVertical = xmlStr;
                            }
                            ln = ln.getNextSibling();
                        }
                    }
                }
                this.profilesList.put(pName, pStringList);
                if (layouHolder == null) continue;
                this.profilesLayouts.put(pName, layouHolder);
            }
            if (this.defaultProfile != null && !"".equalsIgnoreCase(this.defaultProfile)) {
                if (this.profilesList.get(this.defaultProfile) != null) {
                    this.activeProfile = this.defaultProfile;
                } else {
                    this.defaultProfile = "";
                }
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        this.addProfilesJMenuToConsole();
    }

    @Override
    public void setEditMode(boolean edit) {
        this.inEditMode = edit;
        if (edit) {
            this.restoreComponentsLayoutVisibility();
            if (!"".equalsIgnoreCase(this.activeProfile)) {
                this.applyLayout(this.horizontalGroup, this.verticalGroup, this.linkSizeHorizontal, this.linkSizeVertical, false);
            }
        } else {
            this.setActiveProfile(this.defaultProfile);
        }
        super.setEditMode(edit);
    }

    private void applyLayout() {
        this.applyLayout(this.horizontalGroup, this.verticalGroup, this.linkSizeHorizontal, this.linkSizeVertical, true);
    }

    private void applyLayout(String horizontalGroupLocal, String verticalGroupLocal, String linkSizeHorizontalLocal, String linkSizeVerticalLocal, boolean applyProfile) {
        this.layout.invalidateLayout(this);
        this.layout.setAutoCreateGaps(this.autoCreateGaps);
        this.layout.setAutoCreateContainerGaps(this.autoCreateContainerGaps);
        this.layout.setHonorsVisibility(this.honorsVisibility);
        try {
            DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?><HorizontalGroup>" + horizontalGroupLocal.trim() + "</HorizontalGroup>").getBytes());
            String[] vmsgs = this.validateLayoutXML(bais);
            if (vmsgs.length != 0) {
                String strMsg = "Invalid XML!\n";
                for (String str : vmsgs) {
                    strMsg = strMsg + "\n" + str;
                }
                NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + "HorizontalGroup: " + strMsg));
            }
            bais.reset();
            Document docHG = builder.parse(bais);
            Element rootHG = docHG.getDocumentElement();
            bais = new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?><VerticalGroup>" + verticalGroupLocal.trim() + "</VerticalGroup>").getBytes());
            vmsgs = this.validateLayoutXML(bais);
            if (vmsgs.length != 0) {
                String strMsg = "Invalid XML!\n";
                for (String str : vmsgs) {
                    strMsg = strMsg + "\n" + str;
                }
                NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + "VerticalGroup: " + strMsg));
            }
            bais.reset();
            Document docVG = builder.parse(bais);
            Element rootVG = docVG.getDocumentElement();
            bais = new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?><LinkSizeHorizontal>" + linkSizeHorizontalLocal.trim() + "</LinkSizeHorizontal>").getBytes());
            vmsgs = this.validateLayoutXML(bais);
            if (vmsgs.length != 0) {
                String strMsg = "Invalid XML!\n";
                for (String str : vmsgs) {
                    strMsg = strMsg + "\n" + str;
                }
                NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + "LinkSizeHorizontal: " + strMsg));
            }
            bais.reset();
            Document docLH = builder.parse(bais);
            Element rootLH = docLH.getDocumentElement();
            bais = new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?><LinkSizeVertical>" + linkSizeVerticalLocal.trim() + "</LinkSizeVertical>").getBytes());
            vmsgs = this.validateLayoutXML(bais);
            if (vmsgs.length != 0) {
                String strMsg = "Invalid XML!\n";
                for (String str : vmsgs) {
                    strMsg = strMsg + "\n" + str;
                }
                NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + "LinkSizeVertical: " + strMsg));
            }
            bais.reset();
            Document docLV = builder.parse(bais);
            Element rootLV = docLV.getDocumentElement();
            bais = new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?><ConsoleGroupLayout><HorizontalGroup>" + horizontalGroupLocal.trim() + "</HorizontalGroup>" + "<VerticalGroup>" + verticalGroupLocal.trim() + "</VerticalGroup>" + "<LinkSizeHorizontal>" + linkSizeHorizontalLocal.trim() + "</LinkSizeHorizontal>" + "<LinkSizeVertical>" + linkSizeVerticalLocal.trim() + "</LinkSizeVertical>" + "</ConsoleGroupLayout>").getBytes());
            vmsgs = this.validateLayoutXML(bais);
            if (vmsgs.length != 0) {
                String strMsg = "Invalid XML!\n";
                for (String str : vmsgs) {
                    strMsg = strMsg + "\n" + str;
                }
                NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + "ConsoleGroupLayout: " + strMsg));
                return;
            }
            this.layout.setHorizontalGroup(this.createLayoutGroup(rootHG));
            this.layout.setVerticalGroup(this.createLayoutGroup(rootVG));
            this.createLayoutLinkSize(rootLH, true);
            this.createLayoutLinkSize(rootLV, false);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        if (!this.inEditMode && applyProfile) {
            this.setActiveProfile(this.activeProfile);
        }
    }

    private GroupLayout.Group createLayoutGroup(Element root) {
        GroupLayout.Group group = null;
        Node bn = root.getFirstChild();
        if (bn != null) {
            if (bn.getNodeName().equalsIgnoreCase("Sequence")) {
                group = this.layout.createSequentialGroup();
                this.createLayoutGroupRecursive(bn, group);
            } else if (bn.getNodeName().equalsIgnoreCase("Parallel")) {
                group = this.createLayoutParallelGroup(bn);
                this.createLayoutGroupRecursive(bn, group);
            } else {
                return this.layout.createSequentialGroup();
            }
        }
        return group;
    }

    private GroupLayout.Group createLayoutGroupRecursive(Node root, GroupLayout.Group groupBase) {
        for (Node bn = root.getFirstChild(); bn != null; bn = bn.getNextSibling()) {
            if (bn.getNodeName().equalsIgnoreCase("Sequence")) {
                GroupLayout.SequentialGroup groupS = this.layout.createSequentialGroup();
                groupBase.addGroup(this.createLayoutGroupRecursive(bn, groupS));
                continue;
            }
            if (bn.getNodeName().equalsIgnoreCase("Parallel")) {
                GroupLayout.ParallelGroup groupP = this.createLayoutParallelGroup(bn);
                groupBase.addGroup(this.createLayoutGroupRecursive(bn, groupP));
                continue;
            }
            if (bn.getNodeName().equalsIgnoreCase("Component")) {
                this.addLayoutComponent(bn, groupBase);
                continue;
            }
            if (bn.getNodeName().equalsIgnoreCase("Gap")) {
                this.addLayoutGap(bn, groupBase);
                continue;
            }
            if (!bn.getNodeName().equalsIgnoreCase("GapComponents") && !bn.getNodeName().equalsIgnoreCase("PreferredGap")) continue;
            this.addLayoutSequentialGroupGapComponentOrPreferred(bn, groupBase);
        }
        return groupBase;
    }

    private GroupLayout.ParallelGroup createLayoutParallelGroup(Node bn) {
        boolean resizable = true;
        GroupLayout.Alignment alignment = GroupLayout.Alignment.LEADING;
        try {
            String al = bn.getAttributes().getNamedItem("alignment").getTextContent();
            alignment = GroupLayout.Alignment.valueOf(al);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        try {
            String rs = bn.getAttributes().getNamedItem("resizable").getTextContent();
            resizable = Boolean.getBoolean(rs);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        return this.layout.createParallelGroup(alignment, resizable);
    }

    private void addLayoutSequentialGroupGapComponentOrPreferred(Node bn, GroupLayout.Group groupBase) {
        String il;
        boolean isGapComponents = true;
        if (bn.getNodeName().equalsIgnoreCase("PreferredGap")) {
            isGapComponents = false;
        }
        LayoutStyle.ComponentPlacement type = LayoutStyle.ComponentPlacement.RELATED;
        int pref = -1;
        int max = -2;
        try {
            String pl = bn.getAttributes().getNamedItem("type").getTextContent();
            type = LayoutStyle.ComponentPlacement.valueOf(pl);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        try {
            il = bn.getAttributes().getNamedItem("pref").getTextContent();
            pref = Integer.parseInt(il);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
            return;
        }
        try {
            il = bn.getAttributes().getNamedItem("max").getTextContent();
            max = Integer.parseInt(il);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        int firstComponent = -1;
        int secondComponent = -1;
        String fcl1 = null;
        String fcl2 = null;
        if (isGapComponents) {
            try {
                fcl1 = bn.getAttributes().getNamedItem("firstComponent").getTextContent();
                fcl2 = bn.getAttributes().getNamedItem("secondComponent").getTextContent();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
                return;
            }
            try {
                firstComponent = Integer.parseInt(fcl1);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
            }
            try {
                secondComponent = Integer.parseInt(fcl2);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
            }
        }
        try {
            if (isGapComponents) {
                ConsolePanel comp1 = firstComponent >= 0 ? (ConsolePanel)this.panels.get(firstComponent) : this.getSubPanelByName(fcl1);
                ConsolePanel comp2 = secondComponent >= 0 ? (ConsolePanel)this.panels.get(secondComponent) : this.getSubPanelByName(fcl2);
                ((GroupLayout.SequentialGroup)groupBase).addPreferredGap(comp1, comp2, type, pref, max);
            } else {
                ((GroupLayout.SequentialGroup)groupBase).addPreferredGap(type, pref, max);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
    }

    private void addLayoutGap(Node bn, GroupLayout.Group groupBase) {
        String il;
        int min = Integer.MIN_VALUE;
        int pref = -1;
        int max = Integer.MIN_VALUE;
        try {
            il = bn.getAttributes().getNamedItem("min").getTextContent();
            min = Integer.parseInt(il);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        try {
            il = bn.getAttributes().getNamedItem("pref").getTextContent();
            pref = Integer.parseInt(il);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
            return;
        }
        try {
            il = bn.getAttributes().getNamedItem("max").getTextContent();
            max = Integer.parseInt(il);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        try {
            if (min == Integer.MIN_VALUE || max == Integer.MIN_VALUE) {
                groupBase.addGap(pref);
            } else {
                groupBase.addGap(min, pref, max);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
    }

    private void addLayoutComponent(Node bn, GroupLayout.Group groupBase) {
        String il;
        GroupLayout.Alignment alignment = GroupLayout.Alignment.LEADING;
        try {
            String al = bn.getAttributes().getNamedItem("alignment").getTextContent();
            alignment = GroupLayout.Alignment.valueOf(al);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        int min = -1;
        int pref = -1;
        int max = -1;
        try {
            il = bn.getAttributes().getNamedItem("min").getTextContent();
            min = Integer.parseInt(il);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        try {
            il = bn.getAttributes().getNamedItem("pref").getTextContent();
            pref = Integer.parseInt(il);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        try {
            il = bn.getAttributes().getNamedItem("max").getTextContent();
            max = Integer.parseInt(il);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        ConsolePanel comp = null;
        String il2 = null;
        int id = -1;
        try {
            il2 = bn.getAttributes().getNamedItem("id").getTextContent();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
            return;
        }
        try {
            id = Integer.parseInt(il2);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
        try {
            ConsolePanel consolePanel = comp = id >= 0 ? (ConsolePanel)this.panels.get(id) : this.getSubPanelByName(il2);
            if (comp == null) {
                System.out.print("------------------ " + id + "  ----- " + il2 + " --- " + this.subPanelList().length);
                GuiUtils.printArray(this.subPanelList());
                System.out.flush();
            }
            try {
                ((GroupLayout.ParallelGroup)groupBase).addComponent(comp, alignment, min, pref, max);
            }
            catch (Exception e) {
                e.printStackTrace();
                groupBase.addComponent(comp, min, pref, max);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
        }
    }

    private void createLayoutLinkSize(Element root, boolean isForHorizontal) {
        Node bn = root.getFirstChild();
        while (bn != null) {
            if (!bn.getNodeName().equalsIgnoreCase("LinkSizeGroup")) continue;
            Vector<ConsolePanel> compVec = new Vector<ConsolePanel>();
            for (Node cn = bn.getFirstChild(); cn != null; cn = cn.getNextSibling()) {
                ConsolePanel comp;
                if (!"Component".equalsIgnoreCase(cn.getNodeName())) continue;
                String cil = cn.getAttributes().getNamedItem("id").getTextContent();
                int idx = -1;
                try {
                    idx = Integer.parseInt(cil);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                ConsolePanel consolePanel = comp = idx >= 0 ? (ConsolePanel)this.panels.get(idx) : this.getSubPanelByName(cil);
                if (comp == null) continue;
                compVec.add(comp);
            }
            if (compVec.size() >= 2) {
                Component[] components = compVec.toArray(new Component[compVec.size()]);
                this.layout.linkSize(isForHorizontal ? 0 : 1, components);
            }
            bn = bn.getNextSibling();
        }
    }

    private MouseListener getLayoutMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        Component comp;
                        Rectangle screenB = GuiUtils.getScreenBounds(e.getComponent().getX(), e.getComponent().getY());
                        int s = (int)(screenB.getHeight() / 22.0);
                        JPopupMenu popup = new JPopupMenu();
                        if (GroupLayoutContainer.this.honorsVisibility && (comp = e.getComponent()) != GroupLayoutContainer.this) {
                            JMenuItem mtjmi = new JMenuItem(new AbstractAction("Maximize this " + PluginUtils.getPluginName(comp.getClass())){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    if (comp != null) {
                                        GroupLayoutContainer.this.setComponentLayoutVisibility(false);
                                        GroupLayoutContainer.this.setComponentLayoutVisibility(true, new Component[]{comp});
                                    }
                                }
                            });
                            mtjmi.setIcon(ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(comp.getClass()), 16, 16));
                            popup.add(mtjmi);
                            JMenuItem mtjmi2 = new JMenuItem(new AbstractAction("Hide this " + PluginUtils.getPluginName(comp.getClass())){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    if (comp != null) {
                                        GroupLayoutContainer.this.setComponentLayoutVisibility(false, new Component[]{comp});
                                    }
                                }
                            });
                            mtjmi2.setIcon(ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(comp.getClass()), 16, 16));
                            popup.add(mtjmi2);
                            popup.addSeparator();
                        }
                        boolean isContainerSelected = false;
                        if (popup.getComponentCount() == 0) {
                            isContainerSelected = true;
                        }
                        if (isContainerSelected = true) {
                            JMenu addp = new JMenu("Maximize component");
                            int i = 0;
                            for (String spName : GroupLayoutContainer.this.subPanelList()) {
                                final ConsolePanel comp2 = GroupLayoutContainer.this.getSubPanelByName(spName);
                                boolean hidden = false;
                                try {
                                    ConsolePanel ssp = comp2;
                                    hidden = !ssp.getVisibility();
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                                JMenuItem cjmi = new JMenuItem(new AbstractAction("(" + i++ + ") " + spName + (hidden ? " (hidden)" : "")){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        GroupLayoutContainer.this.setComponentLayoutVisibility(false);
                                        GroupLayoutContainer.this.setComponentLayoutVisibility(true, new Component[]{comp2});
                                    }
                                });
                                if (hidden) {
                                    cjmi.setEnabled(false);
                                }
                                cjmi.setIcon(ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(comp2.getClass()), 16, 16));
                                addp.add(cjmi);
                            }
                            MenuScroller.setScrollerFor(addp, s, 150, 0, 0);
                            popup.add(addp);
                            JMenu addp2 = new JMenu("Hide component");
                            i = 0;
                            for (String spName : GroupLayoutContainer.this.subPanelList()) {
                                final ConsolePanel comp3 = GroupLayoutContainer.this.getSubPanelByName(spName);
                                boolean hidden = false;
                                try {
                                    ConsolePanel ssp = comp3;
                                    hidden = !ssp.getVisibility();
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                                JMenuItem cjmi = new JMenuItem(new AbstractAction("(" + i++ + ") " + spName + (hidden ? " (hidden)" : "")){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        GroupLayoutContainer.this.setComponentLayoutVisibility(false, new Component[]{comp3});
                                    }
                                });
                                if (hidden) {
                                    cjmi.setEnabled(false);
                                }
                                cjmi.setIcon(ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(comp3.getClass()), 16, 16));
                                addp2.add(cjmi);
                            }
                            MenuScroller.setScrollerFor(addp2, s, 150, 0, 0);
                            popup.add(addp2);
                            popup.add(new JMenuItem(new AbstractAction("Restore"){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    if ("".equalsIgnoreCase(GroupLayoutContainer.this.defaultProfile)) {
                                        GroupLayoutContainer.this.restoreComponentsLayoutVisibility();
                                    } else {
                                        GroupLayoutContainer.this.setActiveProfile(GroupLayoutContainer.this.defaultProfile);
                                    }
                                }
                            }));
                        }
                        if (popup.getComponentCount() != 0 && GroupLayoutContainer.this.profilesList.size() > 0) {
                            popup.addSeparator();
                            JMenu addProfile = new JMenu("Activate Profile");
                            if (!GroupLayoutContainer.this.showOnlyProfilesToUser) {
                                JCheckBoxMenuItem defProf = new JCheckBoxMenuItem(new AbstractAction(GroupLayoutContainer.NONE_PROFILE_STRING){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        GroupLayoutContainer.this.setActiveProfile("");
                                    }
                                });
                                if ("".equalsIgnoreCase(GroupLayoutContainer.this.activeProfile)) {
                                    defProf.setSelected(true);
                                }
                                addProfile.add(defProf);
                            }
                            Iterator<String> i$ = GroupLayoutContainer.this.profilesList.keySet().iterator();
                            while (i$.hasNext()) {
                                String pName;
                                final String name = pName = i$.next();
                                JCheckBoxMenuItem cjmi = new JCheckBoxMenuItem(new AbstractAction(name){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        GroupLayoutContainer.this.setActiveProfile(name);
                                    }
                                });
                                if (name.equalsIgnoreCase(GroupLayoutContainer.this.activeProfile)) {
                                    cjmi.setSelected(true);
                                }
                                addProfile.add(cjmi);
                            }
                            popup.add(addProfile);
                            JMenu setDefaultProfile = new JMenu("Set Default Profile");
                            if (!GroupLayoutContainer.this.showOnlyProfilesToUser) {
                                JCheckBoxMenuItem defProf = new JCheckBoxMenuItem(new AbstractAction(GroupLayoutContainer.NONE_PROFILE_STRING){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        GroupLayoutContainer.this.defaultProfile = "";
                                        GroupLayoutContainer.this.changeDefaultProfileInXml();
                                    }
                                });
                                if ("".equalsIgnoreCase(GroupLayoutContainer.this.defaultProfile)) {
                                    defProf.setSelected(true);
                                }
                                setDefaultProfile.add(defProf);
                            }
                            Iterator<String> i$2 = GroupLayoutContainer.this.profilesList.keySet().iterator();
                            while (i$2.hasNext()) {
                                String pName;
                                final String name = pName = i$2.next();
                                JCheckBoxMenuItem cjmi = new JCheckBoxMenuItem(new AbstractAction(name){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        GroupLayoutContainer.this.defaultProfile = name;
                                        GroupLayoutContainer.this.changeDefaultProfileInXml();
                                    }
                                });
                                if (name.equalsIgnoreCase(GroupLayoutContainer.this.defaultProfile)) {
                                    cjmi.setSelected(true);
                                }
                                setDefaultProfile.add(cjmi);
                            }
                            popup.add(setDefaultProfile);
                        }
                        if (popup.getComponentCount() != 0) {
                            popup.addSeparator();
                        }
                        popup.add(new JMenuItem(new AbstractAction("Maximize container"){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                GroupLayoutContainer.this.setMaximizePanel(true);
                            }
                        }));
                        popup.add(new JMenuItem(new AbstractAction("Restore container"){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                GroupLayoutContainer.this.setMaximizePanel(false);
                            }
                        }));
                        popup.show(e.getComponent(), e.getX(), e.getY());
                        GroupLayoutContainer.this.requestFocusInWindow();
                    }
                    if (GroupLayoutContainer.this.getParent() != null) {
                        for (MouseListener ml : GroupLayoutContainer.this.getParent().getMouseListeners()) {
                            ml.mouseClicked(e);
                        }
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (GroupLayoutContainer.this.getParent() != null) {
                        for (MouseListener ml : GroupLayoutContainer.this.getParent().getMouseListeners()) {
                            ml.mouseReleased(e);
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (GroupLayoutContainer.this.getParent() != null) {
                        for (MouseListener ml : GroupLayoutContainer.this.getParent().getMouseListeners()) {
                            ml.mousePressed(e);
                        }
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (GroupLayoutContainer.this.getParent() != null) {
                        for (MouseListener ml : GroupLayoutContainer.this.getParent().getMouseListeners()) {
                            ml.mouseExited(e);
                        }
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (GroupLayoutContainer.this.getParent() != null) {
                        for (MouseListener ml : GroupLayoutContainer.this.getParent().getMouseListeners()) {
                            ml.mouseEntered(e);
                        }
                    }
                }
            };
        }
        return this.mouseListener;
    }

    @Override
    public String getActiveProfile() {
        return this.activeProfile;
    }

    @Override
    public boolean setActiveProfile(String name) {
        if (name == null || "".equalsIgnoreCase(name)) {
            this.restoreComponentsLayoutVisibility();
            boolean resetLayout = false;
            if (!"".equalsIgnoreCase(this.activeProfile)) {
                resetLayout = true;
            }
            this.activeProfile = "";
            this.propagateActiveProfileChange(name);
            if (resetLayout) {
                try {
                    this.applyLayout(this.horizontalGroup, this.verticalGroup, this.linkSizeHorizontal, this.linkSizeVertical, false);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
            this.invalidate();
            this.repaint();
            return true;
        }
        try {
            String profile = this.profilesList.get(name);
            if (profile == null) {
                return false;
            }
            boolean resetLayout = true;
            String[] plst = profile.split("[,]+");
            boolean exclude = false;
            if (plst.length <= 1 || "-".equalsIgnoreCase(plst[0].trim())) {
                exclude = true;
            }
            Vector<ConsolePanel> components = new Vector<ConsolePanel>();
            for (int i = 1; i < plst.length; ++i) {
                int id = -1;
                try {
                    id = Integer.parseInt(plst[i].trim());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ConsolePanel comp = id >= 0 ? (ConsolePanel)this.panels.get(id) : this.getSubPanelByName(plst[i].trim());
                components.add(comp);
            }
            boolean aVi = exclude;
            this.setComponentLayoutVisibility(aVi);
            this.setComponentLayoutVisibility(!aVi, components.toArray(new Component[components.size()]));
            this.activeProfile = name;
            this.propagateActiveProfileChange(name);
            if (resetLayout) {
                LayoutHolder profileLayout = this.profilesLayouts.get(name);
                if (profileLayout == null) {
                    this.applyLayout(this.horizontalGroup, this.verticalGroup, this.linkSizeHorizontal, this.linkSizeVertical, false);
                } else {
                    this.applyLayout(profileLayout.horizontalGroup, profileLayout.verticalGroup, profileLayout.linkSizeHorizontal, profileLayout.linkSizeVertical, false);
                }
            }
            this.invalidate();
            this.repaint();
            return true;
        }
        catch (Exception e) {
            this.invalidate();
            this.repaint();
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String[] listProfileNames() {
        return this.profilesList.keySet().toArray(new String[0]);
    }

    private void propagateActiveProfileChange(String profileName) {
        for (Component cp : this.panels) {
            if (!(cp instanceof LayoutProfileProvider)) continue;
            ((LayoutProfileProvider)((Object)cp)).setActiveProfile(profileName);
        }
    }

    public boolean resetActiveProfile() {
        return this.setActiveProfile("");
    }

    private void restoreComponentsLayoutVisibility() {
        this.setComponentLayoutVisibility(true);
    }

    private void setComponentLayoutVisibility(boolean visible) {
        this.setComponentLayoutVisibility(visible, this.panels.toArray(new Component[this.panels.size()]));
    }

    private void setComponentLayoutVisibility(boolean visible, Component ... components) {
        block2: for (Component comp : components) {
            for (Component cp : this.panels) {
                if (!cp.equals(comp)) continue;
                try {
                    ConsolePanel ssp = (ConsolePanel)cp;
                    if (visible && ssp.getVisibility()) {
                        cp.setVisible(visible);
                        continue block2;
                    }
                    cp.setVisible(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    cp.setVisible(visible);
                }
                continue block2;
            }
        }
        this.repaint();
    }

    @Override
    public boolean supportsMaximizePanelOnContainer() {
        return true;
    }

    @Override
    public boolean maximizePanelOnContainer(Component comp) {
        boolean ret = true;
        if (comp != null && this.panels.contains(comp)) {
            this.setComponentLayoutVisibility(false);
            this.setComponentLayoutVisibility(true, comp);
        } else {
            if (comp != null) {
                ret = false;
            }
            if ("".equalsIgnoreCase(this.defaultProfile)) {
                this.restoreComponentsLayoutVisibility();
            } else {
                ret = ret && this.setActiveProfile(this.defaultProfile);
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        String profToChange = "<Default  profile= '\"teste\ndd' />\n<Profile />";
        profToChange = "<Default  profile=\"New Plan 'Control\" /><Profile name=\"New Plan Control\" exclude=\"true\"><Component id=\"Mission Elements\"/><Component id=\"ImcMissionStatePanel\"/></Profile><Profile name=\"Old Plan Control\" exclude=\"true\"><Component id=\"Plan Control\"/><Component id=\"Plan Control State\"/></Profile><Profile name=\"No GPS\" exclude=\"true\"><Component id=\"GPS Device Panel\"/><Component id=\"FindVehicle\"/></Profile>";
        Pattern pat = Pattern.compile("^<Default\\s+profile=\\s*(\"((.|\\s)+?)\"|'((.|\\s)+?)')\\s*/>");
        Matcher m = pat.matcher(profToChange);
        m.find();
        NeptusLog.pub().info((Object)("<###> " + m.groupCount()));
        NeptusLog.pub().info((Object)("<###> " + m.group(2) + "    " + m.group(4)));
        NeptusLog.pub().info((Object)("<###> " + m.replaceFirst("<Default profile=\"def\" />")));
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            SchemaFactory sm = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            File sFx = StreamUtil.copyStreamToTempFile(GroupLayoutContainer.class.getResourceAsStream(GROUP_LAYOUT_SCHEMA));
            Schema schema = sm.newSchema(sFx);
            dbf.setSchema(schema);
            dbf.setValidating(false);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<HorizontalGroup></HorizontalGroup>".getBytes());
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    System.err.println("WARNING: " + exception.getMessage());
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    System.err.println("ERROR: " + exception.getMessage());
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    System.err.println("FATAL: " + exception.getMessage());
                }
            });
            NeptusLog.pub().info((Object)("<###> " + ReflectionUtil.class.getPackage().getName()));
            validator.validate(new StreamSource(bais));
            bais.reset();
            Document docHG = builder.parse(bais);
            FileInputStream fis = new FileInputStream("./ConsoleGroupLayout-test.xml");
            validator.validate(new StreamSource(fis));
            FileInputStream fis1 = new FileInputStream("./ConsoleGroupLayout-test2.xml");
            validator.validate(new StreamSource(fis1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class LayoutHolder {
        String horizontalGroup = "";
        String verticalGroup = "";
        String linkSizeHorizontal = "";
        String linkSizeVertical = "";

        private LayoutHolder() {
        }
    }
}

