/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.containers;

import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ContainerSubPanel;
import pt.lsts.neptus.console.plugins.containers.LayoutProfileProvider;
import pt.lsts.neptus.console.plugins.containers.propeditor.MiGLayoutXmlPropertyEditor;
import pt.lsts.neptus.events.NeptusEventLayoutChanged;
import pt.lsts.neptus.events.NeptusEvents;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription(author="Jos\u00e9 Quadrado", version="1.0.0", name="Console Layout: MigLayout", description="This container uses MigLayout manager", icon="pt/lsts/neptus/plugins/containers/layout.png", category=PluginDescription.CATEGORY.INTERFACE)
public class MigLayoutContainer
extends ContainerSubPanel
implements ConfigurationListener,
LayoutProfileProvider {
    @NeptusProperty(name="XML Definitions", description="XML layout definition", editorClass=MiGLayoutXmlPropertyEditor.class, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public String xmlDef = "";
    @NeptusProperty(name="Current Profile", description="Name of the current active profile", distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public String currentProfile = "";
    private final ArrayList<String> profileList = new ArrayList();
    private JMenu profilesMenu;

    public MigLayoutContainer(ConsoleLayout console) {
        super(console);
        NeptusEvents.register(this);
        this.setLayout((LayoutManager)new MigLayout("ins 0"));
    }

    @Override
    public void init() {
        this.loadProfiles();
        if (this.profileList.size() >= 1 && this.currentProfile.equals("")) {
            this.changeProfile(this.profileList.get(0));
            this.applyLayout(this.xmlDef);
        } else {
            this.changeProfile(this.currentProfile);
            this.applyLayout(this.xmlDef);
        }
        super.init();
    }

    private void loadProfiles() {
        this.removeAll();
        if (this.xmlDef.isEmpty()) {
            return;
        }
        SAXReader reader = new SAXReader();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(this.xmlDef));
        this.profileList.clear();
        try {
            Document doc = reader.read(is);
            Element root = doc.getRootElement();
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                if (!e.getQualifiedName().equals("profile")) continue;
                String profileName = e.attributeValue("name");
                this.profileList.add(profileName);
            }
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)"mig container loading profiles", (Throwable)e);
        }
        this.removeProfilesMenu();
        this.profilesMenu = this.getConsole().getOrCreateJMenu(new String[]{I18n.text("Profiles")});
        for (final String name : this.profileList) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(new AbstractAction(I18n.text(name)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MigLayoutContainer.this.changeProfile(name);
                    MigLayoutContainer.this.applyLayout(MigLayoutContainer.this.xmlDef);
                }
            });
            this.profilesMenu.add(item);
        }
    }

    public void changeProfile(String profileName) {
        this.currentProfile = profileName;
        for (int i = 0; i < this.profilesMenu.getItemCount(); ++i) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)this.profilesMenu.getItem(i);
            item.setSelected(item.getText().equals(profileName));
        }
        this.propagateActiveProfileChange(profileName);
    }

    private void propagateActiveProfileChange(String profileName) {
        for (Component cp : this.panels) {
            if (!(cp instanceof LayoutProfileProvider)) continue;
            ((LayoutProfileProvider)((Object)cp)).setActiveProfile(profileName);
        }
    }

    private void removeProfilesMenu() {
        if (this.profilesMenu != null) {
            this.profilesMenu.getParent().remove(this.profilesMenu);
            this.profilesMenu = null;
        }
    }

    @Override
    public void propertiesChanged() {
        if (this.panels.size() > 0) {
            this.loadProfiles();
            this.changeProfile(this.currentProfile);
            this.applyLayout(this.xmlDef);
        }
    }

    @Subscribe
    public void consume(NeptusEventLayoutChanged e) {
        this.applyLayout(e.getLayout());
    }

    public void applyLayout(String xml) {
        this.removeAll();
        if (xml.isEmpty()) {
            return;
        }
        SAXReader reader = new SAXReader();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        try {
            Document doc = reader.read(is);
            List nodes = doc.selectNodes("//profiles/profile");
            for (Node node : nodes) {
                if (!node.valueOf("@name").equals(this.currentProfile)) continue;
                NeptusLog.pub().debug((Object)("Loaded profile " + node.valueOf("@name")));
                this.parse(node, this);
            }
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)"reading inner xml", (Throwable)e);
        }
        this.getConsole().revalidate();
        this.getConsole().repaint();
    }

    public ConsolePanel parse(Node node, JComponent parent) {
        Element e = (Element)node;
        if (!node.hasContent()) {
            return null;
        }
        List elements = e.elements();
        for (Element element : elements) {
            if ("container".equals(element.getName())) {
                String type;
                String layoutparam = element.attributeValue("layoutparam");
                String colparam = element.attributeValue("colparam");
                String rowparam = element.attributeValue("rowparam");
                String addParam = element.attributeValue("param");
                String string = type = element.attributeValue("type") == null ? "" : element.attributeValue("type");
                if ("tabcontainer".equals(type)) {
                    JTabbedPane tabbedPane = new JTabbedPane();
                    parent.add((Component)tabbedPane, addParam);
                    this.parse((Node)element, tabbedPane);
                } else {
                    ConsolePanel container = new ConsolePanel(this.getConsole()){
                        private static final long serialVersionUID = 8543725153078587308L;

                        @Override
                        public void cleanSubPanel() {
                        }

                        @Override
                        public void initSubPanel() {
                        }
                    };
                    container.setLayout((LayoutManager)new MigLayout(layoutparam, colparam, rowparam));
                    parent.add((Component)container, addParam);
                    this.parse((Node)element, container);
                }
            }
            if ("child".equals(element.getName())) {
                String name = element.attributeValue("name");
                String param = element.attributeValue("param");
                ConsolePanel child = this.getSubPanelByName(name);
                if (child != null) {
                    parent.add((Component)child, param);
                }
            }
            if (!"tab".equals(element.getName())) continue;
            JTabbedPane tabsPane = (JTabbedPane)parent;
            String name = element.attributeValue("tabname");
            String layoutparam = element.attributeValue("layoutparam");
            String colparam = element.attributeValue("colparam");
            String rowparam = element.attributeValue("rowparam");
            JPanel tab = new JPanel();
            tab.setLayout((LayoutManager)new MigLayout(layoutparam, colparam, rowparam));
            tabsPane.addTab(name, null, tab, name);
            this.parse((Node)element, tab);
        }
        return null;
    }

    @Override
    public void addSubPanel(ConsolePanel panel) {
        this.panels.add(panel);
    }

    @Override
    public void removeSubPanel(ConsolePanel sp) {
        this.panels.remove(sp);
        this.remove(sp);
        this.applyLayout(this.xmlDef);
        sp.clean();
    }

    @Override
    public void clean() {
        super.clean();
        this.removeProfilesMenu();
    }

    @Override
    public String getActiveProfile() {
        return this.currentProfile;
    }

    @Override
    public boolean setActiveProfile(String name) {
        if (!this.profileList.contains(name)) {
            return false;
        }
        this.changeProfile(name);
        this.applyLayout(this.xmlDef);
        return true;
    }

    @Override
    public String[] listProfileNames() {
        return this.profileList.toArray(new String[0]);
    }

    @Override
    public boolean supportsMaximizePanelOnContainer() {
        return false;
    }

    @Override
    public boolean maximizePanelOnContainer(Component comp) {
        return false;
    }
}

