/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.containers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ContainerSubPanel;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription(name="Console Layout: Split", description="Allows to add 2 components with a flexible split bar", icon="pt/lsts/neptus/plugins/containers/layout.png")
public class SplitContainer
extends ContainerSubPanel
implements ConfigurationListener {
    boolean addedLeftComponent = false;
    @NeptusProperty(name="Split orientation", description="The split bar's orientation", distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public SplitTypeEnum splitType = SplitTypeEnum.Horizontal;
    @NeptusProperty(editable=false)
    public int splitLocation = 100;
    private JSplitPane splitPane = new JSplitPane();
    private JComponent pivot = null;

    public SplitContainer(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout());
        this.pivot = this.splitPane;
        this.splitPane.setOrientation(this.splitType == SplitTypeEnum.Horizontal ? 1 : 0);
        this.splitPane.setOneTouchExpandable(true);
        BasicSplitPaneUI paneUi = (BasicSplitPaneUI)this.splitPane.getUI();
        paneUi.getDivider().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SplitContainer.this.splitLocation = SplitContainer.this.splitPane.getDividerLocation();
            }
        });
        this.add((Component)this.pivot, "Center");
    }

    @Override
    public void addSubPanel(ConsolePanel panel) {
        panel.setBorder(BorderFactory.createEmptyBorder());
        this.panels.add(panel);
        if (!this.addedLeftComponent) {
            this.addedLeftComponent = true;
            this.splitPane.setLeftComponent(panel);
        } else {
            this.splitPane.setRightComponent(panel);
        }
    }

    @Override
    public void propertiesChanged() {
        this.splitPane.setOrientation(this.splitType == SplitTypeEnum.Horizontal ? 1 : 0);
        this.splitPane.setDividerLocation(this.splitLocation);
    }

    public static enum SplitTypeEnum {
        Vertical,
        Horizontal;

    }
}

