/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.containers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dom4j.Element;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ContainerSubPanel;
import pt.lsts.neptus.console.plugins.AlarmProviderOld;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;

@PluginDescription(name="Console Layout: Tabbed", description="Allows to add various tabs to the console", icon="pt/lsts/neptus/plugins/containers/layout.png")
public class TabContainer
extends ContainerSubPanel
implements ConfigurationListener,
IPeriodicUpdates {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Tab names", description="The name to be displayed in the tabs, separated by commas", distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public String tabNames = "1,2,3,4,5,6,7,8,9";
    private LinkedHashMap<ConsolePanel, ArrayList<AlarmProviderOld>> subPanelList = new LinkedHashMap();
    @NeptusProperty(name="Tab placement", description="Where to place the tabs")
    public PlacementEnum tabPlacement = PlacementEnum.Top;
    @NeptusProperty
    public int selectedIndex = 0;
    @NeptusProperty
    public String name = "";
    private JComponent pivot = null;
    protected boolean destroyed = false;

    public ConsolePanel getSelectedSubPanel() {
        try {
            return (ConsolePanel)this.pivot.getComponent(((JTabbedPane)this.pivot).getSelectedIndex());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TabContainer(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout());
        this.pivot = new JTabbedPane();
        ((JTabbedPane)this.pivot).addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                JTabbedPane tp = (JTabbedPane)arg0.getSource();
                tp.setForegroundAt(tp.getSelectedIndex(), Color.BLACK);
            }
        });
        this.add((Component)this.pivot, "Center");
        switch (this.tabPlacement) {
            case Top: {
                ((JTabbedPane)this.pivot).setTabPlacement(1);
                break;
            }
            case Bottom: {
                ((JTabbedPane)this.pivot).setTabPlacement(3);
                break;
            }
            case Left: {
                ((JTabbedPane)this.pivot).setTabPlacement(2);
                break;
            }
            case Right: {
                ((JTabbedPane)this.pivot).setTabPlacement(4);
                break;
            }
        }
        PeriodicUpdatesService.register(this);
    }

    public void setTabNames() {
        String[] names = this.tabNames.split(",");
        if (names.length >= ((JTabbedPane)this.pivot).getTabCount()) {
            for (int i = 0; i < ((JTabbedPane)this.pivot).getTabCount(); ++i) {
                ((JTabbedPane)this.pivot).setTitleAt(i, names[i]);
            }
        }
    }

    @Override
    public void addSubPanel(ConsolePanel panel) {
        super.addSubPanel(panel);
        ArrayList<AlarmProviderOld> l = new ArrayList<AlarmProviderOld>();
        for (Component c : panel.getComponents()) {
            if (!(c instanceof AlarmProviderOld)) continue;
            l.add((AlarmProviderOld)((Object)c));
        }
        this.subPanelList.put(panel, l);
        this.setTabNames();
    }

    @Override
    public void XML_ChildsRead(Element el) {
        super.XML_ChildsRead(el);
        ((JTabbedPane)this.pivot).addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TabContainer.this.selectedIndex = ((JTabbedPane)TabContainer.this.pivot).getSelectedIndex();
            }
        });
        ((JTabbedPane)this.pivot).setSelectedIndex(this.selectedIndex);
    }

    @Override
    public void propertiesChanged() {
        this.setTabNames();
        switch (this.tabPlacement) {
            case Top: {
                ((JTabbedPane)this.pivot).setTabPlacement(1);
                break;
            }
            case Bottom: {
                ((JTabbedPane)this.pivot).setTabPlacement(3);
                break;
            }
            case Left: {
                ((JTabbedPane)this.pivot).setTabPlacement(2);
                break;
            }
            case Right: {
                ((JTabbedPane)this.pivot).setTabPlacement(4);
                break;
            }
        }
    }

    @Override
    public long millisBetweenUpdates() {
        return 1000L;
    }

    @Override
    public boolean update() {
        JTabbedPane tp = (JTabbedPane)this.pivot;
        int size = tp.getTabCount();
        for (int i = 0; i < size; ++i) {
            Component jc = tp.getComponentAt(i);
            if (this.subPanelList.get(jc).size() == 0) continue;
            for (AlarmProviderOld ap : this.subPanelList.get(jc)) {
                if (ap.getAlarmState() <= 0 || i == tp.getSelectedIndex()) continue;
                tp.setForegroundAt(i, Color.RED);
            }
        }
        return !this.destroyed;
    }

    @Override
    public void clean() {
        super.clean();
        PeriodicUpdatesService.unregister(this);
        this.destroyed = true;
    }

    public static enum PlacementEnum {
        Left,
        Right,
        Top,
        Bottom;

    }
}

