/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.containers.propeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.events.NeptusEventLayoutChanged;
import pt.lsts.neptus.events.NeptusEvents;
import pt.lsts.neptus.fileeditor.SyntaxDocument;
import pt.lsts.neptus.gui.editor.XMLPropertyEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.XMLUtil;

public class MiGLayoutXmlPropertyEditor
extends XMLPropertyEditor {
    public MiGLayoutXmlPropertyEditor() {
        this.rootElement = "MiGLayout Layout XML";
        this.title = I18n.text("Layout for: MiGLayout Layout XML");
        this.smallMsg = I18n.text("This follows the MiGLayout");
        this.contentType = "text/html";
        this.helpText = "<html>";
    }

    @Override
    protected void buildUI() {
        this.dialog = new JDialog(SwingUtilities.getWindowAncestor(this.editor));
        this.dialog.setTitle(this.title);
        this.dialog.setSize(800, 600);
        this.dialog.setLayout(new BorderLayout());
        GuiUtils.centerOnScreen(this.dialog);
        this.dialog.setResizable(true);
        final String oldXmlStr = this.xmlStr;
        final JEditorPane editorPane = SyntaxDocument.getXmlEditorPane();
        JScrollPane editorScrollPane = new JScrollPane();
        editorScrollPane.setViewportView(editorPane);
        editorScrollPane.setVisible(true);
        try {
            if (!"".equalsIgnoreCase(this.xmlStr)) {
                this.xmlStr = XMLUtil.getAsCompactFormatedXMLString(this.xmlStr);
                this.xmlStr = XMLUtil.getAsPrettyPrintFormatedXMLString(this.xmlStr);
            }
        }
        catch (Exception e1) {
            this.xmlStr = oldXmlStr;
        }
        editorPane.setText(this.xmlStr.trim());
        JScrollPane helpScrollPane = new JScrollPane();
        JEditorPane help = new JEditorPane();
        help.setEditable(false);
        help.setContentType(this.contentType);
        help.setBackground(new Color(255, 255, 160));
        help.setText(this.helpText);
        help.setCaretPosition(0);
        helpScrollPane.setViewportView(help);
        helpScrollPane.setVisible(true);
        JSplitPane splitPane = new JSplitPane(1, editorScrollPane, helpScrollPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation((int)((double)this.dialog.getWidth() * 0.7));
        this.dialog.add((Component)splitPane, "Center");
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        GroupLayout layout = new GroupLayout(buttons);
        buttons.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JButton testButton = new JButton(I18n.text("Test"));
        testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String tmpStr = editorPane.getText();
                NeptusEvents.post(new NeptusEventLayoutChanged(tmpStr));
            }
        });
        JButton okButton = new JButton(I18n.text("Ok"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String tmpStr = editorPane.getText();
                NeptusEvents.post(new NeptusEventLayoutChanged(tmpStr));
                MiGLayoutXmlPropertyEditor.this.setValue(tmpStr);
                MiGLayoutXmlPropertyEditor.this.dialog.setVisible(false);
                MiGLayoutXmlPropertyEditor.this.dialog.dispose();
            }
        });
        JButton cancelButton = new JButton(I18n.text("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NeptusEvents.post(new NeptusEventLayoutChanged(oldXmlStr));
                MiGLayoutXmlPropertyEditor.this.setValue(oldXmlStr);
                MiGLayoutXmlPropertyEditor.this.dialog.setVisible(false);
                MiGLayoutXmlPropertyEditor.this.dialog.dispose();
            }
        });
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(testButton).addComponent(okButton).addComponent(cancelButton));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(testButton).addComponent(okButton).addComponent(cancelButton));
        toolbar.add((Component)buttons, "East");
        this.dialog.add((Component)toolbar, "South");
    }
}

