/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.SystemsList;
import pt.lsts.neptus.console.plugins.planning.CoverageCell;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.templates.PlanCreator;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@LayerPriority(priority=50)
@PluginDescription(name="Polygon Coverage Planner", icon="images/planning/polyline.png")
public class AreaCoveragePlanner
extends ConsolePanel
implements StateRendererInteraction,
IEditorMenuExtension,
Renderer2DPainter {
    @NeptusProperty(name="Depth")
    public double depth = 1.0;
    @NeptusProperty(name="Grid width")
    public double grid = 20.0;
    protected InteractionAdapter adapter;
    private boolean initCalled = false;
    PathElement pe = null;
    int vertexCount = 0;

    public AreaCoveragePlanner(ConsoleLayout console) {
        super(console);
        this.adapter = new InteractionAdapter(console);
        this.setVisibility(false);
    }

    @Override
    public void initSubPanel() {
        if (this.initCalled) {
            return;
        }
        this.initCalled = true;
        this.addMenuItem(I18n.text("Settings") + ">" + I18n.text("Coverage Planner Settings"), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)AreaCoveragePlanner.this, AreaCoveragePlanner.this.getConsole(), true);
            }
        });
    }

    @Override
    public void paint(Graphics2D g2, StateRenderer2D renderer) {
        if (this.pe != null) {
            Graphics2D g = (Graphics2D)g2.create();
            this.pe.paint(g, renderer, -renderer.getRotation());
            g.dispose();
        }
    }

    @Override
    public Collection<JMenuItem> getApplicableItems(LocationType loc, IMapPopup source) {
        JMenu menu = new JMenu("Polygon coverage");
        final LocationType l = loc;
        menu.add(new AbstractAction("Add polygon vertex"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (AreaCoveragePlanner.this.pe == null) {
                    AreaCoveragePlanner.this.pe = new PathElement(MapGroup.getMapGroupInstance(AreaCoveragePlanner.this.getConsole().getMission()), new MapType(), l);
                    AreaCoveragePlanner.this.pe.setMyColor(Color.green.brighter());
                    AreaCoveragePlanner.this.pe.setShape(true);
                    AreaCoveragePlanner.this.pe.setFinished(true);
                    AreaCoveragePlanner.this.pe.setStroke(new BasicStroke(2.0f));
                    AreaCoveragePlanner.this.pe.addPoint(0.0, 0.0, 0.0, false);
                } else {
                    double[] offsets = l.getOffsetFrom(AreaCoveragePlanner.this.pe.getCenterLocation());
                    AreaCoveragePlanner.this.pe.addPoint(offsets[1], -offsets[0], 0.0, false);
                }
                ++AreaCoveragePlanner.this.vertexCount;
            }
        });
        if (this.vertexCount > 0) {
            menu.add(new AbstractAction("Clear"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AreaCoveragePlanner.this.pe = null;
                    AreaCoveragePlanner.this.vertexCount = 0;
                }
            });
        }
        if (this.vertexCount > 2) {
            menu.add(new AbstractAction("Generate plan(s)"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AreaCoveragePlanner.this.solve();
                }
            });
        }
        Vector<JMenuItem> items = new Vector<JMenuItem>();
        items.add(menu);
        return items;
    }

    private void solve() {
        int j;
        int i;
        if (this.pe == null) {
            GuiUtils.errorMessage(this.getConsole(), "Coverage Plan Solver", "The polygon is not valid");
            return;
        }
        double[] bounds = this.pe.getBounds3d();
        double south = bounds[0];
        double west = bounds[4];
        double north = bounds[1];
        double east = bounds[5];
        CoverageCell[][] cells = new CoverageCell[(int)((north - south) / this.grid) + 1][(int)((east - west) / this.grid) + 1];
        for (i = 0; i < cells.length; ++i) {
            for (j = 0; j < cells[i].length; ++j) {
                cells[i][j] = new CoverageCell();
                cells[i][j].i = i;
                cells[i][j].j = j;
            }
        }
        i = 0;
        j = 0;
        int desiredCells = 0;
        for (double n = south + this.grid / 2.0; n < north; n += this.grid) {
            j = 0;
            for (double e = west + this.grid / 2.0; e < east; e += this.grid) {
                LocationType lt = new LocationType(this.pe.getCenterLocation());
                lt.translatePosition(n, e, 0.0);
                CoverageCell cell = cells[i][j];
                cell.realWorldLoc = lt.getNewAbsoluteLatLonDepth();
                if (this.pe.containsPoint(lt, null)) {
                    cell.desired = true;
                    ++desiredCells;
                }
                cells[i][j] = cell;
                ++j;
            }
            ++i;
        }
        CoverageCell initialCell = null;
        i = 0;
        for (j = 0; j < cells[0].length - 1 && initialCell == null; ++j) {
            for (i = 0; i < cells.length && initialCell == null; ++i) {
                if (!cells[i][j].desired) continue;
                initialCell = cells[i][j];
            }
        }
        if (initialCell == null) {
            GuiUtils.errorMessage("Polygon coverage", "Polygon area is invalid");
            return;
        }
        CoverageCell current = initialCell;
        --desiredCells;
        int dir = -1;
        while (desiredCells > 0) {
            current.visited = true;
            current.active = false;
            if (dir == 1) {
                if (current.i < cells.length - 1 && cells[current.i + 1][current.j].desired && !cells[current.i + 1][current.j].visited) {
                    current.next = cells[current.i + 1][current.j];
                    cells[current.i + 1][current.j].previous = current;
                    current = current.next;
                    current.active = true;
                } else {
                    dir = -1;
                    if (current.j == cells[0].length - 1) break;
                    while (!cells[current.i][current.j + 1].desired && i > 0 && current.previous != null) {
                        current.active = false;
                        current = current.previous;
                    }
                    if (i == 0) break;
                    current.next = cells[current.i][current.j + 1];
                    cells[current.i][current.j + 1].previous = current;
                    current = current.next;
                    current.active = true;
                }
            } else if (current.i > 0 && cells[current.i - 1][current.j].desired && !cells[current.i - 1][current.j].visited) {
                current.next = cells[current.i - 1][current.j];
                cells[current.i - 1][current.j].previous = current;
                current = current.next;
                current.active = true;
            } else {
                dir = 1;
                if (current.j == cells[0].length - 1) break;
                while (current.previous != null && !cells[current.i][current.j + 1].desired && i < cells.length) {
                    current.active = false;
                    current = current.previous;
                }
                if (i == cells.length) break;
                current.next = cells[current.i][current.j + 1];
                cells[current.i][current.j + 1].previous = current;
                current = current.next;
                current.active = true;
            }
            --desiredCells;
        }
        this.generatePlans(cells, initialCell);
    }

    void generatePlans(CoverageCell[][] mat, CoverageCell first) {
        Vector<String> selectedVehicles = new Vector<String>();
        Vector<SystemsList> tmp = this.getConsole().getSubPanelsOfClass(SystemsList.class);
        selectedVehicles.addAll(tmp.get(0).getSelectedSystems(true));
        String planid = selectedVehicles.size() > 1 ? JOptionPane.showInputDialog(this.getConsole(), (Object)"Enter desired plan prefix") : JOptionPane.showInputDialog(this.getConsole(), (Object)"Enter desired plan name");
        MissionType mission = this.getConsole().getMission();
        if (mission == null) {
            GuiUtils.errorMessage(this.getConsole(), "Coverage Plan Solver", "No mission has been set");
            return;
        }
        if (selectedVehicles.size() <= 1) {
            CoverageCell current = first;
            CoverageCell next = current.next;
            PlanCreator creator = new PlanCreator(mission);
            creator.setLocation(first.realWorldLoc);
            while (next != null) {
                if (next.j != current.j) {
                    CoverageCell pivot = current;
                    while (pivot.previous != null && pivot.previous.i == current.i) {
                        pivot = pivot.previous;
                    }
                    creator.setLocation(pivot.realWorldLoc);
                    creator.addManeuver("Goto");
                    creator.setLocation(next.realWorldLoc);
                    creator.addManeuver("Goto");
                }
                current = next;
                next = current.next;
            }
            PlanType plan = creator.getPlan();
            plan.setId(planid.toString());
            plan.setVehicle(this.getConsole().getMainSystem());
            mission.addPlan(plan);
            mission.save(false);
            this.getConsole().updateMissionListeners();
        } else {
            PlanType plan;
            double distance = 0.0;
            CoverageCell current = first;
            CoverageCell next = current.next;
            distance += current.realWorldLoc.getDistanceInMeters(next.realWorldLoc);
            while (next != null) {
                if (next.j != current.j) {
                    CoverageCell pivot = current;
                    while (pivot.previous != null && pivot.previous.i == current.i) {
                        pivot = pivot.previous;
                    }
                }
                distance += current.realWorldLoc.getDistanceInMeters(next.realWorldLoc);
                current = next;
                next = current.next;
            }
            double distEach = distance / (double)selectedVehicles.size();
            current = first;
            next = current.next;
            PlanCreator creator = new PlanCreator(mission);
            creator.setLocation(current.realWorldLoc);
            distance = 0.0;
            int curIndex = 0;
            while (next != null) {
                if (next.j != current.j) {
                    CoverageCell pivot = current;
                    while (pivot.previous != null && pivot.previous.i == current.i) {
                        pivot = pivot.previous;
                    }
                    creator.setLocation(pivot.realWorldLoc);
                    creator.addManeuver("Goto");
                    distance += current.realWorldLoc.getDistanceInMeters(next.realWorldLoc);
                    if (distance < distEach) {
                        creator.setLocation(next.realWorldLoc);
                        creator.addManeuver("Goto");
                    }
                } else {
                    distance += current.realWorldLoc.getDistanceInMeters(next.realWorldLoc);
                }
                if (distance > distEach) {
                    creator.setLocation(current.realWorldLoc);
                    creator.addManeuver("Goto");
                    plan = creator.getPlan();
                    plan.setVehicle((String)selectedVehicles.get(curIndex));
                    plan.setId(planid + "_" + (String)selectedVehicles.get(curIndex++));
                    mission.addPlan(plan);
                    creator = new PlanCreator(mission);
                    creator.setLocation(current.realWorldLoc);
                    creator.addManeuver("Goto");
                    distance = 0.0;
                }
                current = next;
                next = current.next;
            }
            plan = creator.getPlan();
            plan.setVehicle((String)selectedVehicles.get(curIndex));
            plan.setId(planid + "_" + (String)selectedVehicles.get(curIndex++));
            mission.addPlan(plan);
            mission.save(false);
            this.getConsole().updateMissionListeners();
        }
    }

    void printMatrix(CoverageCell[][] mat) {
        for (int i = 0; i < mat.length; ++i) {
            for (int j = 0; j < mat[0].length; ++j) {
                if (mat[i][j] == null) continue;
                System.out.print(mat[i][j].rep());
            }
            System.out.println();
        }
    }

    @Override
    public Image getIconImage() {
        return ImageUtils.getImage(PluginUtils.getPluginIcon(this.getClass()));
    }

    @Override
    public Cursor getMouseCursor() {
        return this.adapter.getMouseCursor();
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyPressed(event, source);
    }

    @Override
    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyReleased(event, source);
    }

    @Override
    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyTyped(event, source);
    }

    @Override
    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            popup.add("Generate plans locally").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AreaCoveragePlanner.this.solve();
                }
            });
            popup.add("Clear polygon").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AreaCoveragePlanner.this.pe = null;
                    AreaCoveragePlanner.this.vertexCount = 0;
                }
            });
            popup.add("Settings").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PropertiesEditor.editProperties((PropertiesProvider)AreaCoveragePlanner.this, AreaCoveragePlanner.this.getConsole(), true);
                }
            });
            popup.show(source, event.getX(), event.getY());
        } else if (this.pe == null) {
            LocationType l = source.getRealWorldLocation(event.getPoint());
            this.pe = new PathElement(MapGroup.getMapGroupInstance(this.getConsole().getMission()), new MapType(), l);
            this.pe.setMyColor(Color.green.brighter());
            this.pe.setShape(true);
            this.pe.setFinished(true);
            this.pe.setStroke(new BasicStroke(2.0f));
            this.pe.addPoint(0.0, 0.0, 0.0, false);
            this.vertexCount = 1;
        } else {
            LocationType l = source.getRealWorldLocation(event.getPoint());
            double[] offsets = l.getOffsetFrom(this.pe.getCenterLocation());
            this.pe.addPoint(offsets[1], offsets[0], 0.0, false);
            ++this.vertexCount;
        }
    }

    @Override
    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseDragged(event, source);
    }

    @Override
    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseMoved(event, source);
    }

    @Override
    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        this.adapter.mousePressed(event, source);
    }

    @Override
    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseReleased(event, source);
    }

    @Override
    public void wheelMoved(MouseWheelEvent event, StateRenderer2D source) {
        this.adapter.wheelMoved(event, source);
    }

    @Override
    public void setActive(boolean mode, StateRenderer2D source) {
        this.adapter.setActive(mode, source);
    }

    @Override
    public void setAssociatedSwitch(ToolbarSwitch tswitch) {
    }

    @Override
    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
    }

    @Override
    public void mouseExited(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseExited(event, source);
    }

    @Override
    public void focusGained(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusGained(event, source);
    }

    @Override
    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusLost(event, source);
    }

    @Override
    public void cleanSubPanel() {
    }
}

