/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PlanControl;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCSendMessageUtils;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.mp.maneuvers.Loiter;
import pt.lsts.neptus.mp.maneuvers.StationKeeping;
import pt.lsts.neptus.mp.templates.PlanCreator;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;

@PluginDescription(name="Command Planner", author="zp, pdias", icon="pt/lsts/neptus/console/plugins/kenolaba.png", version="1.5", category=PluginDescription.CATEGORY.PLANNING)
public class CommandPlanner
extends ConsolePanel
implements IEditorMenuExtension,
NeptusMessageListener {
    private static final String PLAN_PREFIX = "";
    @NeptusProperty(name="AUV travelling depth", category="AUV", description="Use 0 for going at surface", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double auvDepth = 0.0;
    @NeptusProperty(name="AUV travelling speed", category="AUV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double auvSpeed = 1000.0;
    @NeptusProperty(name="AUV travelling speed units", category="AUV", editorClass=SpeedUnitsEditor.class, userLevel=NeptusProperty.LEVEL.REGULAR)
    public String auvSpeedUnits = I18n.text("RPM");
    @NeptusProperty(name="AUV loiter radius", category="AUV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double auvLoiterRadius = 20.0;
    @NeptusProperty(name="AUV Station Keeping radius", category="AUV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double auvSkRadius = 15.0;
    @NeptusProperty(name="UAV flying altitude", category="UAV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double uavAltitude = 200.0;
    @NeptusProperty(name="UAV flying speed", category="UAV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double uavSpeed = 18.0;
    @NeptusProperty(name="UAV flying speed units", category="UAV", editorClass=SpeedUnitsEditor.class, userLevel=NeptusProperty.LEVEL.REGULAR)
    public String uavSpeedUnits = I18n.text("m/s");
    @NeptusProperty(name="UAV loiter radius", category="UAV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double uavLoiterRadius = 180.0;
    @NeptusProperty(name="ASV speed", category="ASV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double asvSpeed = 1000.0;
    @NeptusProperty(name="ASV speed units", category="ASV", editorClass=SpeedUnitsEditor.class, userLevel=NeptusProperty.LEVEL.REGULAR)
    public String asvSpeedUnits = "RPM";
    @NeptusProperty(name="ASV Station Keeping radius", category="ASV", description="Radius of the circle where the ASV should keep its position", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double asvSkRadius = 20.0;
    @NeptusProperty(name="ASV loiter radius", category="ASV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double asvLoiterRadius = 30.0;
    private final HashMap<String, ImageIcon> vehIconPool = new HashMap();
    private final LinkedHashMap<Integer, Long> registerRequestIdsTime = new LinkedHashMap();
    private final String[] messagesToObserve = new String[]{"PlanControl"};

    public CommandPlanner(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
    }

    @Override
    public void initSubPanel() {
        Vector<IMapPopup> r = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        for (IMapPopup str2d : r) {
            str2d.addMenuExtension(this);
        }
    }

    @Override
    public void cleanSubPanel() {
        Vector<IMapPopup> r = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        for (IMapPopup str2d : r) {
            str2d.removeMenuExtension(this);
        }
    }

    @Override
    public String[] getObservedMessages() {
        return this.messagesToObserve;
    }

    @Override
    public Collection<JMenuItem> getApplicableItems(LocationType loc, IMapPopup source) {
        Vector<VehicleType> avVehicles = new Vector<VehicleType>();
        ImcSystem[] veh = ImcSystemsHolder.lookupActiveSystemVehicles();
        Arrays.sort(veh, new Comparator<ImcSystem>(){

            @Override
            public int compare(ImcSystem o1, ImcSystem o2) {
                if (o1.isWithAuthority() ^ o2.isWithAuthority()) {
                    return o1.isWithAuthority() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                }
                if (o1.getAuthorityState() != o2.getAuthorityState()) {
                    return o2.getAuthorityState().ordinal() - o1.getAuthorityState().ordinal();
                }
                return o1.compareTo(o2);
            }
        });
        for (int i = 0; i < veh.length; ++i) {
            VehicleType vehicle;
            if (veh[i].getAuthorityState().ordinal() < ImcSystem.IMCAuthorityState.SYSTEM_FULL.ordinal() || (vehicle = VehiclesHolder.getVehicleWithImc(veh[i].getId())) == null) continue;
            if (this.getConsole().getMainSystem() != null && this.getConsole().getMainSystem().equalsIgnoreCase(vehicle.getId())) {
                avVehicles.add(0, vehicle);
                continue;
            }
            avVehicles.add(vehicle);
        }
        if (this.getConsole().getMainSystem() != null && !avVehicles.contains(VehiclesHolder.getVehicleById(this.getConsole().getMainSystem()))) {
            avVehicles.add(0, VehiclesHolder.getVehicleById(this.getConsole().getMainSystem()));
        }
        Vector<JMenuItem> items = new Vector<JMenuItem>();
        final LocationType target = loc;
        for (final VehicleType v : avVehicles) {
            ImageIcon vicon;
            JMenu menu = new JMenu(I18n.textf("Command %vehicle", v.getId()));
            if (this.vehIconPool.containsKey(v.getId())) {
                vicon = this.vehIconPool.get(v.getId());
            } else {
                String imgFile = !v.getPresentationImageHref().equalsIgnoreCase(PLAN_PREFIX) ? v.getPresentationImageHref() : v.getSideImageHref();
                Image vimg = new ImageIcon(imgFile).getImage();
                vicon = new ImageIcon(vimg.getScaledInstance(40, -1, 4));
                this.vehIconPool.put(v.getId(), vicon);
            }
            menu.setIcon(vicon);
            boolean ok = false;
            if (v.getFeasibleManeuvers().containsValue(Goto.class.getName())) {
                menu.add(new AbstractAction(I18n.text("Go here")){

                    @Override
                    public void actionPerformed(final ActionEvent arg0) {
                        new Thread(){

                            @Override
                            public void run() {
                                double speed = 0.0;
                                double z = 0.0;
                                ManeuverLocation.Z_UNITS zunits = ManeuverLocation.Z_UNITS.NONE;
                                String speedUnit = "RPM";
                                PlanCreator creator = new PlanCreator(CommandPlanner.this.getConsole().getMission());
                                creator.setLocation(target);
                                if ("auv".equalsIgnoreCase(v.getType()) || "uuv".equalsIgnoreCase(v.getType())) {
                                    speed = CommandPlanner.this.auvSpeed;
                                    z = CommandPlanner.this.auvDepth;
                                    zunits = ManeuverLocation.Z_UNITS.DEPTH;
                                    speedUnit = CommandPlanner.this.auvSpeedUnits;
                                    creator.setZ(z, zunits);
                                } else if ("uav".equalsIgnoreCase(v.getType())) {
                                    speed = CommandPlanner.this.uavSpeed;
                                    z = CommandPlanner.this.uavAltitude;
                                    zunits = ManeuverLocation.Z_UNITS.ALTITUDE;
                                    speedUnit = CommandPlanner.this.uavSpeedUnits;
                                    creator.setZ(z, zunits);
                                } else if ("asv".equalsIgnoreCase(v.getType()) || "usv".equalsIgnoreCase(v.getType())) {
                                    speed = CommandPlanner.this.asvSpeed;
                                    z = 0.0;
                                    zunits = ManeuverLocation.Z_UNITS.DEPTH;
                                    speedUnit = CommandPlanner.this.asvSpeedUnits;
                                    creator.setZ(z, zunits);
                                } else {
                                    NeptusLog.pub().error((Object)"error sending goto ");
                                    return;
                                }
                                creator.setZ(z, zunits);
                                creator.addManeuver("Goto", "speed", speed, "speedUnits", speedUnit);
                                PlanType plan = creator.getPlan();
                                plan.setVehicle(v);
                                plan.setId("go_" + plan.getId());
                                plan = CommandPlanner.this.addPlanToMission(plan);
                                CommandPlanner.this.startPlan(plan, false, (arg0.getModifiers() & 2) != 0);
                            }
                        }.start();
                    }
                });
                ok = true;
            }
            if (v.getFeasibleManeuvers().containsValue(StationKeeping.class.getName())) {
                menu.add(new AbstractAction(I18n.text("Surface here")){

                    @Override
                    public void actionPerformed(final ActionEvent arg0) {
                        new Thread(){

                            @Override
                            public void run() {
                                double speed = 0.0;
                                String speedUnit = "RPM";
                                double radius = 10.0;
                                int duration = 0;
                                if ("auv".equalsIgnoreCase(v.getType()) || "uuv".equalsIgnoreCase(v.getType())) {
                                    speed = CommandPlanner.this.auvSpeed;
                                    speedUnit = CommandPlanner.this.auvSpeedUnits;
                                    radius = CommandPlanner.this.auvSkRadius;
                                } else if ("asv".equalsIgnoreCase(v.getType()) || "usv".equalsIgnoreCase(v.getType())) {
                                    speed = CommandPlanner.this.asvSpeed;
                                    speedUnit = CommandPlanner.this.asvSpeedUnits;
                                    radius = CommandPlanner.this.asvSkRadius;
                                } else {
                                    return;
                                }
                                PlanCreator creator = new PlanCreator(CommandPlanner.this.getConsole().getMission());
                                creator.setLocation(target);
                                creator.setZ(0.0, ManeuverLocation.Z_UNITS.DEPTH);
                                creator.addManeuver("StationKeeping", "speed", speed, "speedUnits", speedUnit, "duration", duration, "radius", radius);
                                PlanType plan = creator.getPlan();
                                plan.setVehicle(v);
                                plan.setId("sk_" + plan.getId());
                                plan = CommandPlanner.this.addPlanToMission(plan);
                                CommandPlanner.this.startPlan(plan, false, (arg0.getModifiers() & 2) != 0);
                            }
                        }.start();
                    }
                });
                ok = true;
            }
            if (v.getFeasibleManeuvers().containsValue(Loiter.class.getName())) {
                menu.add(new AbstractAction(I18n.text("Loiter here")){

                    @Override
                    public void actionPerformed(final ActionEvent arg0) {
                        new Thread(){

                            @Override
                            public void run() {
                                double speed = 0.0;
                                String speedUnit = "RPM";
                                double radius = 10.0;
                                int duration = 0;
                                double z = 0.0;
                                ManeuverLocation.Z_UNITS zunits = ManeuverLocation.Z_UNITS.NONE;
                                if ("auv".equalsIgnoreCase(v.getType()) || "uuv".equalsIgnoreCase(v.getType())) {
                                    speed = CommandPlanner.this.auvSpeed;
                                    speedUnit = CommandPlanner.this.auvSpeedUnits;
                                    radius = CommandPlanner.this.auvLoiterRadius;
                                    z = CommandPlanner.this.auvDepth;
                                    zunits = ManeuverLocation.Z_UNITS.DEPTH;
                                } else if ("asv".equalsIgnoreCase(v.getType()) || "usv".equalsIgnoreCase(v.getType())) {
                                    speed = CommandPlanner.this.asvSpeed;
                                    speedUnit = CommandPlanner.this.asvSpeedUnits;
                                    radius = CommandPlanner.this.asvLoiterRadius;
                                    z = 0.0;
                                    zunits = ManeuverLocation.Z_UNITS.DEPTH;
                                } else if ("uav".equalsIgnoreCase(v.getType())) {
                                    speed = CommandPlanner.this.uavSpeed;
                                    speedUnit = CommandPlanner.this.uavSpeedUnits;
                                    radius = CommandPlanner.this.uavLoiterRadius;
                                    z = CommandPlanner.this.uavAltitude;
                                    zunits = ManeuverLocation.Z_UNITS.ALTITUDE;
                                } else {
                                    return;
                                }
                                PlanCreator creator = new PlanCreator(CommandPlanner.this.getConsole().getMission());
                                creator.setLocation(target);
                                creator.setZ(z, zunits);
                                creator.addManeuver("Loiter", "speed", speed, "speedUnits", speedUnit, "loiterDuration", duration, "radius", radius);
                                PlanType plan = creator.getPlan();
                                plan.setVehicle(v);
                                plan.setId("lt_" + plan.getId());
                                plan = CommandPlanner.this.addPlanToMission(plan);
                                CommandPlanner.this.startPlan(plan, false, (arg0.getModifiers() & 2) != 0);
                            }
                        }.start();
                    }
                });
                ok = true;
            }
            if (!ok) continue;
            items.add(menu);
        }
        return items;
    }

    private PlanType addPlanToMission(PlanType plan) {
        String planId = plan.getId();
        this.getConsole().getMission().addPlan(plan);
        this.getConsole().getMission().save(true);
        this.getConsole().updateMissionListeners();
        PlanType result = this.getConsole().getMission().getIndividualPlansList().get(planId);
        this.getConsole().setPlan(result);
        return result;
    }

    protected void startPlan(PlanType plan, boolean calibrate, boolean ignoreErrors) {
        PlanControl startPlan = new PlanControl();
        startPlan.setType(PlanControl.TYPE.REQUEST);
        startPlan.setOp(PlanControl.OP.START);
        startPlan.setPlanId(plan.getId());
        startPlan.setArg(plan.asIMCPlan(true));
        int reqId = IMCSendMessageUtils.getNextRequestId();
        startPlan.setRequestId(reqId);
        startPlan.setFlags((calibrate ? 1 : 0) | (ignoreErrors ? 2 : 0));
        boolean ret = IMCSendMessageUtils.sendMessage((IMCMessage)startPlan, (Component)this, "Error starting " + plan.getId() + " plan", false, true, plan.getVehicle());
        if (ret) {
            this.registerPlanControlRequest(reqId);
        }
    }

    private void registerPlanControlRequest(int reqId) {
        this.registerRequestIdsTime.put(reqId, System.currentTimeMillis());
    }

    @Override
    public void messageArrived(IMCMessage message) {
        if (message.getMgid() == 559) {
            PlanControl pc = (PlanControl)message;
            try {
                int reqId;
                PlanControl.TYPE typeId = pc.getType();
                if (typeId != PlanControl.TYPE.REQUEST && this.registerRequestIdsTime.containsKey(reqId = pc.getRequestId())) {
                    boolean cleanReg = false;
                    if (typeId == PlanControl.TYPE.SUCCESS) {
                        cleanReg = true;
                    } else if (typeId == PlanControl.TYPE.FAILURE) {
                        cleanReg = true;
                    }
                    if (cleanReg) {
                        this.registerRequestIdsTime.remove(reqId);
                    }
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
    }
}

