/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Map;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ConsoleSystem;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.util.MathMiscUtils;

@PluginDescription(name="Distances Layer", author="Jos\u00e9 Quadrado", category=PluginDescription.CATEGORY.PLANNING)
public class DistancesLayer
extends ConsolePanel
implements Renderer2DPainter {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Visible", category="Visibility", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean visible = true;
    private ConsoleLayout console;
    private Map<String, ConsoleSystem> systems;

    public DistancesLayer(ConsoleLayout console) {
        super(console);
        this.console = console;
    }

    @Override
    public void initSubPanel() {
        this.systems = this.console.getSystems();
    }

    @Override
    public void cleanSubPanel() {
        this.systems.clear();
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (!this.visible) {
            return;
        }
        Point2D me = renderer.getScreenPosition(MyState.getLocation());
        for (ConsoleSystem sys : this.systems.values()) {
            double dist = sys.getState().getPosition().getDistanceInMeters(MyState.getLocation());
            Point2D point = renderer.getScreenPosition(sys.getState().getPosition());
            g.setColor(Color.RED.darker());
            g.drawRect((int)point.getX() - 10, (int)point.getY() - 10, 20, 20);
            g.drawLine((int)me.getX(), (int)me.getY(), (int)point.getX(), (int)point.getY());
            int x = (int)((me.getX() + point.getX()) / 2.0 + 4.0);
            int y = (int)((me.getY() + point.getY()) / 2.0 + 4.0);
            g.setColor(Color.RED.brighter());
            g.drawString(MathMiscUtils.round(dist, 2) + "m", x, y);
        }
    }
}

