/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.jdesktop.swingx.JXLabel;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.LockableSubPanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.gui.system.EmergencyTaskSymbol;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.MultiSystemIMCMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="Emergency Control", description="This panel controls the emergency plan for the vehicle.", version="1.0.0", author="Paulo Dias")
public class EmergencyControlPanel
extends ConsolePanel
implements ConfigurationListener,
MainVehicleChangeListener,
LockableSubPanel,
IPeriodicUpdates {
    @NeptusProperty(name="Font Size Multiplier", description="The font size. Use '1' for default.")
    public int fontMultiplier = 1;
    private final ImageIcon ICON_UP = ImageUtils.getIcon("images/planning/up.png");
    private final ImageIcon ICON_START = ImageUtils.getIcon("images/planning/start.png");
    private final ImageIcon ICON_STOP = ImageUtils.getIcon("images/planning/stop.png");
    private final ImageIcon ICON_ENABLE = ImageUtils.getIcon("images/planning/enable.png");
    private final ImageIcon ICON_DISABLE = ImageUtils.getIcon("images/planning/disable.png");
    private final ImageIcon ICON_QUERY = ImageUtils.getIcon("images/planning/sendquery.png");
    private MultiSystemIMCMessageListener mainVehicleMessageListener = null;
    private EmergencyStateEnum reportedState = EmergencyStateEnum.UNKNOWN;
    private String reportedPlanId = "";
    private short reportedCommLevel = (short)-1;
    private boolean locked = false;
    private JLabel titleLabel = null;
    private JXLabel planIdLabel = null;
    private Font planIdLabelFont = null;
    private ToolbarButton uploadPlanButton = null;
    private ToolbarButton sendQueryButton = null;
    private ToolbarButton sendEnableDisableButton = null;
    private ToolbarButton sendStartStopButton = null;
    private EmergencyTaskSymbol stateSymbolLabel = null;

    public EmergencyControlPanel(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    private void initialize() {
        this.removeAll();
        this.setSize(new Dimension(190, 60));
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(PluginUtils.getPluginName(this.getClass()));
        this.titleLabel.setFont(new Font("Arial", 1, 9 * this.fontMultiplier));
        this.add((Component)this.titleLabel, "North");
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 2));
        this.add((Component)tmpPanel, "Center");
        this.planIdLabel = new JXLabel("");
        this.planIdLabelFont = this.planIdLabel.getFont();
        this.planIdLabel.setFont(this.planIdLabelFont.deriveFont((float)(this.planIdLabelFont.getSize() * this.fontMultiplier)));
        this.add((Component)this.planIdLabel, "South");
        this.uploadPlanButton = new ToolbarButton(new AbstractAction("Upload Plan", this.ICON_UP){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        EmergencyControlPanel.this.uploadPlanButton.setEnabled(false);
                        EmergencyControlPanel.this.sendPlanSpecAsEmergencyPlan();
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        EmergencyControlPanel.this.uploadPlanButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        });
        tmpPanel.add((Component)((Object)this.uploadPlanButton));
        this.sendQueryButton = new ToolbarButton(new AbstractAction("Query", this.ICON_QUERY){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        EmergencyControlPanel.this.sendQueryButton.setEnabled(false);
                        EmergencyControlPanel.this.sendQuery();
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        EmergencyControlPanel.this.sendQueryButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        });
        tmpPanel.add((Component)((Object)this.sendQueryButton));
        this.sendEnableDisableButton = new ToolbarButton(new AbstractAction("Enable Plan", this.ICON_ENABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String cmd = e.getActionCommand();
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        EmergencyControlPanel.this.sendEnableDisableButton.setEnabled(false);
                        if ("Enable Plan".equalsIgnoreCase(cmd)) {
                            EmergencyControlPanel.this.sendEnableDisableStartStop(0);
                        } else if ("Disable Plan".equalsIgnoreCase(cmd)) {
                            EmergencyControlPanel.this.sendEnableDisableStartStop(1);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        EmergencyControlPanel.this.sendEnableDisableButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        });
        this.sendEnableDisableButton.setActionCommand("Enable Plan");
        tmpPanel.add((Component)((Object)this.sendEnableDisableButton));
        this.sendStartStopButton = new ToolbarButton(new AbstractAction("Start Plan", this.ICON_START){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String cmd = e.getActionCommand();
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        EmergencyControlPanel.this.sendStartStopButton.setEnabled(false);
                        if ("Start Plan".equalsIgnoreCase(cmd)) {
                            EmergencyControlPanel.this.sendEnableDisableStartStop(2);
                        } else if ("Stop Plan".equalsIgnoreCase(cmd)) {
                            EmergencyControlPanel.this.sendEnableDisableStartStop(3);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        EmergencyControlPanel.this.sendStartStopButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        });
        this.sendStartStopButton.setActionCommand("Start Plan");
        tmpPanel.add((Component)((Object)this.sendStartStopButton));
        this.stateSymbolLabel = new EmergencyTaskSymbol();
        this.stateSymbolLabel.setSize(32, 32);
        this.stateSymbolLabel.setMaximumSize(new Dimension(32, 32));
        this.stateSymbolLabel.setSymbolHeight(32);
        this.stateSymbolLabel.setSymbolWidth(32);
        this.stateSymbolLabel.setActive(true);
        this.updateStatusSymbol();
        tmpPanel.add((Component)((Object)this.stateSymbolLabel));
        this.initializeMainVehicleMessageListener();
    }

    @Override
    public void propertiesChanged() {
        if (this.fontMultiplier < 1) {
            return;
        }
        this.titleLabel.setFont(new Font("Arial", 1, 9 * this.fontMultiplier));
        this.planIdLabel.setFont(this.planIdLabelFont.deriveFont((float)(this.planIdLabelFont.getSize() * this.fontMultiplier)));
        this.revalidate();
    }

    private void refreshUI() {
        this.updateStatusSymbol();
        if (this.isLocked()) {
            this.planIdLabel.setEnabled(false);
            this.uploadPlanButton.setEnabled(false);
            this.sendQueryButton.setEnabled(false);
            this.sendEnableDisableButton.setEnabled(false);
            this.sendStartStopButton.setEnabled(false);
            this.stateSymbolLabel.setEnabled(false);
            return;
        }
        this.planIdLabel.setEnabled(true);
        this.uploadPlanButton.setEnabled(true);
        this.sendQueryButton.setEnabled(true);
        this.sendEnableDisableButton.setEnabled(true);
        this.sendStartStopButton.setEnabled(true);
        this.stateSymbolLabel.setEnabled(true);
        if (this.reportedState == EmergencyStateEnum.NOT_CONFIGURED || this.reportedState == EmergencyStateEnum.UNKNOWN) {
            this.sendEnableDisableButton.setEnabled(false);
            this.sendStartStopButton.setEnabled(false);
        } else {
            this.sendEnableDisableButton.setEnabled(true);
            if (this.reportedState != EmergencyStateEnum.DISABLED) {
                this.sendEnableDisableButton.setActionCommand("Disable Plan");
                this.sendEnableDisableButton.getAction().putValue("SmallIcon", this.ICON_DISABLE);
                this.sendEnableDisableButton.getAction().putValue("ShortDescription", "Disable Plan");
            } else {
                this.sendEnableDisableButton.setActionCommand("Enable Plan");
                this.sendEnableDisableButton.getAction().putValue("SmallIcon", this.ICON_ENABLE);
                this.sendEnableDisableButton.getAction().putValue("ShortDescription", "Enable Plan");
            }
            if (this.reportedState == EmergencyStateEnum.DISABLED) {
                this.sendStartStopButton.setEnabled(false);
            } else {
                this.sendStartStopButton.setEnabled(true);
            }
            if (!(this.reportedState != EmergencyStateEnum.ENABLED && this.reportedState != EmergencyStateEnum.ARMED || this.reportedState == EmergencyStateEnum.DISABLED || this.reportedState == EmergencyStateEnum.ACTIVE && this.reportedState == EmergencyStateEnum.STOPPING)) {
                this.sendStartStopButton.setActionCommand("Start Plan");
                this.sendStartStopButton.getAction().putValue("SmallIcon", this.ICON_START);
                this.sendStartStopButton.getAction().putValue("ShortDescription", "Start Plan");
            } else {
                this.sendStartStopButton.setActionCommand("Stop Plan");
                this.sendStartStopButton.getAction().putValue("SmallIcon", this.ICON_STOP);
                this.sendStartStopButton.getAction().putValue("ShortDescription", "Stop Plan");
            }
        }
    }

    private void updateStatusSymbol() {
        try {
            this.stateSymbolLabel.setStatus(EmergencyTaskSymbol.EmergencyStatus.valueOf(this.reportedState.name()));
            this.stateSymbolLabel.setActive(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stateSymbolLabel.setStatus(EmergencyTaskSymbol.EmergencyStatus.NOT_CONFIGURED);
            this.stateSymbolLabel.setActive(false);
        }
    }

    private void initializeMainVehicleMessageListener() {
        if (this.mainVehicleMessageListener != null) {
            return;
        }
        this.mainVehicleMessageListener = new MultiSystemIMCMessageListener(this.getClass().getSimpleName() + " [" + Integer.toHexString(this.hashCode()) + "]"){

            @Override
            public void messageArrived(ImcId16 id, IMCMessage msg) {
                if ("EmergencyControlState".equalsIgnoreCase(msg.getAbbrev())) {
                    String strPlanId = msg.getString("plan_id");
                    if (strPlanId == null) {
                        strPlanId = msg.getString("mission_id");
                    }
                    int stateEn = msg.getInteger("state");
                    int commLevel = (int)msg.getDouble("comm_level");
                    EmergencyControlPanel.this.setReportedState(EmergencyStateEnum.translate(stateEn));
                    EmergencyControlPanel.this.setReportedPlanId(strPlanId);
                    EmergencyControlPanel.this.setReportedCommLevel((short)commLevel);
                    EmergencyControlPanel.this.refreshUI();
                }
            }
        };
        this.mainVehicleMessageListener.setMessagesToListen("EmergencyControlState");
    }

    @Override
    public void initSubPanel() {
        this.mainVehicleMessageListener.setSystemToListenStrings(this.getMainVehicleId());
    }

    @Override
    public void cleanSubPanel() {
        this.mainVehicleMessageListener.clean();
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange evt) {
        this.mainVehicleMessageListener.setSystemToListenStrings(evt.getCurrent());
        this.setReportedState(EmergencyStateEnum.UNKNOWN);
        this.setReportedPlanId("");
        this.setReportedCommLevel((short)-1);
        this.update();
        this.refreshUI();
    }

    public String getReportedPlanId() {
        return this.reportedPlanId;
    }

    private void setReportedPlanId(String reportedPlanId) {
        this.reportedPlanId = reportedPlanId;
        this.planIdLabel.setText("<html><b>Plan: </b>" + reportedPlanId);
        this.planIdLabel.setToolTipText("Plan: " + reportedPlanId);
        this.planIdLabel.repaint();
    }

    public EmergencyStateEnum getReportedState() {
        return this.reportedState;
    }

    private void setReportedState(EmergencyStateEnum reportedState) {
        this.reportedState = reportedState;
    }

    public short getReportedCommLevel() {
        return this.reportedCommLevel;
    }

    private void setReportedCommLevel(short reportedCommLevel) {
        this.reportedCommLevel = reportedCommLevel;
    }

    @Override
    public long millisBetweenUpdates() {
        return 5000L;
    }

    @Override
    public boolean update() {
        ImcSystem tmp = ImcSystemsHolder.lookupSystemByName(this.getMainVehicleId());
        if (tmp != null) {
            this.reportedPlanId = tmp.getEmergencyPlanId();
            try {
                this.setReportedState(EmergencyStateEnum.valueOf(tmp.getEmergencyStatusStr()));
                this.setReportedPlanId(tmp.getEmergencyPlanId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.refreshUI();
        }
        return true;
    }

    protected boolean sendPlanSpecAsEmergencyPlan() {
        if (!this.checkConditionToRun(this, true, true)) {
            return false;
        }
        IMCMessage msgEmergencyControl = IMCDefinition.getInstance().create("EmergencyControl", new Object[0]);
        msgEmergencyControl.setValue("command", (Object)"SET_PLAN");
        IMCMessage msgPlanSpecification = this.getPlanAsSpecification();
        if (msgPlanSpecification == null) {
            GuiUtils.errorMessage(this, "Send Emergency Control Mission Plan", "Error sending MissionSpecification message!\nNo Mission Plan Spec. valid!");
        }
        if (msgEmergencyControl.getMessageType().getFieldType("plan") != null) {
            msgEmergencyControl.setValue("plan", (Object)msgPlanSpecification);
        } else {
            msgEmergencyControl.setValue("mission", (Object)msgPlanSpecification);
        }
        return this.sendTheMessage(msgEmergencyControl, "Error sending Plan message!");
    }

    protected boolean sendQuery() {
        IMCMessage msgEmergencyControl = IMCDefinition.getInstance().create("EmergencyControl", new Object[0]);
        msgEmergencyControl.setValue("command", (Object)"QUERY");
        return this.sendTheMessage(msgEmergencyControl, "Error sending Query Command message!");
    }

    protected boolean sendEnableDisableStartStop(int enableOrDisableOrStartOrStopCmd) {
        IMCMessage msgEmergencyControl = IMCDefinition.getInstance().create("EmergencyControl", new Object[0]);
        String enumerated = "";
        String cmdStr = "Unknown";
        try {
            switch (enableOrDisableOrStartOrStopCmd) {
                case 0: {
                    enumerated = "ENABLE";
                    cmdStr = "Enable";
                    break;
                }
                case 1: {
                    enumerated = "DISABLE";
                    cmdStr = "Disable";
                    break;
                }
                case 2: {
                    enumerated = "START";
                    cmdStr = "Start";
                    break;
                }
                case 3: {
                    enumerated = "STOP";
                    cmdStr = "Stop";
                    break;
                }
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)this, (Throwable)ex);
        }
        msgEmergencyControl.setValue("command", (Object)enumerated);
        return this.sendTheMessage(msgEmergencyControl, "Error sending " + cmdStr + " Command message!");
    }

    private boolean sendTheMessage(IMCMessage msg, String errorTextForDialog) {
        String vid = this.getConsole().getMainSystem();
        boolean ret = ImcMsgManager.getManager().sendMessageToSystem(msg, vid, null, null);
        if (!ret) {
            GuiUtils.errorMessage(this, "Send Emergency Control Message", errorTextForDialog);
            return false;
        }
        return true;
    }

    protected IMCMessage getPlanAsSpecification() {
        if (!this.checkConditionToRun(this, true, true)) {
            return null;
        }
        ConsoleLayout cons = this.getConsole();
        PlanType plan = cons.getPlan();
        if (!(plan instanceof PlanType)) {
            return null;
        }
        PlanType iPlan = plan;
        return iPlan.asIMCPlan();
    }

    protected boolean checkConditionToRun(Component component, boolean checkMission, boolean checkPlan) {
        PlanType plan;
        MissionType miss;
        if (!ImcMsgManager.getManager().isRunning()) {
            GuiUtils.errorMessage(this, component.getName(), "IMC comms. are not running!");
            return false;
        }
        ConsoleLayout cons = this.getConsole();
        if (cons == null) {
            GuiUtils.errorMessage(this, component.getName(), "Missing console attached!");
            return false;
        }
        if (checkMission && (miss = cons.getMission()) == null) {
            GuiUtils.errorMessage(this, component.getName(), "Missing attached mission!");
            return false;
        }
        if (checkPlan && (plan = cons.getPlan()) == null) {
            GuiUtils.errorMessage(this, component.getName(), "Missing attached plan!");
            return false;
        }
        return true;
    }

    @Override
    public void lock() {
        this.locked = true;
        this.refreshUI();
    }

    @Override
    public void unLock() {
        this.locked = false;
        this.refreshUI();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        ConsoleParse.dummyConsole(new EmergencyControlPanel(null));
    }

    public static enum EmergencyStateEnum {
        UNKNOWN(-1, "Unknown"),
        NOT_CONFIGURED(0, "Not Configured"),
        DISABLED(1, "Desabled"),
        ENABLED(2, "Enabled"),
        ARMED(3, "Armed"),
        ACTIVE(4, "Active"),
        STOPPING(5, "Stopping");

        int id;
        String desc;

        private EmergencyStateEnum(int id, String desc) {
            this.id = id;
            this.desc = desc;
        }

        public static EmergencyStateEnum translate(int id) {
            for (EmergencyStateEnum tmp : EmergencyStateEnum.values()) {
                if (tmp.id != id) continue;
                return tmp;
            }
            return UNKNOWN;
        }
    }
}

