/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.mp.maneuvers.VehicleFormation;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.CustomInteractionSupport;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;

@PluginDescription(author="zp", name="Formation Planner", description="This Neptus plugin provides an interface for Vehicle Formation (cooperative) plans")
@LayerPriority(priority=50)
public class FormationPlanner
extends ConsolePanel
implements Renderer2DPainter,
StateRendererInteraction {
    private static final long serialVersionUID = 1L;
    protected InteractionAdapter adapter = new InteractionAdapter(null);
    protected VehicleFormation model = new VehicleFormation();
    protected boolean inited = false;

    public FormationPlanner(ConsoleLayout console) {
        super(console);
    }

    @Override
    public Image getIconImage() {
        return this.adapter.getIconImage();
    }

    @Override
    public Cursor getMouseCursor() {
        return this.adapter.getMouseCursor();
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() == 3) {
            NeptusLog.pub().info((Object)"<###>show popup...");
            JPopupMenu popup = new JPopupMenu();
            popup.add(new AbstractAction("Set participants"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                }
            });
            popup.add(new AbstractAction("Edit trajectory"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                }
            });
            popup.addSeparator();
            popup.add(new AbstractAction("Start formation"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                }
            });
            popup.show(source, event.getX(), event.getY());
        } else if (event.getClickCount() == 2) {
            NeptusLog.pub().info((Object)"<###>add point...");
        } else {
            this.adapter.mouseClicked(event, source);
        }
    }

    @Override
    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        this.adapter.mousePressed(event, source);
    }

    @Override
    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseDragged(event, source);
    }

    @Override
    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        NeptusLog.pub().info((Object)"<###>mouse moved");
        this.adapter.mouseMoved(event, source);
    }

    @Override
    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseReleased(event, source);
    }

    @Override
    public void wheelMoved(MouseWheelEvent event, StateRenderer2D source) {
        this.adapter.wheelMoved(event, source);
    }

    @Override
    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyPressed(event, source);
    }

    @Override
    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyReleased(event, source);
    }

    @Override
    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyTyped(event, source);
    }

    @Override
    public void mouseExited(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseExited(event, source);
    }

    @Override
    public void focusGained(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusGained(event, source);
    }

    @Override
    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusLost(event, source);
    }

    @Override
    public void setActive(boolean mode, StateRenderer2D source) {
        this.adapter.setActive(mode, source);
        if (mode) {
            source.addPostRenderPainter(this, "Formation Planner");
        } else {
            source.removePostRenderPainter(this);
        }
    }

    @Override
    public void setAssociatedSwitch(ToolbarSwitch tswitch) {
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        AffineTransform plain = new AffineTransform(g.getTransform());
        g.setTransform(plain);
        g.setColor(Color.white);
        g.drawString(this.model.getParticipants().size() + " participants", 8, 16);
        g.setColor(Color.black);
        g.drawString(this.model.getParticipants().size() + " participants", 7, 15);
    }

    @Override
    public void initSubPanel() {
        if (!this.inited) {
            Vector<CustomInteractionSupport> panels = this.getConsole().getSubPanelsOfInterface(CustomInteractionSupport.class);
            for (CustomInteractionSupport cis : panels) {
                cis.addInteraction(this);
            }
            this.inited = true;
        }
    }

    @Override
    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
    }

    @Override
    public void cleanSubPanel() {
    }
}

