/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import pt.lsts.imc.PlanControlState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ConsoleSystem;
import pt.lsts.neptus.console.IConsoleLayer;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.ConsoleVehicleChangeListener;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.console.plugins.PlanChangeListener;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.renderer2d.CustomInteractionSupport;
import pt.lsts.neptus.renderer2d.FeatureFocuser;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.renderer2d.VehicleStateListener;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="Map Panel", icon="images/planning/planning.png", author="ZP, Paulo Dias", documentation="planning/planning_panel.html", category=PluginDescription.CATEGORY.INTERFACE)
public class MapPanel
extends ConsolePanel
implements MainVehicleChangeListener,
MissionChangeListener,
PlanChangeListener,
IPeriodicUpdates,
ILayerPainter,
ConfigurationListener,
IMapPopup,
CustomInteractionSupport,
VehicleStateListener,
ConsoleVehicleChangeListener {
    private static final long serialVersionUID = 1L;
    private final ImageIcon TAIL_ICON = ImageUtils.getScaledIcon("images/planning/tailOnOff.png", 16, 16);
    @NeptusProperty(name="Show world map")
    public boolean worldMapShown = true;
    @NeptusProperty
    public int updateMillis = 100;
    @NeptusProperty(name="Save mission states", description="Save the mission states whenever the mission is changed")
    public boolean saveMissionStates = false;
    @NeptusProperty(name="Smooth image resizing")
    public boolean smoothResize = false;
    @NeptusProperty(name="Antialiasing")
    public boolean antialias = true;
    @NeptusProperty(name="Interpolate States")
    public boolean interpolate = false;
    @NeptusProperty(name="Fixed Vehicle Size", description="Vehicle icon size (0 for real size)")
    public int fixedSize = 0;
    @NeptusProperty(name="Toolbar placement", description="Where to place the toolbar")
    public PlacementEnum toolbarPlacement = PlacementEnum.Bottom;
    protected StateRenderer2D renderer = new StateRenderer2D();
    protected String planId = null;
    protected boolean editing = false;
    protected ToolbarSwitch tailSwitch;
    protected ToolbarSwitch dummySwitch;
    protected AbstractAction tailMode;
    protected AbstractAction addPlan;
    protected JLabel status = new JLabel();
    protected PlanElement mainPlanPainter = null;
    protected ButtonGroup bg = new ButtonGroup();
    protected JToolBar bottom = new JToolBar(1);
    protected LinkedHashMap<VehicleType, SystemPositionAndAttitude> vehicles = new LinkedHashMap();
    protected LinkedHashMap<String, StateRendererInteraction> interactionModes = new LinkedHashMap();
    protected LinkedHashMap<String, ToolbarSwitch> interactionButtons = new LinkedHashMap();
    private MissionType mission = null;
    private PlanElement planElem;
    private MapGroup mapGroup = null;

    public MapPanel(ConsoleLayout console) {
        super(console);
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.renderer.setMinDelay(0);
        this.renderer.setShowWorldMapOnScreenControls(false);
        this.add((Component)this.renderer, "Center");
        this.bottom.setFloatable(false);
        this.bottom.setAlignmentX(0.5f);
        this.renderer.addMenuExtension(new FeatureFocuser(console));
        AbstractAction tmp = new AbstractAction(I18n.text("Translate"), null){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.dummySwitch = new ToolbarSwitch(tmp);
        this.bg.add(this.dummySwitch);
        this.dummySwitch.setSelected(true);
        this.tailMode = new AbstractAction(I18n.text("Show tail"), this.TAIL_ICON){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    String mainVehicle = MapPanel.this.getConsole().getMainSystem();
                    if (mainVehicle != null) {
                        MapPanel.this.renderer.setVehicleTailOn(null);
                    }
                } else {
                    MapPanel.this.renderer.setVehicleTailOff(null);
                }
            }
        };
        this.tailSwitch = new ToolbarSwitch(this.tailMode);
        this.tailSwitch.setSelected(false);
        this.bottom.add(new JSeparator(0));
        this.bottom.add(this.tailSwitch);
        this.status.setForeground(Color.red);
        this.bottom.add(this.status);
        this.setToolbarPlacement();
    }

    @Override
    public void initSubPanel() {
        this.setSize(500, 500);
        this.setMission(this.getConsole().getMission());
        this.getConsole().addConsoleVehicleListener(this);
        for (ConsoleSystem v : this.getConsole().getSystems().values()) {
            v.addRenderFeed(this);
        }
    }

    @Override
    public void cleanSubPanel() {
        ImcMsgManager.getManager().removeListenerFromAllSystems(this);
        this.getConsole().removeRenderAll(this);
    }

    private void setToolbarPlacement() {
        String position = "South";
        switch (this.toolbarPlacement) {
            case Left: {
                position = "West";
                this.bottom.setOrientation(1);
                break;
            }
            case Right: {
                position = "East";
                this.bottom.setOrientation(1);
                break;
            }
            case Top: {
                position = "North";
                this.bottom.setOrientation(0);
                break;
            }
            case Bottom: {
                position = "South";
                this.bottom.setOrientation(0);
            }
        }
        this.add((Component)this.bottom, position);
    }

    @Subscribe
    public void consume(PlanControlState message) {
        if (this.getConsole().getMainSystem() != null && !message.getSourceName().equals(this.getConsole().getMainSystem())) {
            return;
        }
        String planId = message.getPlanId();
        String manId = message.getManId();
        if (this.getConsole().getPlan() != null && this.getConsole().getPlan().getId().equals(planId) && this.mainPlanPainter != null) {
            this.mainPlanPainter.setActiveManeuver(manId);
        }
    }

    @Override
    public void missionReplaced(MissionType mission) {
        this.setMission(mission);
        if (this.addPlan != null) {
            this.addPlan.setEnabled(mission != null);
        }
    }

    @Override
    public void missionUpdated(MissionType mission) {
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange evt) {
        if (this.mainPlanPainter != null) {
            this.mainPlanPainter.setActiveManeuver(null);
        }
    }

    @Override
    public void planChange(PlanType plan) {
        StateRenderer2D r2d = this.renderer;
        if (this.mainPlanPainter != null) {
            r2d.removePostRenderPainter(this.mainPlanPainter);
        }
        if (plan != null) {
            PlanElement po = new PlanElement(r2d.getMapGroup(), new MapType());
            po.setMissionType(plan.getMissionType());
            po.setPlan(plan);
            po.setRenderer(r2d);
            po.setColor(new Color(255, 255, 255, 128));
            po.setShowDistances(false);
            po.setShowManNames(false);
            r2d.addPostRenderPainter(po, I18n.text("Plan Painter"));
            this.mainPlanPainter = po;
        }
    }

    @Override
    public long millisBetweenUpdates() {
        return this.updateMillis;
    }

    @Override
    public boolean update() {
        try {
            for (VehicleType vt : this.vehicles.keySet()) {
                this.renderer.vehicleStateChanged(vt.getId(), this.vehicles.get(vt), false);
            }
            this.renderer.repaint();
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)e);
        }
        return true;
    }

    public void setMission(MissionType mission) {
        if (mission == null) {
            return;
        }
        this.mapGroup = MapGroup.getMapGroupInstance(mission);
        this.renderer.setMapGroup(this.mapGroup);
        this.mission = mission;
    }

    public void setPlan(PlanType plan) {
        if (plan == null) {
            this.renderer.removePostRenderPainter(this.planElem);
            return;
        }
        if (plan.getMissionType() != this.mission) {
            this.setMission(plan.getMissionType());
        }
        this.renderer.removePostRenderPainter(this.planElem);
        this.planElem = new PlanElement(this.mapGroup, new MapType());
        this.planElem.setTransp2d(1.0);
        this.renderer.addPostRenderPainter(this.planElem, "Plan Layer");
        this.planElem.setRenderer(this.renderer);
        this.planElem.setPlan(plan);
        this.renderer.repaint();
    }

    @Override
    public void propertiesChanged() {
        this.renderer.setSmoothResizing(this.smoothResize);
        this.renderer.setAntialiasing(this.antialias);
        this.renderer.setFixedVehicleWidth(this.fixedSize);
        this.renderer.setWorldMapShown(this.worldMapShown);
        this.setToolbarPlacement();
    }

    public void addLayer(final IConsoleLayer layer) {
        final String name = layer.getName();
        AbstractAction custom = new AbstractAction(layer.getName(), ImageUtils.getScaledIcon(layer.getIcon(), 16, 16)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    MapPanel.this.renderer.addPostRenderPainter(layer, name);
                } else {
                    MapPanel.this.renderer.removePostRenderPainter(layer);
                }
            }
        };
        ToolbarSwitch tswitch = new ToolbarSwitch(I18n.text(name), custom);
        tswitch.setSelected(false);
        this.bottom.add((Component)tswitch, this.bottom.getComponentCount());
        this.invalidate();
        this.revalidate();
    }

    public void removeLayer(IConsoleLayer layer) {
        String name = layer.getName();
        this.renderer.removePostRenderPainter(layer);
        for (int i = 0; i < this.bottom.getComponentCount(); ++i) {
            ToolbarSwitch ts;
            Component c = this.bottom.getComponent(i);
            if (!(c instanceof ToolbarSwitch) || !(ts = (ToolbarSwitch)c).getToolTipText().equals(name)) continue;
            this.bottom.remove(ts);
            break;
        }
        this.invalidate();
        this.revalidate();
    }

    @Override
    public void addInteraction(StateRendererInteraction interaction) {
        try {
            final String name = interaction.getName();
            if (this.interactionModes.containsKey(name)) {
                return;
            }
            this.interactionModes.put(name, interaction);
            AbstractAction custom = new AbstractAction(interaction.getName(), ImageUtils.getScaledIcon(interaction.getIconImage(), 16, 16)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((ToolbarSwitch)e.getSource()).isSelected()) {
                        StateRendererInteraction ri = MapPanel.this.interactionModes.get(name);
                        if (ri.isExclusive() && MapPanel.this.renderer.getActiveInteraction() != null) {
                            MapPanel.this.renderer.getActiveInteraction().setActive(false, MapPanel.this.renderer);
                            if (MapPanel.this.renderer.getActiveInteraction() == ri) {
                                MapPanel.this.renderer.setActiveInteraction(null);
                                MapPanel.this.dummySwitch.setSelected(true);
                                return;
                            }
                        }
                        MapPanel.this.renderer.setActiveInteraction(ri);
                        ri.setActive(true, MapPanel.this.renderer);
                    }
                }
            };
            ToolbarSwitch tswitch = new ToolbarSwitch(I18n.text(name), custom);
            if (tswitch.isEnabled()) {
                this.bg.add(tswitch);
            }
            this.bottom.add((Component)tswitch, 0);
            this.interactionButtons.put(interaction.getName(), tswitch);
            tswitch.setSelected(false);
            interaction.setAssociatedSwitch(tswitch);
            this.invalidate();
            this.revalidate();
        }
        catch (AbstractMethodError e) {
            AbstractMethodError e1 = new AbstractMethodError(e.getMessage() + " :: " + interaction.getClass().getName() + " missed the complete implementation of " + StateRendererInteraction.class.getName() + "!!! Recompiling the plugin jar might resolve " + "this issue.");
            e1.setStackTrace(e.getStackTrace());
            e1.printStackTrace();
        }
    }

    @Override
    public Collection<StateRendererInteraction> getInteractionModes() {
        return this.interactionModes.values();
    }

    @Override
    public void removeInteraction(StateRendererInteraction interaction) {
        this.renderer.removeInteraction(interaction);
        ToolbarSwitch sw = this.interactionButtons.get(interaction.getName());
        if (sw != null) {
            this.bottom.remove(sw);
        }
        this.doLayout();
    }

    @Override
    public void setActiveInteraction(StateRendererInteraction interaction) {
        if (interaction == null) {
            this.renderer.setActiveInteraction(null);
            return;
        }
        ToolbarSwitch sw = this.interactionButtons.get(interaction.getName());
        if (sw != null) {
            sw.doClick();
        } else {
            this.renderer.setActiveInteraction(interaction);
        }
    }

    @Override
    public StateRendererInteraction getActiveInteraction() {
        return this.renderer.getActiveInteraction();
    }

    @Override
    public void setVehicleState(VehicleType vehicle, SystemPositionAndAttitude state) {
        this.vehicles.put(vehicle, state);
    }

    @Override
    public void consoleVehicleChange(VehicleType v, int status) {
        if (status != 1) {
            this.getConsole().addRender(v.getId(), this);
            ImcMsgManager.getManager().addListener(this, v.getId());
        }
    }

    @Override
    public void addPreRenderPainter(Renderer2DPainter painter) {
        this.renderer.addPreRenderPainter(painter);
    }

    @Override
    public void removePreRenderPainter(Renderer2DPainter painter) {
        this.renderer.removePreRenderPainter(painter);
    }

    @Override
    public boolean addPostRenderPainter(Renderer2DPainter painter, String name) {
        return this.renderer.addPostRenderPainter(painter, name);
    }

    @Override
    public boolean removePostRenderPainter(Renderer2DPainter painter) {
        return this.renderer.removePostRenderPainter(painter);
    }

    @Override
    public StateRenderer2D getRenderer() {
        return this.renderer;
    }

    @Override
    public boolean addMenuExtension(IEditorMenuExtension extension) {
        return this.renderer.addMenuExtension(extension);
    }

    @Override
    public boolean removeMenuExtension(IEditorMenuExtension extension) {
        return this.renderer.removeMenuExtension(extension);
    }

    @Override
    public Collection<IEditorMenuExtension> getMenuExtensions() {
        return this.renderer.getMenuExtensions();
    }

    public static enum PlacementEnum {
        Left,
        Right,
        Top,
        Bottom;

    }
}

