/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import pt.lsts.neptus.console.ConsoleLayer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;

@PluginDescription(name="Keyboard Shortcuts", icon="pt/lsts/neptus/console/plugins/planning/keyboard.png")
@LayerPriority(priority=200)
public class MapShortcutsLayer
extends ConsoleLayer {
    JLabel lbl;

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        super.paint(g, renderer);
        Dimension d = this.lbl.getPreferredSize();
        double x = ((double)renderer.getWidth() - d.getWidth()) / 2.0;
        double y = ((double)renderer.getHeight() - d.getHeight()) / 2.0;
        g.translate(x, y);
        this.lbl.setBounds((int)x, (int)y, (int)d.getWidth(), (int)d.getHeight());
        this.lbl.paint(g);
    }

    public static String getShortcutsHtml() {
        return "<html><body background=\"#FF0000\"><table border='0' align='center'><tr><th>" + I18n.text("Key") + "</th><th>" + I18n.text("Action") + "</th></tr>" + "<tr><td>" + I18n.text("plus (+)") + "</td><td>" + I18n.text("Double the current zoom value") + "</td></tr>" + "<tr><td>" + I18n.text("minus (-)") + "</td><td>" + I18n.text("Half the current zoom value") + "</td></tr>" + "<tr><td>" + I18n.text("left") + "</td><td>" + I18n.text("Move the map to the left") + "</td></tr>" + "<tr><td>" + I18n.text("right") + "</td><td>" + I18n.text("Move the map to the right") + "</td></tr>" + "<tr><td>" + I18n.text("up") + "</td><td>" + I18n.text("Move the map upwards") + "</td></tr>" + "<tr><td>" + I18n.text("down") + "</td><td>" + I18n.text("Move the map downwards") + "</td></tr>" + "<tr><td>" + I18n.textc("N", "The 'N' key.") + "</td><td>" + I18n.text("Reset the current rotation (up facing north)") + "</td></tr>" + "<tr><td>" + I18n.text("F1") + "</td><td>" + I18n.text("Reset the current view to defaults") + "</td></tr>" + "<tr><td>" + I18n.text("Control") + "</td><td>" + I18n.text("Measure distances by click and dragging the mouse") + "</td></tr>" + "<tr><td>" + I18n.text("Shift") + "</td><td>" + I18n.text("Rotate map by click and dragging the mouse") + "</td></tr>" + "</table>" + "</body>" + "</html>";
    }

    @Override
    public boolean userControlsOpacity() {
        return true;
    }

    @Override
    public void initLayer() {
        this.lbl = new JLabel(MapShortcutsLayer.getShortcutsHtml());
        this.lbl.setOpaque(true);
        this.lbl.setBackground(Color.black);
        this.lbl.setBackground(new Color(255, 255, 255, 200));
    }

    @Override
    public void cleanLayer() {
    }
}

