/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LblConfig;
import pt.lsts.imc.LblRangeAcceptance;
import pt.lsts.imc.PlanControlState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCSendMessageUtils;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.MessageDeliveryListener;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.events.ConsoleEventPlanChange;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.console.plugins.IPlanSelection;
import pt.lsts.neptus.console.plugins.ITransponderSelection;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.console.plugins.planning.MissionTreePlanDbAdapter;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBControl;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBInfo;
import pt.lsts.neptus.gui.LocationPanel;
import pt.lsts.neptus.gui.MissionBrowser;
import pt.lsts.neptus.gui.MissionTreeModel;
import pt.lsts.neptus.gui.tree.ExtendedTreeNode;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.NameId;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.HomeReferenceElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;

@PluginDescription(name="Mission Tree", author="Jos\u00e9 Pinto, Paulo Dias, Margarida Faria", icon="pt/up/fe/dceg/neptus/plugins/planning/mission_tree.png", category=PluginDescription.CATEGORY.PLANNING, version="1.5.0")
public class MissionTreePanel
extends ConsolePanel
implements MissionChangeListener,
MainVehicleChangeListener,
DropTargetListener,
NeptusMessageListener,
IPlanSelection,
IPeriodicUpdates,
ConfigurationListener,
ITransponderSelection {
    @NeptusProperty(name="Use Plan DB Sync. Features", userLevel=NeptusProperty.LEVEL.ADVANCED, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public boolean usePlanDBSyncFeatures = true;
    @NeptusProperty(name="Use Plan DB Sync. Features Extended", userLevel=NeptusProperty.LEVEL.ADVANCED, distribution=NeptusProperty.DistributionEnum.DEVELOPER, description="Needs 'Use Plan DB Sync. Features' on")
    public boolean usePlanDBSyncFeaturesExt = false;
    @NeptusProperty(name="Debug", userLevel=NeptusProperty.LEVEL.ADVANCED, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public boolean debugOn = false;
    @NeptusProperty(name="Acceptable Elapsed Time", description="Maximum acceptable interval between beacon ranges, in seconds.")
    public int maxAcceptableElapsedTime = 600;
    private MissionTreeMouse mouseAdapter;
    private boolean running = false;
    boolean inited = false;
    protected MissionBrowser browser = new MissionBrowser();
    protected PlanDBControl pdbControl;
    protected MissionTreePlanDbAdapter planDBListener = new MissionTreePlanDbAdapter(this.getConsole(), this);

    public MissionTreePanel(ConsoleLayout console) {
        super(console);
        this.browser.setMaxAcceptableElapsedTime(this.maxAcceptableElapsedTime);
        this.removeAll();
        this.setPreferredSize(new Dimension(150, 400));
        this.setMinimumSize(new Dimension(0, 0));
        this.setMaximumSize(new Dimension(1000, 1000));
        this.setLayout(new BorderLayout());
        this.add((Component)this.browser, "Center");
        new DropTarget(this.browser, this).setActive(true);
        this.setupListeners();
    }

    public void setupListeners() {
        this.browser.addTreeListener(this.getConsole());
        this.mouseAdapter = new MissionTreeMouse();
        this.browser.addMouseAdapter(this.mouseAdapter);
    }

    public boolean removePlanMenuItem(String label) {
        return this.mouseAdapter.removePlanMenuItem(label);
    }

    @Override
    public void cleanSubPanel() {
        this.removePlanDBListener();
    }

    @Override
    public void missionReplaced(MissionType mission) {
        this.browser.refreshBrowser(this.getConsole().getMission(), this.getMainVehicleId(), this.getConsole());
    }

    @Override
    public void missionUpdated(MissionType mission) {
        Object selItemOld = this.browser.getSelectedItem();
        this.browser.refreshBrowser(this.getConsole().getMission(), this.getMainVehicleId(), this.getConsole());
        Object selItem = this.browser.getSelectedItem();
        if (selItemOld instanceof PlanDBInfo && selItem instanceof PlanType) {
            this.getConsole().setPlan((PlanType)selItem);
        }
    }

    @Override
    public void initSubPanel() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.updatePlanDBListener(this.getMainVehicleId());
        this.browser.refreshBrowser(this.getConsole().getMission(), this.getMainVehicleId(), this.getConsole());
        this.planDBListener.setDebugOn(this.debugOn);
        this.addClearPlanDbMenuItem();
    }

    private void addClearPlanDbMenuItem() {
        this.addMenuItem(I18n.text("Advanced") + ">" + I18n.text("Clear remote PlanDB for main system"), new ImageIcon(PluginUtils.getPluginIcon(this.getClass())), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MissionTreePanel.this.pdbControl != null) {
                    MissionTreePanel.this.pdbControl.clearDatabase();
                }
            }
        });
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public String[] getObservedMessages() {
        String[] messages = new String[4];
        messages[0] = "LblRangeAcceptance";
        messages[1] = "PlanControlState";
        messages[2] = "LblConfig";
        if (IMCDefinition.getInstance().getMessageId("PlanSpecification") != -1) {
            messages[3] = "PlanSpecification";
        }
        return messages;
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange evt) {
        this.running = false;
        this.updatePlanDBListener(evt.getCurrent());
        this.askForBeaconConfig();
        this.browser.refreshBrowser(this.getConsole().getMission(), this.getMainVehicleId(), this.getConsole());
    }

    private void askForBeaconConfig() {
        SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    LblConfig msgLBLConfiguration = new LblConfig();
                    msgLBLConfiguration.setOp(LblConfig.OP.GET_CFG);
                    IMCSendMessageUtils.sendMessage((IMCMessage)msgLBLConfiguration, I18n.textf("Could not ask %vehicle for it's accoustic beacons.", MissionTreePanel.this.getMainVehicleId()), true, MissionTreePanel.this.getMainVehicleId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        sw.run();
    }

    private void updatePlanDBListener(String id) {
        this.removePlanDBListener();
        ImcSystem sys = ImcSystemsHolder.lookupSystemByName(id);
        if (sys == null) {
            this.pdbControl = null;
            NeptusLog.pub().error((Object)("The main vehicle selected " + id + " is not in the vehicles-defs folder. Please add definitions file for this vehicle."));
        } else {
            this.pdbControl = sys.getPlanDBControl();
            if (this.pdbControl == null) {
                this.pdbControl = new PlanDBControl();
                this.pdbControl.setRemoteSystemId(id);
            }
            this.pdbControl.addListener(this.planDBListener);
        }
    }

    private void removePlanDBListener() {
        if (this.pdbControl != null) {
            this.pdbControl.removeListener(this.planDBListener);
        }
    }

    @Override
    public Vector<PlanType> getSelectedPlans() {
        ArrayList<NameId> selectedItems = this.browser.getSelectedItems();
        Vector<PlanType> plans = new Vector<PlanType>();
        if (selectedItems.size() > 0) {
            for (NameId o : selectedItems) {
                if (!(o instanceof PlanType)) continue;
                plans.add((PlanType)o);
            }
        }
        if (plans.isEmpty() && this.getConsole().getPlan() != null) {
            plans.add(this.getConsole().getPlan());
        }
        return plans;
    }

    @Override
    public Collection<TransponderElement> getSelectedTransponders() {
        ArrayList<ExtendedTreeNode> selectedNodes = this.browser.getSelectedNodes();
        ArrayList<TransponderElement> trans = new ArrayList<TransponderElement>();
        for (ExtendedTreeNode node : selectedNodes) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof TransponderElement) || node.getUserInfo().get((Object)MissionTreeModel.NodeInfoKey.SYNC) == MissionBrowser.State.REMOTE) continue;
            trans.add((TransponderElement)userObject);
        }
        return trans;
    }

    @Override
    public void messageArrived(IMCMessage message) {
        int mgid = message.getMgid();
        switch (mgid) {
            case 551: {
                PlanType plan = IMCUtils.parsePlanSpecification(this.getConsole().getMission(), message);
                if (this.getConsole().getMission().getIndividualPlansList().containsKey(plan.getId())) break;
                this.getConsole().getMission().getIndividualPlansList().put(plan.getId(), plan);
                this.getConsole().updateMissionListeners();
                this.getConsole().getMission().save(true);
                break;
            }
            case 560: {
                PlanControlState planState = (PlanControlState)message;
                if (planState.getState() == PlanControlState.STATE.READY || planState.getState() == PlanControlState.STATE.BLOCKED) {
                    this.browser.transStopTimers();
                    this.running = false;
                    break;
                }
                if (this.running) break;
                this.browser.transStartVehicleTimers(this.getMainVehicleId());
                this.running = true;
                break;
            }
            case 357: {
                try {
                    LblRangeAcceptance acceptance = LblRangeAcceptance.clone((IMCMessage)message);
                    short id = acceptance.getId();
                    this.browser.transUpdateTimer(id, this.getMainVehicleId());
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)"Problem cloning a message.", (Throwable)e);
                }
                break;
            }
            case 203: {
                LblConfig lblConfig = (LblConfig)message;
                if (((LblConfig)message).getOp() != LblConfig.OP.CUR_CFG) break;
                this.browser.updateTransStateEDT(this.getConsole().getMission(), this.getMainVehicleId(), (Vector)lblConfig.getBeacons().clone(), this.getConsole());
                break;
            }
            default: {
                NeptusLog.pub().error((Object)("Unknown message " + mgid));
            }
        }
    }

    @Override
    public long millisBetweenUpdates() {
        return 900L;
    }

    @Override
    public boolean update() {
        if (this.running) {
            this.repaint();
        }
        return true;
    }

    @Subscribe
    public void on(ConsoleEventPlanChange event) {
        this.browser.setSelectedPlan(event.getCurrent());
    }

    @Override
    public void propertiesChanged() {
        this.browser.setDebugOn(this.debugOn);
        this.planDBListener.setDebugOn(this.debugOn);
        this.browser.setMaxAcceptableElapsedTime(this.maxAcceptableElapsedTime);
    }

    private static enum ItemTypes {
        Plans,
        HomeRef,
        Transponder,
        Mix,
        None;

    }

    class ActionItem {
        public String label;
        public ActionListener action;

        ActionItem() {
        }
    }

    class MissionTreeMouse
    extends MouseAdapter {
        private Container popupMenu;
        MessageDeliveryListener listener = new MessageDeliveryListener(){
            int tries = 0;
            private final int maxAttemps = 3;

            private String getDest(IMCMessage message) {
                ImcSystem sys = message != null ? ImcSystemsHolder.lookupSystem(message.getDst()) : null;
                String dest = sys != null ? sys.getName() : I18n.text("unknown destination");
                return dest;
            }

            private void processDeliveryFailure(IMCMessage message, String errorText) {
                if (3 < this.tries) {
                    this.tries = 0;
                    MissionTreePanel.this.post(Notification.error(I18n.text("Delivering Message"), errorText));
                } else {
                    ++this.tries;
                    MissionTreeMouse.this.sendMsg(message);
                }
            }

            @Override
            public void deliveryUnreacheable(IMCMessage message) {
                this.processDeliveryFailure(message, I18n.textf("Message %messageType to %destination delivery destination unreacheable", message.getAbbrev(), this.getDest(message)));
            }

            @Override
            public void deliveryTimeOut(IMCMessage message) {
                this.processDeliveryFailure(message, I18n.textf("Message %messageType to %destination delivery timeout", message.getAbbrev(), this.getDest(message)));
            }

            @Override
            public void deliveryError(IMCMessage message, Object error) {
                this.processDeliveryFailure(message, I18n.text(I18n.textf("Message %messageType to %destination delivery error. (%error)", message.getAbbrev(), this.getDest(message), error)));
            }

            @Override
            public void deliveryUncertain(IMCMessage message, Object msg) {
            }

            @Override
            public void deliverySuccess(IMCMessage message) {
                this.tries = 0;
            }
        };

        MissionTreeMouse() {
        }

        public boolean removePlanMenuItem(String label) {
            int componentCount = this.popupMenu.getComponentCount();
            for (int c = 0; c < componentCount; ++c) {
                String labelM;
                Component component = this.popupMenu.getComponent(c);
                if (!(component instanceof JMenuItem) || !(labelM = ((JMenuItem)component).getText()).equals(I18n.text(label))) continue;
                this.popupMenu.remove(component);
                return true;
            }
            return false;
        }

        private void addActionSendPlan(final ConsoleLayout console2, final PlanDBControl pdbControl, final ArrayList<NameId> selectedItems, JPopupMenu popupMenu) {
            popupMenu.add(I18n.textf("Send %planName to %system", this.getPlanNamesString(selectedItems), console2.getMainSystem())).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (NameId nameId : selectedItems) {
                        PlanType sel = (PlanType)nameId;
                        String mainSystem = console2.getMainSystem();
                        pdbControl.setRemoteSystemId(mainSystem);
                        pdbControl.sendPlan(sel);
                    }
                }
            });
        }

        private <T extends NameId> StringBuilder getPlanNamesString(ArrayList<T> selectedItems) {
            StringBuilder planNames = new StringBuilder();
            if (selectedItems.size() > 3) {
                planNames.append(selectedItems.size() + " plans");
                return planNames;
            }
            Iterator<T> it = selectedItems.iterator();
            if (!it.hasNext()) {
                return planNames;
            }
            while (true) {
                NameId e = (NameId)it.next();
                planNames.append(e.getDisplayName());
                if (!it.hasNext()) {
                    return planNames;
                }
                planNames.append(',').append(' ');
            }
        }

        private void addActionRemovePlanLocally(final ConsoleLayout console2, final ArrayList<NameId> selectedItems, JPopupMenu popupMenu) {
            final StringBuilder itemsInString = this.getPlanNamesString(selectedItems);
            popupMenu.add(I18n.textf("Delete %planName locally", itemsInString)).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int resp = JOptionPane.showConfirmDialog(console2, I18n.textf("Remove %planName from mission?", itemsInString));
                    if (resp == 0) {
                        for (NameId nameId : selectedItems) {
                            console2.getMission().getIndividualPlansList().remove(nameId.getIdentification());
                            MissionTreePanel.this.browser.deleteCurrSelectedNodeLocally();
                        }
                        console2.setPlan(null);
                        console2.getMission().save(false);
                    }
                }
            });
        }

        private void addActionGetRemotePlan(ConsoleLayout console2, final PlanDBControl pdbControl, final ArrayList<NameId> remotePlans, JPopupMenu popupMenu) {
            StringBuilder itemsInString = this.getPlanNamesString(remotePlans);
            popupMenu.add(I18n.textf("Get %planName from %system", itemsInString, console2.getMainSystem())).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (NameId nameId : remotePlans) {
                        pdbControl.requestPlan(nameId.getIdentification());
                    }
                }
            });
        }

        private void addActionGetRemoteTrans(ConsoleLayout console2, JPopupMenu popupMenu, final ArrayList<NameId> remoteTrans) {
            StringBuilder itemsInString = this.getPlanNamesString(remoteTrans);
            popupMenu.add(I18n.textf("Get %planName from %system", itemsInString, console2.getMainSystem())).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MissionTreePanel.this.browser.addTransToMerge(remoteTrans);
                    LblConfig msgLBLConfiguration = new LblConfig();
                    msgLBLConfiguration.setOp(LblConfig.OP.GET_CFG);
                    MissionTreeMouse.this.sendMsg((IMCMessage)msgLBLConfiguration);
                }
            });
        }

        private void addActionRemovePlanRemotely(final ConsoleLayout console2, final PlanDBControl pdbControl, final ArrayList<NameId> synAndUnsyncPlans, JPopupMenu popupMenu) {
            popupMenu.add(I18n.textf("Remove '%planName' from %system", this.getPlanNamesString(synAndUnsyncPlans), console2.getMainSystem())).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    pdbControl.setRemoteSystemId(console2.getMainSystem());
                    for (NameId nameId : synAndUnsyncPlans) {
                        pdbControl.deletePlan(nameId.getIdentification());
                    }
                }
            });
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 3) {
                return;
            }
            ArrayList<NameId> selectedItems = MissionTreePanel.this.browser.getSelectedItems();
            ArrayList<ExtendedTreeNode> selectedNodes = MissionTreePanel.this.browser.getSelectedNodes();
            JPopupMenu popupMenu = new JPopupMenu();
            ArrayList<NameId> toShare = new ArrayList<NameId>();
            ItemTypes selecType = this.findSelecMissionElem(selectedItems);
            switch (selecType) {
                case Plans: {
                    popupMenu.addSeparator();
                    ArrayList<NameId> toRemoveLocally = new ArrayList<NameId>();
                    ArrayList<NameId> toRemoveRemotely = new ArrayList<NameId>();
                    ArrayList<NameId> toGetPlan = new ArrayList<NameId>();
                    ArrayList<NameId> toSend = new ArrayList<NameId>();
                    for (ExtendedTreeNode extendedTreeNode : selectedNodes) {
                        MissionBrowser.State syncState = (MissionBrowser.State)((Object)extendedTreeNode.getUserInfo().get(MissionTreeModel.NodeInfoKey.SYNC.name()));
                        if (syncState != null) {
                            switch (syncState) {
                                case REMOTE: {
                                    toRemoveRemotely.add((NameId)extendedTreeNode.getUserObject());
                                    toGetPlan.add((NameId)extendedTreeNode.getUserObject());
                                    break;
                                }
                                case SYNC: {
                                    toRemoveRemotely.add((NameId)extendedTreeNode.getUserObject());
                                    toRemoveLocally.add((NameId)extendedTreeNode.getUserObject());
                                    toShare.add((NameId)extendedTreeNode.getUserObject());
                                    break;
                                }
                                case NOT_SYNC: {
                                    toRemoveRemotely.add((NameId)extendedTreeNode.getUserObject());
                                    toRemoveLocally.add((NameId)extendedTreeNode.getUserObject());
                                    toSend.add((NameId)extendedTreeNode.getUserObject());
                                    toGetPlan.add((NameId)extendedTreeNode.getUserObject());
                                    toShare.add((NameId)extendedTreeNode.getUserObject());
                                    break;
                                }
                                case LOCAL: {
                                    toRemoveLocally.add((NameId)extendedTreeNode.getUserObject());
                                    toSend.add((NameId)extendedTreeNode.getUserObject());
                                }
                            }
                            continue;
                        }
                        NeptusLog.pub().error((Object)("The plan " + extendedTreeNode + " has no state."));
                    }
                    if (toRemoveRemotely.size() > 0) {
                        this.addActionRemovePlanRemotely(MissionTreePanel.this.getConsole(), MissionTreePanel.this.pdbControl, toRemoveRemotely, popupMenu);
                    }
                    if (toRemoveLocally.size() > 0) {
                        this.addActionRemovePlanLocally(MissionTreePanel.this.getConsole(), toRemoveLocally, popupMenu);
                    }
                    if (toSend.size() > 0) {
                        this.addActionSendPlan(MissionTreePanel.this.getConsole(), MissionTreePanel.this.pdbControl, toSend, popupMenu);
                    }
                    if (toGetPlan.size() <= 0) break;
                    this.addActionGetRemotePlan(MissionTreePanel.this.getConsole(), MissionTreePanel.this.pdbControl, toGetPlan, popupMenu);
                    break;
                }
                case Transponder: {
                    this.addActionAddNewTrans(popupMenu);
                    this.addActionRemoveAllTrans(popupMenu);
                    if (selectedItems.size() == 1) {
                        this.addActionEditTrans((TransponderElement)selectedItems.get(0), popupMenu);
                    }
                    ArrayList<TransponderElement> localTrans = new ArrayList<TransponderElement>();
                    ArrayList<NameId> notSyncTrans = new ArrayList<NameId>();
                    for (ExtendedTreeNode extendedTreeNode : selectedNodes) {
                        MissionBrowser.State state = (MissionBrowser.State)((Object)extendedTreeNode.getUserInfo().get(MissionTreeModel.NodeInfoKey.SYNC.name()));
                        toShare.add((NameId)extendedTreeNode.getUserObject());
                        if (state == MissionBrowser.State.LOCAL) {
                            localTrans.add((TransponderElement)extendedTreeNode.getUserObject());
                        }
                        if (state != MissionBrowser.State.NOT_SYNC) continue;
                        notSyncTrans.add((TransponderElement)extendedTreeNode.getUserObject());
                    }
                    if (localTrans.size() > 0) {
                        this.addActionRemoveTrans(localTrans, popupMenu);
                    }
                    if (notSyncTrans.size() > 0) {
                        this.addActionGetRemoteTrans(MissionTreePanel.this.getConsole(), popupMenu, notSyncTrans);
                    }
                    JMenu switchM = new JMenu(I18n.text("Switch"));
                    ArrayList<TransponderElement> transponders = MissionTreePanel.this.browser.getTransponders();
                    if (transponders.size() <= 0) break;
                    for (int iA = 0; iA < transponders.size(); ++iA) {
                        TransponderElement transA = transponders.get(iA);
                        for (int iB = iA + 1; iB < transponders.size(); ++iB) {
                            TransponderElement transB = transponders.get(iB);
                            if (transA.getDisplayName().equals(transB.getDisplayName())) continue;
                            this.addActionSwitchTrans(transA, switchM, transB);
                        }
                    }
                    popupMenu.add(switchM);
                    break;
                }
                case HomeRef: {
                    this.addActionEditHomeRef(selectedItems.get(0), popupMenu);
                    break;
                }
                case Mix: 
                case None: {
                    String parentName;
                    if (selectedNodes.size() != 1 || !(parentName = (String)selectedNodes.get(0).getUserObject()).equals(MissionTreeModel.ParentNodes.TRANSPONDERS.nodeName)) break;
                    this.addActionAddNewTrans(popupMenu);
                    this.addActionRemoveAllTrans(popupMenu);
                    break;
                }
            }
            popupMenu.addSeparator();
            if (toShare.size() > 0) {
                this.addActionShare(toShare, popupMenu);
            }
            if (Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null) != null) {
                this.addActionPasteUrl(popupMenu);
            }
            this.addActionReloadPanel(popupMenu);
            popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }

        private void addActionRemoveAllTrans(JPopupMenu popupMenu) {
            popupMenu.add(I18n.text("Remove all transponders from vehicle")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LblConfig msgLBLConfiguration = new LblConfig();
                    msgLBLConfiguration.setOp(LblConfig.OP.SET_CFG);
                    msgLBLConfiguration.setBeacons(new Vector());
                    MissionTreeMouse.this.sendMsg((IMCMessage)msgLBLConfiguration);
                    msgLBLConfiguration = new LblConfig();
                    msgLBLConfiguration.setOp(LblConfig.OP.GET_CFG);
                    MissionTreeMouse.this.sendMsg((IMCMessage)msgLBLConfiguration);
                }
            });
        }

        private void sendMsg(IMCMessage msgLBLConfiguration) {
            String errorTextForDialog = I18n.text("Error sending acoustic beacons");
            boolean ignoreAcousticSending = true;
            String acousticOpServiceName = "acoustic/operation";
            boolean acousticOpUseOnlyActive = false;
            boolean acousticOpUserAprovedQuestion = true;
            IMCSendMessageUtils.sendMessage(msgLBLConfiguration, "TCP", this.listener, MissionTreePanel.this, errorTextForDialog, ignoreAcousticSending, acousticOpServiceName, acousticOpUseOnlyActive, acousticOpUserAprovedQuestion, MissionTreePanel.this.getMainVehicleId());
        }

        private ItemTypes findSelecMissionElem(ArrayList<NameId> selectedItems) {
            ItemTypes type = ItemTypes.None;
            for (NameId item : selectedItems) {
                if (item instanceof PlanType || item instanceof PlanDBInfo) {
                    if (type == ItemTypes.Plans || type == ItemTypes.None) {
                        type = ItemTypes.Plans;
                        continue;
                    }
                    type = ItemTypes.Mix;
                    continue;
                }
                if (item instanceof HomeReference) {
                    if (type == ItemTypes.HomeRef || type == ItemTypes.None) {
                        type = ItemTypes.HomeRef;
                        continue;
                    }
                    type = ItemTypes.Mix;
                    continue;
                }
                if (!(item instanceof TransponderElement)) continue;
                if (type == ItemTypes.Transponder || type == ItemTypes.None) {
                    type = ItemTypes.Transponder;
                    continue;
                }
                type = ItemTypes.Mix;
            }
            return type;
        }

        private void addActionReloadPanel(JPopupMenu popupMenu) {
            popupMenu.add(I18n.text("Reload Panel")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MissionTreePanel.this.browser.refreshBrowser(MissionTreePanel.this.getConsole().getMission(), MissionTreePanel.this.getMainVehicleId(), MissionTreePanel.this.getConsole());
                }
            });
        }

        private void addActionEditHomeRef(final Object selection, JPopupMenu popupMenu) {
            popupMenu.add(I18n.text("View/Edit home reference")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LocationType loc = new LocationType((HomeReference)selection);
                    LocationType after = LocationPanel.showLocationDialog(MissionTreePanel.this.getConsole(), I18n.text("Set home reference"), loc, MissionTreePanel.this.getConsole().getMission(), true);
                    if (after == null) {
                        return;
                    }
                    MissionTreePanel.this.getConsole().getMission().getHomeRef().setLocation(after);
                    Vector<HomeReferenceElement> hrefElems = MapGroup.getMapGroupInstance(MissionTreePanel.this.getConsole().getMission()).getAllObjectsOfType(HomeReferenceElement.class);
                    hrefElems.get(0).setCoordinateSystem(MissionTreePanel.this.getConsole().getMission().getHomeRef());
                    MissionTreePanel.this.getConsole().getMission().save(false);
                    MissionTreePanel.this.getConsole().updateMissionListeners();
                }
            });
        }

        private void addActionSwitchTrans(final TransponderElement selection, JMenu popupMenu, final TransponderElement tel) {
            popupMenu.add(I18n.textf("Switch %transponderName1 with %transponderName2", selection.getDisplayName(), tel.getDisplayName())).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            MissionTreePanel.this.browser.swithLocationsTransponder(selection, tel, MissionTreePanel.this.getConsole());
                        }
                    }.start();
                }
            });
        }

        private void addActionRemoveTrans(final ArrayList<TransponderElement> selectedTrans, JPopupMenu popupMenu) {
            StringBuilder itemsInString = this.getPlanNamesString(selectedTrans);
            popupMenu.add(I18n.textf("Remove %transponderName", itemsInString)).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (TransponderElement transponderElement : selectedTrans) {
                        MissionTreePanel.this.browser.removeTransponder(transponderElement, MissionTreePanel.this.getConsole());
                    }
                }
            });
        }

        private void addActionEditTrans(final TransponderElement selection, JPopupMenu popupMenu) {
            popupMenu.add(I18n.textf("View/Edit %transponderName", selection.getDisplayName())).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MissionTreePanel.this.browser.editTransponder(selection, MissionTreePanel.this.getConsole().getMission(), MissionTreePanel.this.getMainVehicleId());
                }
            });
        }

        private void addActionShare(final ArrayList<NameId> selectedItems, JPopupMenu popupMenu2) {
            StringBuilder itemsInString = this.getPlanNamesString(selectedItems);
            popupMenu2.add(I18n.textf("Share %planName", itemsInString)).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (NameId nameId : selectedItems) {
                        MissionTreePanel.this.getConsole().getImcMsgManager().broadcastToCCUs(((PlanType)nameId).asIMCPlan());
                    }
                }
            });
        }

        private void addActionAddNewTrans(JPopupMenu popupMenu) {
            popupMenu.add(I18n.text("Add a new transponder")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MissionTreePanel.this.browser.addTransponderElement(MissionTreePanel.this.getConsole());
                }
            });
        }

        private void addActionPasteUrl(JPopupMenu popupMenu2) {
            popupMenu2.add(I18n.text("Paste URL")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (MissionTreePanel.this.browser.setContent(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null), MissionTreePanel.this.getConsole().getMission())) {
                        MissionTreePanel.this.getConsole().updateMissionListeners();
                    }
                }
            });
        }
    }
}

