/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TreeMap;
import javax.swing.tree.TreePath;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.plugins.planning.MissionTreePanel;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBAdapter;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBState;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.ByteUtil;

public class MissionTreePlanDbAdapter
extends PlanDBAdapter {
    private ConsoleLayout console;
    private MissionTreePanel missionTree;
    private boolean debugOn = true;

    public MissionTreePlanDbAdapter(ConsoleLayout console, MissionTreePanel missionTree) {
        this.console = console;
        this.missionTree = missionTree;
    }

    @Override
    public void dbCleared() {
    }

    @Override
    public void dbInfoUpdated(PlanDBState updatedInfo) {
        TreeMap<String, PlanType> localPlans;
        TreePath[] selectedNodes = this.missionTree.browser.getSelectionPath();
        try {
            localPlans = this.console.getMission().getIndividualPlansList();
        }
        catch (NullPointerException e) {
            NeptusLog.pub().warn((Object)("I cannot find local plans for " + this.console.getMainSystem()));
            localPlans = new TreeMap();
        }
        this.missionTree.browser.updatePlansStateEDT(localPlans, this.console.getMainSystem());
        this.missionTree.browser.setSelectedNodes(selectedNodes);
    }

    @Override
    public void dbPlanReceived(PlanType spec) {
        PlanType lp = this.console.getMission().getIndividualPlansList().get(spec.getId());
        spec.setMissionType(this.console.getMission());
        this.console.getMission().addPlan(spec);
        this.console.getMission().save(true);
        this.console.updateMissionListeners();
        if (this.debugOn && lp != null) {
            try {
                IMCMessage p1 = lp.asIMCPlan();
                IMCMessage p2 = spec.asIMCPlan();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IMCOutputStream imcOs = new IMCOutputStream((OutputStream)baos);
                IMCDefinition.getInstance().serializeFields(p1, imcOs);
                ByteUtil.dumpAsHex(baos.toByteArray(), System.out);
                ByteUtil.dumpAsHex(p1.payloadMD5(), System.out);
                baos = new ByteArrayOutputStream();
                imcOs = new IMCOutputStream((OutputStream)baos);
                IMCDefinition.getInstance().serializeFields(p2, imcOs);
                ByteUtil.dumpAsHex(baos.toByteArray(), System.out);
                ByteUtil.dumpAsHex(p2.payloadMD5(), System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void dbPlanRemoved(String planId) {
        this.missionTree.browser.removeCurrSelectedNodeRemotely();
    }

    @Override
    public void dbPlanSent(String planId) {
        this.missionTree.browser.setPlanAsSync(planId);
    }

    public void setDebugOn(boolean debugOn) {
        this.debugOn = debugOn;
    }
}

