/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.imc.PlanControlState;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;

@PluginDescription(name="Multi-Vehicle plan overlay")
public class MultiVehiclePlanOverlay
extends ConsolePanel
implements Renderer2DPainter,
MissionChangeListener {
    private static final long serialVersionUID = 1L;
    protected LinkedHashMap<String, String> vehicleToPlanIds = new LinkedHashMap();
    protected LinkedHashMap<String, Vector<LocationType>> planToLocations = new LinkedHashMap();
    protected LinkedHashMap<String, Vector<Point2D>> planPoints = new LinkedHashMap();
    protected double lastZoom;
    protected LocationType lastCenter;
    protected double lastRotation = 0.0;
    protected Vector<StateRenderer2D> renderers = new Vector();

    public MultiVehiclePlanOverlay(ConsoleLayout console) {
        super(console);
    }

    @Override
    public void initSubPanel() {
    }

    @Override
    public void missionReplaced(MissionType mission) {
        this.planToLocations.clear();
        this.planPoints.clear();
    }

    @Override
    public void missionUpdated(MissionType mission) {
        this.planToLocations.clear();
        this.planPoints.clear();
    }

    @Subscribe
    public void consume(PlanControlState pcstate) {
        if (pcstate.getPlanId().isEmpty()) {
            return;
        }
        ImcSystem system = ImcSystemsHolder.lookupSystem(pcstate.getSrc());
        if (system == null) {
            return;
        }
        String sysId = system.getName();
        switch (pcstate.getState()) {
            case INITIALIZING: 
            case EXECUTING: {
                this.vehicleToPlanIds.put(sysId, pcstate.getPlanId());
                break;
            }
            case BLOCKED: 
            case READY: {
                this.vehicleToPlanIds.remove(sysId);
            }
        }
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (!this.renderers.contains(renderer)) {
            this.renderers.add(renderer);
            renderer.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    MultiVehiclePlanOverlay.this.planPoints.clear();
                }
            });
        }
        if ((double)renderer.getZoom() != this.lastZoom || !renderer.getCenter().equals(this.lastCenter) || renderer.getRotation() != this.lastRotation) {
            this.planPoints.clear();
        }
        for (Map.Entry<String, String> entry : this.vehicleToPlanIds.entrySet()) {
            Vector<Point2D> points;
            PlanType pt;
            VehicleType vt = VehiclesHolder.getVehicleById(entry.getKey());
            Color c = Color.GRAY;
            if (vt != null) {
                c = vt.getIconColor();
            }
            if (!this.planToLocations.containsKey(entry.getValue()) && (pt = this.getConsole().getMission().getIndividualPlansList().get(entry.getValue())) != null) {
                this.planToLocations.put(pt.getId(), pt.planPath());
            }
            if ((points = this.planPoints.get(entry.getValue())) == null) {
                points = new Vector();
                Vector<LocationType> planLocs = this.planToLocations.get(entry.getValue());
                if (planLocs == null) continue;
                for (LocationType l : planLocs) {
                    points.add(renderer.getScreenPosition(l));
                }
                this.lastZoom = renderer.getZoom();
                this.lastCenter = new LocationType(renderer.getCenter());
            }
            this.planPoints.put(entry.getValue(), points);
            Point2D prev = null;
            for (Point2D cur : this.planPoints.get(entry.getValue())) {
                g.setColor(c.darker());
                if (prev != null) {
                    g.draw(new Line2D.Double(prev, cur));
                }
                prev = cur;
                g.setColor(c.brighter());
                g.fill(new Ellipse2D.Double(cur.getX() - 2.0, cur.getY() - 2.0, 4.0, 4.0));
            }
        }
    }

    @Override
    public void cleanSubPanel() {
    }
}

