/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.util.Vector;
import java.util.concurrent.PriorityBlockingQueue;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.planning.MultiVehicleTask;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.CustomInteractionSupport;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription(name="MultiVehicle Planner", icon="images/planning/stars.png")
@LayerPriority(priority=90)
public class MultiVehiclePlanner
extends ConsolePanel
implements StateRendererInteraction,
Renderer2DPainter {
    private static final long serialVersionUID = -1620554331443024866L;
    protected InteractionAdapter adapter;
    protected Image stars = ImageUtils.getImage("images/planning/stars.png");
    protected Vector<LocationType> lastClicks = new Vector();
    protected MultiVehicleTask editing = null;
    PriorityBlockingQueue<MultiVehicleTask> tasks = new PriorityBlockingQueue();

    public MultiVehiclePlanner(ConsoleLayout console) {
        super(console);
        this.adapter = new InteractionAdapter(console);
        this.removeAll();
        this.add(new JLabel(new ImageIcon(this.stars)));
    }

    @Override
    public void initSubPanel() {
        Vector<CustomInteractionSupport> panels = this.getConsole().getSubPanelsOfInterface(CustomInteractionSupport.class);
        for (CustomInteractionSupport cis : panels) {
            cis.addInteraction(this);
        }
        Vector<ILayerPainter> renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter p : renderers) {
            p.addPostRenderPainter(this, "Multi-Vehicle planner");
        }
    }

    @Override
    public Image getIconImage() {
        return this.stars;
    }

    @Override
    public Cursor getMouseCursor() {
        return this.adapter.getMouseCursor();
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyPressed(event, source);
    }

    @Override
    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyReleased(event, source);
    }

    @Override
    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyTyped(event, source);
    }

    @Override
    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() == 3) {
            this.lastClicks.clear();
            this.editing = null;
            return;
        }
        if (event.getClickCount() == 2) {
            int size = this.lastClicks.size();
            MultiVehicleTask t = new MultiVehicleTask();
            t.state = MultiVehicleTask.TASK_STATE.ADDED;
            switch (size) {
                case 1: {
                    t.type = MultiVehicleTask.TASK_TYPE.GOTO;
                    t.center = this.lastClicks.get(0);
                    t.depth = 2.0;
                    this.tasks.add(t);
                    break;
                }
                case 2: {
                    t.type = MultiVehicleTask.TASK_TYPE.LOITER;
                    t.center = this.lastClicks.get(0);
                    t.depth = 2.0;
                    t.width = this.lastClicks.get(1).getHorizontalDistanceInMeters(t.center);
                    this.tasks.add(t);
                    break;
                }
                default: {
                    t.type = MultiVehicleTask.TASK_TYPE.SCAN;
                    t.center = new LocationType(this.lastClicks.get(0));
                    t.length = this.lastClicks.get(1).getHorizontalDistanceInMeters(t.center);
                    double[] offsets = this.lastClicks.get(1).getOffsetFrom(this.lastClicks.get(0));
                    t.center.translatePosition(offsets[0] / 2.0, offsets[1] / 2.0, 0.0);
                    t.rotation = this.lastClicks.get(0).getXYAngle(this.lastClicks.get(1));
                    t.depth = 2.0;
                    LocationType l = source.getRealWorldLocation(event.getPoint());
                    t.width = l.getHorizontalDistanceInMeters(this.lastClicks.get(1));
                    this.tasks.add(t);
                }
            }
            this.lastClicks.clear();
            this.editing = null;
            source.repaint();
        } else {
            this.lastClicks.add(source.getRealWorldLocation(event.getPoint()));
        }
    }

    @Override
    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseDragged(event, source);
    }

    @Override
    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseMoved(event, source);
        int size = this.lastClicks.size();
        if (size < 1) {
            return;
        }
        if (size == 1) {
            MultiVehicleTask t = new MultiVehicleTask();
            t.state = MultiVehicleTask.TASK_STATE.EDITING;
            t.type = MultiVehicleTask.TASK_TYPE.LOITER;
            t.center = this.lastClicks.get(0);
            t.depth = 2.0;
            LocationType l = source.getRealWorldLocation(event.getPoint());
            t.width = l.getHorizontalDistanceInMeters(t.center);
            this.editing = t;
            source.repaint();
            return;
        }
        if (size == 2) {
            MultiVehicleTask t = new MultiVehicleTask();
            t.type = MultiVehicleTask.TASK_TYPE.SCAN;
            t.state = MultiVehicleTask.TASK_STATE.EDITING;
            t.center = new LocationType(this.lastClicks.get(0));
            t.length = this.lastClicks.get(1).getHorizontalDistanceInMeters(t.center);
            double[] offsets = this.lastClicks.get(1).getOffsetFrom(this.lastClicks.get(0));
            t.center.translatePosition(offsets[0] / 2.0, offsets[1] / 2.0, 0.0);
            t.rotation = this.lastClicks.get(0).getXYAngle(this.lastClicks.get(1));
            t.depth = 2.0;
            LocationType l = source.getRealWorldLocation(event.getPoint());
            t.width = l.getHorizontalDistanceInMeters(this.lastClicks.get(1));
            this.editing = t;
            source.repaint();
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        this.adapter.mousePressed(event, source);
    }

    @Override
    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseReleased(event, source);
    }

    @Override
    public void wheelMoved(MouseWheelEvent event, StateRenderer2D source) {
        this.adapter.wheelMoved(event, source);
    }

    @Override
    public void mouseExited(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseExited(event, source);
    }

    @Override
    public void focusGained(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusGained(event, source);
    }

    @Override
    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusLost(event, source);
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        for (MultiVehicleTask t : this.tasks) {
            t.paint((Graphics2D)g.create(), renderer);
        }
        if (this.editing != null) {
            this.editing.paint((Graphics2D)g.create(), renderer);
        }
    }

    @Override
    public void setActive(boolean mode, StateRenderer2D source) {
        this.adapter.setActive(mode, source);
    }

    @Override
    public void setAssociatedSwitch(ToolbarSwitch tswitch) {
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        ConsoleParse.consoleLayoutLoader(new File("conf/consoles/multivehicleplanner.ncon").getAbsolutePath());
    }

    @Override
    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
    }

    @Override
    public void cleanSubPanel() {
    }
}

