/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@LayerPriority(priority=50)
public class MultiVehicleTask
implements Renderer2DPainter,
Comparable<MultiVehicleTask> {
    protected TASK_TYPE type = TASK_TYPE.LOITER;
    protected TASK_STATE state = TASK_STATE.EDITING;
    protected LocationType center = null;
    protected double width;
    protected double length;
    protected double depth;
    protected double rotation;
    protected long timeOfCreation;
    protected Vector<LocationType> edges = new Vector();

    public MultiVehicleTask() {
        this.timeOfCreation = System.currentTimeMillis();
    }

    @Override
    public int compareTo(MultiVehicleTask o) {
        return (int)(this.timeOfCreation - o.timeOfCreation);
    }

    public boolean containsPoint(StateRenderer2D renderer, Point2D click) {
        switch (this.type) {
            case LOITER: {
                Point2D pt = renderer.getScreenPosition(this.center);
                return pt.distance(click) < this.width * (double)renderer.getZoom();
            }
            case GOTO: {
                Point2D p = renderer.getScreenPosition(this.center);
                return p.distance(click) < 5.0;
            }
        }
        return false;
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        Point2D pt = renderer.getScreenPosition(this.center);
        g.translate(pt.getX(), pt.getY());
        double zoom = renderer.getZoom();
        Color opaque = Color.white;
        switch (this.state) {
            case ADDED: {
                opaque = Color.yellow;
                break;
            }
            case ATTACHED: {
                opaque = Color.green;
                break;
            }
            case INPROGRESS: {
                opaque = Color.blue;
                break;
            }
            case DONE: {
                opaque = Color.cyan;
                break;
            }
            default: {
                opaque = Color.red;
            }
        }
        Color transp = new Color(opaque.getRed(), opaque.getGreen(), opaque.getBlue(), 100);
        switch (this.type) {
            case LOITER: {
                g.setColor(transp);
                Ellipse2D.Double e = new Ellipse2D.Double(-this.getWidth() * zoom, -this.getWidth() * zoom, this.getWidth() * 2.0 * zoom, this.getWidth() * 2.0 * zoom);
                g.fill(e);
                g.setColor(opaque);
                g.draw(e);
                g.draw(new Line2D.Double(-5.0, -5.0, 5.0, 5.0));
                g.draw(new Line2D.Double(-5.0, 5.0, 5.0, -5.0));
                break;
            }
            case GOTO: {
                g.setColor(opaque);
                g.draw(new Line2D.Double(-5.0, -5.0, 5.0, 5.0));
                g.draw(new Line2D.Double(-5.0, 5.0, 5.0, -5.0));
                break;
            }
            case SCAN: {
                g.rotate(this.rotation);
                Rectangle2D.Double r = new Rectangle2D.Double(-this.getWidth() / 2.0 * zoom, -this.getLength() / 2.0 * zoom, this.getWidth() * zoom, this.getLength() * zoom);
                g.setColor(transp);
                g.fill(r);
                g.setColor(opaque);
                g.draw(r);
                break;
            }
        }
    }

    public TASK_TYPE getType() {
        return this.type;
    }

    public void setType(TASK_TYPE type) {
        this.type = type;
    }

    public TASK_STATE getState() {
        return this.state;
    }

    public void setState(TASK_STATE state) {
        this.state = state;
    }

    public LocationType getCenter() {
        return this.center;
    }

    public void setCenter(LocationType center) {
        this.center = center;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public static enum TASK_STATE {
        EDITING,
        ADDED,
        ATTACHED,
        INPROGRESS,
        DONE;

    }

    public static enum TASK_TYPE {
        LOITER,
        GOTO,
        SCAN;

    }
}

