/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedHashMap;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.plugins.planning.MapPanel;
import pt.lsts.neptus.console.plugins.planning.PCCWaypoint;
import pt.lsts.neptus.console.plugins.planning.UavPiccoloControl;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ColorUtils;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.conf.ConfigFetch;

@LayerPriority(priority=40)
public class PCCWaypointPainter
implements Renderer2DPainter {
    protected boolean paintEnable = true;
    protected boolean paintHandoverWP = true;
    protected boolean paintExternalWP = false;
    protected LinkedHashMap<String, LinkedHashMap<Integer, PCCWaypoint>> waypoints = new LinkedHashMap();
    protected LinkedHashMap<String, Boolean> showWaypoints = new LinkedHashMap();
    protected LinkedHashMap<String, LocationType> vehiclePositionList = new LinkedHashMap();
    protected float thickness = 10.0f;
    protected GeneralPath endTriangle = new GeneralPath();
    protected LinkedHashMap<String, Integer> toWaypoints = new LinkedHashMap();
    protected LinkedHashMap<String, Integer> fromWaypoints = new LinkedHashMap();
    protected LinkedHashMap<String, Integer> serviceWaypoints = new LinkedHashMap();
    protected LinkedHashMap<String, UavPiccoloControl.WaypointColors> colorsWaypoints = new LinkedHashMap();
    protected LinkedHashMap<String, UavPiccoloControl.PiccoloControlConfiguration> configsWaypoints = new LinkedHashMap();
    protected String mainVehicle = "";
    public UavPiccoloControl.WaypointColors colors;

    public PCCWaypointPainter() {
        this.endTriangle.moveTo(0.0f, 0.0f);
        this.endTriangle.lineTo(-4.0f * this.thickness, 2.0f * this.thickness);
        this.endTriangle.lineTo(-4.0f * this.thickness, -2.0f * this.thickness);
        this.endTriangle.closePath();
    }

    public String getMainVehicle() {
        return this.mainVehicle;
    }

    public void setMainVehicle(String mainVehicle) {
        this.mainVehicle = mainVehicle == null ? "" : mainVehicle;
    }

    public LinkedHashMap<String, UavPiccoloControl.PiccoloControlConfiguration> getConfigsWaypoints() {
        return this.configsWaypoints;
    }

    public void setConfigsWaypoints(LinkedHashMap<String, UavPiccoloControl.PiccoloControlConfiguration> configsWaypoints) {
        this.configsWaypoints = configsWaypoints;
    }

    public boolean isPaintEnable() {
        return this.paintEnable;
    }

    public void setPaintEnable(boolean paintEnable) {
        this.paintEnable = paintEnable;
    }

    public boolean isPaintHandoverWP() {
        return this.paintHandoverWP;
    }

    public void setPaintHandoverWP(boolean paintHandoverWP) {
        this.paintHandoverWP = paintHandoverWP;
    }

    public boolean isPaintExternalWP() {
        return this.paintExternalWP;
    }

    public void setPaintExternalWP(boolean paintExternalWP) {
        this.paintExternalWP = paintExternalWP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVehicleWaypointsVisible(String vehicle) {
        boolean ret = true;
        LinkedHashMap<String, Boolean> linkedHashMap = this.showWaypoints;
        synchronized (linkedHashMap) {
            if (this.showWaypoints.containsKey(vehicle)) {
                ret = this.showWaypoints.get(vehicle);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVehicleWaypointsVisible(String vehicle, boolean visible) {
        LinkedHashMap<String, Boolean> linkedHashMap = this.showWaypoints;
        synchronized (linkedHashMap) {
            this.showWaypoints.put(vehicle, visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVehiclesList() {
        String[] ret;
        LinkedHashMap<String, LinkedHashMap<Integer, PCCWaypoint>> linkedHashMap = this.waypoints;
        synchronized (linkedHashMap) {
            ret = this.waypoints.keySet().toArray(new String[this.waypoints.keySet().size()]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasVehicle(String id) {
        boolean ret = false;
        LinkedHashMap<String, LinkedHashMap<Integer, PCCWaypoint>> linkedHashMap = this.waypoints;
        synchronized (linkedHashMap) {
            ret = this.waypoints.containsKey(id);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintPlan(Graphics2D g, StateRenderer2D renderer, String vehicle) {
        if (!this.isPaintEnable()) {
            return;
        }
        if (!this.isVehicleWaypointsVisible(vehicle)) {
            return;
        }
        boolean drawnActive = false;
        Color c1 = VehiclesHolder.getVehicleById(vehicle).getIconColor();
        Color c2 = c1.brighter();
        LinkedHashMap wpts = new LinkedHashMap();
        LinkedHashMap<String, LinkedHashMap<Integer, PCCWaypoint>> linkedHashMap = this.waypoints;
        synchronized (linkedHashMap) {
            wpts.putAll(this.waypoints.get(vehicle));
        }
        UavPiccoloControl.PiccoloControlConfiguration config = this.configsWaypoints.get(vehicle);
        Integer dst = this.toWaypoints.get(vehicle);
        Integer src = this.fromWaypoints.get(vehicle);
        UavPiccoloControl.WaypointColors wpcTmp = this.colorsWaypoints.get(vehicle);
        if (wpcTmp != null) {
            // empty if block
        }
        int destinationWaypoint = dst != null ? dst : -1;
        int sourceWaypoint = src != null ? src : -1;
        for (PCCWaypoint wpt : wpts.values()) {
            Color fillColor;
            boolean active = false;
            if (wpt.radius > 0.0f && destinationWaypoint == wpt.number) {
                active = true;
            } else if (sourceWaypoint == wpt.number && wpt.next == destinationWaypoint) {
                active = true;
            }
            if (active) {
                drawnActive = true;
            }
            Color color = fillColor = active ? c2 : c1;
            if (active && this.getMainVehicle().equalsIgnoreCase(vehicle)) {
                fillColor = Color.MAGENTA;
            }
            if (!active && destinationWaypoint != wpt.number && config != null && (!this.paintHandoverWP && config.isHandhoverWP((short)wpt.number) || !this.paintExternalWP && config.isExternalWP((short)wpt.number))) continue;
            Color lineColor = Color.black;
            Point2D finish = null;
            Point2D start = renderer.getScreenPosition(wpt.location);
            double radius = wpt.radius * renderer.getZoom();
            if (wpts.containsKey(wpt.next)) {
                try {
                    finish = renderer.getScreenPosition(((PCCWaypoint)wpts.get((Object)Integer.valueOf((int)wpt.next))).location);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    finish = start;
                }
            } else {
                finish = start;
            }
            double dist = start.distance(finish);
            Area arrow = new Area(new Rectangle2D.Double(0.0, -this.thickness / 2.0f, dist - (double)(2.0f * this.thickness), this.thickness));
            Graphics2D clone = (Graphics2D)g.create();
            clone.translate(start.getX(), start.getY());
            if (!finish.equals(start)) {
                clone.rotate(Math.atan2(finish.getY() - start.getY(), finish.getX() - start.getX()));
            }
            AffineTransform trans = new AffineTransform();
            trans.translate(dist, 0.0);
            if (!finish.equals(start)) {
                arrow.add(new Area(this.endTriangle).createTransformedArea(trans));
            }
            clone.setColor(fillColor);
            clone.fill(arrow);
            clone.setColor(lineColor);
            clone.draw(arrow);
            if (!(wpt.radius > 0.0f)) continue;
            boolean paintRadius = true;
            if (destinationWaypoint != wpt.number && config != null && config.isServiceWP((short)wpt.number)) {
                paintRadius = false;
            }
            if (!paintRadius) continue;
            Area loiterArea = new Area(new Ellipse2D.Double(start.getX() - radius - (double)(this.thickness / 2.0f), start.getY() - radius - (double)(this.thickness / 2.0f), radius * 2.0 + (double)this.thickness, radius * 2.0 + (double)this.thickness));
            loiterArea.subtract(new Area(new Ellipse2D.Double(start.getX() - radius + (double)(this.thickness / 2.0f), start.getY() - radius + (double)(this.thickness / 2.0f), radius * 2.0 - (double)this.thickness, radius * 2.0 - (double)this.thickness)));
            g.setColor(fillColor);
            g.fill(loiterArea);
            g.setColor(lineColor);
            g.draw(loiterArea);
        }
        if (!drawnActive && wpts.get(destinationWaypoint) != null) {
            LocationType dest = ((PCCWaypoint)wpts.get((Object)Integer.valueOf((int)destinationWaypoint))).location;
            LocationType vehiclePosition = this.vehiclePositionList.get(vehicle);
            if (vehiclePosition != null) {
                Point2D start = renderer.getScreenPosition(vehiclePosition);
                Point2D finish = renderer.getScreenPosition(dest);
                double dist = start.distance(finish);
                Area arrow = new Area(new Rectangle2D.Double(0.0, -this.thickness / 2.0f, dist - (double)(2.0f * this.thickness), this.thickness));
                Graphics2D clone = (Graphics2D)g.create();
                clone.translate(start.getX(), start.getY());
                if (!finish.equals(start)) {
                    clone.rotate(Math.atan2(finish.getY() - start.getY(), finish.getX() - start.getX()));
                }
                AffineTransform trans = new AffineTransform();
                trans.translate(dist, 0.0);
                if (!finish.equals(start)) {
                    arrow.add(new Area(this.endTriangle).createTransformedArea(trans));
                }
                clone.setColor(Color.magenta);
                clone.fill(arrow);
                clone.setColor(Color.red.darker());
                clone.draw(arrow);
            }
        }
        for (PCCWaypoint wpt : wpts.values()) {
            Point2D start = renderer.getScreenPosition(wpt.location);
            if (destinationWaypoint != wpt.number && config != null && (!this.paintHandoverWP && config.isHandhoverWP((short)wpt.number) || !this.paintExternalWP && config.isExternalWP((short)wpt.number))) continue;
            String str = "" + wpt.number;
            if (config != null) {
                str = config.isServiceWP((short)wpt.number) ? "____S" + wpt.number : (config.isPlanWP((short)wpt.number) ? "P" + wpt.number : (config.isHandhoverWP((short)wpt.number) ? "H" + wpt.number : "E" + wpt.number));
            }
            if (start == null) continue;
            if (destinationWaypoint == wpt.number) {
                g.setColor(Color.black);
                g.drawString(str, (int)start.getX() + 1, (int)start.getY() + 1);
                g.setColor(new Color(255, 128, 128));
                g.drawString(str, (int)start.getX(), (int)start.getY());
                continue;
            }
            Color bColor = Color.black;
            Color fColor = Color.yellow.brighter();
            if (!this.getMainVehicle().equalsIgnoreCase(vehicle)) {
                fColor = ColorUtils.setTransparencyToColor(c1, 220);
                bColor = ColorUtils.invertColor(c1, 220);
            }
            g.setColor(bColor);
            g.drawString(str, (int)start.getX() + 1, (int)start.getY() + 1);
            g.setColor(fColor);
            g.drawString(str, (int)start.getX(), (int)start.getY());
        }
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (!this.isPaintEnable()) {
            return;
        }
        Font beforeFont = g.getFont();
        g.setFont(new Font("Helvetica", 1, 14 + (int)this.thickness));
        for (String v : this.waypoints.keySet()) {
            this.paintPlan(g, renderer, v);
        }
        g.setFont(beforeFont);
    }

    public LinkedHashMap<Integer, PCCWaypoint> getWaypoints(String vid) {
        return (LinkedHashMap)this.waypoints.get(vid).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaypoints(String vid, Collection<PCCWaypoint> waypts) {
        LinkedHashMap<String, LinkedHashMap<Integer, PCCWaypoint>> linkedHashMap = this.waypoints;
        synchronized (linkedHashMap) {
            LinkedHashMap<Integer, PCCWaypoint> values = this.waypoints.get(vid);
            if (values == null) {
                values = this.waypoints.put(vid, new LinkedHashMap());
            }
            for (PCCWaypoint wpt : waypts) {
                values.put(wpt.number, wpt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaypoint(String vid, PCCWaypoint waypoint) {
        LinkedHashMap<Integer, PCCWaypoint> values = this.waypoints.get(vid);
        if (values == null) {
            LinkedHashMap<String, LinkedHashMap<Integer, PCCWaypoint>> linkedHashMap = this.waypoints;
            synchronized (linkedHashMap) {
                values = new LinkedHashMap();
                this.waypoints.put(vid, values);
            }
        }
        values.put(waypoint.number, waypoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWaypoint(String vid, int number) {
        LinkedHashMap<String, LinkedHashMap<Integer, PCCWaypoint>> linkedHashMap = this.waypoints;
        synchronized (linkedHashMap) {
            this.waypoints.get(vid).remove(number);
        }
    }

    public int getDestinationWaypoint(String vid) {
        Integer ret = this.toWaypoints.get(vid);
        return ret == null ? -1 : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestinationWaypoint(String vid, int destinationWaypoint) {
        this.toWaypoints.put(vid, destinationWaypoint);
        LinkedHashMap<String, LinkedHashMap<Integer, PCCWaypoint>> linkedHashMap = this.waypoints;
        synchronized (linkedHashMap) {
            if (this.waypoints.get(vid) == null) {
                this.waypoints.put(vid, new LinkedHashMap());
            }
        }
    }

    public int getSourceWaypoint(String vid) {
        Integer ret = this.fromWaypoints.get(vid);
        return ret == null ? -1 : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceWaypoint(String vid, int sourceWaypoint) {
        this.fromWaypoints.put(vid, sourceWaypoint);
        LinkedHashMap<String, LinkedHashMap<Integer, PCCWaypoint>> linkedHashMap = this.waypoints;
        synchronized (linkedHashMap) {
            if (this.waypoints.get(vid) == null) {
                this.waypoints.put(vid, new LinkedHashMap());
            }
        }
    }

    public void setVehiclePosition(String vid, LocationType vehiclePosition) {
        this.vehiclePositionList.put(vid, vehiclePosition);
    }

    public float getThickness() {
        return this.thickness;
    }

    public void setThickness(float thickness) {
        this.thickness = thickness;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(-4.0f * thickness, 2.0f * thickness);
        gp.lineTo(-4.0f * thickness, -2.0f * thickness);
        gp.closePath();
        this.endTriangle = gp;
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        VehiclesHolder.loadVehicles();
        IMCMessage wpt = IMCDefinition.getInstance().create("PiccoloWaypoint", new Object[]{"index", 0, "lat", 0, "lon", 1.0E-5, "depth", 0, "next", 2});
        wpt.getHeader().setValue("src", (Object)47906);
        IMCMessage wpt2 = IMCDefinition.getInstance().create("PiccoloWaypoint", new Object[]{"index", 2, "lat", 0.003, "lon", 0.001, "depth", 0, "next", 1});
        wpt2.getHeader().setValue("src", (Object)47906);
        IMCMessage wpt3 = IMCDefinition.getInstance().create("PiccoloWaypoint", new Object[]{"index", 1, "lat", 0, "lon", 0, "depth", 0, "lradius", 300, "ltime", 100, "next", 4});
        wpt3.getHeader().setValue("src", (Object)47906);
        IMCMessage track = IMCDefinition.getInstance().create("PiccoloTrackingState", new Object[]{"to", 2, "from", 3});
        track.getHeader().setValue("src", (Object)47906);
        IMCMessage wpt1_1 = IMCDefinition.getInstance().create("PiccoloWaypoint", new Object[]{"index", 0, "lat", 0, "lon", 3.0E-5, "depth", 0, "next", 1});
        wpt1_1.getHeader().setValue("src", (Object)47907);
        IMCMessage wpt1_2 = IMCDefinition.getInstance().create("PiccoloWaypoint", new Object[]{"index", 1, "lat", 0.0024, "lon", 0.0014, "depth", 0, "next", 0});
        wpt1_2.getHeader().setValue("src", (Object)47907);
        IMCMessage track_1 = IMCDefinition.getInstance().create("PiccoloTrackingState", new Object[]{"to", 0, "from", 1});
        track_1.getHeader().setValue("src", (Object)47907);
        MapPanel planPanel = new MapPanel(null);
        LocationType loc = new LocationType();
        loc.setLatitudeDegs(41.0);
        loc.setLongitudeDegs(-8.0);
        loc.translatePosition(50.0, 35.0, 0.0);
        LocationType loc1 = new LocationType();
        loc1.setLatitudeDegs(41.0);
        loc1.setLongitudeDegs(-8.0);
        loc1.translatePosition(150.0, 85.0, 0.0);
        planPanel.getRenderer().setCenter(loc);
        UavPiccoloControl pp = new UavPiccoloControl(null);
        pp.propertiesChanged();
        pp.wptPainter.setVehiclePosition("alfa02", loc);
        pp.wptPainter.setVehiclePosition("alfa03", loc1);
        pp.onMessage(null, wpt);
        pp.onMessage(null, wpt2);
        pp.onMessage(null, wpt3);
        pp.onMessage(null, track);
        pp.onMessage(null, wpt1_1);
        pp.onMessage(null, wpt1_2);
        pp.onMessage(null, track_1);
        ConsoleParse.dummyConsole(planPanel, pp);
    }
}

