/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PathControlState;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.messages.MessageFilter;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription(name="PathControlLayer")
@LayerPriority(priority=-5)
public class PathControlLayer
extends ConsolePanel
implements Renderer2DPainter {
    @NeptusProperty(name="Consider start of path to be the vehicle's position")
    public boolean startFromCurrentLocation = true;
    private static final long serialVersionUID = 1L;
    protected final int pcontrol_id = IMCDefinition.getInstance().getMessageId("PathControlState");
    protected Map<Integer, PathControlState> lastMsgs = Collections.synchronizedMap(new LinkedHashMap());

    public PathControlLayer(ConsoleLayout console) {
        super(console);
    }

    @Override
    public void initSubPanel() {
        ImcMsgManager.getManager().addListener(this, (MessageFilter)new MessageFilter<MessageInfo, IMCMessage>(){

            @Override
            public boolean isMessageToListen(MessageInfo info, IMCMessage msg) {
                return msg.getMgid() == PathControlLayer.this.pcontrol_id;
            }
        });
    }

    @Override
    public void cleanSubPanel() {
        ImcMsgManager.getManager().removeListener(this);
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        for (PathControlState pcs : this.lastMsgs.values()) {
            LocationType dest = new LocationType(Math.toDegrees(pcs.getEndLat()), Math.toDegrees(pcs.getEndLon()));
            LocationType src = new LocationType(Math.toDegrees(pcs.getStartLat()), Math.toDegrees(pcs.getStartLon()));
            ImcSystem system = ImcSystemsHolder.lookupSystem(pcs.getSrc());
            Point2D pt = renderer.getScreenPosition(dest);
            g.setColor(Color.black);
            g.draw(new Ellipse2D.Double(pt.getX() - 5.0, pt.getY() - 5.0, 10.0, 10.0));
            if (system == null) continue;
            if (this.startFromCurrentLocation) {
                src = system.getLocation();
            }
            Point2D ptSrc = renderer.getScreenPosition(src);
            g.draw(new Line2D.Double(ptSrc, pt));
        }
    }

    @Subscribe
    public void consume(PathControlState pcs) {
        this.lastMsgs.put(pcs.getSrc(), pcs);
    }
}

