/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import pt.lsts.neptus.console.plugins.planning.UavPiccoloControl;
import pt.lsts.neptus.util.GuiUtils;

public class PiccoloControlConfigurationPanel
extends JPanel {
    private UavPiccoloControl.PiccoloControlConfiguration config = null;
    private JFormattedTextField planWpMinText;
    private JFormattedTextField planWpMaxText;
    private JFormattedTextField handoverWpMinText;
    private JFormattedTextField handoverWpMaxText;
    private JFormattedTextField serviceWpRadiusText;
    private JFormattedTextField serviceWpAltitudeText;
    private JFormattedTextField serviceWpSpeedText;
    private JLabel planWpLabel;
    private JLabel handoverWpLabel;
    private JLabel bracketsLabel1;
    private JLabel bracketsLabel2;
    private JLabel bracketsLabel3;
    private JLabel bracketsLabel4;
    private JLabel commaLabel1;
    private JLabel commaLabel2;
    private JLabel serviceWpLabel;
    private JLabel serviceWpRadiusLabel;
    private JLabel serviceWpAltitudeLabel;
    private JLabel serviceWpSpeedLabel;
    boolean userCanceled = false;

    public PiccoloControlConfigurationPanel() {
        this.initialize();
    }

    private void initialize() {
        this.planWpLabel = new JLabel("Plan waypoints:");
        this.handoverWpLabel = new JLabel("Handover waypoints:");
        this.bracketsLabel1 = new JLabel("[");
        this.bracketsLabel2 = new JLabel("]");
        this.bracketsLabel3 = new JLabel("[");
        this.bracketsLabel4 = new JLabel("]");
        this.commaLabel1 = new JLabel(", ");
        this.commaLabel2 = new JLabel(", ");
        this.serviceWpLabel = new JLabel("Service waypoint");
        this.serviceWpRadiusLabel = new JLabel("Radius (m):");
        this.serviceWpAltitudeLabel = new JLabel("Altitude (m):");
        this.serviceWpSpeedLabel = new JLabel("Speed (m/s):");
        this.planWpMinText = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.planWpMaxText = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.handoverWpMinText = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.handoverWpMaxText = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.serviceWpRadiusText = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.serviceWpAltitudeText = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.serviceWpSpeedText = new JFormattedTextField(NumberFormat.getNumberInstance());
        GroupLayout layout = new GroupLayout(this);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.planWpLabel).addComponent(this.bracketsLabel1).addGap(2).addComponent(this.planWpMinText, 40, 70, Short.MAX_VALUE).addGap(2).addComponent(this.commaLabel1).addGap(2).addComponent(this.planWpMaxText, 40, 70, Short.MAX_VALUE).addGap(2).addComponent(this.bracketsLabel2)).addGroup(layout.createSequentialGroup().addComponent(this.handoverWpLabel).addComponent(this.bracketsLabel3).addGap(2).addComponent(this.handoverWpMinText, 40, 70, Short.MAX_VALUE).addGap(2).addComponent(this.commaLabel2).addGap(2).addComponent(this.handoverWpMaxText, 40, 70, Short.MAX_VALUE).addGap(2).addComponent(this.bracketsLabel4))).addGroup(layout.createParallelGroup().addComponent(this.serviceWpLabel).addGroup(layout.createSequentialGroup().addComponent(this.serviceWpRadiusLabel).addComponent(this.serviceWpRadiusText, 80, 200, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.serviceWpAltitudeLabel).addComponent(this.serviceWpAltitudeText, 80, 200, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.serviceWpSpeedLabel).addComponent(this.serviceWpSpeedText, 80, 200, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.planWpLabel).addComponent(this.bracketsLabel1).addComponent(this.planWpMinText).addComponent(this.commaLabel1).addComponent(this.planWpMaxText).addComponent(this.bracketsLabel2)).addGroup(layout.createParallelGroup().addComponent(this.handoverWpLabel).addComponent(this.bracketsLabel3).addComponent(this.handoverWpMinText).addComponent(this.commaLabel2).addComponent(this.handoverWpMaxText).addComponent(this.bracketsLabel4))).addGroup(layout.createSequentialGroup().addComponent(this.serviceWpLabel).addGroup(layout.createParallelGroup().addComponent(this.serviceWpRadiusLabel).addComponent(this.serviceWpRadiusText)).addGroup(layout.createParallelGroup().addComponent(this.serviceWpAltitudeLabel).addComponent(this.serviceWpAltitudeText)).addGroup(layout.createParallelGroup().addComponent(this.serviceWpSpeedLabel).addComponent(this.serviceWpSpeedText))));
        layout.linkSize(1, this.planWpLabel, this.planWpMinText, this.planWpMaxText, this.handoverWpLabel, this.handoverWpMinText, this.handoverWpMaxText, this.serviceWpRadiusText, this.serviceWpAltitudeText, this.serviceWpSpeedText);
        layout.linkSize(0, this.planWpLabel, this.handoverWpLabel);
        layout.linkSize(0, this.serviceWpRadiusLabel, this.serviceWpAltitudeLabel, this.serviceWpSpeedLabel);
    }

    public UavPiccoloControl.PiccoloControlConfiguration getConfiguration() {
        if (this.config == null) {
            return new UavPiccoloControl.PiccoloControlConfiguration();
        }
        this.getConfigurationWorker(this.config);
        return this.config;
    }

    public UavPiccoloControl.PiccoloControlConfiguration getConfigurationWorker(UavPiccoloControl.PiccoloControlConfiguration config) {
        config.setPlanWpMin((short)Integer.parseInt(this.planWpMinText.getText()));
        config.setPlanWpMax((short)Integer.parseInt(this.planWpMaxText.getText()));
        config.setHandoverWpMin((short)Integer.parseInt(this.handoverWpMinText.getText()));
        config.setHandoverWpMax((short)Integer.parseInt(this.handoverWpMaxText.getText()));
        config.setServiceRadius(Double.parseDouble(this.serviceWpRadiusText.getText()));
        config.setServiceAltitude(Double.parseDouble(this.serviceWpAltitudeText.getText()));
        config.setServiceSpeed(Double.parseDouble(this.serviceWpSpeedText.getText()));
        return config;
    }

    public void setConfiguration(UavPiccoloControl.PiccoloControlConfiguration config) {
        this.config = config;
        this.planWpMinText.setText("" + this.config.planWpMin);
        this.planWpMaxText.setText("" + this.config.planWpMax);
        this.handoverWpMinText.setText("" + this.config.handoverWpMin);
        this.handoverWpMaxText.setText("" + this.config.handoverWpMax);
        this.serviceWpRadiusText.setText("" + this.config.serviceRadius);
        this.serviceWpAltitudeText.setText("" + this.config.serviceAltitude);
        this.serviceWpSpeedText.setText("" + this.config.serviceSpeed);
    }

    public String[] validateConfiguration() {
        Vector<String> list = new Vector<String>();
        UavPiccoloControl.PiccoloControlConfiguration cfg = new UavPiccoloControl.PiccoloControlConfiguration();
        this.getConfigurationWorker(cfg);
        if (cfg.planWpMin < -1 || cfg.planWpMin > 99) {
            list.add("planWpMin should be in [-1, 99] range");
        }
        if (cfg.planWpMax < -1 || cfg.planWpMax > 99) {
            list.add("planWpMax should be in [-1, 99] range");
        }
        if (cfg.handoverWpMin < -1 || cfg.handoverWpMin > 99) {
            list.add("handoverWpMin should be in [-1, 99] range");
        }
        if (cfg.handoverWpMax < -1 || cfg.handoverWpMax > 99) {
            list.add("handoverWpMax should be in [-1, 99] range");
        }
        if (cfg.planWpMax < cfg.planWpMin) {
            list.add("planWpMax is higher than planWpMin");
        }
        if (cfg.handoverWpMax < cfg.handoverWpMin) {
            list.add("handoverWpMax is higher than handoverWpMin");
        }
        if (list.size() == 0 && (cfg.planWpMin != -1 || cfg.planWpMax != -1 || cfg.handoverWpMin != -1 || cfg.handoverWpMax != -1) && (cfg.planWpMin <= cfg.handoverWpMin && cfg.handoverWpMin <= cfg.planWpMax || cfg.planWpMin <= cfg.handoverWpMax && cfg.handoverWpMax <= cfg.planWpMax)) {
            list.add("plan and handover ranges are overlapping");
        }
        return list.toArray(new String[list.size()]);
    }

    public UavPiccoloControl.PiccoloControlConfiguration showEditPanel(UavPiccoloControl.PiccoloControlConfiguration source, Window parent) {
        this.userCanceled = false;
        this.setConfiguration(source);
        final JDialog dialog = new JDialog(parent, "Set Configurations");
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setDefaultCloseOperation(2);
        dialog.add(this);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PiccoloControlConfigurationPanel.this.userCanceled = true;
            }
        });
        final JButton okButton = new JButton(new AbstractAction("Ok"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PiccoloControlConfigurationPanel.this.userCanceled = false;
                dialog.dispose();
            }
        });
        GuiUtils.reactEnterKeyPress(okButton);
        dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                okButton.requestFocusInWindow();
            }
        });
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PiccoloControlConfigurationPanel.this.userCanceled = true;
                dialog.dispose();
            }
        });
        GuiUtils.reactEscapeKeyPress(cancelButton);
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 2));
        jp.add(okButton);
        jp.add(cancelButton);
        dialog.add((Component)jp, "South");
        dialog.pack();
        GuiUtils.centerParent(dialog, parent);
        dialog.setVisible(true);
        if (!this.userCanceled) {
            String[] errors = this.validateConfiguration();
            if (errors.length == 0) {
                return this.getConfiguration();
            }
            String message = "";
            for (String msg : errors) {
                message = message + msg + "\n";
            }
            JOptionPane.showMessageDialog(parent, message, "Configuration not valid", 0);
            return this.showEditPanel(source, parent);
        }
        return null;
    }

    public static void main(String[] args) {
        new PiccoloControlConfigurationPanel().showEditPanel(new UavPiccoloControl.PiccoloControlConfiguration(), new JFrame());
    }
}

