/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import pt.lsts.imc.AcousticOperation;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LblBeacon;
import pt.lsts.imc.LblConfig;
import pt.lsts.imc.PlanControl;
import pt.lsts.imc.PlanDB;
import pt.lsts.imc.Teleoperation;
import pt.lsts.imc.TeleoperationDone;
import pt.lsts.imc.VehicleState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCSendMessageUtils;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.MessageDeliveryListener;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.console.plugins.IPlanSelection;
import pt.lsts.neptus.console.plugins.ITransponderSelection;
import pt.lsts.neptus.console.plugins.LockableSubPanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.SystemsList;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBState;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.gui.system.btn.SystemsSelectionAction;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.map.TransponderUtils;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;

@PluginDescription(name="Plan Control", author="Paulo Dias", version="1.2.3", documentation="plan-control/plan-control.html#PlanControl", category=PluginDescription.CATEGORY.INTERFACE)
public class PlanControlPanel
extends ConsolePanel
implements ConfigurationListener,
MainVehicleChangeListener,
LockableSubPanel,
IPeriodicUpdates,
NeptusMessageListener {
    protected static final boolean DONT_USE_ACOUSTICS = true;
    protected static final boolean USE_ACOUSTICS = false;
    private final ImageIcon ICON_BEACONS = ImageUtils.getIcon("images/planning/uploadBeacons.png");
    private final ImageIcon ICON_UP = ImageUtils.getIcon("images/planning/up.png");
    private final ImageIcon ICON_DOWN_R = ImageUtils.getIcon("images/planning/fileimport.png");
    private final ImageIcon ICON_START = ImageUtils.getIcon("images/planning/start.png");
    private final ImageIcon ICON_STOP = ImageUtils.getIcon("images/planning/stop.png");
    private final ImageIcon ICON_TELEOP_ON = ImageUtils.getScaledIcon("images/planning/teleoperation.png", 32, 32);
    private final ImageIcon ICON_TELEOP_OFF = ImageUtils.getScaledIcon("images/planning/teleoperation-off.png", 32, 32);
    private final String startTeleOperationStr = I18n.text("Start Tele-Operation");
    private final String stopTeleOperationStr = I18n.text("Stop Tele-Operation");
    private final String startPlanStr = I18n.text("Start Plan");
    private final String stopPlanStr = I18n.text("Stop Plan");
    private final String sendAcousticBeaconsStr = I18n.text("Send Acoustic Beacons");
    private final String sendSelectedPlanStr = I18n.text("Send Selected Plan");
    private final String downloadActivePlanStr = I18n.text("Download Active Plan");
    @NeptusProperty(name="Font Size Multiplier", description="The font size. Use '1' for default.")
    public int fontMultiplier = 1;
    @NeptusProperty(name="Verify plans for island nodes", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Always runs a verification on the plan for maneuvers that have no input edges. If you choose to switch off here you can allways click Alt when sending the plan that this verification will run.")
    public boolean allwaysVerifyAllManeuversUsed = true;
    @NeptusProperty(name="Service name for acoustic message sending", userLevel=NeptusProperty.LEVEL.ADVANCED, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public String acousticOpServiceName = "acoustic/operation";
    @NeptusProperty(name="Use only active systems for acoustic message sending", userLevel=NeptusProperty.LEVEL.ADVANCED, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public boolean acousticOpUseOnlyActive = false;
    @NeptusProperty(name="Use Full Mode or Teleoperation Mode", userLevel=NeptusProperty.LEVEL.ADVANCED, description="By default this value is true and makes it display all buttons, if false only teleoperation button is shown.")
    public boolean useFullMode = true;
    @NeptusProperty(name="Enable teleoperation button", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Configures if send beacons button is shown or not in Full Mode.")
    public boolean enableTeleopButton = true;
    @NeptusProperty(name="Enable console actions", editable=false)
    public boolean enableConsoleActions = true;
    @NeptusProperty(name="Enable selection button", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Configures if system selection button is active or not")
    public boolean enableSelectionButton = false;
    @NeptusProperty(name="Enable beacons button", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Configures if send beacons button is active or not")
    public boolean enableBeaconsButton = true;
    @NeptusProperty(name="Use Calibration on Start Plan", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public boolean useCalibrationOnStartPlan = true;
    @NeptusProperty(name="Use TCP To Send Messages", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public boolean useTcpToSendMessages = true;
    private JPanel holder;
    private JLabel titleLabel;
    private JLabel planIdLabel;
    private ToolbarButton selectionButton;
    private ToolbarButton sendAcousticsButton;
    private ToolbarButton sendUploadPlanButton;
    private ToolbarButton sendDownloadPlanButton;
    private ToolbarButton sendStartButton;
    private ToolbarButton sendStopButton;
    private ToolbarButton teleOpButton;
    private SystemsSelectionAction selectionAction;
    private AbstractAction sendAcousticsAction;
    private AbstractAction sendUploadPlanAction;
    private AbstractAction sendDownloadPlanAction;
    private AbstractAction sendStartAction;
    private AbstractAction sendStopAction;
    private AbstractAction teleOpAction;
    private int teleoperationManeuver = -1;
    private boolean locked;
    private final LinkedHashMap<Integer, Long> registerRequestIdsTime;
    private final LinkedHashMap<Integer, PlanControl> requests;
    private final String[] messagesToObserve;
    private short requestsCleanupFlag;
    int lastTeleopState;

    public PlanControlPanel(ConsoleLayout console) {
        super(console);
        IMCMessage tomsg = IMCDefinition.getInstance().create("Teleoperation", new Object[0]);
        if (tomsg != null) {
            this.teleoperationManeuver = tomsg.getMgid();
        }
        this.locked = false;
        this.registerRequestIdsTime = new LinkedHashMap();
        this.requests = new LinkedHashMap();
        this.messagesToObserve = new String[]{"PlanControl", "PlanControlState", "VehicleState", "PlanDB", "LblConfig", "AcousticOperation"};
        this.requestsCleanupFlag = 0;
        this.lastTeleopState = 0;
        this.initialize();
    }

    @Override
    public String[] getObservedMessages() {
        return this.messagesToObserve;
    }

    private void initialize() {
        this.initializeActions();
        this.removeAll();
        this.setSize(new Dimension(255, 60));
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(I18n.text(this.getName()));
        this.titleLabel.setFont(new Font("Arial", 1, 9 * this.fontMultiplier));
        this.add((Component)this.titleLabel, "North");
        this.holder = new JPanel();
        this.holder.setLayout(new BoxLayout(this.holder, 2));
        this.add((Component)this.holder, "Center");
        this.planIdLabel = new JLabel("");
        this.add((Component)this.planIdLabel, "South");
        this.selectionButton = new ToolbarButton(this.selectionAction);
        this.sendAcousticsButton = new ToolbarButton(this.sendAcousticsAction);
        this.sendUploadPlanButton = new ToolbarButton(this.sendUploadPlanAction);
        this.sendDownloadPlanButton = new ToolbarButton(this.sendDownloadPlanAction);
        this.sendStartButton = new ToolbarButton(this.sendStartAction);
        this.sendStartButton.setActionCommand(this.startPlanStr);
        this.sendStopButton = new ToolbarButton(this.sendStopAction);
        this.sendStopButton.setActionCommand(this.stopPlanStr);
        this.teleOpButton = new ToolbarButton(this.teleOpAction);
        this.teleOpButton.setActionCommand(this.startTeleOperationStr);
        this.holder.add((Component)((Object)this.selectionButton));
        this.holder.add((Component)((Object)this.sendAcousticsButton));
        this.holder.add((Component)((Object)this.sendUploadPlanButton));
        this.holder.add((Component)((Object)this.sendStartButton));
        this.holder.add((Component)((Object)this.sendStopButton));
        this.holder.add((Component)((Object)this.teleOpButton));
        this.setModeComponentsVisibility();
    }

    public String validateFontMultiplier(int value) {
        if (value <= 0) {
            return I18n.text("Values lower than zero are not valid!");
        }
        if (value > 10) {
            return I18n.text("Values bigger than 10 are not valid!");
        }
        return null;
    }

    private void setModeComponentsVisibility() {
        for (Component comp : this.holder.getComponents()) {
            comp.setVisible(this.useFullMode);
        }
        this.titleLabel.setVisible(this.useFullMode);
        if (this.useFullMode) {
            if (this.enableTeleopButton) {
                this.teleOpButton.setVisible(true);
            } else {
                this.teleOpButton.setVisible(false);
            }
        } else {
            this.teleOpButton.setVisible(true);
        }
        this.selectionButton.setVisible(this.enableSelectionButton && this.useFullMode);
        this.sendAcousticsButton.setVisible(this.enableBeaconsButton && this.useFullMode);
    }

    private void initializeActions() {
        this.selectionAction = new SystemsSelectionAction(I18n.text("Using") + ":", 20);
        this.sendAcousticsAction = new AbstractAction(this.sendAcousticBeaconsStr, this.ICON_BEACONS){

            @Override
            public void actionPerformed(final ActionEvent ev) {
                final Object action = this.getValue("Name");
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        NeptusLog.action().info(action);
                        PlanControlPanel.this.sendAcousticsButton.setEnabled(false);
                        PlanControlPanel.this.sendAcoustics(false, PlanControlPanel.this.getSystemsToSendTo(SystemsSelectionAction.getClearSelectionOption(ev)));
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        PlanControlPanel.this.sendAcousticsButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        };
        this.sendUploadPlanAction = new AbstractAction(this.sendSelectedPlanStr, this.ICON_UP){

            @Override
            public void actionPerformed(final ActionEvent ev) {
                final Object action = this.getValue("Name");
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        NeptusLog.action().info(action);
                        try {
                            PlanControlPanel.this.sendUploadPlanButton.setEnabled(false);
                            boolean verifyAllManeuversUsed = false;
                            if (PlanControlPanel.this.allwaysVerifyAllManeuversUsed || (ev.getModifiers() & 8) == 8) {
                                verifyAllManeuversUsed = true;
                            }
                            PlanControlPanel.this.sendPlan(verifyAllManeuversUsed, PlanControlPanel.this.getSystemsToSendTo(SystemsSelectionAction.getClearSelectionOption(ev)));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        PlanControlPanel.this.sendUploadPlanButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        };
        this.sendDownloadPlanAction = new AbstractAction(this.downloadActivePlanStr, this.ICON_DOWN_R){

            @Override
            public void actionPerformed(final ActionEvent ev) {
                final Object action = this.getValue("Name");
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        NeptusLog.action().info(action);
                        try {
                            PlanControlPanel.this.sendDownloadPlanButton.setEnabled(false);
                            PlanControlPanel.this.sendDownLoadPlan(PlanControlPanel.this.getSystemsToSendTo(SystemsSelectionAction.getClearSelectionOption(ev)));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        PlanControlPanel.this.sendDownloadPlanButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        };
        this.sendStartAction = new AbstractAction(this.startPlanStr, this.ICON_START){

            @Override
            public void actionPerformed(final ActionEvent ev) {
                final Object action = this.getValue("Name");
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        NeptusLog.action().info(action);
                        PlanControlPanel.this.sendStartButton.setEnabled(false);
                        PlanControlPanel.this.sendStartPlan(PlanControlPanel.this.getSystemsToSendTo(SystemsSelectionAction.getClearSelectionOption(ev)));
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        PlanControlPanel.this.sendStartButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        };
        this.sendStopAction = new AbstractAction(this.stopPlanStr, this.ICON_STOP){

            @Override
            public void actionPerformed(final ActionEvent ev) {
                final Object action = this.getValue("Name");
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        NeptusLog.action().info(action);
                        PlanControlPanel.this.sendStopButton.setEnabled(false);
                        PlanControlPanel.this.sendStopPlan(PlanControlPanel.this.getSystemsToSendTo(SystemsSelectionAction.getClearSelectionOption(ev)));
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        PlanControlPanel.this.sendStopButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        };
        this.teleOpAction = new AbstractAction(this.startTeleOperationStr, this.ICON_TELEOP_ON){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object action = this.getValue("Name");
                NeptusLog.action().info(action);
                String[] systems = PlanControlPanel.this.getSystemsToSendTo(SystemsSelectionAction.getClearSelectionOption(e));
                if (PlanControlPanel.this.testAndShowWarningForNoSystemSelection(systems)) {
                    return;
                }
                if (PlanControlPanel.this.startTeleOperationStr.equalsIgnoreCase(e.getActionCommand())) {
                    Teleoperation teleop = new Teleoperation();
                    int reqId = IMCSendMessageUtils.getNextRequestId();
                    PlanControl pc = new PlanControl();
                    pc.setType(PlanControl.TYPE.REQUEST);
                    pc.setOp(PlanControl.OP.START);
                    pc.setRequestId(reqId);
                    pc.setPlanId("teleoperation-mode");
                    pc.setFlags(0);
                    pc.setArg((IMCMessage)teleop);
                    boolean ret = IMCSendMessageUtils.sendMessage((IMCMessage)pc, PlanControlPanel.this.useTcpToSendMessages ? "TCP" : null, PlanControlPanel.this.createDefaultMessageDeliveryListener(), PlanControlPanel.this, I18n.text("Error Initializing Tele-Operation"), true, "", false, true, systems);
                    if (!ret) {
                        PlanControlPanel.this.post(Notification.error(I18n.text("Tele-Operation"), I18n.text("Error sending Tele-Operation message!")));
                    } else {
                        PlanControlPanel.this.registerPlanControlRequest(reqId);
                    }
                } else {
                    boolean ret = IMCSendMessageUtils.sendMessage((IMCMessage)new TeleoperationDone(), PlanControlPanel.this.useTcpToSendMessages ? "TCP" : null, PlanControlPanel.this.createDefaultMessageDeliveryListener(), PlanControlPanel.this, I18n.text("Error sending exiting Tele-Operation message!"), true, "", false, true, systems);
                    if (!ret) {
                        PlanControlPanel.this.post(Notification.error(I18n.text("Tele-Op"), I18n.text("Error sending exiting Tele-Operation message!")));
                    }
                }
            }
        };
    }

    private MessageDeliveryListener createDefaultMessageDeliveryListener() {
        return !this.useTcpToSendMessages ? null : new MessageDeliveryListener(){

            private String getDest(IMCMessage message) {
                ImcSystem sys = message != null ? ImcSystemsHolder.lookupSystem(message.getDst()) : null;
                String dest = sys != null ? sys.getName() : I18n.text("unknown destination");
                return dest;
            }

            @Override
            public void deliveryUnreacheable(IMCMessage message) {
                PlanControlPanel.this.post(Notification.error(I18n.text("Delivering Message"), I18n.textf("Message %messageType to %destination delivery destination unreacheable", message.getAbbrev(), this.getDest(message))));
            }

            @Override
            public void deliveryTimeOut(IMCMessage message) {
                PlanControlPanel.this.post(Notification.error(I18n.text("Delivering Message"), I18n.textf("Message %messageType to %destination delivery timeout", message.getAbbrev(), this.getDest(message))));
            }

            @Override
            public void deliveryError(IMCMessage message, Object error) {
                PlanControlPanel.this.post(Notification.error(I18n.text("Delivering Message"), I18n.textf("Message %messageType to %destination delivery error. (%error)", message.getAbbrev(), this.getDest(message), error)));
            }

            @Override
            public void deliveryUncertain(IMCMessage message, Object msg) {
            }

            @Override
            public void deliverySuccess(IMCMessage message) {
            }
        };
    }

    @Override
    public void initSubPanel() {
        this.setModeComponentsVisibility();
    }

    @Override
    public void propertiesChanged() {
        if (this.fontMultiplier < 1) {
            return;
        }
        this.titleLabel.setFont(new Font("Arial", 1, 9 * this.fontMultiplier));
        this.planIdLabel.setFont(new Font("Arial", 1, 9 * this.fontMultiplier));
        this.setModeComponentsVisibility();
        this.revalidate();
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange ev) {
        this.update();
        this.refreshUI();
    }

    private void refreshUI() {
        boolean bEnable = true;
        if (this.isLocked()) {
            bEnable = false;
        }
        if (bEnable != this.sendAcousticsButton.isEnabled()) {
            for (Component comp : this.holder.getComponents()) {
                comp.setEnabled(bEnable);
            }
        }
    }

    @Override
    public void lock() {
        this.locked = true;
        this.refreshUI();
    }

    @Override
    public void unLock() {
        this.locked = false;
        this.refreshUI();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public long millisBetweenUpdates() {
        return 1000L;
    }

    @Override
    public boolean update() {
        ImcSystem tmp = ImcSystemsHolder.lookupSystemByName(this.getMainVehicleId());
        if (tmp != null) {
            this.refreshUI();
        }
        this.requestsCleanupFlag = (short)(this.requestsCleanupFlag + 1);
        if (this.requestsCleanupFlag > 100) {
            this.requestsCleanupFlag = 0;
            try {
                for (Integer key : this.registerRequestIdsTime.keySet().toArray(new Integer[0])) {
                    if (System.currentTimeMillis() - this.registerRequestIdsTime.get(key) <= 10000L) continue;
                    this.registerRequestIdsTime.remove(key);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private String[] getSystemsToSendTo(boolean clearSelection) {
        if (this.sendToMainOrSelection()) {
            return new String[]{this.getMainVehicleId()};
        }
        Vector<String> selectedSystems = this.getSelectedSystems(clearSelection);
        return selectedSystems.toArray(new String[selectedSystems.size()]);
    }

    private boolean sendToMainOrSelection() {
        return this.selectionAction.getSelectionType() == SystemsSelectionAction.SelectionType.MAIN;
    }

    private Vector<String> getSelectedSystems(boolean clearSelection) {
        Vector<SystemsList> sysLst = this.getConsole().getSubPanelsOfClass(SystemsList.class);
        Vector<String> selectedSystems = new Vector<String>();
        for (SystemsList systemsList : sysLst) {
            selectedSystems.addAll(systemsList.getSelectedSystems(clearSelection));
        }
        return selectedSystems;
    }

    private boolean sendAcoustics(boolean sendBlancTranspondersList, String ... systems) {
        if (!this.checkConditionToRun(this, true, false)) {
            return false;
        }
        if (this.testAndShowWarningForNoSystemSelection(systems)) {
            return false;
        }
        MissionType miss = this.getConsole().getMission();
        ArrayList<TransponderElement> transpondersList = new ArrayList<TransponderElement>();
        if (!sendBlancTranspondersList) {
            LinkedHashMap<String, MapMission> mapList = miss.getMapsList();
            for (MapMission mpm : mapList.values()) {
                transpondersList.addAll(mpm.getMap().getTranspondersList().values());
            }
            TransponderUtils.orderTransponders(transpondersList);
            TransponderElement[] selTransponders = this.getSelectedTransponderElementsFromExternalComponents();
            if (selTransponders.length > 0 && selTransponders.length < transpondersList.size()) {
                String beaconsToSend = "";
                boolean hideComma = true;
                for (TransponderElement tElnt : selTransponders) {
                    beaconsToSend = beaconsToSend + (hideComma ? "" : ", ");
                    beaconsToSend = beaconsToSend + tElnt.getDisplayName();
                    hideComma = false;
                }
                int resp = GuiUtils.confirmDialog(SwingUtilities.windowForComponent(this), I18n.text("LBL Beacons"), I18n.textf("Are you sure you want to send only %beaconsToSend?", beaconsToSend));
                if (resp == 0) {
                    transpondersList.clear();
                    transpondersList.addAll(Arrays.asList(selTransponders));
                } else if (resp == 1) {
                    return false;
                }
            }
        }
        Vector<LblBeacon> lblBeaconsList = new Vector<LblBeacon>();
        if (!sendBlancTranspondersList) {
            for (int i = 0; i < transpondersList.size(); ++i) {
                TransponderElement transp = transpondersList.get(i);
                LblBeacon msgLBLBeaconSetup = TransponderUtils.getTransponderAsLblBeaconMessage(transp);
                if (msgLBLBeaconSetup == null) {
                    this.post(Notification.error(this.sendAcousticsButton.getName(), I18n.textf("Bad configuration parsing for transponder %transponderid!", transp.getId())));
                    return false;
                }
                lblBeaconsList.add(msgLBLBeaconSetup);
            }
        }
        LblConfig msgLBLConfiguration = new LblConfig();
        msgLBLConfiguration.setOp(LblConfig.OP.SET_CFG);
        msgLBLConfiguration.setBeacons(lblBeaconsList);
        IMCSendMessageUtils.sendMessage((IMCMessage)msgLBLConfiguration, this.useTcpToSendMessages ? "TCP" : null, this.createDefaultMessageDeliveryListener(), this, I18n.text("Error sending acoustic beacons"), true, this.acousticOpServiceName, this.acousticOpUseOnlyActive, true, systems);
        final String[] dest = systems;
        SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    Thread.sleep(1000L);
                    LblConfig msgLBLConfiguration = new LblConfig();
                    msgLBLConfiguration.setOp(LblConfig.OP.GET_CFG);
                    IMCSendMessageUtils.sendMessage((IMCMessage)msgLBLConfiguration, PlanControlPanel.this.useTcpToSendMessages ? "TCP" : null, PlanControlPanel.this.createDefaultMessageDeliveryListener(), PlanControlPanel.this, I18n.text("Error sending acoustic beacons"), true, PlanControlPanel.this.acousticOpServiceName, PlanControlPanel.this.acousticOpUseOnlyActive, true, dest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        sw.run();
        if (transpondersList.size() > 0) {
            String missionlog = GuiUtils.getLogFileName("mission_state", "zip");
            miss.asZipFile(missionlog, true);
        }
        return true;
    }

    private boolean sendPlan(boolean verifyAllManeuversUsed, String ... systems) {
        if (!this.checkConditionToRun(this, true, true)) {
            return false;
        }
        if (this.testAndShowWarningForNoSystemSelection(systems)) {
            return false;
        }
        PlanType[] plans = this.getSelectedPlansFromExternalComponents();
        int iSent = 0;
        for (int i = 0; i < plans.length; ++i) {
            PlanType plan = plans[i];
            try {
                if (verifyAllManeuversUsed) {
                    plan.validatePlan();
                }
            }
            catch (Exception e) {
                this.post(Notification.error(I18n.text("Send Plan"), e.getMessage()));
                return false;
            }
            IMCMessage planSpecificationMessage = IMCUtils.generatePlanSpecification(plan);
            if (planSpecificationMessage == null) {
                this.post(Notification.error(I18n.text("Send Plan"), I18n.text("Error sending plan message!\nNo plan spec. valid!")));
            }
            int reqId = IMCSendMessageUtils.getNextRequestId();
            PlanDB pdb = new PlanDB();
            pdb.setType(PlanDB.TYPE.REQUEST);
            pdb.setOp(PlanDB.OP.SET);
            pdb.setRequestId(reqId);
            pdb.setPlanId(plan.getId());
            pdb.setArg(planSpecificationMessage);
            pdb.setInfo("Plan sent by Neptus version " + ConfigFetch.getNeptusVersion());
            this.registerPlanControlRequest(reqId);
            boolean ret = IMCSendMessageUtils.sendMessage((IMCMessage)pdb, this.useTcpToSendMessages ? "TCP" : null, this.createDefaultMessageDeliveryListener(), this, I18n.text("Error sending plan"), true, this.acousticOpServiceName, this.acousticOpUseOnlyActive, true, systems);
            if (!ret) continue;
            ++iSent;
        }
        if (iSent > 0) {
            String missionlog = GuiUtils.getLogFileName("mission_state", "zip");
            this.getConsole().getMission().asZipFile(missionlog, true);
        }
        return true;
    }

    private boolean sendDownLoadPlan(String ... systems) {
        if (!this.checkConditionToRun(this, true, false)) {
            return false;
        }
        if (this.testAndShowWarningForNoSystemSelection(systems)) {
            return false;
        }
        IMCMessage planControlMessage = IMCDefinition.getInstance().create("PlanControl", new Object[0]);
        planControlMessage.setValue("type", (Object)0);
        planControlMessage.setValue("op", (Object)"GET");
        int reqId = IMCSendMessageUtils.getNextRequestId();
        planControlMessage.setValue("request_id", (Object)reqId);
        boolean ret = IMCSendMessageUtils.sendMessage(planControlMessage, this.useTcpToSendMessages ? "TCP" : null, this.createDefaultMessageDeliveryListener(), this, I18n.text("Error sending plan download request"), true, this.acousticOpServiceName, this.acousticOpUseOnlyActive, true, systems);
        if (ret) {
            this.registerPlanControlRequest(reqId);
            PlanControl pc = new PlanControl(planControlMessage);
            try {
                pc.copyFrom(planControlMessage);
                this.requests.put(reqId, pc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private boolean sendStartPlan(String ... systems) {
        return this.sendStartStop(PlanControl.OP.START, systems);
    }

    private boolean sendStopPlan(String ... systems) {
        return this.sendStartStop(PlanControl.OP.STOP, systems);
    }

    private boolean sendStartStop(PlanControl.OP cmd, String ... systems) {
        boolean ret;
        String planId;
        if (!this.checkConditionToRun(this, cmd != PlanControl.OP.START, cmd != PlanControl.OP.STOP)) {
            return false;
        }
        if (this.testAndShowWarningForNoSystemSelection(systems)) {
            return false;
        }
        int reqId = IMCSendMessageUtils.getNextRequestId();
        PlanControl pc = new PlanControl();
        pc.setType(PlanControl.TYPE.REQUEST);
        pc.setRequestId(reqId);
        String cmdStrMsg = "";
        try {
            switch (cmd) {
                case START: {
                    cmdStrMsg = cmdStrMsg + I18n.text("Error sending start plan");
                    PlanType[] plans = this.getSelectedPlansFromExternalComponents();
                    PlanType plan = plans[0];
                    if (!this.verifyIfPlanIsInSyncOnTheSystem(plan, systems)) {
                        if (systems.length == 1) {
                            this.post(Notification.error(I18n.text("Send Start Plan"), "Plan not in sync on system!"));
                        } else {
                            this.post(Notification.error(I18n.text("Send Start Plan"), "Plan not in sync on systems!"));
                        }
                        return false;
                    }
                    pc.setPlanId(plan.getId());
                    if (this.useCalibrationOnStartPlan) {
                        pc.setFlags(1);
                    }
                    break;
                }
                case STOP: {
                    cmdStrMsg = cmdStrMsg + I18n.text("Error sending stopping plan");
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)this, (Throwable)ex);
        }
        pc.setOp(cmd);
        boolean dontSendByAcoustics = true;
        if (cmd == PlanControl.OP.START && (planId = pc.getPlanId()).length() <= GeneralPreferences.maximumSizePlanNameForAcoustics) {
            dontSendByAcoustics = false;
        }
        if (!(ret = IMCSendMessageUtils.sendMessage((IMCMessage)pc, this.useTcpToSendMessages ? "TCP" : null, this.createDefaultMessageDeliveryListener(), this, cmdStrMsg, dontSendByAcoustics, this.acousticOpServiceName, this.acousticOpUseOnlyActive, true, systems))) {
            this.post(Notification.error(I18n.text("Send Plan"), I18n.text("Error sending PlanControl message!")));
            return false;
        }
        this.registerPlanControlRequest(reqId);
        this.requests.put(reqId, pc);
        return true;
    }

    private boolean verifyIfPlanIsInSyncOnTheSystem(PlanType plan, String ... systems) {
        boolean planInSync = true;
        String systemsNotInSync = "";
        for (String sysStr : systems) {
            PlanDBState prs;
            ImcSystem sys = ImcSystemsHolder.lookupSystemByName(sysStr);
            if (sys == null || (prs = sys.getPlanDBControl().getRemoteState()) != null && prs.matchesRemotePlan(plan)) continue;
            planInSync = false;
            systemsNotInSync = systemsNotInSync + (systemsNotInSync.length() > 0 ? ", " : "") + sysStr;
        }
        if (!planInSync) {
            int resp = GuiUtils.confirmDialog(SwingUtilities.windowForComponent(this), I18n.text("Plan not synchronized"), I18n.textf("The plan '%plan' is not synchronized on %system.\nYou should resend the plan.\nDo you still want to start the plan?", plan.getId(), systemsNotInSync));
            planInSync = resp == 0;
        }
        return planInSync;
    }

    private void registerPlanControlRequest(int reqId) {
        this.registerRequestIdsTime.put(reqId, System.currentTimeMillis());
    }

    protected boolean checkConditionToRun(Component component, boolean checkMission, boolean checkPlan) {
        PlanType[] plans;
        MissionType miss;
        if (!ImcMsgManager.getManager().isRunning()) {
            this.post(Notification.error(component.getName(), I18n.text("IMC comms. are not running!")));
            return false;
        }
        ConsoleLayout cons = this.getConsole();
        if (cons == null) {
            this.post(Notification.error(component.getName(), I18n.text("Missing console attached!")));
            return false;
        }
        if (checkMission && (miss = cons.getMission()) == null) {
            this.post(Notification.error(component.getName(), I18n.text("Missing attached mission!")));
            return false;
        }
        if (checkPlan && ((plans = this.getSelectedPlansFromExternalComponents()) == null || plans.length == 0)) {
            this.post(Notification.error(component.getName(), I18n.text("Missing attached plan!")));
            return false;
        }
        return true;
    }

    private PlanType[] getSelectedPlansFromExternalComponents() {
        if (this.getConsole() == null) {
            return new PlanType[0];
        }
        Vector<IPlanSelection> psel = this.getConsole().getSubPanelsOfInterface(IPlanSelection.class);
        if (psel.size() == 0) {
            if (this.getConsole().getPlan() != null) {
                return new PlanType[]{this.getConsole().getPlan()};
            }
            return new PlanType[0];
        }
        Vector<PlanType> vecPlans = psel.get(0).getSelectedPlans();
        return vecPlans.toArray(new PlanType[vecPlans.size()]);
    }

    private TransponderElement[] getSelectedTransponderElementsFromExternalComponents() {
        if (this.getConsole() == null) {
            return new TransponderElement[0];
        }
        Vector<ITransponderSelection> psel = this.getConsole().getSubPanelsOfInterface(ITransponderSelection.class);
        Collection<TransponderElement> vecTrans = psel.get(0).getSelectedTransponders();
        return vecTrans.toArray(new TransponderElement[vecTrans.size()]);
    }

    private boolean testAndShowWarningForNoSystemSelection(String ... systems) {
        return systems.length < 1;
    }

    private String convertTimeSecondsToFormatedStringMillis(double timeSeconds) {
        String tt = "";
        tt = timeSeconds < 60.0 ? MathMiscUtils.parseToEngineeringNotation(timeSeconds, 3) + "s" : DateTimeUtil.milliSecondsToFormatedString((long)(timeSeconds * 1000.0));
        return tt;
    }

    @Override
    public void messageArrived(IMCMessage message) {
        block2 : switch (message.getMgid()) {
            case 559: {
                PlanControl msg = (PlanControl)message;
                try {
                    int reqId;
                    PlanControl.TYPE type = msg.getType();
                    if (type == PlanControl.TYPE.IN_PROGRESS || !this.registerRequestIdsTime.containsKey(reqId = msg.getRequestId())) break;
                    boolean cleanReg = false;
                    if (type == PlanControl.TYPE.SUCCESS) {
                        PlanControl request = this.requests.get(reqId);
                        String text = I18n.textf("Request %d completed successfully.", reqId);
                        String src = ImcSystemsHolder.translateImcIdToSystemName(msg.getSrc());
                        if (request != null) {
                            switch (request.getOp()) {
                                case START: {
                                    text = I18n.textf("Starting of %plan was acknowledged by %system.", request.getPlanId(), src);
                                    break;
                                }
                                case STOP: {
                                    text = I18n.textf("Stopping of %plan was acknowledged by %system.", request.getPlanId(), src);
                                    break;
                                }
                            }
                        }
                        this.post(Notification.success("Plan Control", text));
                        cleanReg = true;
                    } else if (type == PlanControl.TYPE.FAILURE) {
                        cleanReg = true;
                        long requestTimeMillis = this.registerRequestIdsTime.get(reqId);
                        String utcStr = " " + I18n.text("UTC");
                        double deltaTime = (double)(msg.getTimestampMillis() - requestTimeMillis) / 1000.0;
                        this.post(Notification.error(I18n.text("Plan Control Error"), I18n.textf("The following error arrived at @%timeArrived for a request @%timeRequested (\u2206t %deltaTime): %msg", DateTimeUtil.timeFormaterNoMillis2UTC.format(msg.getDate()) + utcStr, DateTimeUtil.timeFormaterNoMillis2UTC.format(new Date(requestTimeMillis)) + utcStr, deltaTime < 0.0 ? "-" : this.convertTimeSecondsToFormatedStringMillis(deltaTime), msg.getInfo())).src(ImcSystemsHolder.translateImcIdToSystemName(msg.getSrc())));
                    }
                    if (!cleanReg) break;
                    this.registerRequestIdsTime.remove(reqId);
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e);
                }
                break;
            }
            case 500: {
                VehicleState vstate = (VehicleState)message;
                VehicleState.OP_MODE mode = vstate.getOpMode();
                int manType = vstate.getManeuverType();
                int teleopState = new String(mode.hashCode() + "," + manType).hashCode();
                if (teleopState != this.lastTeleopState) {
                    if (manType == this.teleoperationManeuver && mode == VehicleState.OP_MODE.MANEUVER) {
                        this.teleOpButton.setActionCommand(this.stopTeleOperationStr);
                        this.teleOpButton.setIcon(this.ICON_TELEOP_OFF);
                        this.teleOpButton.setToolTipText(I18n.text(this.stopTeleOperationStr));
                    } else {
                        this.teleOpButton.setActionCommand(this.startTeleOperationStr);
                        this.teleOpButton.setIcon(this.ICON_TELEOP_ON);
                        this.teleOpButton.setToolTipText(this.startTeleOperationStr);
                    }
                }
                this.lastTeleopState = teleopState;
                break;
            }
            case 556: {
                PlanDB planDb = (PlanDB)message;
                try {
                    int reqId;
                    PlanDB.TYPE type = planDb.getType();
                    if (type == PlanDB.TYPE.IN_PROGRESS || !this.registerRequestIdsTime.containsKey(reqId = planDb.getRequestId())) break;
                    boolean cleanReg = false;
                    if (type == PlanDB.TYPE.SUCCESS) {
                        cleanReg = true;
                    } else if (type == PlanDB.TYPE.FAILURE) {
                        cleanReg = true;
                        long requestTimeMillis = this.registerRequestIdsTime.get(reqId);
                        String utcStr = " " + I18n.text("UTC");
                        double deltaTime = (double)(planDb.getTimestampMillis() - requestTimeMillis) / 1000.0;
                        this.post(Notification.error(I18n.text("Plan DB Error"), I18n.textf("The following error arrived at @%timeArrived for a request @%timeRequested (\u2206t %deltaTime): %msg", DateTimeUtil.timeFormaterNoMillis2UTC.format(planDb.getDate()) + utcStr, DateTimeUtil.timeFormaterNoMillis2UTC.format(new Date(requestTimeMillis)) + utcStr, deltaTime < 0.0 ? "-" : this.convertTimeSecondsToFormatedStringMillis(deltaTime), planDb.getInfo())).src(ImcSystemsHolder.translateImcIdToSystemName(planDb.getSrc())));
                    }
                    if (!cleanReg) break;
                    this.registerRequestIdsTime.remove(reqId);
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e, (Throwable)e);
                }
                break;
            }
            case 211: {
                if (message.getDst() != this.getConsole().getImcMsgManager().getLocalId().intValue()) break;
                AcousticOperation aoMsg = (AcousticOperation)message;
                switch (aoMsg.getOp()) {
                    case MSG_DONE: {
                        this.post(Notification.success("Acoustic Message Send", I18n.textf("Message to %systemName has been sent successfully.", aoMsg.getSystem().toString())));
                        break block2;
                    }
                    case MSG_FAILURE: {
                        this.post(Notification.error("Acoustic Message Send", I18n.textf("Failed to send message to %systemName.", aoMsg.getSystem().toString())));
                        break block2;
                    }
                    case MSG_IP: {
                        this.post(Notification.info("Acoustic Message Send", I18n.textf("Sending message to %systemName...", aoMsg.getSystem().toString())));
                        break block2;
                    }
                    case MSG_QUEUED: {
                        this.post(Notification.warning("Acoustic Message Send", I18n.textf("Message to %systemName has been queued in %manta.", aoMsg.getSystem().toString(), aoMsg.getSourceName())));
                        break block2;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void cleanSubPanel() {
    }
}

