/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PlanControlState;
import pt.lsts.imc.PlanDB;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.Periodic;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Plan Control State", author="Paulo Dias", version="0.7", documentation="plan-control/plan-control.html#PlanControlState")
public class PlanControlStatePanel
extends ConsolePanel {
    private static final long serialVersionUID = 1L;
    private static int count = 0;
    private JLabel stateValueLabel;
    private JLabel stateLabel;
    private JLabel planIdValueLabel;
    private JLabel planIdLabel;
    private JLabel nodeIdValueLabel;
    private JLabel nodeIdLabel;
    private JLabel outcomeTitleLabel;
    private JLabel outcomeLabel;
    private PlanControlState.STATE state;
    private String planId = "";
    private String nodeId = "";
    private String lastOutcome = "<html><font color='0x666666'>" + I18n.text("N/A") + "</font>";
    private int nodeTypeImcId = -1;
    private long nodeStarTimeMillisUTC = -1L;
    private long nodeEtaSec = -1L;
    private long lastUpdated = -1L;
    @NeptusProperty(name="Request plans automatically", userLevel=NeptusProperty.LEVEL.ADVANCED, category="Planning", description="Select if Neptus should ask the vehicle for plans it is executing but Neptus doesn't know about")
    public boolean requestPlans = false;

    public PlanControlStatePanel(ConsoleLayout console) {
        super(console);
        this.removeAll();
        this.initialize();
    }

    private void initialize() {
        this.setSize(200, 200);
        this.setLayout((LayoutManager)new MigLayout("ins 0"));
        this.stateValueLabel = new JLabel();
        this.stateValueLabel.setText("");
        this.stateLabel = new JLabel();
        this.stateLabel.setText("<html><b>" + I18n.text("State") + ": ");
        this.add((Component)this.stateLabel, "");
        this.add((Component)this.stateValueLabel, "wrap");
        this.planIdValueLabel = new JLabel();
        this.planIdValueLabel.setText("");
        this.planIdLabel = new JLabel();
        this.planIdLabel.setText("<html><b>" + I18n.text("Plan") + ": ");
        this.add(this.planIdLabel);
        this.add((Component)this.planIdValueLabel, "wrap");
        this.nodeIdValueLabel = new JLabel();
        this.nodeIdValueLabel.setText("");
        this.nodeIdLabel = new JLabel();
        this.nodeIdLabel.setText("<html><b>" + I18n.textc("Man.", "Maneuver") + ": ");
        this.add(this.nodeIdLabel);
        this.add((Component)this.nodeIdValueLabel, "wrap");
        this.outcomeTitleLabel = new JLabel("<html><b>" + I18n.text("Outcome") + ": ");
        this.outcomeTitleLabel.setHorizontalAlignment(10);
        this.outcomeLabel = new JLabel(this.lastOutcome);
        this.add(this.outcomeTitleLabel);
        this.add((Component)this.outcomeLabel, "wrap");
    }

    @Subscribe
    public void on(PlanControlState msg) {
        if (!this.requestPlans || msg.getPlanId().isEmpty()) {
            return;
        }
        if (!this.getConsole().getMission().getIndividualPlansList().containsKey(msg.getPlanId())) {
            PlanDB pdb = new PlanDB();
            pdb.setOp(PlanDB.OP.GET);
            pdb.setPlanId(msg.getPlanId());
            pdb.setType(PlanDB.TYPE.REQUEST);
            pdb.setRequestId(count++);
            this.send(msg.getSourceName(), (IMCMessage)pdb);
        }
    }

    @Subscribe
    public void consume(PlanControlState message) {
        if (!message.getSourceName().equals(this.getConsole().getMainSystem())) {
            return;
        }
        if (message.getPlanId().isEmpty()) {
            if (message.getPlanProgress() != -1.0) {
                this.outcomeTitleLabel.setText("<html><b>" + I18n.text("Progress") + ": ");
                this.outcomeLabel.setText(GuiUtils.getNeptusDecimalFormat(0).format(message.getPlanProgress()) + " %");
            }
            return;
        }
        try {
            this.planId = message.getPlanId();
            this.nodeId = message.getManId();
            this.nodeTypeImcId = message.getManType();
            this.nodeEtaSec = message.getManEta();
            double progress = -1.0;
            block1 : switch (message.getState()) {
                case READY: 
                case BLOCKED: {
                    this.outcomeTitleLabel.setText("<html><b>" + I18n.text("Outcome") + ": ");
                    switch (message.getLastOutcome()) {
                        case SUCCESS: {
                            this.lastOutcome = "<html><b><font color='#00CC00'>" + I18n.text("Success") + "</font></b>";
                            break block1;
                        }
                        case FAILURE: {
                            this.lastOutcome = "<html><b><font color='#CC0000'>" + I18n.text("Failure") + "</font></b>";
                            break block1;
                        }
                    }
                    this.lastOutcome = "<html><font color='#666666'>" + I18n.text("N/A") + "</font>";
                    break;
                }
                case EXECUTING: {
                    progress = message.getPlanProgress();
                }
                case INITIALIZING: {
                    this.outcomeTitleLabel.setText("<html><b>" + I18n.text("Progress") + ": ");
                    if (progress != -1.0) {
                        this.lastOutcome = GuiUtils.getNeptusDecimalFormat(0).format(message.getPlanProgress()) + " %";
                        break;
                    }
                    this.lastOutcome = "<html><font color='#666666'>" + I18n.text("N/A") + "</font>";
                    break;
                }
                default: {
                    this.outcomeTitleLabel.setText("<html><b>" + I18n.text("Progress") + ": ");
                    this.lastOutcome = "Initializing";
                }
            }
            this.outcomeLabel.setText(this.lastOutcome);
            this.lastUpdated = System.currentTimeMillis();
            this.state = message.getState();
            this.update();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Periodic
    public void update() {
        if (this.state != null) {
            this.stateValueLabel.setText(I18n.text(this.state.toString()));
        }
        String planTimeStr = "";
        this.planIdValueLabel.setText(this.planId + planTimeStr);
        String nodeStr = this.nodeId;
        if (IMCDefinition.getInstance().getMessageName(this.nodeTypeImcId) != null) {
            nodeStr = nodeStr + " <font color='#666666' size='3'>(" + IMCDefinition.getInstance().getMessageName(this.nodeTypeImcId) + ")</font> ";
        }
        String nodeTimeStr = this.nodeStarTimeMillisUTC > 0L ? "@" + DateTimeUtil.timeFormaterNoMillis2.format(new Date(this.nodeStarTimeMillisUTC)) : "";
        String etaStr = this.nodeEtaSec >= 0L && !"".equalsIgnoreCase(nodeTimeStr) && this.nodeEtaSec != 65535L ? " ETA " + DateTimeUtil.milliSecondsToFormatedString(this.nodeEtaSec * 1000L) : "";
        this.nodeIdValueLabel.setText("<html>" + nodeStr + etaStr);
        Color fColor = Color.BLACK;
        if (System.currentTimeMillis() - this.lastUpdated > 5000L) {
            fColor = Color.RED.darker();
        }
        if (!this.stateLabel.getForeground().equals(fColor)) {
            this.stateLabel.setForeground(fColor);
            this.planIdLabel.setForeground(fColor);
            this.nodeIdLabel.setForeground(fColor);
            this.outcomeTitleLabel.setForeground(fColor);
        }
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange ev) {
        this.state = PlanControlState.STATE.BLOCKED;
        this.planId = "";
        this.nodeId = "";
        this.nodeStarTimeMillisUTC = -1L;
        this.nodeTypeImcId = 65535;
    }

    @Override
    public void initSubPanel() {
    }

    @Override
    public void cleanSubPanel() {
    }
}

