/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.propertysheet.PropertySheetDialog;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.console.plugins.planning.PlanTemplatesDialog;
import pt.lsts.neptus.console.plugins.planning.edit.ManeuverAdded;
import pt.lsts.neptus.console.plugins.planning.edit.ManeuverChanged;
import pt.lsts.neptus.console.plugins.planning.edit.ManeuverPropertiesPanel;
import pt.lsts.neptus.console.plugins.planning.edit.ManeuverRemoved;
import pt.lsts.neptus.console.plugins.planning.edit.ManeuverTranslated;
import pt.lsts.neptus.console.plugins.planning.edit.PlanRotated;
import pt.lsts.neptus.console.plugins.planning.edit.PlanSettingsChanged;
import pt.lsts.neptus.console.plugins.planning.edit.PlanTranslated;
import pt.lsts.neptus.console.plugins.planning.edit.PlanZChanged;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.VehicleChooser;
import pt.lsts.neptus.gui.VehicleSelectionDialog;
import pt.lsts.neptus.gui.ZValueSelector;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverFactory;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.preview.PlanSimulationOverlay;
import pt.lsts.neptus.params.ManeuverPayloadConfig;
import pt.lsts.neptus.planeditor.PlanTransitionsSimpleEditor;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.map.PlanUtil;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.TransitionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription(name="Plan Edition", icon="images/planning/plan_editor.png", author="Jos\u00e9 Pinto, Paulo Dias", version="1.5", category=PluginDescription.CATEGORY.INTERFACE)
@LayerPriority(priority=100)
public class PlanEditor
extends InteractionAdapter
implements Renderer2DPainter,
IPeriodicUpdates,
MissionChangeListener {
    private static final long serialVersionUID = 1L;
    private final String defaultCondition = "ManeuverIsDone";
    private MissionType mission = null;
    private PlanType plan = null;
    private PlanElement planElem;
    private ManeuverFactory mf = null;
    private final MapGroup mapGroup = null;
    private Maneuver selectedManeuver = null;
    private Point2D lastDragPoint = null;
    private final Vector<String> takenNames = new Vector();
    private StateRenderer2D renderer;
    private StateRendererInteraction delegate = null;
    private JPanel controls;
    protected JPanel sidePanel = null;
    protected JLabel statsLabel = null;
    protected static final String maneuverPreamble = "[Neptus:Maneuver]\n";
    protected PlanSimulationOverlay overlay = null;
    private ManeuverPropertiesPanel propertiesPanel = null;
    private ManeuverLocation maneuverLocationBeforeMoving = null;
    private boolean maneuverWasMoved = false;
    private boolean planChanged = false;
    private boolean planTranslated = false;
    private double planRotatedRads = 0.0;
    private String planStatistics = "";
    @NeptusProperty(name="Toolbar Location", userLevel=NeptusProperty.LEVEL.REGULAR)
    public ToolbarLocation toolbarLocation = ToolbarLocation.Right;
    private final UndoManager manager = new UndoManager(){
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized boolean addEdit(UndoableEdit anEdit) {
            boolean ret = super.addEdit(anEdit);
            PlanEditor.this.updateUndoRedo();
            return ret;
        }

        @Override
        public synchronized void undo() throws CannotUndoException {
            super.undo();
            PlanEditor.this.updateUndoRedo();
        }

        @Override
        public synchronized void redo() throws CannotRedoException {
            super.redo();
            PlanEditor.this.updateUndoRedo();
        }
    };
    protected AbstractAction undoAction;
    protected AbstractAction redoAction;
    private String xml = null;

    public PlanEditor(ConsoleLayout console) {
        super(console);
    }

    @Override
    public long millisBetweenUpdates() {
        return 1000L;
    }

    protected ManeuverPropertiesPanel getPropertiesPanel() {
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new ManeuverPropertiesPanel();
        }
        return this.propertiesPanel;
    }

    @Override
    public boolean update() {
        Maneuver curManeuver = this.getPropertiesPanel().getManeuver();
        if (curManeuver != null && this.renderer.isFocusOwner()) {
            this.getPropertiesPanel().setManeuver(curManeuver);
            this.getPropertiesPanel().setPlan(this.plan);
            this.getPropertiesPanel().setManager(this.manager);
            if (this.delegate != null) {
                this.getPropertiesPanel().getEditBtn().setSelected(true);
            }
        }
        try {
            if (this.planElem != null && this.planElem.getPlan() != null) {
                this.planStatistics = PlanUtil.getPlanStatisticsAsText(this.planElem.getPlan(), null, true, true);
                this.statsLabel.setText(this.planStatistics);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public Image getIconImage() {
        return ImageUtils.getImage(PluginUtils.getPluginIcon(this.getClass()));
    }

    @Override
    public void setActive(boolean mode, StateRenderer2D source) {
        super.setActive(mode, source);
        this.getPropertiesPanel().setManeuver(null);
        this.renderer = source;
        if (mode) {
            PeriodicUpdatesService.register(this);
            Container c = source;
            while (c.getParent() != null && !(c.getLayout() instanceof BorderLayout)) {
                c = c.getParent();
            }
            if (c.getLayout() instanceof BorderLayout) {
                switch (this.toolbarLocation) {
                    case Left: {
                        c.add((Component)this.getSidePanel(), "West");
                        break;
                    }
                    default: {
                        c.add((Component)this.getSidePanel(), "East");
                    }
                }
                c.invalidate();
                c.validate();
                if (c instanceof JComponent) {
                    ((JComponent)c).setBorder(new LineBorder(Color.orange.darker(), 3));
                }
            }
            if (this.plan == null && this.getConsole().getPlan() != null) {
                this.setPlan(this.getConsole().getPlan().clonePlan());
            } else if (this.plan == null) {
                VehicleType choice = null;
                choice = this.getConsole().getMainSystem() != null ? VehicleChooser.showVehicleDialog(null, VehiclesHolder.getVehicleById(this.getConsole().getMainSystem()), this.getConsole()) : VehicleChooser.showVehicleDialog(null, null, this.getConsole());
                if (choice == null) {
                    if (this.getAssociatedSwitch() != null) {
                        this.getAssociatedSwitch().doClick();
                    }
                    return;
                }
                PlanType plan = new PlanType(this.getConsole().getMission());
                plan.setVehicle(choice.getId());
                this.setPlan(plan);
            } else {
                this.setPlan(this.plan);
            }
        } else {
            PeriodicUpdatesService.unregister(this);
            if (this.delegate != null) {
                this.delegate.setActive(false, source);
                this.getPropertiesPanel().getEditBtn().setSelected(false);
                this.delegate = null;
            }
            Container c = source;
            while (c.getParent() != null && !(c.getLayout() instanceof BorderLayout)) {
                c = c.getParent();
            }
            if (c.getLayout() instanceof BorderLayout) {
                c.remove(this.getSidePanel());
                c.invalidate();
                c.validate();
                if (c instanceof JComponent) {
                    ((JComponent)c).setBorder(new EmptyBorder(0, 0, 0, 0));
                }
            }
            if (this.plan != null && !this.manager.canUndo() && this.getConsole().getMission().getIndividualPlansList().containsKey(this.plan.getId())) {
                this.plan = null;
            }
            this.planElem = null;
            this.renderer.setToolTipText("");
            this.overlay = null;
        }
    }

    protected JPanel getSidePanel() {
        if (this.sidePanel == null) {
            this.sidePanel = new JPanel(new BorderLayout(2, 2));
            this.statsLabel = new JLabel(){

                @Override
                public void setText(String text) {
                    String[] txts = text.split("\n");
                    text = "<html>";
                    for (String str : txts) {
                        if (str.contains(I18n.text("Plan Statistics")) || str.contains(I18n.text("ID") + ":") || str.contains(I18n.text("Vehicle") + ":") || str.equals("")) continue;
                        text = text + str + "<br>";
                    }
                    super.setText(text);
                }
            };
            this.controls = new JPanel(new GridLayout(0, 3));
            this.controls.add(new JButton(this.getNewAction()));
            this.controls.add(new JButton(this.getSaveAction()));
            this.controls.add(new JButton(this.getCloseAction()));
            this.controls.add(new JButton(this.getSettingsAction()){
                {
                    this.setEnabled(false);
                }
            });
            this.controls.add(new JButton(this.getUndoAction()));
            this.controls.add(new JButton(this.getRedoAction()));
            this.updateUndoRedo();
            this.controls.setBorder(new TitledBorder(I18n.text("Plan")));
            this.sidePanel.add((Component)this.controls, "South");
            JPanel holder = new JPanel(new BorderLayout());
            holder.add(this.getPropertiesPanel());
            holder.add((Component)this.statsLabel, "South");
            this.sidePanel.add((Component)holder, "Center");
            this.getPropertiesPanel().getEditBtn().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Maneuver man = PlanEditor.this.getPropertiesPanel().getManeuver();
                    if (man instanceof StateRendererInteraction) {
                        if (PlanEditor.this.getPropertiesPanel().getEditBtn().isSelected()) {
                            PlanEditor.this.delegate = (StateRendererInteraction)((Object)man);
                            PlanEditor.this.delegate.setActive(true, PlanEditor.this.renderer);
                        } else {
                            PlanEditor.this.delegate.setActive(false, PlanEditor.this.renderer);
                            PlanEditor.this.delegate = null;
                            PlanEditor.this.planElem.recalculateManeuverPositions(PlanEditor.this.renderer);
                        }
                    }
                }
            });
            this.getPropertiesPanel().getDeleteBtn().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PlanEditor.this.getPropertiesPanel().getManeuver() != null) {
                        PlanEditor.this.removeManeuver(PlanEditor.this.getPropertiesPanel().getManeuver().getId());
                    }
                }
            });
            this.getPropertiesPanel().setOpaque(false);
            this.controls.setOpaque(false);
        }
        return this.sidePanel;
    }

    protected AbstractAction getSettingsAction() {
        return new AbstractAction(I18n.text("Statistics"), ImageUtils.getScaledIcon("images/planning/edit_settings.png", 16, 16)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dialog = new JDialog((Frame)PlanEditor.this.getConsole(), I18n.text("Edited plan statistics"));
                JEditorPane editor = new JEditorPane("text/html", PlanUtil.getPlanStatisticsAsText(PlanEditor.this.plan, I18n.textf("%planName statistics", PlanEditor.this.plan.getId()), false, false));
                editor.setEditable(false);
                dialog.getContentPane().add(new JScrollPane(editor));
                dialog.setSize(400, 400);
                dialog.setDefaultCloseOperation(2);
                GuiUtils.centerOnScreen(dialog);
                dialog.setVisible(true);
            }
        };
    }

    public void editDifferentPlan(PlanType newPlan) {
        int option;
        if (this.plan != null && this.manager.canUndo() && (option = JOptionPane.showConfirmDialog(this.getConsole(), I18n.textf("Continuing will discard all changes made to %planName. Continue?", this.plan.getId()), I18n.text("Edit plan"), 0)) == 1) {
            return;
        }
        this.manager.discardAllEdits();
        this.updateUndoRedo();
        this.setPlan(newPlan.clonePlan());
        if (this.getAssociatedSwitch() != null && !this.getAssociatedSwitch().isSelected()) {
            this.getAssociatedSwitch().doClick();
        }
    }

    public void newPlan() {
        int option;
        this.getPropertiesPanel().setManeuver(null);
        if (this.plan != null && (option = JOptionPane.showConfirmDialog(this.getConsole(), I18n.textf("Continuing will discard all changes made to %planName. Continue?", this.plan.getId()), I18n.text("Create new plan"), 0)) == 1) {
            return;
        }
        this.manager.discardAllEdits();
        this.updateUndoRedo();
        VehicleType choice = null;
        choice = this.getConsole().getMainSystem() != null ? VehicleChooser.showVehicleDialog(null, VehiclesHolder.getVehicleById(this.getConsole().getMainSystem()), this.getConsole()) : VehicleChooser.showVehicleDialog(null, null, this.getConsole());
        if (choice == null) {
            return;
        }
        PlanType plan = new PlanType(this.getConsole().getMission());
        plan.setVehicle(choice.getId());
        this.setPlan(plan);
        if (this.getAssociatedSwitch() != null && !this.getAssociatedSwitch().isSelected()) {
            this.getAssociatedSwitch().doClick();
        }
    }

    protected AbstractAction getNewAction() {
        return new AbstractAction(I18n.textc("New", "Plan"), ImageUtils.getScaledIcon("images/planning/edit_new.png", 16, 16)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanEditor.this.newPlan();
            }
        };
    }

    protected void updateUndoRedo() {
        this.getUndoAction().putValue("ShortDescription", this.manager.getUndoPresentationName());
        this.getRedoAction().putValue("ShortDescription", this.manager.getRedoPresentationName());
        this.getUndoAction().setEnabled(this.manager.canUndo());
        this.getRedoAction().setEnabled(this.manager.canRedo());
        this.planChanged = this.manager.canUndo();
        if (this.planElem != null) {
            this.planElem.recalculateManeuverPositions(this.renderer);
        }
        try {
            if (this.getPropertiesPanel().getManeuver() != null && this.plan.getGraph().getManeuver(this.getPropertiesPanel().getManeuver().getId()) == null) {
                this.getPropertiesPanel().setManeuver(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected AbstractAction getUndoAction() {
        if (this.undoAction == null) {
            this.undoAction = new AbstractAction(I18n.text("Undo"), ImageUtils.getScaledIcon("images/planning/undo.png", 16, 16)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlanEditor.this.manager.undo();
                    PlanEditor.this.planElem.recalculateManeuverPositions(PlanEditor.this.renderer);
                    PlanEditor.this.refreshPropertiesManeuver();
                }
            };
        }
        return this.undoAction;
    }

    protected AbstractAction getRedoAction() {
        if (this.redoAction == null) {
            this.redoAction = new AbstractAction(I18n.text("Redo"), ImageUtils.getScaledIcon("images/planning/redo.png", 16, 16)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlanEditor.this.manager.redo();
                    PlanEditor.this.planElem.recalculateManeuverPositions(PlanEditor.this.renderer);
                    PlanEditor.this.refreshPropertiesManeuver();
                }
            };
        }
        return this.redoAction;
    }

    protected AbstractAction getSaveAction() {
        return new AbstractAction(I18n.text("Save"), ImageUtils.getScaledIcon("images/planning/edit_save.png", 16, 16)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String lastPlanId;
                PlanEditor.this.getPropertiesPanel().setManeuver(null);
                String planId = lastPlanId = PlanEditor.this.plan.getId();
                while (true) {
                    if ((planId = JOptionPane.showInputDialog(PlanEditor.this.getConsole(), I18n.text("Enter the plan ID"), lastPlanId)) == null) {
                        return;
                    }
                    if (PlanEditor.this.getConsole().getMission().getIndividualPlansList().get(planId) == null) break;
                    int option = JOptionPane.showConfirmDialog(PlanEditor.this.getConsole(), I18n.text("Do you wish to replace the existing plan with same name?"));
                    if (option == 2) {
                        return;
                    }
                    if (option == 0) break;
                    lastPlanId = planId;
                }
                PlanEditor.this.plan.setId(planId);
                PlanEditor.this.plan.setMissionType(PlanEditor.this.getConsole().getMission());
                PlanEditor.this.getConsole().getMission().addPlan(PlanEditor.this.plan);
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        PlanEditor.this.getConsole().getMission().save(true);
                        return null;
                    }
                };
                worker.execute();
                if (PlanEditor.this.getConsole().getPlan() == null || PlanEditor.this.getConsole().getPlan().getId().equalsIgnoreCase(PlanEditor.this.plan.getId())) {
                    PlanEditor.this.getConsole().setPlan(PlanEditor.this.plan);
                }
                PlanEditor.this.setPlan(null);
                PlanEditor.this.manager.discardAllEdits();
                PlanEditor.this.updateUndoRedo();
                if (PlanEditor.this.getAssociatedSwitch() != null) {
                    PlanEditor.this.getAssociatedSwitch().doClick();
                }
                PlanEditor.this.getConsole().updateMissionListeners();
            }
        };
    }

    protected AbstractAction getCloseAction() {
        return new AbstractAction(I18n.text("Close"), ImageUtils.getScaledIcon("images/planning/edit_close.png", 16, 16)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int option;
                if (PlanEditor.this.plan != null && PlanEditor.this.planChanged && (option = JOptionPane.showConfirmDialog(PlanEditor.this.getConsole(), I18n.textf("Continuing will discard all changes made to %planName. Continue?", PlanEditor.this.plan.getId()), I18n.text("Close discarding changes"), 0)) == 1) {
                    return;
                }
                PlanEditor.this.setPlan(null);
                PlanEditor.this.manager.discardAllEdits();
                PlanEditor.this.updateUndoRedo();
                if (PlanEditor.this.getAssociatedSwitch() != null) {
                    PlanEditor.this.getAssociatedSwitch().doClick();
                }
            }
        };
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        this.renderer = renderer;
        if (this.planElem != null) {
            this.planElem.setRenderer(renderer);
            this.planElem.paint((Graphics2D)g.create(), renderer);
        }
        if (this.overlay != null && this.isActive()) {
            this.overlay.paint(g, renderer);
        }
        g.setFont(new Font("Helvetica", 1, 14));
        if (this.delegate != null) {
            String txt = I18n.textf("Editing %manName - Double click to end", ((Maneuver)((Object)this.delegate)).getId());
            g.setColor(Color.black);
            g.drawString(txt, 55, 15);
            g.setColor(Color.white);
            g.drawString(txt, 54, 14);
        }
    }

    public static boolean isVehicleSupported(String vehicleID) {
        VehicleType vehicle = VehiclesHolder.getVehicleById(vehicleID);
        if (vehicle == null) {
            return false;
        }
        LinkedHashMap<String, String> maneuvers = vehicle.getFeasibleManeuvers();
        for (String maneuver : maneuvers.keySet()) {
            Maneuver man = ManeuverFactory.createManeuver(maneuver, maneuvers.get(maneuver));
            if (man == null) continue;
            return true;
        }
        return false;
    }

    public void setPlan(PlanType plan) {
        this.plan = plan;
        if (plan == null) {
            this.planElem = null;
            return;
        }
        this.getPropertiesPanel().setManager(null);
        this.parsePlan();
        this.planElem = new PlanElement(this.mapGroup, new MapType());
        this.planElem.setBeingEdited(true);
        this.planElem.setRenderer(this.renderer);
        this.planElem.setTransp2d(1.0);
        this.planElem.setPlan(plan);
        this.controls.setBorder(new TitledBorder(I18n.textf("Editing %planName", plan.getId())));
    }

    private void parsePlan() {
        VehicleType vt = this.plan.getVehicleType();
        if (vt == null) {
            NeptusLog.pub().warn((Object)("No vehicle type for vehicle " + this.plan.getVehicle() + " for plan " + this.plan.getId()));
            String mvid = this.getMainVehicleId();
            vt = VehiclesHolder.getVehicleById(mvid);
            if (vt == null) {
                NeptusLog.pub().warn((Object)("No vehicle type for main vehicle " + this.getMainVehicleId() + " for plan " + this.plan.getId()));
            } else {
                this.plan.setVehicle(this.getMainVehicleId());
            }
        }
        if (vt != null) {
            this.mf = vt.getManeuverFactory();
        } else {
            NeptusLog.pub().warn((Object)("No vehicle type creating empty maneuver factory for plan " + this.plan.getId()));
            this.mf = new ManeuverFactory(null);
        }
        for (Maneuver man : this.plan.getGraph().getAllManeuvers()) {
            this.takenNames.add(man.getId());
        }
    }

    protected Collection<AbstractAction> getActionsForManeuver(final Maneuver man, final Point mousePoint) {
        Vector<AbstractAction> actions = new Vector<AbstractAction>();
        AbstractAction props = new AbstractAction(I18n.textf("%manName properties", man.getId())){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean wasInitialManeuver = man.isInitialManeuver();
                String oldXml = man.asXML();
                PropertiesEditor.editProperties((PropertiesProvider)man, PlanEditor.this.getConsole(), true);
                PlanEditor.this.manager.addEdit(new ManeuverChanged(man, PlanEditor.this.plan, oldXml));
                if (man.isInitialManeuver()) {
                    PlanEditor.this.plan.getGraph().setInitialManeuver(man.getId());
                } else if (wasInitialManeuver) {
                    man.setInitialManeuver(true);
                    GuiUtils.infoMessage(ConfigFetch.getSuperParentFrame(), I18n.text("Set Properties"), I18n.text("To change the initial maneuver, please set another maneuver as the initial"));
                }
                PlanEditor.this.planElem.recalculateManeuverPositions(PlanEditor.this.renderer);
                PlanEditor.this.renderer.repaint();
                PlanEditor.this.refreshPropertiesManeuver();
            }
        };
        props.putValue("SmallIcon", new ImageIcon(ImageUtils.getImage("images/menus/edit.png")));
        actions.add(props);
        if (man instanceof StateRendererInteraction) {
            AbstractAction editMan = new AbstractAction(I18n.textf("Edit %maneuverName in the map", man.getId())){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlanEditor.this.delegate = (StateRendererInteraction)((Object)man);
                    PlanEditor.this.delegate.setActive(true, PlanEditor.this.renderer);
                }
            };
            actions.add(editMan);
        }
        AbstractAction remove = new AbstractAction(I18n.textf("Remove %maneuverName", man.getId())){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanEditor.this.removeManeuver(man.getId());
            }
        };
        remove.putValue("SmallIcon", new ImageIcon(ImageUtils.getImage("images/menus/editdelete.png")));
        actions.add(remove);
        AbstractAction copy = new AbstractAction(I18n.textf("Copy %maneuverName to clipboard", man.getId())){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipboardOwner owner = new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                };
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(PlanEditor.maneuverPreamble + man.getManeuverXml()), owner);
            }
        };
        copy.putValue("SmallIcon", new ImageIcon(ImageUtils.getImage("images/menus/editcopy.png")));
        actions.add(copy);
        actions.add(this.getPasteAction(mousePoint));
        List<String> names = Arrays.asList(this.mf.getAvailableManeuversIDs());
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Collator collator = Collator.getInstance(Locale.US);
                return collator.compare(o1, o2);
            }
        });
        ImageIcon icon = ImageUtils.getIcon("images/led_none.png");
        Iterator<String> i$ = names.iterator();
        while (i$.hasNext()) {
            String manName;
            final String manType = manName = i$.next();
            AbstractAction act = new AbstractAction(I18n.textf("Add %maneuverName1 before %maneuverName2", manName, man.getId()), icon){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Vector<TransitionType> trans = PlanEditor.this.plan.getGraph().getIncomingTransitions(man);
                    if (trans.isEmpty()) {
                        PlanEditor.this.addManeuverAtBeginning(manType, mousePoint);
                    } else {
                        PlanEditor.this.addManeuverAfter(manType, trans.firstElement().getSourceManeuver());
                    }
                    PlanEditor.this.planElem.recalculateManeuverPositions(PlanEditor.this.renderer);
                    PlanEditor.this.renderer.repaint();
                }
            };
            actions.add(act);
        }
        return actions;
    }

    @Override
    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        final StateRenderer2D renderer = source;
        final Point mousePoint = event.getPoint();
        if (this.delegate != null) {
            if (event.getClickCount() == 2) {
                this.delegate.setActive(false, source);
                this.getPropertiesPanel().setManeuver(this.getPropertiesPanel().getManeuver());
                this.getPropertiesPanel().getEditBtn().setSelected(false);
                this.planElem.recalculateManeuverPositions(source);
                this.delegate = null;
                if (this.xml != null) {
                    ManeuverChanged edit = new ManeuverChanged(this.getPropertiesPanel().getManeuver(), this.plan, this.xml);
                    this.xml = null;
                    this.manager.addEdit(edit);
                }
                return;
            }
            this.delegate.mouseClicked(event, source);
            return;
        }
        if (event.getClickCount() == 2) {
            this.planElem.iterateManeuverBack(event.getPoint());
            Maneuver man = this.planElem.iterateManeuverBack(event.getPoint());
            if (man != null) {
                if (man instanceof StateRendererInteraction) {
                    this.delegate = (StateRendererInteraction)((Object)man);
                    ((StateRendererInteraction)((Object)man)).setActive(true, source);
                    this.getPropertiesPanel().getEditBtn().setSelected(true);
                    this.xml = this.getPropertiesPanel().getManeuver().getManeuverXml();
                }
                return;
            }
        }
        if (event.isControlDown() && event.getButton() == 1) {
            Maneuver m = this.plan.getGraph().getLastManeuver();
            this.addManeuverAtEnd(event.getPoint(), m.getType());
            return;
        }
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            AbstractAction copy = new AbstractAction(I18n.text("Copy location")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CoordinateUtil.copyToClipboard(renderer.getRealWorldLocation(mousePoint));
                }
            };
            copy.putValue("SmallIcon", new ImageIcon(ImageUtils.getImage("images/menus/editcopy.png")));
            popup.add(copy);
            Maneuver[] mans = this.planElem.getAllInterceptedManeuvers(event.getPoint());
            popup.addSeparator();
            if (mans.length == 1) {
                for (AbstractAction act : this.getActionsForManeuver(mans[0], mousePoint)) {
                    popup.add(act);
                }
            } else if (mans.length > 1) {
                for (Maneuver m : mans) {
                    JMenu subMenu = new JMenu(m.getId());
                    if (m instanceof LocatedManeuver) {
                        subMenu.setText(m.getId() + " (" + GuiUtils.getNeptusDecimalFormat(1).format(((LocatedManeuver)((Object)m)).getManeuverLocation().getAllZ()) + " m)");
                    }
                    subMenu.setIcon(new ImageIcon(ImageUtils.getImage("images/menus/plan.png")));
                    for (AbstractAction act : this.getActionsForManeuver(m, mousePoint)) {
                        subMenu.add(act);
                    }
                    popup.add(subMenu);
                }
            } else {
                if (this.plan.hasInitialManeuver()) {
                    JMenu planSettings = new JMenu(I18n.text("Change Existing Maneuvers"));
                    AbstractAction pDepth = new AbstractAction(I18n.text("Plan depth / altitude...")){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            boolean newZ;
                            ManeuverLocation loc = new ManeuverLocation();
                            for (Maneuver m : PlanEditor.this.plan.getGraph().getAllManeuvers()) {
                                if (!(m instanceof LocatedManeuver)) continue;
                                loc = ((LocatedManeuver)((Object)m)).getManeuverLocation().clone();
                                break;
                            }
                            if (newZ = ZValueSelector.showHeightDepthDialog(PlanEditor.this.getConsole().getMainPanel(), loc, I18n.text("Plan depth / altitude"))) {
                                LinkedHashMap<String, ManeuverLocation.Z_UNITS> prevUnits = new LinkedHashMap<String, ManeuverLocation.Z_UNITS>();
                                LinkedHashMap<String, Double> prevValues = new LinkedHashMap<String, Double>();
                                for (Maneuver m : PlanEditor.this.plan.getGraph().getAllManeuvers()) {
                                    if (!(m instanceof LocatedManeuver)) continue;
                                    ManeuverLocation l = ((LocatedManeuver)((Object)m)).getManeuverLocation();
                                    prevUnits.put(m.getId(), l.getZUnits());
                                    prevValues.put(m.getId(), l.getZ());
                                }
                                PlanEditor.this.planElem.setPlanZ(loc.getZ(), loc.getZUnits());
                                PlanEditor.this.manager.addEdit(new PlanZChanged(PlanEditor.this.plan, loc.getZ(), loc.getZUnits(), prevUnits, prevValues));
                                PlanEditor.this.refreshPropertiesManeuver();
                            }
                        }
                    };
                    pDepth.putValue("SmallIcon", new ImageIcon(ImageUtils.getScaledImage("images/buttons/wizard.png", 16, 16)));
                    planSettings.add(pDepth);
                    AbstractAction pVel = new AbstractAction(I18n.text("Plan speed...")){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Object resp;
                            Object[] optionsI18n = new String[]{I18n.text("m/s"), I18n.text("RPM"), "%"};
                            String[] optionsNotI18n = new String[]{"m/s", "RPM", "%"};
                            DefaultProperty dp = PlanEditor.this.planElem.getLastSetProperties().get("Speed units");
                            String curValueNotI18n = "m/s";
                            if (dp != null) {
                                curValueNotI18n = dp.getValue().toString();
                            }
                            if ((resp = JOptionPane.showInputDialog(PlanEditor.this.getConsole(), I18n.text("Please choose the speed units"), I18n.text("Set plan speed"), 3, null, optionsI18n, I18n.text(curValueNotI18n))) == null) {
                                return;
                            }
                            String velUnitI18n = resp.toString();
                            String velUnitNotI18n = "m/s";
                            for (int i = 0; i < optionsI18n.length; ++i) {
                                if (!velUnitI18n.equals(optionsI18n[i])) continue;
                                velUnitNotI18n = optionsNotI18n[i];
                                break;
                            }
                            double velocity = 0.0;
                            boolean validVel = false;
                            while (!validVel) {
                                String res;
                                double curSpeed = 1.3;
                                dp = PlanEditor.this.planElem.getLastSetProperties().get("Speed");
                                if (dp != null) {
                                    curSpeed = (Double)dp.getValue();
                                }
                                if ((res = JOptionPane.showInputDialog(PlanEditor.this.getConsole(), I18n.textf("Enter new speed (%speedUnit)", velUnitI18n), curSpeed)) == null) {
                                    return;
                                }
                                try {
                                    velocity = Double.parseDouble(res);
                                    validVel = true;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    GuiUtils.errorMessage(PlanEditor.this.getConsole(), I18n.text("Set plan speed"), I18n.text("Speed must be a numeric value"));
                                }
                            }
                            LinkedHashMap<String, Vector<DefaultProperty>> previousSettings = new LinkedHashMap<String, Vector<DefaultProperty>>();
                            for (Maneuver m : PlanEditor.this.plan.getGraph().getAllManeuvers()) {
                                for (DefaultProperty p : m.getProperties()) {
                                    if (!p.getName().equalsIgnoreCase("Speed") && !p.getName().equalsIgnoreCase("Speed units")) continue;
                                    if (!previousSettings.containsKey(m.getId())) {
                                        previousSettings.put(m.getId(), new Vector());
                                    }
                                    ((Vector)previousSettings.get(m.getId())).add(p);
                                }
                            }
                            DefaultProperty propVel = new DefaultProperty();
                            propVel.setName("Speed");
                            propVel.setValue((Object)velocity);
                            propVel.setType(Double.class);
                            propVel.setDisplayName(I18n.text("Speed"));
                            PlanEditor.this.planElem.setPlanProperty(propVel);
                            DefaultProperty propVelUnits = new DefaultProperty();
                            propVelUnits.setName("Speed units");
                            propVelUnits.setValue((Object)velUnitNotI18n);
                            propVelUnits.setType(String.class);
                            propVelUnits.setDisplayName(I18n.text("Speed units"));
                            PlanEditor.this.planElem.setPlanProperty(propVelUnits);
                            PlanEditor.this.manager.addEdit(new PlanSettingsChanged(PlanEditor.this.plan, Arrays.asList(propVel, propVelUnits), previousSettings));
                            PlanEditor.this.refreshPropertiesManeuver();
                        }
                    };
                    pVel.putValue("SmallIcon", new ImageIcon(ImageUtils.getScaledImage("images/buttons/wizard.png", 16, 16)));
                    planSettings.add(pVel);
                    AbstractAction pPayload = new AbstractAction(I18n.text("Payload settings...")){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Goto pivot = new Goto();
                            PropertySheetPanel psp = new PropertySheetPanel();
                            psp.setEditorFactory((PropertyEditorFactory)PropertiesEditor.getPropertyEditorRegistry());
                            psp.setRendererFactory((PropertyRendererFactory)PropertiesEditor.getPropertyRendererRegistry());
                            psp.setMode(1);
                            psp.setToolBarVisible(false);
                            psp.setSortingCategories(true);
                            psp.setDescriptionVisible(true);
                            ManeuverPayloadConfig payloadConfig = new ManeuverPayloadConfig(PlanEditor.this.plan.getVehicle(), pivot, psp);
                            DefaultProperty[] properties = payloadConfig.getProperties();
                            ManeuverPayloadConfig payloadDefaultsConfig = new ManeuverPayloadConfig(PlanEditor.this.plan.getVehicle(), pivot, psp);
                            DefaultProperty[] propertiesDefaults = payloadDefaultsConfig.getProperties();
                            int ret = PlanEditor.this.fillPropertiesWithAllChangesFromDefaults(PlanEditor.this.plan, properties, propertiesDefaults, psp);
                            String extraTxt = "";
                            switch (ret) {
                                case 0: 
                                case 1: {
                                    extraTxt = "<br><small>(" + I18n.text("All maneuvers have the same values.") + ")";
                                    break;
                                }
                                default: {
                                    extraTxt = "<br><small>(" + I18n.text("Not all maneuvers have the same values.") + ")";
                                }
                            }
                            psp.setProperties((Property[])properties);
                            PropertySheetDialog propertySheetDialog = PropertiesEditor.createWindow(PlanEditor.this.getConsole(), true, psp, I18n.text("Payload Settings to apply to entire plan"), "<html>" + I18n.text("Payload Settings to apply to entire plan") + extraTxt);
                            if (propertySheetDialog.ask()) {
                                payloadConfig.setProperties((Property[])properties);
                                Vector<IMCMessage> startActions = new Vector<IMCMessage>();
                                startActions.addAll(Arrays.asList(pivot.getStartActions().getAllMessages()));
                                for (Maneuver m : PlanEditor.this.plan.getGraph().getAllManeuvers()) {
                                    m.getStartActions().parseMessages(startActions);
                                    NeptusLog.pub().info((Object)("<###> " + m.getId()));
                                }
                                PlanEditor.this.refreshPropertiesManeuver();
                            }
                        }
                    };
                    pPayload.putValue("SmallIcon", new ImageIcon(ImageUtils.getScaledImage("images/buttons/wizard.png", 16, 16)));
                    planSettings.add(pPayload);
                    AbstractAction pVehicle = new AbstractAction(I18n.text("Set plan vehicles...")){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Window parentW = SwingUtilities.getWindowAncestor(PlanEditor.this.getConsole());
                            String[] vehicles = VehicleSelectionDialog.showSelectionDialog(parentW, PlanEditor.this.plan.getVehicles().toArray(new VehicleType[0]));
                            Vector<VehicleType> vts = new Vector<VehicleType>();
                            for (String v : vehicles) {
                                vts.add(VehiclesHolder.getVehicleById(v));
                            }
                            PlanEditor.this.plan.setVehicles(vts);
                        }
                    };
                    pVehicle.putValue("SmallIcon", new ImageIcon(ImageUtils.getScaledImage("images/buttons/wizard.png", 16, 16)));
                    planSettings.add(pVehicle);
                    planSettings.setIcon(new ImageIcon(ImageUtils.getScaledImage("images/buttons/wizard.png", 16, 16)));
                    popup.add(planSettings);
                }
                AbstractAction pTransitions = new AbstractAction(I18n.text("Plan Transitions")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Window parent = SwingUtilities.getWindowAncestor(PlanEditor.this.getConsole());
                        if (parent == null) {
                            parent = SwingUtilities.getWindowAncestor(ConfigFetch.getSuperParentAsFrame());
                        }
                        JDialog transitions = new JDialog(parent, I18n.textf("Edit '%planName' plan transitions", PlanEditor.this.plan.getId()));
                        transitions.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                        transitions.getContentPane().add(new PlanTransitionsSimpleEditor(PlanEditor.this.plan));
                        transitions.setSize(800, 500);
                        GuiUtils.centerParent(transitions, PlanEditor.this.getConsole());
                        transitions.setVisible(true);
                        PlanEditor.this.parsePlan();
                        renderer.repaint();
                        PlanEditor.this.refreshPropertiesManeuver();
                    }
                };
                pTransitions.putValue("SmallIcon", new ImageIcon(ImageUtils.getScaledImage("images/buttons/wizard.png", 16, 16)));
                popup.add(pTransitions);
                JMenu pStatistics = PlanUtil.getPlanStatisticsAsJMenu(this.plan, I18n.text("Edited Plan Statistics"));
                pStatistics.setIcon(new ImageIcon(ImageUtils.getScaledImage("images/buttons/wizard.png", 16, 16)));
                popup.add(pStatistics);
                popup.addSeparator();
                popup.add(this.getPasteAction(mousePoint));
                List<String> names = Arrays.asList(this.mf.getAvailableManeuversIDs());
                Collections.sort(names);
                ImageIcon icon = ImageUtils.getIcon("images/led_none.png");
                for (final String manName : names) {
                    String manNameStr = I18n.text(manName);
                    AbstractAction act = new AbstractAction(I18n.textf("Add %maneuverName", manNameStr), icon){
                        private static final long serialVersionUID = 1L;
                        private final Point2D mousePos;
                        {
                            super(x0, x1);
                            this.mousePos = mousePoint;
                        }

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            String maneuverName = manName;
                            PlanEditor.this.addManeuverAtEnd((Point)this.mousePos, maneuverName);
                            PlanEditor.this.planElem.recalculateManeuverPositions(renderer);
                            renderer.repaint();
                        }
                    };
                    popup.add(act);
                }
            }
            popup.show(source, (int)((Point2D)mousePoint).getX(), (int)((Point2D)mousePoint).getY());
        }
    }

    protected int fillPropertiesWithAllChangesFromDefaults(PlanType plan, DefaultProperty[] properties, DefaultProperty[] propertiesDefaults, PropertySheetPanel psp) {
        Maneuver[] allManeuvers = plan.getGraph().getAllManeuvers();
        int[] countChangesArray = new int[properties.length];
        Arrays.fill(countChangesArray, 0);
        for (Maneuver man : allManeuvers) {
            ManeuverPayloadConfig payloadConfig = new ManeuverPayloadConfig(plan.getVehicle(), man, psp);
            DefaultProperty[] manProperties = payloadConfig.getProperties();
            for (int i = 0; i < manProperties.length; ++i) {
                if (manProperties[i].getValue().equals(propertiesDefaults[i].getValue())) continue;
                if (!manProperties[i].getValue().equals(properties[i].getValue())) {
                    properties[i].setValue(manProperties[i].getValue());
                }
                int n = i;
                countChangesArray[n] = countChangesArray[n] + 1;
            }
        }
        int sumAll = 0;
        int sumAll2 = 0;
        for (int i : countChangesArray) {
            sumAll += i;
            sumAll2 += i == 0 ? allManeuvers.length : i;
        }
        if (sumAll == 0) {
            return 0;
        }
        if (sumAll2 == countChangesArray.length * allManeuvers.length) {
            return 1;
        }
        return 2;
    }

    private void refreshPropertiesManeuver() {
        if (this.getPropertiesPanel().getManeuver() != null) {
            this.getPropertiesPanel().setManeuver(this.getPropertiesPanel().getManeuver());
        }
    }

    protected AbstractAction getPasteAction(final Point mousePoint) {
        boolean hasTransferableText;
        Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        boolean enabled = false;
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                if (text.startsWith(maneuverPreamble)) {
                    enabled = true;
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        AbstractAction paste = new AbstractAction(I18n.text("Paste maneuver from clipboard")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                try {
                    String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                    String xml = text.substring(PlanEditor.maneuverPreamble.length());
                    Document doc = DocumentHelper.parseText((String)xml);
                    String maneuverType = doc.getRootElement().getName();
                    Maneuver m = PlanEditor.this.mf.getManeuver(maneuverType);
                    if (m != null) {
                        m.loadFromXML(xml);
                        m.setId(PlanEditor.this.getNewManeuverName(maneuverType));
                        if (m instanceof LocatedManeuver) {
                            ManeuverLocation originalPos = ((LocatedManeuver)((Object)m)).getManeuverLocation().clone();
                            LocationType pos = PlanEditor.this.renderer.getRealWorldLocation(mousePoint);
                            originalPos.setLatitudeRads(pos.getLatitudeRads());
                            originalPos.setLongitudeRads(pos.getLongitudeRads());
                            ((LocatedManeuver)((Object)m)).setManeuverLocation(originalPos);
                        }
                        Vector<TransitionType> addedTransitions = new Vector<TransitionType>();
                        Vector<TransitionType> removedTransitions = new Vector<TransitionType>();
                        PlanEditor.this.plan.getGraph().addManeuver(m);
                        PlanEditor.this.parsePlan();
                        addedTransitions.add(PlanEditor.this.plan.getGraph().addTransition(PlanEditor.this.plan.getGraph().getLastManeuver().getId(), m.getId(), "ManeuverIsDone"));
                        PlanEditor.this.planElem.recalculateManeuverPositions(PlanEditor.this.renderer);
                        PlanEditor.this.manager.addEdit(new ManeuverAdded(m, PlanEditor.this.plan, addedTransitions, removedTransitions));
                        PlanEditor.this.getPropertiesPanel().setManeuver(m);
                        PlanEditor.this.repaint();
                    }
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage(PlanEditor.this.getConsole(), ex);
                }
            }
        };
        paste.putValue("SmallIcon", new ImageIcon(ImageUtils.getImage("images/menus/editpaste.png")));
        paste.setEnabled(enabled);
        return paste;
    }

    @Override
    public void mouseDragged(MouseEvent e, StateRenderer2D renderer) {
        if (this.delegate != null) {
            this.delegate.mouseDragged(e, renderer);
            this.getPropertiesPanel().setManeuver((Maneuver)((Object)this.delegate));
            return;
        }
        if (this.lastDragPoint == null && this.selectedManeuver != null) {
            this.selectedManeuver = this.planElem.iterateManeuverBack(e.getPoint());
            this.getPropertiesPanel().setManeuver(this.selectedManeuver);
            this.getPropertiesPanel().getEditBtn().setEnabled(this.selectedManeuver instanceof StateRendererInteraction);
            this.getPropertiesPanel().getEditBtn().setSelected(false);
            this.getPropertiesPanel().setManager(this.manager);
            this.getPropertiesPanel().setPlan(this.plan);
        }
        if (this.selectedManeuver != null && this.selectedManeuver instanceof LocatedManeuver) {
            if (this.lastDragPoint != null) {
                this.maneuverWasMoved = true;
                double diffX = e.getPoint().getX() - this.lastDragPoint.getX();
                double diffY = e.getPoint().getY() - this.lastDragPoint.getY();
                if (e.isControlDown()) {
                    LocationType oldPt = renderer.getRealWorldLocation(this.lastDragPoint);
                    LocationType newPt = renderer.getRealWorldLocation(e.getPoint());
                    double[] offsets = newPt.getOffsetFrom(oldPt);
                    this.planElem.translatePlan(offsets[0], offsets[1], 0.0);
                    this.lastDragPoint = e.getPoint();
                    this.planTranslated = true;
                } else if (e.isShiftDown()) {
                    double ammount = Math.toRadians(this.lastDragPoint.getY() - e.getPoint().getY());
                    this.planElem.rotatePlan((LocatedManeuver)((Object)this.selectedManeuver), ammount);
                    this.lastDragPoint = e.getPoint();
                    this.planRotatedRads += ammount;
                } else {
                    Point2D newManPos = this.planElem.translateManeuverPosition(this.selectedManeuver.getId(), diffX, diffY);
                    ManeuverLocation loc = ((LocatedManeuver)((Object)this.selectedManeuver)).getManeuverLocation();
                    loc.setLocation(renderer.getRealWorldLocation(newManPos));
                    ((LocatedManeuver)((Object)this.selectedManeuver)).setManeuverLocation(loc);
                    this.lastDragPoint = newManPos;
                }
                renderer.repaint();
            } else {
                this.lastDragPoint = e.getPoint();
                renderer.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            super.mouseDragged(e, renderer);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e, StateRenderer2D renderer) {
        if (this.plan == null || this.selectedManeuver != null) {
            super.mouseMoved(e, renderer);
            return;
        }
        String[] mans = this.planElem.getManeuversUnder(e.getPoint());
        if (mans.length > 0) {
            renderer.setCursor(Cursor.getDefaultCursor());
            String text = this.plan.getGraph().getManeuver(mans[0]).getTooltipText();
            for (int i = 1; i < mans.length && i < 3; ++i) {
                String tooltip = this.plan.getGraph().getManeuver(mans[i]).getTooltipText();
                if (tooltip.startsWith("<html>")) {
                    tooltip = tooltip.substring(6);
                }
                text = text + "<br><br>" + tooltip;
            }
            if (mans.length >= 4) {
                text = text + "<br><b>(...)</b>";
            }
            renderer.setToolTipText(text);
        }
        super.mouseMoved(e, renderer);
    }

    @Override
    public void mousePressed(MouseEvent event, StateRenderer2D renderer) {
        this.planTranslated = false;
        this.planRotatedRads = 0.0;
        if (this.delegate != null) {
            this.delegate.mousePressed(event, renderer);
            this.getPropertiesPanel().setManeuver((Maneuver)((Object)this.delegate));
            return;
        }
        if (event.getButton() == 1) {
            if (this.planElem != null && event.getPoint() != null) {
                this.selectedManeuver = this.planElem.iterateManeuverUnder(event.getPoint());
                this.lastDragPoint = event.getPoint();
                if (this.selectedManeuver != null && this.selectedManeuver instanceof LocatedManeuver) {
                    this.maneuverLocationBeforeMoving = ((LocatedManeuver)((Object)this.selectedManeuver)).getManeuverLocation();
                }
                if (this.selectedManeuver != this.getPropertiesPanel().getManeuver()) {
                    if (this.getPropertiesPanel().getManeuver() != null && this.getPropertiesPanel().isChanged()) {
                        ManeuverChanged edit = new ManeuverChanged(this.getPropertiesPanel().getManeuver(), this.plan, this.getPropertiesPanel().getBeforeXml());
                        this.manager.addEdit(edit);
                    }
                    this.getPropertiesPanel().setPlan(this.plan);
                    this.getPropertiesPanel().setManeuver(this.selectedManeuver);
                    this.getPropertiesPanel().setManager(this.manager);
                    this.getPropertiesPanel().getEditBtn().setEnabled(this.selectedManeuver instanceof StateRendererInteraction);
                    this.getPropertiesPanel().getEditBtn().setSelected(false);
                }
                if (this.selectedManeuver == null) {
                    super.mousePressed(event, renderer);
                }
            }
        } else {
            super.mousePressed(event, renderer);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e, StateRenderer2D renderer) {
        if (this.delegate != null) {
            this.delegate.mouseReleased(e, renderer);
            this.getPropertiesPanel().setManeuver((Maneuver)((Object)this.delegate));
            return;
        }
        if (this.selectedManeuver != null) {
            if (this.planTranslated) {
                LocatedManeuver locProvider = (LocatedManeuver)((Object)this.selectedManeuver);
                ManeuverLocation curLocation = locProvider.getManeuverLocation();
                double[] offsets = curLocation.getOffsetFrom(this.maneuverLocationBeforeMoving);
                PlanTranslated edit = new PlanTranslated(this.plan, offsets[1], offsets[0]);
                this.manager.addEdit(edit);
            } else if (this.planRotatedRads != 0.0) {
                PlanRotated edit = new PlanRotated(this.plan, (LocatedManeuver)((Object)this.selectedManeuver), this.planRotatedRads);
                this.manager.addEdit(edit);
            } else if (this.maneuverWasMoved) {
                LocatedManeuver locProvider = (LocatedManeuver)((Object)this.selectedManeuver);
                ManeuverLocation after = locProvider.getManeuverLocation().clone();
                ManeuverLocation before = this.maneuverLocationBeforeMoving.clone();
                this.manager.addEdit(new ManeuverTranslated(locProvider, this.plan, before, after));
            }
            this.maneuverWasMoved = false;
            this.maneuverLocationBeforeMoving = null;
            this.planElem.recalculateManeuverPositions(renderer);
            this.getPropertiesPanel().setManeuver(this.selectedManeuver);
            this.getPropertiesPanel().getEditBtn().setEnabled(this.selectedManeuver instanceof StateRendererInteraction);
            this.getPropertiesPanel().getEditBtn().setSelected(false);
            this.getPropertiesPanel().setPlan(this.plan);
            this.getPropertiesPanel().setManager(this.manager);
        }
        this.lastDragPoint = null;
        this.selectedManeuver = null;
        this.mouseMoved(e, renderer);
        super.mouseReleased(e, renderer);
    }

    @Override
    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        if (this.delegate != null) {
            this.delegate.keyPressed(event, source);
        } else {
            super.keyPressed(event, source);
        }
    }

    @Override
    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        if (this.delegate != null) {
            this.delegate.keyReleased(event, source);
        } else {
            super.keyReleased(event, source);
        }
    }

    @Override
    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        if (this.delegate != null) {
            this.delegate.keyTyped(event, source);
        } else {
            super.keyTyped(event, source);
        }
    }

    private void removeManeuver(String manID) {
        Maneuver man = this.plan.getGraph().getManeuver(manID);
        Maneuver next = this.plan.getGraph().getFollowingManeuver(manID);
        boolean wasInitial = man.isInitialManeuver();
        Vector<TransitionType> addedTransitions = new Vector<TransitionType>();
        Vector<TransitionType> removedTransitions = new Vector<TransitionType>();
        if (next != null) {
            removedTransitions.add(this.plan.getGraph().removeTransition(manID, next.getId()));
        }
        for (Maneuver previous : this.plan.getGraph().getPreviousManeuvers(manID)) {
            removedTransitions.add(this.plan.getGraph().removeTransition(previous.getId(), manID));
            if (next == null || previous == null) continue;
            addedTransitions.add(this.plan.getGraph().addTransition(previous.getId(), next.getId(), "ManeuverIsDone"));
        }
        this.plan.getGraph().removeManeuver(man);
        this.planElem.recalculateManeuverPositions(this.renderer);
        this.renderer.repaint();
        if (man.isInitialManeuver() && next != null) {
            this.plan.getGraph().setInitialManeuver(next.getId());
        }
        ManeuverRemoved edit = new ManeuverRemoved(man, this.plan, addedTransitions, removedTransitions, wasInitial);
        this.manager.addEdit(edit);
    }

    private Maneuver addManeuverAfter(String manType, String manID) {
        LocationType loc1;
        Maneuver nextMan = this.plan.getGraph().getFollowingManeuver(manID);
        Maneuver previousMan = this.plan.getGraph().getManeuver(manID);
        ManeuverLocation worldLoc = new ManeuverLocation(this.renderer.getCenter());
        HashSet<TransitionType> addedTransitions = new HashSet<TransitionType>();
        HashSet<TransitionType> removedTransitions = new HashSet<TransitionType>();
        if (previousMan instanceof LocatedManeuver && nextMan instanceof LocatedManeuver) {
            loc1 = ((LocatedManeuver)((Object)previousMan)).getManeuverLocation().clone();
            ManeuverLocation loc2 = ((LocatedManeuver)((Object)nextMan)).getManeuverLocation().clone();
            double[] offsets = loc2.getOffsetFrom(loc1);
            loc1.translatePosition(offsets[0] / 2.0, offsets[1] / 2.0, 0.0);
            loc1.setDepth(loc1.getDepth());
            worldLoc.setLocation(loc1);
        } else {
            if (previousMan instanceof LocatedManeuver) {
                loc1 = new LocationType(((LocatedManeuver)((Object)previousMan)).getManeuverLocation());
                loc1.translatePosition(0.0, 30.0, 0.0);
                worldLoc.setLocation(loc1);
            }
            if (nextMan instanceof LocatedManeuver) {
                loc1 = new LocationType(((LocatedManeuver)((Object)nextMan)).getManeuverLocation());
                loc1.translatePosition(0.0, -30.0, 0.0);
                worldLoc.setLocation(loc1);
            }
        }
        Maneuver newMan = this.create(manType, worldLoc, previousMan);
        if (newMan == null) {
            GuiUtils.errorMessage(this, I18n.text("Error adding maneuver"), I18n.textf("The maneuver %maneuverType can't be added", manType));
            return null;
        }
        this.plan.getGraph().addManeuver(newMan);
        if (this.plan.getGraph().getExitingTransitions(previousMan).size() != 0) {
            for (TransitionType exitingTrans : this.plan.getGraph().getExitingTransitions(previousMan)) {
                removedTransitions.add(this.plan.getGraph().removeTransition(exitingTrans.getSourceManeuver(), exitingTrans.getTargetManeuver()));
            }
        }
        addedTransitions.add(this.plan.getGraph().addTransition(previousMan.getId(), newMan.getId(), "ManeuverIsDone"));
        if (nextMan != null) {
            removedTransitions.add(this.plan.getGraph().removeTransition(previousMan.getId(), nextMan.getId()));
            addedTransitions.add(this.plan.getGraph().addTransition(newMan.getId(), nextMan.getId(), "ManeuverIsDone"));
        }
        this.parsePlan();
        this.manager.addEdit(new ManeuverAdded(newMan, this.plan, addedTransitions, removedTransitions));
        this.getPropertiesPanel().setManeuver(newMan);
        return newMan;
    }

    private Maneuver create(String manType, LocationType worldLoc, Maneuver copyFrom) {
        Maneuver man = this.mf.getManeuver(manType);
        if (man == null) {
            return null;
        }
        if (copyFrom != null) {
            man.setProperties((Property[])copyFrom.getProperties());
            man.cloneActions(copyFrom);
        }
        if (man instanceof LocatedManeuver) {
            ManeuverLocation lt = ((LocatedManeuver)((Object)man)).getManeuverLocation();
            lt.setLocation(worldLoc);
            if (copyFrom != null && copyFrom instanceof LocatedManeuver) {
                ManeuverLocation l = ((LocatedManeuver)((Object)copyFrom)).getManeuverLocation();
                lt.setZ(l.getZ());
                lt.setZUnits(l.getZUnits());
            }
            ((LocatedManeuver)((Object)man)).setManeuverLocation(lt);
        }
        man.setId(this.getNewManeuverName(manType));
        return man;
    }

    private Maneuver addManeuverAtBeginning(String manType, Point loc) {
        String initial = this.plan.getGraph().getInitialManeuverId();
        Maneuver copyFrom = null;
        if (initial != null) {
            copyFrom = this.plan.getGraph().getManeuver(this.plan.getGraph().getInitialManeuverId());
        }
        Maneuver man = this.create(manType, this.renderer.getRealWorldLocation(loc), copyFrom);
        Vector<TransitionType> addedTransitions = new Vector<TransitionType>();
        if (initial != null) {
            addedTransitions.add(this.plan.getGraph().addTransition(man.getId(), initial, "ManeuverIsDone"));
        }
        this.plan.getGraph().addManeuver(man);
        this.plan.getGraph().setInitialManeuver(man.getId());
        this.parsePlan();
        this.manager.addEdit(new ManeuverAdded(man, this.plan, addedTransitions, new Vector<TransitionType>()));
        this.selectedManeuver = man;
        this.getPropertiesPanel().setManeuver(man);
        return man;
    }

    private Maneuver addManeuverAtEnd(Point loc, String manType) {
        Maneuver lastMan = this.plan.getGraph().getLastManeuver();
        LocationType worldLoc = this.renderer.getRealWorldLocation(loc);
        Maneuver man = this.create(manType, worldLoc, lastMan);
        Vector<TransitionType> addedTransitions = new Vector<TransitionType>();
        Vector<TransitionType> removedTransitions = new Vector<TransitionType>();
        if (man == null) {
            GuiUtils.errorMessage(this, I18n.text("Error adding maneuver"), I18n.textf("The maneuver %maneuverType can't be added", manType));
            return null;
        }
        if (lastMan != null && lastMan != man) {
            if (this.plan.getGraph().getExitingTransitions(lastMan).size() != 0) {
                for (TransitionType exitingTrans : this.plan.getGraph().getExitingTransitions(lastMan)) {
                    removedTransitions.add(this.plan.getGraph().removeTransition(exitingTrans.getSourceManeuver(), exitingTrans.getTargetManeuver()));
                }
            }
            addedTransitions.add(this.plan.getGraph().addTransition(lastMan.getId(), man.getId(), "ManeuverIsDone"));
        }
        if (man instanceof LocatedManeuver) {
            ManeuverLocation l = new ManeuverLocation();
            l.setLocation(this.renderer.getRealWorldLocation(loc));
            l.setZ(((LocatedManeuver)((Object)man)).getManeuverLocation().getZ());
            l.setZUnits(((LocatedManeuver)((Object)man)).getManeuverLocation().getZUnits());
            ((LocatedManeuver)((Object)man)).setManeuverLocation(l);
        }
        this.plan.getGraph().addManeuver(man);
        this.parsePlan();
        this.manager.addEdit(new ManeuverAdded(man, this.plan, addedTransitions, removedTransitions));
        this.getPropertiesPanel().setManeuver(man);
        if (lastMan == null) {
            this.selectedManeuver = null;
            this.getPropertiesPanel().setManeuver(null);
        }
        return man;
    }

    private String getNewManeuverName(String manType) {
        int i = 1;
        while (this.plan.getGraph().getManeuver(manType + i) != null) {
            ++i;
        }
        return manType + i;
    }

    public void reset() {
        this.planElem.recalculateManeuverPositions(this.renderer);
        this.repaint();
    }

    public PlanElement getPlanElem() {
        return this.planElem;
    }

    public StateRenderer2D getRenderer() {
        return this.renderer;
    }

    public MissionType getMission() {
        return this.mission;
    }

    @Override
    public void missionReplaced(MissionType mission) {
        this.mission = mission;
    }

    @Override
    public void missionUpdated(MissionType mission) {
        this.mission = mission;
    }

    @Override
    public void initSubPanel() {
        this.mission = this.getConsole().getMission();
        this.addMenuItem(I18n.text("Tools") + ">" + I18n.text("Generate plan..."), ImageUtils.getIcon("images/planning/template.png"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new PlanTemplatesDialog(PlanEditor.this.getConsole()).showDialog();
            }
        });
    }

    public static enum ToolbarLocation {
        Right,
        Left;

    }
}

