/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import com.google.common.eventbus.Subscribe;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.PlanControlState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventPositionEstimation;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.preview.PlanSimulationOverlay;
import pt.lsts.neptus.mp.preview.PlanSimulator;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Plan Simulation Preview", author="zp", icon="images/planning/robot.png")
@LayerPriority(priority=60)
public class PlanExecutionPreview
extends ConsolePanel
implements Renderer2DPainter,
ConfigurationListener {
    private static final long serialVersionUID = 1L;
    protected GeneralPath arrow = new GeneralPath();
    protected LinkedHashMap<String, PlanSimulator> simulators;
    protected LinkedHashMap<String, EstimatedState> lastStates;
    protected LinkedHashMap<String, Long> lastStateTimes;
    protected PlanSimulator mainSimulator;
    protected boolean forceSimVisualization;
    @NeptusProperty(name="Active")
    public boolean activated;
    @NeptusProperty(name="Milliseconds to wait before simulation")
    public long millisToWait;
    @NeptusProperty(name="Interval between simulated states, in seconds")
    public double timestep;
    @NeptusProperty(name="Simulated (flat) bathymetry")
    public double bathymetry;
    protected long lastEstimateTime;

    public PlanExecutionPreview(ConsoleLayout console) {
        super(console);
        this.arrow.moveTo(-2.0f, -10.0f);
        this.arrow.lineTo(2.0f, -10.0f);
        this.arrow.lineTo(2.0f, 0.0f);
        this.arrow.lineTo(5.0f, 0.0f);
        this.arrow.lineTo(0.0f, 10.0f);
        this.arrow.lineTo(-5.0f, 0.0f);
        this.arrow.lineTo(-2.0f, 0.0f);
        this.arrow.closePath();
        this.simulators = new LinkedHashMap();
        this.lastStates = new LinkedHashMap();
        this.lastStateTimes = new LinkedHashMap();
        this.mainSimulator = null;
        this.forceSimVisualization = false;
        this.activated = true;
        this.millisToWait = 1000L;
        this.timestep = 0.25;
        this.bathymetry = 10.0;
        this.lastEstimateTime = 0L;
        this.setVisibility(false);
    }

    protected double getVehicleDepth() {
        EstimatedState state = this.lastStates.get(this.getConsole().getMainSystem());
        try {
            if (state != null) {
                return ImcMsgManager.getManager().getState(this.getConsole().getMainSystem()).lastEstimatedState().getDepth();
            }
            return 0.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    @Subscribe
    public void consume(EstimatedState msg) {
        String src = msg.getSourceName();
        if (src == null) {
            return;
        }
        if (this.simulators.containsKey(src)) {
            this.simulators.get(src).setEstimatedState(msg);
            this.lastStates.put(src, msg);
            this.lastStateTimes.put(src, System.currentTimeMillis());
        }
    }

    @Subscribe
    public void consume(ConsoleEventPositionEstimation estimate) {
        this.lastEstimateTime = System.currentTimeMillis();
        if (this.mainSimulator == null) {
            return;
        }
        long lastStateTime = this.lastStateTimes.get(this.getConsole().getMainSystem());
        if (System.currentTimeMillis() - lastStateTime < 1000L) {
            return;
        }
        this.mainSimulator.setPositionEstimation(estimate.getEstimation(), 8.0);
    }

    protected void stopSimulator() {
        for (PlanSimulator s : this.simulators.values()) {
            s.stopSimulation();
        }
        this.simulators.clear();
        this.mainSimulator = null;
    }

    @Override
    public void cleanSubPanel() {
        this.stopSimulator();
    }

    @Subscribe
    public synchronized void consume(PlanControlState msg) {
        boolean main;
        String src = msg.getSourceName();
        boolean bl = main = src == this.getConsole().getMainSystem();
        if (msg.getPlanId().isEmpty()) {
            return;
        }
        if (msg.getState() != PlanControlState.STATE.EXECUTING) {
            if (this.forceSimVisualization && main) {
                return;
            }
            if (this.simulators.containsKey(src)) {
                this.simulators.get(src).stopSimulation();
                this.simulators.remove(src);
            }
            if (main) {
                this.mainSimulator = null;
            }
        } else {
            try {
                String planid = msg.getPlanId();
                PlanSimulator simulator = this.simulators.get(src);
                if (simulator == null || simulator.isFinished() || !planid.equals(simulator.getPlan().getId())) {
                    PlanType plan;
                    if (simulator != null) {
                        simulator.stopSimulation();
                    }
                    if ((plan = this.getConsole().getMission().getIndividualPlansList().get(planid)) != null) {
                        EstimatedState last = ImcMsgManager.getManager().getState(msg.getSourceName()).lastEstimatedState();
                        simulator = last != null ? new PlanSimulator(plan, new SystemPositionAndAttitude(last)) : new PlanSimulator(plan, null);
                        simulator.setManId(msg.getManId());
                        simulator.setVehicleId(src);
                        simulator.setTimestep(this.timestep);
                        if (this.activated) {
                            simulator.startSimulation();
                        }
                        if (main) {
                            this.mainSimulator = simulator;
                        }
                        this.simulators.put(src, simulator);
                    }
                }
                if (simulator != null) {
                    simulator.setManId(msg.getManId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                NeptusLog.pub().error((Object)e);
            }
        }
    }

    public void paintVerticalProfile(Graphics2D g, StateRenderer2D renderer) {
    }

    @Override
    public void paint(Graphics2D g2, StateRenderer2D renderer) {
        Graphics2D g;
        Vector<String> strs = new Vector<String>();
        for (PlanSimulator sim : this.simulators.values()) {
            long lastStateTime;
            g = (Graphics2D)g2.create();
            String vehicle = sim.getVehicleId();
            long lastTime = this.lastStateTimes.containsKey(vehicle) ? this.lastStateTimes.get(vehicle) : 0L;
            long simTime = System.currentTimeMillis() - lastTime;
            if (simTime > 1000L) {
                strs.add("[" + I18n.textf("Simulating %vehicle for %time", vehicle, DateTimeUtil.milliSecondsToFormatedString(simTime)) + "]");
            }
            long l = lastStateTime = this.lastStateTimes.containsKey(vehicle) ? this.lastStateTimes.get(vehicle) : 0L;
            if (System.currentTimeMillis() - lastStateTime < this.millisToWait || sim == null || !sim.isRunning()) continue;
            SystemPositionAndAttitude simulatedState = sim.getState();
            if (simulatedState == null) {
                return;
            }
            Point2D pt = renderer.getScreenPosition(simulatedState.getPosition());
            g.translate(pt.getX(), pt.getY());
            g.rotate(Math.PI + simulatedState.getYaw() - renderer.getRotation());
            VehicleType type = VehiclesHolder.getVehicleById(sim.getVehicleId());
            Color c = type.getIconColor();
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 150));
            g.fill(this.arrow);
            g.setColor(Color.black);
            g.draw(this.arrow);
            g.rotate(-Math.PI - simulatedState.getYaw() + renderer.getRotation());
            g.setColor(Color.black);
            g.drawString("(" + vehicle + ", " + GuiUtils.getNeptusDecimalFormat(1).format(simulatedState.getPosition().getDepth()) + " m)", 7, 5);
        }
        if (!strs.isEmpty()) {
            Collections.sort(strs);
            g = (Graphics2D)g2.create();
            int ypos = 20;
            double maxWidth = 0.0;
            for (String str : strs) {
                maxWidth = Math.max(maxWidth, g.getFontMetrics().getStringBounds(str, g).getWidth());
            }
            g.setColor(new Color(255, 255, 255, 64));
            g.fill(new RoundRectangle2D.Double(50.0, 5.0, maxWidth + 10.0, strs.size() * 15 + 10, 10.0, 10.0));
            for (String str : strs) {
                g.setColor(new Color(68, 68, 68, 128));
                g.drawString(str, 56, ypos);
                g.setColor(Color.red.darker());
                g.drawString(str, 55, ypos);
                ypos += 15;
            }
        }
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        if (this.mainSimulator != null) {
            this.mainSimulator.setTimestep(this.timestep);
        }
        if (!this.activated && this.mainSimulator != null) {
            this.stopSimulator();
        }
    }

    @Override
    public void propertiesChanged() {
        PlanSimulationOverlay.bottomDepth = this.bathymetry;
    }

    @Override
    public void initSubPanel() {
    }

    public int getLayerPriority() {
        return 1;
    }
}

