/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import pt.lsts.neptus.console.ConsoleLayer;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.events.ConsoleEventPlanChange;
import pt.lsts.neptus.data.Pair;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.preview.PlanSimulationListener;
import pt.lsts.neptus.mp.preview.PlanSimulationOverlay;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.mission.plan.PlanCompability;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="Plan Simulation", icon="images/planning/robot.png")
public class PlanSimulationLayer
extends ConsoleLayer
implements PlanSimulationListener {
    private PlanSimulationOverlay simOverlay = null;
    private PlanType mainPlan = null;
    private Image errorImage = ImageUtils.getImage("pt/lsts/neptus/console/plugins/planning/error.png");
    private Image warnImage = ImageUtils.getImage("pt/lsts/neptus/console/plugins/planning/warning.png");
    private Image fineImage = ImageUtils.getImage("pt/lsts/neptus/console/plugins/planning/fine.png");
    @NeptusProperty(name="Max AUV distance", description="Warn user if AUV distance exceeds this value")
    private double maxAUVDistance = 1000.0;
    @NeptusProperty(name="Max AUV end distance", description="Warn user if last planned AUV position is further than this distance away from base")
    private double maxAUVDistAtEnd = 300.0;
    @NeptusProperty(name="Max UAV distance", description="Warn user if UAV distance exceeds this value")
    private double maxUAVDistance = 10000.0;
    @NeptusProperty(name="Max UAV end distance", description="Warn user if last planned UAV position is further than this distance away from base")
    private double maxUAVDistAtEnd = 500.0;
    private Vector<Pair<PlanCheck, String>> checks = new Vector();

    @Subscribe
    public void on(ConsoleEventPlanChange evt) {
        this.mainPlan = evt.getCurrent();
        this.refreshOverlay();
    }

    @Subscribe
    public void on(ConsoleEventMainSystemChange evt) {
        this.refreshOverlay();
    }

    @Override
    public boolean userControlsOpacity() {
        return true;
    }

    @Override
    public void simulationFinished(PlanSimulationOverlay source) {
        source.removeListener(this);
        this.validatePlan();
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        super.paint(g, renderer);
        if (this.simOverlay != null) {
            this.simOverlay.paint((Graphics2D)g.create(), renderer);
        }
        g.setColor(Color.white);
        int pos = 20;
        for (Pair<PlanCheck, String> check : this.checks) {
            switch (check.first()) {
                case Error: {
                    g.drawImage(this.errorImage, 5, pos - 12, null);
                    break;
                }
                case Warning: {
                    g.drawImage(this.warnImage, 5, pos - 12, null);
                    break;
                }
                case Fine: {
                    g.drawImage(this.fineImage, 5, pos - 12, null);
                    break;
                }
            }
            g.drawString(check.second(), 24, pos);
            pos += 20;
        }
    }

    @Override
    public void initLayer() {
        this.mainPlan = this.getConsole().getPlan();
        this.refreshOverlay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshOverlay() {
        if (this.mainPlan != null) {
            PlanSimulationLayer planSimulationLayer = this;
            synchronized (planSimulationLayer) {
                this.simOverlay = new PlanSimulationOverlay(this.mainPlan, 0.0, 4.0, null);
                this.simOverlay.addListener(this);
            }
        } else {
            this.simOverlay = null;
        }
    }

    private synchronized void validatePlan() {
        this.checks.clear();
        if (this.mainPlan == null) {
            return;
        }
        try {
            this.mainPlan.validatePlan();
        }
        catch (Exception e) {
            this.checks.add(new Pair<PlanCheck, String>(PlanCheck.Error, e.getMessage()));
        }
        this.checks.addAll(this.validatePlanCompatibility());
        this.checks.addAll(this.validateDistances());
        this.checks.addAll(this.validateCollisions());
        if (this.checks.isEmpty()) {
            this.checks.add(new Pair<PlanCheck, String>(PlanCheck.Fine, I18n.textf("Plan takes approximately %timeAmount", DateTimeUtil.milliSecondsToFormatedString((long)(this.simOverlay.getTotalTime() * 1000.0)))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<PlanCheck, String>> validateDistances() {
        VehicleType v = VehiclesHolder.getVehicleById(this.getConsole().getMainSystem());
        LocationType base = MyState.getLocation();
        double maxDistToBase = 0.0;
        double distAtEnd = 0.0;
        ArrayList<Pair<PlanCheck, String>> checks = new ArrayList<Pair<PlanCheck, String>>();
        PlanSimulationLayer planSimulationLayer = this;
        synchronized (planSimulationLayer) {
            for (SystemPositionAndAttitude s : this.simOverlay.getStates()) {
                distAtEnd = s.getPosition().getDistanceInMeters(base);
                maxDistToBase = Math.max(distAtEnd, maxDistToBase);
            }
        }
        if ("auv".equalsIgnoreCase(v.getType()) || "uuv".equalsIgnoreCase(v.getType())) {
            if (maxDistToBase > this.maxAUVDistance) {
                checks.add(new Pair<PlanCheck, String>(PlanCheck.Warning, I18n.textf("%vehicle will be %maxDistToBase meters away from here", v.getId(), (int)maxDistToBase)));
            }
            if (distAtEnd > this.maxAUVDistAtEnd) {
                checks.add(new Pair<PlanCheck, String>(PlanCheck.Warning, I18n.textf("%vehicle will finish %distance  meters away from base", v.getId(), (int)distAtEnd)));
            }
        } else if ("uav".equalsIgnoreCase(v.getType())) {
            if (maxDistToBase > this.maxUAVDistance) {
                checks.add(new Pair<PlanCheck, String>(PlanCheck.Warning, I18n.textf("%vehicle will be %maxDistToBase meters away from here", v.getId(), (int)maxDistToBase)));
            }
            if (distAtEnd > this.maxUAVDistAtEnd) {
                checks.add(new Pair<PlanCheck, String>(PlanCheck.Warning, I18n.textf("%vehicle will finish %distance  meters away from base", v.getId(), (int)distAtEnd)));
            }
        }
        return checks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<PlanCheck, String>> validateCollisions() {
        ArrayList<Pair<PlanCheck, String>> checks = new ArrayList<Pair<PlanCheck, String>>();
        Vector<AbstractElement> obstacles = MapGroup.getMapGroupInstance(this.getConsole().getMission()).getObstacles();
        PlanSimulationLayer planSimulationLayer = this;
        synchronized (planSimulationLayer) {
            for (SystemPositionAndAttitude s : this.simOverlay.getStates()) {
                for (AbstractElement a : obstacles) {
                    if (!a.containsPoint(s.getPosition(), null)) continue;
                    checks.add(new Pair<PlanCheck, String>(PlanCheck.Warning, I18n.textf("Vehicle may collide with %obstacle", a.getId())));
                    return checks;
                }
            }
        }
        return checks;
    }

    private List<Pair<PlanCheck, String>> validatePlanCompatibility() {
        ArrayList<Pair<PlanCheck, String>> checks = new ArrayList<Pair<PlanCheck, String>>();
        try {
            PlanCompability.testCompatibility(VehiclesHolder.getVehicleById(this.getConsole().getMainSystem()), this.mainPlan);
        }
        catch (Exception e) {
            checks.add(new Pair<PlanCheck, String>(PlanCheck.Warning, e.getMessage()));
        }
        return checks;
    }

    @Override
    public void cleanLayer() {
    }

    private static enum PlanCheck {
        Fine,
        Warning,
        Error;

    }
}

