/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanUtil;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Plan Statistics", category=PluginDescription.CATEGORY.PLANNING)
public class PlanStatistics
extends ConsolePanel
implements IEditorMenuExtension {
    NumberFormat format = GuiUtils.getNeptusDecimalFormat(0);
    boolean initCalled = false;
    @NeptusProperty(name="Maximum Top Speed (100%)")
    public double maxSpeed = 1.3;
    @NeptusProperty(name="Maximum Number of RPMs")
    public double maxRpms = 1000.0;

    public PlanStatistics(ConsoleLayout console) {
        super(console);
    }

    @Override
    public void initSubPanel() {
        if (this.initCalled) {
            return;
        }
        this.initCalled = true;
        this.setVisibility(false);
        Vector<IMapPopup> r = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        for (IMapPopup str2d : r) {
            str2d.addMenuExtension(this);
        }
    }

    @Override
    public Collection<JMenuItem> getApplicableItems(LocationType loc, IMapPopup source) {
        Vector<JMenuItem> items = new Vector<JMenuItem>();
        if (this.getConsole().getPlan() != null) {
            PlanType plan = this.getConsole().getPlan();
            JMenu menu = PlanUtil.getPlanStatisticsAsJMenu(plan, I18n.text("Active Plan Statistics"), this.maxSpeed, this.maxRpms);
            items.add(menu);
            return items;
        }
        return null;
    }

    @Override
    public void cleanSubPanel() {
    }
}

