/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.Dialog;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.VehicleChooser;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.templates.AbstractPlanTemplate;
import pt.lsts.neptus.mp.templates.ScriptedPlanTemplate;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.ReflectionUtil;

public class PlanTemplatesDialog {
    private ConsoleLayout console;
    private ImageIcon templateIcon = ImageUtils.getIcon("images/planning/template.png");
    private final String scriptsDir = "conf/planscripts/";

    public PlanTemplatesDialog(ConsoleLayout console) {
        this.console = console;
    }

    public void showDialog() {
        int i;
        VehicleType choice = null;
        choice = this.console.getMainSystem() != null ? VehicleChooser.showVehicleDialog(null, VehiclesHolder.getVehicleById(this.console.getMainSystem()), this.console) : VehicleChooser.showVehicleDialog(null, null, this.console);
        if (choice == null) {
            return;
        }
        Class<?>[] classes = ReflectionUtil.listPlanTemplates();
        File[] scripts = new File("conf/planscripts/").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("js");
            }
        });
        Object[] names = new String[classes.length + scripts.length];
        for (i = 0; i < classes.length; ++i) {
            names[i] = PluginUtils.getPluginName(classes[i]);
        }
        for (i = 0; i < scripts.length; ++i) {
            names[classes.length + i] = scripts[i].getName();
        }
        JOptionPane jop = new JOptionPane(I18n.text("Choose the plan template"), 3, -1, this.templateIcon);
        jop.setSelectionValues(names);
        jop.setInitialSelectionValue(names[0]);
        JDialog dialog = jop.createDialog(this.console, I18n.text("Add plan template"));
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setVisible(true);
        Object option = jop.getInputValue();
        if (option == null) {
            return;
        }
        PlanType plan = null;
        if (option.toString().endsWith("js")) {
            ScriptedPlanTemplate planTemplate = new ScriptedPlanTemplate();
            String source = FileUtil.getFileAsString("conf/planscripts/" + option);
            planTemplate.setSource(source);
            planTemplate.setMission(this.console.getMission());
            PropertiesEditor.editProperties(planTemplate, true);
            try {
                plan = planTemplate.generatePlan();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Class<?> c = classes[0];
            for (int i2 = 0; i2 < classes.length; ++i2) {
                if (PluginUtils.getPluginName(classes[i2]).equals(option)) {
                    c = classes[i2];
                    break;
                }
                NeptusLog.pub().info((Object)("<###> " + option + " != " + PluginUtils.getPluginName(classes[i2])));
            }
            if ((plan = AbstractPlanTemplate.addTemplateToMission(this.console, this.console.getMission(), c)) == null) {
                return;
            }
            try {
                plan.validatePlan();
            }
            catch (Exception e) {
                GuiUtils.errorMessage(this.console, e);
            }
        }
        if (plan == null) {
            return;
        }
        plan.setVehicle(choice);
        plan.setMissionType(this.console.getMission());
        final PlanType p = plan;
        new Thread(){

            @Override
            public void run() {
                PlanTemplatesDialog.this.console.getMission().addPlan(p);
                PlanTemplatesDialog.this.console.getMission().save(true);
                PlanTemplatesDialog.this.console.updateMissionListeners();
                GuiUtils.infoMessage(PlanTemplatesDialog.this.console, I18n.text("Plan template"), I18n.textf("The plan %planid was added to this mission", p.getId()));
            }
        }.run();
    }
}

