/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins.planning;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import java.util.Map;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

public class SimulatedBathymetry
implements Renderer2DPainter {
    protected double defaultDepth = 10.0;
    protected double minDistToSounding = 200.0;
    protected LinkedHashMap<LocationType, Double> soundings = new LinkedHashMap();

    protected void addSounding(LocationType loc, double depth) {
        this.soundings.put(loc, depth);
    }

    protected void clearSoundings() {
        this.soundings.clear();
    }

    public LinkedHashMap<LocationType, Double> getSoundings() {
        return this.soundings;
    }

    public double getSimulatedDepth(LocationType loc) {
        if (this.soundings.size() == 0) {
            return this.defaultDepth;
        }
        if (this.soundings.size() == 1) {
            return this.soundings.values().iterator().next();
        }
        double dTotal = 0.0;
        double valTotal = 0.0;
        for (Map.Entry<LocationType, Double> sounding : this.soundings.entrySet()) {
            double dist = loc.getHorizontalDistanceInMeters(sounding.getKey());
            dist = (dist = Math.pow(dist, 3.0)) > 0.0 ? 1.0 / dist : 1.0E20;
            valTotal += dist * sounding.getValue();
            dTotal += dist;
        }
        return valTotal / dTotal;
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        g.setColor(Color.orange);
        for (Map.Entry<LocationType, Double> sounding : this.soundings.entrySet()) {
            Point2D pt = renderer.getScreenPosition(sounding.getKey());
            g.draw(new Line2D.Double(pt.getX() - 3.0, pt.getY(), pt.getX() + 3.0, pt.getY()));
            g.draw(new Line2D.Double(pt.getX(), pt.getY() - 3.0, pt.getX(), pt.getY() + 3.0));
            g.drawString(String.format("%.1f m", sounding.getValue()), (int)pt.getX() + 5, (int)pt.getY() + 5);
        }
    }
}

